/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Region;
import net.minecraft.world.World;

public abstract class PathNavigator {
    protected final MobEntity field_75515_a;
    protected final World field_75513_b;
    @Nullable
    protected Path field_75514_c;
    protected double field_75511_d;
    protected int field_75510_g;
    protected int field_75520_h;
    protected Vector3d field_75521_i = Vector3d.field_186680_a;
    protected Vector3i field_188557_k = Vector3i.field_177959_e;
    protected long field_188558_l;
    protected long field_188559_m;
    protected double field_188560_n;
    protected float field_188561_o = 0.5f;
    protected boolean field_188562_p;
    protected long field_188563_q;
    protected NodeProcessor field_179695_a;
    private BlockPos field_188564_r;
    private int field_225468_r;
    private float field_226334_s_ = 1.0f;
    private final PathFinder field_179681_j;
    private boolean field_244431_t;

    public PathNavigator(MobEntity mobEntity, World world) {
        this.field_75515_a = mobEntity;
        this.field_75513_b = world;
        int n = MathHelper.func_76128_c(mobEntity.func_233637_b_(Attributes.field_233819_b_) * 16.0);
        this.field_179681_j = this.func_179679_a(n);
    }

    public void func_226336_g_() {
        this.field_226334_s_ = 1.0f;
    }

    public void func_226335_a_(float f) {
        this.field_226334_s_ = f;
    }

    public BlockPos func_208485_j() {
        return this.field_188564_r;
    }

    protected abstract PathFinder func_179679_a(int var1);

    public void func_75489_a(double d) {
        this.field_75511_d = d;
    }

    public boolean func_188553_i() {
        return this.field_188562_p;
    }

    public void func_188554_j() {
        if (this.field_75513_b.func_82737_E() - this.field_188563_q > 20L) {
            if (this.field_188564_r != null) {
                this.field_75514_c = null;
                this.field_75514_c = this.func_179680_a(this.field_188564_r, this.field_225468_r);
                this.field_188563_q = this.field_75513_b.func_82737_E();
                this.field_188562_p = false;
            }
        } else {
            this.field_188562_p = true;
        }
    }

    @Nullable
    public final Path func_225466_a(double d, double d2, double d3, int n) {
        return this.func_179680_a(new BlockPos(d, d2, d3), n);
    }

    @Nullable
    public Path func_225463_a(Stream<BlockPos> stream, int n) {
        return this.func_225464_a(stream.collect(Collectors.toSet()), 8, false, n);
    }

    @Nullable
    public Path func_241390_a_(Set<BlockPos> set, int n) {
        return this.func_225464_a(set, 8, false, n);
    }

    @Nullable
    public Path func_179680_a(BlockPos blockPos, int n) {
        return this.func_225464_a((Set<BlockPos>)ImmutableSet.of((Object)blockPos), 8, false, n);
    }

    @Nullable
    public Path func_75494_a(Entity entity, int n) {
        return this.func_225464_a((Set<BlockPos>)ImmutableSet.of((Object)entity.func_233580_cy_()), 16, true, n);
    }

    @Nullable
    protected Path func_225464_a(Set<BlockPos> set, int n, boolean bl, int n2) {
        if (set.isEmpty()) {
            return null;
        }
        if (this.field_75515_a.func_226278_cu_() < 0.0) {
            return null;
        }
        if (!this.func_75485_k()) {
            return null;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && set.contains(this.field_188564_r)) {
            return this.field_75514_c;
        }
        this.field_75513_b.func_217381_Z().func_76320_a("pathfind");
        float f = (float)this.field_75515_a.func_233637_b_(Attributes.field_233819_b_);
        BlockPos \u26032 = bl ? this.field_75515_a.func_233580_cy_().func_177984_a() : this.field_75515_a.func_233580_cy_();
        int \u26033 = (int)(f + (float)n);
        Region \u26034 = new Region(this.field_75513_b, \u26032.func_177982_a(-\u26033, -\u26033, -\u26033), \u26032.func_177982_a(\u26033, \u26033, \u26033));
        Path \u26035 = this.field_179681_j.func_227478_a_(\u26034, this.field_75515_a, set, f, n2, this.field_226334_s_);
        this.field_75513_b.func_217381_Z().func_76319_b();
        if (\u26035 != null && \u26035.func_224770_k() != null) {
            this.field_188564_r = \u26035.func_224770_k();
            this.field_225468_r = n2;
            this.func_234113_e_();
        }
        return \u26035;
    }

    public boolean func_75492_a(double d, double d2, double d3, double d4) {
        return this.func_75484_a(this.func_225466_a(d, d2, d3, 1), d4);
    }

    public boolean func_75497_a(Entity entity, double d) {
        Path path = this.func_75494_a(entity, 1);
        return path != null && this.func_75484_a(path, d);
    }

    public boolean func_75484_a(@Nullable Path path, double d) {
        if (path == null) {
            this.field_75514_c = null;
            return false;
        }
        if (!path.func_75876_a(this.field_75514_c)) {
            this.field_75514_c = path;
        }
        if (this.func_75500_f()) {
            return false;
        }
        this.func_75487_m();
        if (this.field_75514_c.func_75874_d() <= 0) {
            return false;
        }
        this.field_75511_d = d;
        Vector3d vector3d = this.func_75502_i();
        this.field_75520_h = this.field_75510_g;
        this.field_75521_i = vector3d;
        return true;
    }

    @Nullable
    public Path func_75505_d() {
        return this.field_75514_c;
    }

    public void func_75501_e() {
        Object \u26032;
        ++this.field_75510_g;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (this.func_75500_f()) {
            return;
        }
        if (this.func_75485_k()) {
            this.func_75508_h();
        } else if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vector3d vector3d = this.func_75502_i();
            \u26032 = this.field_75514_c.func_75878_a(this.field_75515_a);
            if (vector3d.field_72448_b > ((Vector3d)\u26032).field_72448_b && !this.field_75515_a.func_233570_aj_() && MathHelper.func_76128_c(vector3d.field_72450_a) == MathHelper.func_76128_c(((Vector3d)\u26032).field_72450_a) && MathHelper.func_76128_c(vector3d.field_72449_c) == MathHelper.func_76128_c(((Vector3d)\u26032).field_72449_c)) {
                this.field_75514_c.func_75875_a();
            }
        }
        DebugPacketSender.func_218803_a(this.field_75513_b, this.field_75515_a, this.field_75514_c, this.field_188561_o);
        if (this.func_75500_f()) {
            return;
        }
        vector3d = this.field_75514_c.func_75878_a(this.field_75515_a);
        \u26032 = new BlockPos(vector3d);
        this.field_75515_a.func_70605_aq().func_75642_a(vector3d.field_72450_a, this.field_75513_b.func_180495_p(((BlockPos)\u26032).func_177977_b()).func_196958_f() ? vector3d.field_72448_b : WalkNodeProcessor.func_197682_a(this.field_75513_b, (BlockPos)\u26032), vector3d.field_72449_c, this.field_75511_d);
    }

    protected void func_75508_h() {
        Vector3d vector3d = this.func_75502_i();
        this.field_188561_o = this.field_75515_a.func_213311_cf() > 0.75f ? this.field_75515_a.func_213311_cf() / 2.0f : 0.75f - this.field_75515_a.func_213311_cf() / 2.0f;
        BlockPos \u26032 = this.field_75514_c.func_242948_g();
        double \u26033 = Math.abs(this.field_75515_a.func_226277_ct_() - ((double)\u26032.func_177958_n() + 0.5));
        double \u26034 = Math.abs(this.field_75515_a.func_226278_cu_() - (double)\u26032.func_177956_o());
        double \u26035 = Math.abs(this.field_75515_a.func_226281_cx_() - ((double)\u26032.func_177952_p() + 0.5));
        boolean bl = \u2603 = \u26033 < (double)this.field_188561_o && \u26035 < (double)this.field_188561_o && \u26034 < 1.0;
        if (\u2603 || this.field_75515_a.func_233660_b_(this.field_75514_c.func_237225_h_().field_186287_m) && this.func_234112_b_(vector3d)) {
            this.field_75514_c.func_75875_a();
        }
        this.func_179677_a(vector3d);
    }

    private boolean func_234112_b_(Vector3d vector3d) {
        if (this.field_75514_c.func_75873_e() + 1 >= this.field_75514_c.func_75874_d()) {
            return false;
        }
        \u2603 = Vector3d.func_237492_c_(this.field_75514_c.func_242948_g());
        if (!vector3d.func_237488_a_(\u2603, 2.0)) {
            return false;
        }
        \u2603 = Vector3d.func_237492_c_(this.field_75514_c.func_242947_d(this.field_75514_c.func_75873_e() + 1));
        \u2603 = \u2603.func_178788_d(\u2603);
        return \u2603.func_72430_b(\u2603 = vector3d.func_178788_d(\u2603)) > 0.0;
    }

    protected void func_179677_a(Vector3d vector3d) {
        if (this.field_75510_g - this.field_75520_h > 100) {
            if (vector3d.func_72436_e(this.field_75521_i) < 2.25) {
                this.field_244431_t = true;
                this.func_75499_g();
            } else {
                this.field_244431_t = false;
            }
            this.field_75520_h = this.field_75510_g;
            this.field_75521_i = vector3d;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            BlockPos blockPos = this.field_75514_c.func_242948_g();
            if (blockPos.equals(this.field_188557_k)) {
                this.field_188558_l += Util.func_211177_b() - this.field_188559_m;
            } else {
                this.field_188557_k = blockPos;
                double d = vector3d.func_72438_d(Vector3d.func_237492_c_(this.field_188557_k));
                double d2 = this.field_188560_n = this.field_75515_a.func_70689_ay() > 0.0f ? d / (double)this.field_75515_a.func_70689_ay() * 1000.0 : 0.0;
            }
            if (this.field_188560_n > 0.0 && (double)this.field_188558_l > this.field_188560_n * 3.0) {
                this.func_244427_e();
            }
            this.field_188559_m = Util.func_211177_b();
        }
    }

    private void func_244427_e() {
        this.func_234113_e_();
        this.func_75499_g();
    }

    private void func_234113_e_() {
        this.field_188557_k = Vector3i.field_177959_e;
        this.field_188558_l = 0L;
        this.field_188560_n = 0.0;
        this.field_244431_t = false;
    }

    public boolean func_75500_f() {
        return this.field_75514_c == null || this.field_75514_c.func_75879_b();
    }

    public boolean func_226337_n_() {
        return !this.func_75500_f();
    }

    public void func_75499_g() {
        this.field_75514_c = null;
    }

    protected abstract Vector3d func_75502_i();

    protected abstract boolean func_75485_k();

    protected boolean func_75506_l() {
        return this.field_75515_a.func_203005_aq() || this.field_75515_a.func_180799_ab();
    }

    protected void func_75487_m() {
        if (this.field_75514_c == null) {
            return;
        }
        for (int i = 0; i < this.field_75514_c.func_75874_d(); ++i) {
            PathPoint pathPoint = this.field_75514_c.func_75877_a(i);
            \u2603 = i + 1 < this.field_75514_c.func_75874_d() ? this.field_75514_c.func_75877_a(i + 1) : null;
            BlockState \u26032 = this.field_75513_b.func_180495_p(new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c));
            if (!\u26032.func_203425_a(Blocks.field_150383_bp)) continue;
            this.field_75514_c.func_186309_a(i, pathPoint.func_186283_a(pathPoint.field_75839_a, pathPoint.field_75837_b + 1, pathPoint.field_75838_c));
            if (\u2603 == null || pathPoint.field_75837_b < \u2603.field_75837_b) continue;
            this.field_75514_c.func_186309_a(i + 1, pathPoint.func_186283_a(\u2603.field_75839_a, pathPoint.field_75837_b + 1, \u2603.field_75838_c));
        }
    }

    protected abstract boolean func_75493_a(Vector3d var1, Vector3d var2, int var3, int var4, int var5);

    public boolean func_188555_b(BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        return this.field_75513_b.func_180495_p(\u2603).func_200015_d(this.field_75513_b, \u2603);
    }

    public NodeProcessor func_189566_q() {
        return this.field_179695_a;
    }

    public void func_212239_d(boolean bl) {
        this.field_179695_a.func_186316_c(bl);
    }

    public boolean func_212238_t() {
        return this.field_179695_a.func_186322_e();
    }

    public void func_220970_c(BlockPos blockPos) {
        if (this.field_75514_c == null || this.field_75514_c.func_75879_b() || this.field_75514_c.func_75874_d() == 0) {
            return;
        }
        PathPoint pathPoint = this.field_75514_c.func_75870_c();
        Vector3d \u26032 = new Vector3d(((double)pathPoint.field_75839_a + this.field_75515_a.func_226277_ct_()) / 2.0, ((double)pathPoint.field_75837_b + this.field_75515_a.func_226278_cu_()) / 2.0, ((double)pathPoint.field_75838_c + this.field_75515_a.func_226281_cx_()) / 2.0);
        if (blockPos.func_218137_a(\u26032, this.field_75514_c.func_75874_d() - this.field_75514_c.func_75873_e())) {
            this.func_188554_j();
        }
    }

    public boolean func_244428_t() {
        return this.field_244431_t;
    }
}

