/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PiglinEntity
extends AbstractPiglinEntity
implements ICrossbowUser {
    private static final DataParameter<Boolean> field_234415_d_ = EntityDataManager.func_187226_a(PiglinEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_234409_bv_ = EntityDataManager.func_187226_a(PiglinEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_234410_bw_ = EntityDataManager.func_187226_a(PiglinEntity.class, DataSerializers.field_187198_h);
    private static final UUID field_234411_bx_ = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier field_234412_by_ = new AttributeModifier(field_234411_bx_, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.MULTIPLY_BASE);
    private final Inventory field_234406_bA_ = new Inventory(8);
    private boolean field_234407_bB_ = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super PiglinEntity>>> field_234405_b_ = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_234129_b_, SensorType.field_221002_f, SensorType.field_234130_l_);
    protected static final ImmutableList<MemoryModuleType<?>> field_234414_c_ = ImmutableList.of(MemoryModuleType.field_220951_l, MemoryModuleType.field_225462_q, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_, MemoryModuleType.field_234090_X_, MemoryModuleType.field_234089_W_, MemoryModuleType.field_234076_J_, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220950_k, (Object[])new MemoryModuleType[]{MemoryModuleType.field_223021_x, MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_, MemoryModuleType.field_220952_m, MemoryModuleType.field_220954_o, MemoryModuleType.field_234078_L_, MemoryModuleType.field_234079_M_, MemoryModuleType.field_234106_z_, MemoryModuleType.field_234080_N_, MemoryModuleType.field_242310_O, MemoryModuleType.field_234081_O_, MemoryModuleType.field_242311_P, MemoryModuleType.field_234083_Q_, MemoryModuleType.field_234084_R_, MemoryModuleType.field_234082_P_, MemoryModuleType.field_234086_T_, MemoryModuleType.field_234077_K_, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234105_s_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234095_ac_, MemoryModuleType.field_234085_S_, MemoryModuleType.field_234088_V_, MemoryModuleType.field_234096_ad_, MemoryModuleType.field_234097_ae_, MemoryModuleType.field_234098_af_});

    public PiglinEntity(EntityType<? extends AbstractPiglinEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 5;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.func_70631_g_()) {
            compoundNBT.func_74757_a("IsBaby", true);
        }
        if (this.field_234407_bB_) {
            compoundNBT.func_74757_a("CannotHunt", true);
        }
        compoundNBT.func_218657_a("Inventory", this.field_234406_bA_.func_70487_g());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_82227_f(compoundNBT.func_74767_n("IsBaby"));
        this.func_234443_v_(compoundNBT.func_74767_n("CannotHunt"));
        this.field_234406_bA_.func_70486_a(compoundNBT.func_150295_c("Inventory", 10));
    }

    @Override
    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
        super.func_213333_a(damageSource, n, bl);
        this.field_234406_bA_.func_233543_f_().forEach(this::func_199701_a_);
    }

    protected ItemStack func_234436_k_(ItemStack itemStack) {
        return this.field_234406_bA_.func_174894_a(itemStack);
    }

    protected boolean func_234437_l_(ItemStack itemStack) {
        return this.field_234406_bA_.func_233541_b_(itemStack);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234415_d_, false);
        this.field_70180_af.func_187214_a(field_234409_bv_, false);
        this.field_70180_af.func_187214_a(field_234410_bw_, false);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        super.func_184206_a(dataParameter);
        if (field_234415_d_.equals(dataParameter)) {
            this.func_213323_x_();
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234420_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.35f).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    public static boolean func_234418_b_(EntityType<PiglinEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return !iWorld.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_189878_dg);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        if (spawnReason != SpawnReason.STRUCTURE) {
            if (iServerWorld.func_201674_k().nextFloat() < 0.2f) {
                this.func_82227_f(true);
            } else if (this.func_242337_eM()) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, this.func_234432_eW_());
            }
        }
        PiglinTasks.func_234466_a_(this);
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        return super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    protected boolean func_225511_J_() {
        return false;
    }

    @Override
    public boolean func_213397_c(double d) {
        return !this.func_104002_bU();
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (this.func_242337_eM()) {
            this.func_234419_d_(EquipmentSlotType.HEAD, new ItemStack(Items.field_151169_ag));
            this.func_234419_d_(EquipmentSlotType.CHEST, new ItemStack(Items.field_151171_ah));
            this.func_234419_d_(EquipmentSlotType.LEGS, new ItemStack(Items.field_151149_ai));
            this.func_234419_d_(EquipmentSlotType.FEET, new ItemStack(Items.field_151151_aj));
        }
    }

    private void func_234419_d_(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        if (this.field_70170_p.field_73012_v.nextFloat() < 0.1f) {
            this.func_184201_a(equipmentSlotType, itemStack);
        }
    }

    protected Brain.BrainCodec<PiglinEntity> func_230289_cH_() {
        return Brain.func_233705_a_(field_234414_c_, field_234405_b_);
    }

    @Override
    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        return PiglinTasks.func_234469_a_(this, this.func_230289_cH_().func_233748_a_(dynamic));
    }

    public Brain<PiglinEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity2, Hand hand) {
        PlayerEntity playerEntity2;
        ActionResultType actionResultType = super.func_230254_b_(playerEntity2, hand);
        if (actionResultType.func_226246_a_()) {
            return actionResultType;
        }
        if (this.field_70170_p.field_72995_K) {
            boolean bl = PiglinTasks.func_234489_b_(this, playerEntity2.func_184586_b(hand)) && this.func_234424_eM_() != PiglinAction.ADMIRING_ITEM;
            return bl ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return PiglinTasks.func_234471_a_(this, playerEntity2, hand);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return this.func_70631_g_() ? 0.93f : 1.74f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.92;
    }

    @Override
    public void func_82227_f(boolean bl) {
        this.func_184212_Q().func_187227_b(field_234415_d_, bl);
        if (!this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233821_d_);
            modifiableAttributeInstance.func_111124_b(field_234412_by_);
            if (bl) {
                modifiableAttributeInstance.func_233767_b_(field_234412_by_);
            }
        }
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_234415_d_);
    }

    private void func_234443_v_(boolean bl) {
        this.field_234407_bB_ = bl;
    }

    @Override
    protected boolean func_234422_eK_() {
        return !this.field_234407_bB_;
    }

    @Override
    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("piglinBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        PiglinTasks.func_234486_b_(this);
        super.func_70619_bc();
    }

    @Override
    protected int func_70693_a(PlayerEntity playerEntity) {
        return this.field_70728_aV;
    }

    @Override
    protected void func_234416_a_(ServerWorld serverWorld) {
        PiglinTasks.func_234496_c_(this);
        this.field_234406_bA_.func_233543_f_().forEach(this::func_199701_a_);
        super.func_234416_a_(serverWorld);
    }

    private ItemStack func_234432_eW_() {
        if ((double)this.field_70146_Z.nextFloat() < 0.5) {
            return new ItemStack(Items.field_222114_py);
        }
        return new ItemStack(Items.field_151010_B);
    }

    private boolean func_234433_eX_() {
        return this.field_70180_af.func_187225_a(field_234409_bv_);
    }

    @Override
    public void func_213671_a(boolean bl) {
        this.field_70180_af.func_187227_b(field_234409_bv_, bl);
    }

    @Override
    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public PiglinAction func_234424_eM_() {
        if (this.func_234425_eN_()) {
            return PiglinAction.DANCING;
        }
        if (PiglinTasks.func_234480_a_(this.func_184592_cb().func_77973_b())) {
            return PiglinAction.ADMIRING_ITEM;
        }
        if (this.func_213398_dR() && this.func_242338_eO()) {
            return PiglinAction.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.func_234433_eX_()) {
            return PiglinAction.CROSSBOW_CHARGE;
        }
        if (this.func_213398_dR() && this.func_233631_a_(Items.field_222114_py)) {
            return PiglinAction.CROSSBOW_HOLD;
        }
        return PiglinAction.DEFAULT;
    }

    public boolean func_234425_eN_() {
        return this.field_70180_af.func_187225_a(field_234410_bw_);
    }

    public void func_234442_u_(boolean bl) {
        this.field_70180_af.func_187227_b(field_234410_bw_, bl);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        boolean bl = super.func_70097_a(damageSource, f);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (bl && damageSource.func_76346_g() instanceof LivingEntity) {
            PiglinTasks.func_234468_a_(this, (LivingEntity)damageSource.func_76346_g());
        }
        return bl;
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        this.func_234281_b_(this, 1.6f);
    }

    @Override
    public void func_230284_a_(LivingEntity livingEntity, ItemStack itemStack, ProjectileEntity projectileEntity, float f) {
        this.func_234279_a_(this, livingEntity, projectileEntity, f, 1.6f);
    }

    @Override
    public boolean func_230280_a_(ShootableItem shootableItem) {
        return shootableItem == Items.field_222114_py;
    }

    protected void func_234438_m_(ItemStack itemStack) {
        this.func_233657_b_(EquipmentSlotType.MAINHAND, itemStack);
    }

    protected void func_234439_n_(ItemStack itemStack) {
        if (itemStack.func_77973_b() == PiglinTasks.field_234444_a_) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, itemStack);
            this.func_233663_d_(EquipmentSlotType.OFFHAND);
        } else {
            this.func_233657_b_(EquipmentSlotType.OFFHAND, itemStack);
        }
    }

    @Override
    public boolean func_230293_i_(ItemStack itemStack) {
        return this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && this.func_98052_bS() && PiglinTasks.func_234474_a_(this, itemStack);
    }

    protected boolean func_234440_o_(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        ItemStack \u26032 = this.func_184582_a(equipmentSlotType);
        return this.func_208003_a(itemStack, \u26032);
    }

    @Override
    protected boolean func_208003_a(ItemStack itemStack, ItemStack itemStack2) {
        if (EnchantmentHelper.func_190938_b(itemStack2)) {
            return false;
        }
        boolean bl = PiglinTasks.func_234480_a_(itemStack.func_77973_b()) || itemStack.func_77973_b() == Items.field_222114_py;
        boolean bl2 = \u2603 = PiglinTasks.func_234480_a_(itemStack2.func_77973_b()) || itemStack2.func_77973_b() == Items.field_222114_py;
        if (bl && !\u2603) {
            return true;
        }
        if (!bl && \u2603) {
            return false;
        }
        if (this.func_242337_eM() && itemStack.func_77973_b() != Items.field_222114_py && itemStack2.func_77973_b() == Items.field_222114_py) {
            return false;
        }
        return super.func_208003_a(itemStack, itemStack2);
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        this.func_233630_a_(itemEntity);
        PiglinTasks.func_234470_a_(this, itemEntity);
    }

    @Override
    public boolean func_184205_a(Entity entity2, boolean bl) {
        Entity entity2;
        if (this.func_70631_g_() && entity2.func_200600_R() == EntityType.field_233588_G_) {
            entity2 = this.func_234417_b_(entity2, 3);
        }
        return super.func_184205_a(entity2, bl);
    }

    private Entity func_234417_b_(Entity entity, int n) {
        List<Entity> list = entity.func_184188_bt();
        if (n == 1 || list.isEmpty()) {
            return entity;
        }
        return this.func_234417_b_(list.get(0), n - 1);
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        return PiglinTasks.func_241429_d_(this).orElse(null);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_232793_kX_;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232791_kV_;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_232795_kZ_, 0.15f, 1.0f);
    }

    protected void func_241417_a_(SoundEvent soundEvent) {
        this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    protected void func_241848_eP() {
        this.func_241417_a_(SoundEvents.field_232799_la_);
    }
}

