/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends aof<wb>
implements apd,
da,
AutoCloseable {
    private static final Logger j = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    public static final bsa c = new bsa("Demo World", bru.b, false, aor.c, false, new brt(), brk.a);
    protected final cyg.a d;
    protected final cyk e;
    private final apc k = new apc("server", this, x.b());
    private final List<Runnable> l = Lists.newArrayList();
    private final anq m = new anq(x.a, this::ai);
    private anw n = ant.a;
    private final aax o;
    private final aaq p;
    private final un q = new un();
    private final Random r = new Random();
    private final DataFixer s;
    private String t;
    private int u = -1;
    protected final gn.b f;
    private final Map<vj<brx>, aag> v = Maps.newLinkedHashMap();
    private acu w;
    private volatile boolean x = true;
    private boolean y;
    private int z;
    protected final Proxy g;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    @Nullable
    private String E;
    private int F;
    private int G;
    public final long[] h = new long[100];
    @Nullable
    private KeyPair H;
    @Nullable
    private String I;
    private boolean J;
    private String K = "";
    private String L = "";
    private volatile boolean M;
    private long N;
    private boolean O;
    private boolean P;
    private final MinecraftSessionService Q;
    private final GameProfileRepository R;
    private final acq S;
    private long T;
    private final Thread U;
    private long V = x.b();
    private long W;
    private boolean X;
    private final abw Z;
    private final wa aa = new wa(this);
    @Nullable
    private cya ab;
    private final wd ac = new wd();
    private final vx ad;
    private final afc ae = new afc();
    private boolean af;
    private float ag;
    private final Executor ah;
    @Nullable
    private String ai;
    private vz aj;
    private final csw ak;
    protected final cyn i;

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        Thread \u26032 = new Thread(() -> ((MinecraftServer)atomicReference.get()).w(), "Server thread");
        \u26032.setUncaughtExceptionHandler((thread, throwable) -> j.error((Object)throwable));
        MinecraftServer \u26033 = (MinecraftServer)function.apply(\u26032);
        atomicReference.set(\u26033);
        \u26032.start();
        return (S)\u26033;
    }

    public MinecraftServer(Thread thread, gn.b b2, cyg.a a2, cyn cyn2, abw abw2, Proxy proxy, DataFixer dataFixer, vz vz2, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, acq acq2, aaq aaq2) {
        super("Server");
        this.f = b2;
        this.i = cyn2;
        this.g = proxy;
        this.Z = abw2;
        this.aj = vz2;
        this.Q = minecraftSessionService;
        this.R = gameProfileRepository;
        this.S = acq2;
        this.o = new aax(this);
        this.p = aaq2;
        this.d = a2;
        this.e = a2.b();
        this.s = dataFixer;
        this.ad = new vx(this, vz2.a());
        this.ak = new csw(vz2.h(), a2, dataFixer);
        this.U = thread;
        this.ah = x.f();
    }

    @Override
    private void a(cyc cyc2) {
        ddo ddo2 = cyc2.a(ddo::new, "scoreboard");
        ddo2.a(this.aH());
        this.aH().a(new cxr(ddo2));
    }

    protected abstract boolean d() throws IOException;

    public static void a(cyg.a a2) {
        if (a2.c()) {
            j.info("Converting map!");
            a2.a(new afn(){
                private long a = x.b();

                @Override
                public void a(nr nr2) {
                }

                @Override
                public void a(int n2) {
                    if (x.b() - this.a >= 1000L) {
                        this.a = x.b();
                        j.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void c(nr nr2) {
                }
            });
        }
    }

    protected void l_() {
        this.r();
        this.i.a(this.getServerModName(), this.o().isPresent());
        aap aap2 = this.p.create(11);
        this.a(aap2);
        this.q();
        this.b(aap2);
    }

    protected void q() {
    }

    @Override
    protected void a(aap aap2) {
        cfy \u26039;
        cym cym2 = this.i.H();
        chw \u26032 = this.i.A();
        boolean \u26033 = \u26032.g();
        long \u26034 = \u26032.a();
        long \u26035 = bsx.a(\u26034);
        ImmutableList \u26036 = ImmutableList.of((Object)new chu(), (Object)new cht(), (Object)new bff(), (Object)new azm(), (Object)new bfq(cym2));
        gi<che> \u26037 = \u26032.d();
        che \u26038 = \u26037.a(che.b);
        if (\u26038 == null) {
            chd chd2 = this.f.a().d(chd.f);
            \u26039 = chw.a(this.f.b(gm.ay), this.f.b(gm.ar), new Random().nextLong());
        } else {
            chd2 = \u26038.b();
            \u26039 = \u26038.c();
        }
        aag aag2 = new aag(this, this.ah, this.d, cym2, brx.g, chd2, aap2, \u26039, \u26033, \u26035, (List<brj>)\u26036, true);
        this.v.put(brx.g, aag2);
        cyc \u260310 = aag2.s();
        this.a(\u260310);
        this.ab = new cya(\u260310);
        cfu \u260311 = aag2.f();
        \u260311.a(cym2.r());
        if (!cym2.p()) {
            try {
                MinecraftServer.a(aag2, cym2, \u26032.c(), \u26033, true);
                cym2.c(true);
                if (\u26033) {
                    this.a(this.i);
                }
            }
            catch (Throwable throwable) {
                l l2 = l.a(throwable, "Exception initializing level");
                try {
                    aag2.a(l2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new u(l2);
            }
            cym2.c(true);
        }
        this.ae().a(aag2);
        if (this.i.E() != null) {
            this.aM().a(this.i.E());
        }
        for (Map.Entry<vj<che>, che> entry : \u26037.d()) {
            vj<che> vj2 = entry.getKey();
            if (vj2 == che.b) continue;
            vj<brx> \u260312 = vj.a(gm.L, vj2.a());
            chd \u260313 = entry.getValue().b();
            cfy \u260314 = entry.getValue().c();
            cyb \u260315 = new cyb(this.i, cym2);
            aag \u260316 = new aag(this, this.ah, this.d, \u260315, \u260312, \u260313, aap2, \u260314, \u26033, \u26035, (List<brj>)ImmutableList.of(), false);
            \u260311.a(new cfs.a(\u260316.f()));
            this.v.put(\u260312, \u260316);
        }
    }

    private static void a(aag aag2, cym cym22, boolean bl22, boolean bl3, boolean bl4) {
        boolean bl22;
        cym cym22;
        cfy cfy2 = aag2.i().g();
        if (!bl4) {
            cym22.a(fx.b.b(cfy2.c()), 0.0f);
            return;
        }
        if (bl3) {
            cym22.a(fx.b.b(), 0.0f);
            return;
        }
        bsy \u26032 = cfy2.d();
        Random \u26033 = new Random(aag2.C());
        fx \u26034 = \u26032.a(0, aag2.t_(), 0, 256, bsv2 -> bsv2.b().b(), \u26033);
        brd brd2 = \u2603 = \u26034 == null ? new brd(0, 0) : new brd(\u26034);
        if (\u26034 == null) {
            j.warn("Unable to find spawn biome");
        }
        boolean \u26035 = false;
        for (buo buo2 : aed.V.b()) {
            if (!\u26032.c().contains(buo2.n())) continue;
            \u26035 = true;
            break;
        }
        cym22.a(\u2603.l().b(8, cfy2.c(), 8), 0.0f);
        int \u26036 = 0;
        int \u26037 = 0;
        int \u26038 = 0;
        int \u26039 = -1;
        int \u260310 = 32;
        for (int i2 = 0; i2 < 1024; ++i2) {
            if (\u26036 > -16 && \u26036 <= 16 && \u26037 > -16 && \u26037 <= 16 && (\u2603 = aab.a(aag2, new brd(\u2603.b + \u26036, \u2603.c + \u26037), \u26035)) != null) {
                cym22.a(\u2603, 0.0f);
                break;
            }
            if (\u26036 == \u26037 || \u26036 < 0 && \u26036 == -\u26037 || \u26036 > 0 && \u26036 == 1 - \u26037) {
                \u2603 = \u26038;
                \u26038 = -\u26039;
                \u26039 = \u2603;
            }
            \u26036 += \u26038;
            \u26037 += \u26039;
        }
        if (bl22) {
            civ<?, ?> civ2 = kh.U;
            civ2.a(aag2, cfy2, aag2.t, new fx(cym22.a(), cym22.b(), cym22.c()));
        }
    }

    @Override
    private void a(cyn cyn2) {
        cyn2.a(aor.a);
        cyn2.d(true);
        cym cym2 = cyn2.H();
        cym2.b(false);
        cym2.a(false);
        cym2.a(1000000000);
        cym2.b(6000L);
        cym2.a(bru.e);
    }

    private void b(aap aap2) {
        aag aag2 = this.E();
        j.info("Preparing start region for dimension {}", (Object)aag2.Y().a());
        fx \u26032 = aag2.u();
        aap2.a(new brd(\u26032));
        aae \u26033 = aag2.i();
        \u26033.a().a(500);
        this.V = x.b();
        \u26033.a(aal.a, new brd(\u26032), 11, afx.a);
        while (\u26033.b() != 441) {
            this.V = x.b() + 10L;
            this.x();
        }
        this.V = x.b() + 10L;
        this.x();
        for (aag aag3 : this.v.values()) {
            brs brs2 = aag3.s().b(brs::new, "chunks");
            if (brs2 == null) continue;
            LongIterator \u26034 = brs2.a().iterator();
            while (\u26034.hasNext()) {
                long l2 = \u26034.nextLong();
                brd \u26035 = new brd(l2);
                aag3.i().a(\u26035, true);
            }
        }
        this.V = x.b() + 10L;
        this.x();
        aap2.b();
        \u26033.a().a(5);
        this.bc();
    }

    protected void r() {
        File file = this.d.a(cye.h).toFile();
        if (file.isFile()) {
            String string = this.d.a();
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException \u26032) {
                j.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public bru s() {
        return this.i.m();
    }

    public boolean f() {
        return this.i.n();
    }

    public abstract int g();

    public abstract int h();

    public abstract boolean i();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (aag aag2 : this.G()) {
            if (!bl2) {
                j.info("Saving chunks for level '{}'/{}", (Object)aag2, (Object)aag2.Y().a());
            }
            aag2.a(null, bl3, aag2.c && !bl4);
            bl5 = true;
        }
        aag aag2 = this.E();
        cym cym2 = this.i.H();
        cym2.a(aag2.f().t());
        this.i.b(this.aM().c());
        this.d.a(this.f, this.i, this.ae().q());
        return bl5;
    }

    @Override
    public void close() {
        this.t();
    }

    protected void t() {
        j.info("Stopping server");
        if (this.af() != null) {
            this.af().b();
        }
        if (this.w != null) {
            j.info("Saving players");
            this.w.h();
            this.w.r();
        }
        j.info("Saving worlds");
        for (aag aag2 : this.G()) {
            if (aag2 == null) continue;
            aag2.c = false;
        }
        this.a(false, true, false);
        for (aag aag2 : this.G()) {
            if (aag2 == null) continue;
            try {
                aag2.close();
            }
            catch (IOException iOException) {
                j.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
        this.aj.close();
        try {
            this.d.close();
        }
        catch (IOException iOException) {
            j.error("Failed to unlock level {}", (Object)this.d.a(), (Object)iOException);
        }
    }

    public String u() {
        return this.t;
    }

    public void a_(String string) {
        this.t = string;
    }

    public boolean v() {
        return this.x;
    }

    @Override
    public void a(boolean bl2) {
        this.x = false;
        if (bl2) {
            try {
                this.U.join();
            }
            catch (InterruptedException interruptedException) {
                j.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void w() {
        try {
            if (this.d()) {
                this.V = x.b();
                this.q.a(new oe(this.E));
                this.q.a(new un.c(w.a().getName(), w.a().getProtocolVersion()));
                this.a(this.q);
                while (this.x) {
                    long l2 = x.b() - this.V;
                    if (l2 > 2000L && this.V - this.N >= 15000L) {
                        \u2603 = l2 / 50L;
                        j.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.V += \u2603 * 50L;
                        this.N = this.V;
                    }
                    this.V += 50L;
                    anz \u26032 = anz.a("Server");
                    this.a(\u26032);
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::ba);
                    this.n.b("nextTickWait");
                    this.X = true;
                    this.W = Math.max(x.b() + 50L, this.V);
                    this.x();
                    this.n.c();
                    this.n.b();
                    this.b(\u26032);
                    this.M = true;
                }
            } else {
                this.a((l)null);
            }
        }
        catch (Throwable throwable) {
            j.error("Encountered an unexpected exception", throwable);
            l l3 = throwable instanceof u ? this.b(((u)throwable).a()) : this.b(new l("Exception in server tick loop", throwable));
            File \u26033 = new File(new File(this.B(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (l3.a(\u26033)) {
                j.error("This crash report has been saved to: {}", (Object)\u26033.getAbsolutePath());
            } else {
                j.error("We were unable to save this crash report to disk.");
            }
            this.a(l3);
        }
        finally {
            try {
                this.y = true;
                this.t();
            }
            catch (Throwable \u26034) {
                j.error("Exception stopping the server", \u26034);
            }
            finally {
                this.e();
            }
        }
    }

    private boolean ba() {
        return this.bn() || x.b() < (this.X ? this.W : this.V);
    }

    protected void x() {
        this.bl();
        this.c(() -> !this.ba());
    }

    protected wb a(Runnable runnable) {
        return new wb(this.z, runnable);
    }

    protected boolean a(wb wb2) {
        return wb2.a() + 3 < this.z || this.ba();
    }

    @Override
    public boolean y() {
        boolean bl2;
        this.X = bl2 = this.bb();
        return bl2;
    }

    private boolean bb() {
        if (super.y()) {
            return true;
        }
        if (this.ba()) {
            for (aag aag2 : this.G()) {
                if (!aag2.i().d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void b(wb wb2) {
        this.aQ().c("runTask");
        super.c(wb2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void a(un un2) {
        File file = this.c("server-icon.png");
        if (!file.exists()) {
            file = this.d.f();
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                un2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                j.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File B() {
        return new File(".");
    }

    @Override
    protected void a(l l2) {
    }

    protected void e() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = x.c();
        ++this.z;
        this.b(booleanSupplier);
        if (l2 - this.T >= 5000000000L) {
            this.T = l2;
            this.q.a(new un.a(this.J(), this.I()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.I(), 12)];
            int \u26032 = afm.a(this.r, 0, this.I() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.w.s().get(\u26032 + i2).eA();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.z % 6000 == 0) {
            j.debug("Autosave started");
            this.n.a("save");
            this.w.h();
            this.a(true, false, false);
            this.n.c();
            j.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.z > 100) {
            this.k.a();
        }
        if (this.z % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = x.c() - l2;
        this.h[this.z % 100] = l3;
        \u2603 = l3;
        this.ag = this.ag * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = x.c();
        this.ae.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.aB().d();
        this.n.b("levels");
        for (aag aag2 : this.G()) {
            this.n.a(() -> aag2 + " " + aag2.Y().a());
            if (this.z % 20 == 0) {
                this.n.a("timeSync");
                this.w.a(new rk(aag2.T(), aag2.U(), aag2.V().b(brt.j)), aag2.Y());
                this.n.c();
            }
            this.n.a("tick");
            try {
                aag2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                l l2 = l.a(throwable, "Exception ticking world");
                aag2.a(l2);
                throw new u(l2);
            }
            this.n.c();
            this.n.c();
        }
        this.n.b("connection");
        this.af().c();
        this.n.b("players");
        this.w.d();
        if (w.d) {
            ll.a.b();
        }
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            this.l.get(i2).run();
        }
        this.n.c();
    }

    public boolean C() {
        return true;
    }

    public void b(Runnable runnable) {
        this.l.add(runnable);
    }

    protected void b(String string) {
        this.ai = string;
    }

    public File c(String string) {
        return new File(this.B(), string);
    }

    public final aag E() {
        return this.v.get(brx.g);
    }

    @Nullable
    public aag a(vj<brx> vj2) {
        return this.v.get(vj2);
    }

    public Set<vj<brx>> F() {
        return this.v.keySet();
    }

    public Iterable<aag> G() {
        return this.v.values();
    }

    public String H() {
        return w.a().getName();
    }

    public int I() {
        return this.w.m();
    }

    public int J() {
        return this.w.n();
    }

    public String[] K() {
        return this.w.e();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public l b(l l2) {
        if (this.w != null) {
            l2.g().a("Player Count", () -> this.w.m() + " / " + this.w.n() + "; " + this.w.s());
        }
        l2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (abu abu2 : this.Z.e()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(abu2.e());
                if (abu2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.ai != null) {
            l2.g().a("Server Id", () -> this.ai);
        }
        return l2;
    }

    public abstract Optional<String> o();

    @Override
    public void a(nr nr2, UUID uUID) {
        j.info(nr2.getString());
    }

    public KeyPair L() {
        return this.H;
    }

    public int M() {
        return this.u;
    }

    @Override
    public void a(int n2) {
        this.u = n2;
    }

    public String N() {
        return this.I;
    }

    public void d(String string) {
        this.I = string;
    }

    public boolean O() {
        return this.I != null;
    }

    protected void P() {
        j.info("Generating keypair");
        try {
            this.H = aeu.b();
        }
        catch (aev aev2) {
            throw new IllegalStateException("Failed to generate key pair", aev2);
        }
    }

    public void a(aor aor2, boolean bl2) {
        if (!bl2 && this.i.t()) {
            return;
        }
        this.i.a(this.i.n() ? aor.d : aor2);
        this.bc();
        this.ae().s().forEach(this::b);
    }

    public int b(int n2) {
        return n2;
    }

    private void bc() {
        for (aag aag2 : this.G()) {
            aag2.b(this.Q(), this.X());
        }
    }

    public void b(boolean bl2) {
        this.i.d(bl2);
        this.ae().s().forEach(this::b);
    }

    private void b(aah aah2) {
        cyd cyd2 = aah2.u().h();
        aah2.b.a(new pa(cyd2.s(), cyd2.t()));
    }

    protected boolean Q() {
        return this.i.s() != aor.a;
    }

    public boolean R() {
        return this.J;
    }

    @Override
    public void c(boolean bl2) {
        this.J = bl2;
    }

    public String S() {
        return this.K;
    }

    public String T() {
        return this.L;
    }

    public void a(String string, String string2) {
        this.K = string;
        this.L = string2;
    }

    @Override
    public void a(apc apc22) {
        apc apc22;
        apc22.a("whitelist_enabled", false);
        apc22.a("whitelist_count", 0);
        if (this.w != null) {
            apc22.a("players_current", this.I());
            apc22.a("players_max", this.J());
            apc22.a("players_seen", this.e.a().length);
        }
        apc22.a("uses_auth", this.A);
        apc22.a("gui_state", this.ah() ? "enabled" : "disabled");
        apc22.a("run_time", (x.b() - apc22.g()) / 60L * 1000L);
        apc22.a("avg_tick_ms", (int)(afm.a(this.h) * 1.0E-6));
        int n2 = 0;
        for (aag aag2 : this.G()) {
            if (aag2 == null) continue;
            apc22.a("world[" + n2 + "][dimension]", aag2.Y().a());
            apc22.a("world[" + n2 + "][mode]", (Object)this.i.m());
            apc22.a("world[" + n2 + "][difficulty]", (Object)aag2.ad());
            apc22.a("world[" + n2 + "][hardcore]", this.i.n());
            apc22.a("world[" + n2 + "][height]", this.F);
            apc22.a("world[" + n2 + "][chunks_loaded]", aag2.i().h());
            ++n2;
        }
        apc22.a("worlds", n2);
    }

    public abstract boolean j();

    public abstract int k();

    public boolean V() {
        return this.A;
    }

    public void d(boolean bl2) {
        this.A = bl2;
    }

    public boolean W() {
        return this.B;
    }

    public void e(boolean bl2) {
        this.B = bl2;
    }

    public boolean X() {
        return true;
    }

    public boolean Y() {
        return true;
    }

    public abstract boolean l();

    public boolean Z() {
        return this.C;
    }

    public void f(boolean bl2) {
        this.C = bl2;
    }

    public boolean aa() {
        return this.D;
    }

    public void g(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean m();

    public String ab() {
        return this.E;
    }

    public void e(String string) {
        this.E = string;
    }

    public int ac() {
        return this.F;
    }

    @Override
    public void c(int n2) {
        this.F = n2;
    }

    public boolean ad() {
        return this.y;
    }

    public acu ae() {
        return this.w;
    }

    @Override
    public void a(acu acu2) {
        this.w = acu2;
    }

    public abstract boolean n();

    @Override
    public void a(bru bru2) {
        this.i.a(bru2);
    }

    @Nullable
    public aax af() {
        return this.o;
    }

    public boolean ah() {
        return false;
    }

    public abstract boolean a(bru var1, boolean var2, int var3);

    public int ai() {
        return this.z;
    }

    public int ak() {
        return 16;
    }

    public boolean a(aag aag2, fx fx2, bfw bfw2) {
        return false;
    }

    @Override
    public void h(boolean bl2) {
        this.P = bl2;
    }

    public boolean al() {
        return this.P;
    }

    public boolean am() {
        return true;
    }

    public int ao() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    public MinecraftSessionService ap() {
        return this.Q;
    }

    public GameProfileRepository aq() {
        return this.R;
    }

    public acq ar() {
        return this.S;
    }

    public un as() {
        return this.q;
    }

    public void at() {
        this.T = 0L;
    }

    public int au() {
        return 29999984;
    }

    @Override
    public boolean av() {
        return super.av() && !this.ad();
    }

    @Override
    public Thread aw() {
        return this.U;
    }

    public int ax() {
        return 256;
    }

    public long ay() {
        return this.V;
    }

    public DataFixer az() {
        return this.s;
    }

    public int a(@Nullable aag aag2) {
        if (aag2 != null) {
            return aag2.V().c(brt.q);
        }
        return 10;
    }

    public vv aA() {
        return this.aj.g();
    }

    public vx aB() {
        return this.ad;
    }

    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)collection.stream().map(this.Z::a).filter(Objects::nonNull).map(abu::d).collect(ImmutableList.toImmutableList()), this).thenCompose(immutableList -> vz.a((List<abj>)immutableList, this.j() ? dc.a.b : dc.a.c, this.h(), this.ah, this))).thenAcceptAsync(vz2 -> {
            this.aj.close();
            this.aj = vz2;
            this.Z.a(collection);
            this.i.a(MinecraftServer.a(this.Z));
            vz2.i();
            this.ae().h();
            this.ae().t();
            this.ad.a(this.aj.a());
            this.ak.a(this.aj.h());
        }, (Executor)this);
        if (this.bh()) {
            this.c(((CompletableFuture)completionStage)::isDone);
        }
        return completionStage;
    }

    public static brk a(abw abw22, brk brk2, boolean bl2) {
        abw22.a();
        if (bl2) {
            abw22.a(Collections.singleton("vanilla"));
            return new brk((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : brk2.a()) {
            if (abw22.b(string)) {
                linkedHashSet.add(string);
                continue;
            }
            j.warn("Missing data pack {}", (Object)string);
        }
        for (abu abu2 : abw22.c()) {
            String string = abu2.e();
            if (brk2.b().contains(string) || linkedHashSet.contains(string)) continue;
            j.info("Found new data pack {}, loading it automatically", (Object)string);
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty()) {
            j.info("No datapacks selected, forcing vanilla");
            linkedHashSet.add("vanilla");
        }
        abw22.a(linkedHashSet);
        return MinecraftServer.a(abw22);
    }

    private static brk a(abw abw2) {
        Collection<String> collection = abw2.d();
        ImmutableList \u26032 = ImmutableList.copyOf(collection);
        List \u26033 = (List)abw2.b().stream().filter(string -> !collection.contains(string)).collect(ImmutableList.toImmutableList());
        return new brk((List<String>)\u26032, \u26033);
    }

    @Override
    public void a(db db2) {
        if (!this.aN()) {
            return;
        }
        acu acu2 = db2.j().ae();
        adb \u26032 = acu2.i();
        ArrayList \u26033 = Lists.newArrayList(acu2.s());
        for (aah aah2 : \u26033) {
            if (\u26032.a(aah2.eA())) continue;
            aah2.b.b(new of("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public abw aC() {
        return this.Z;
    }

    public dc aD() {
        return this.aj.f();
    }

    public db aE() {
        aag aag2 = this.E();
        return new db(this, aag2 == null ? dcn.a : dcn.b(aag2.u()), dcm.a, aag2, 4, "Server", new oe("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public bor aF() {
        return this.aj.e();
    }

    public aen aG() {
        return this.aj.d();
    }

    public wa aH() {
        return this.aa;
    }

    public cya aI() {
        if (this.ab == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.ab;
    }

    public cyz aJ() {
        return this.aj.c();
    }

    public cza aK() {
        return this.aj.b();
    }

    public brt aL() {
        return this.E().V();
    }

    public wd aM() {
        return this.ac;
    }

    public boolean aN() {
        return this.af;
    }

    public void i(boolean bl2) {
        this.af = bl2;
    }

    public float aO() {
        return this.ag;
    }

    public int b(GameProfile gameProfile) {
        if (this.ae().h(gameProfile)) {
            acw acw2 = (acw)this.ae().k().b(gameProfile);
            if (acw2 != null) {
                return acw2.a();
            }
            if (this.a(gameProfile)) {
                return 4;
            }
            if (this.O()) {
                return this.ae().u() ? 4 : 0;
            }
            return this.g();
        }
        return 0;
    }

    public anw aQ() {
        return this.n;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<vj<brx>, aag> entry : this.v.entrySet()) {
            vk vk2 = entry.getKey().a();
            Path \u26032 = \u2603.resolve(vk2.b()).resolve(vk2.a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().a(\u26032);
        }
        this.d(path.resolve("gamerules.txt"));
        this.e(path.resolve("classpath.txt"));
        this.c(path.resolve("example_crash.txt"));
        this.b(path.resolve("stats.txt"));
        this.f(path.resolve("threads.txt"));
    }

    private void b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.bi()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aO())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.h)));
            bufferedWriter.write(String.format("queue: %s\n", x.f()));
        }
    }

    @Override
    private void c(Path path) throws IOException {
        l l2 = new l("Server dump", new Exception("dummy"));
        this.b(l2);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(l2.e());
        }
    }

    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final brt \u26032 = this.aL();
            brt.a(new brt.c(){

                @Override
                public <T extends brt.g<T>> void a(brt.e<T> e2, brt.f<T> f2) {
                    arrayList.add(String.format("%s=%s\n", e2.a(), ((brt.g)\u26032.a(e2)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    @Override
    private void a(@Nullable anz anz2) {
        if (this.O) {
            this.O = false;
            this.m.c();
        }
        this.n = anz.a(this.m.d(), anz2);
    }

    private void b(@Nullable anz anz2) {
        if (anz2 != null) {
            anz2.b();
        }
        this.n = this.m.d();
    }

    public boolean aS() {
        return this.m.a();
    }

    public void aT() {
        this.O = true;
    }

    public anv aU() {
        anv anv2 = this.m.e();
        this.m.b();
        return anv2;
    }

    public Path a(cye cye2) {
        return this.d.a(cye2);
    }

    public boolean aV() {
        return true;
    }

    public csw aW() {
        return this.ak;
    }

    public cyn aX() {
        return this.i;
    }

    public gn aY() {
        return this.f;
    }

    @Nullable
    public abc a(aah aah2) {
        return null;
    }

    @Override
    public /* synthetic */ void c(Runnable runnable) {
        this.b((wb)runnable);
    }

    @Override
    public /* synthetic */ boolean d(Runnable runnable) {
        return this.a((wb)runnable);
    }

    @Override
    public /* synthetic */ Runnable e(Runnable runnable) {
        return this.a(runnable);
    }
}

