/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ShipwreckPieces {
    private static final BlockPos field_207663_a = new BlockPos(4, 0, 15);
    private static final ResourceLocation[] field_204761_a = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};
    private static final ResourceLocation[] field_204762_b = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/upsidedown_full"), new ResourceLocation("shipwreck/upsidedown_fronthalf"), new ResourceLocation("shipwreck/upsidedown_backhalf"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/upsidedown_full_degraded"), new ResourceLocation("shipwreck/upsidedown_fronthalf_degraded"), new ResourceLocation("shipwreck/upsidedown_backhalf_degraded"), new ResourceLocation("shipwreck/sideways_full_degraded"), new ResourceLocation("shipwreck/sideways_fronthalf_degraded"), new ResourceLocation("shipwreck/sideways_backhalf_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};

    public static void func_204760_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, List<StructurePiece> list, Random random, ShipwreckConfig shipwreckConfig) {
        ResourceLocation resourceLocation = Util.func_240989_a_(shipwreckConfig.field_204753_a ? field_204761_a : field_204762_b, random);
        list.add(new Piece(templateManager, resourceLocation, blockPos, rotation, shipwreckConfig.field_204753_a));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final Rotation field_204755_d;
        private final ResourceLocation field_204756_e;
        private final boolean field_204757_f;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, boolean bl) {
            super(IStructurePieceType.field_214753_ac, 0);
            this.field_186178_c = blockPos;
            this.field_204755_d = rotation;
            this.field_204756_e = resourceLocation;
            this.field_204757_f = bl;
            this.func_204754_a(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214753_ac, compoundNBT);
            this.field_204756_e = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.field_204757_f = compoundNBT.func_74767_n("isBeached");
            this.field_204755_d = Rotation.valueOf(compoundNBT.func_74779_i("Rot"));
            this.func_204754_a(templateManager);
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74778_a("Template", this.field_204756_e.toString());
            compoundNBT.func_74757_a("isBeached", this.field_204757_f);
            compoundNBT.func_74778_a("Rot", this.field_204755_d.name());
        }

        private void func_204754_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.field_204756_e);
            PlacementSettings \u26032 = new PlacementSettings().func_186220_a(this.field_204755_d).func_186214_a(Mirror.NONE).func_207665_a(field_207663_a).func_215222_a(BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, \u26032);
        }

        @Override
        protected void func_186175_a(String string, BlockPos blockPos, IServerWorld iServerWorld, Random random, MutableBoundingBox mutableBoundingBox) {
            if ("map_chest".equals(string)) {
                LockableLootTileEntity.func_195479_a(iServerWorld, random, blockPos.func_177977_b(), LootTables.field_204771_s);
            } else if ("treasure_chest".equals(string)) {
                LockableLootTileEntity.func_195479_a(iServerWorld, random, blockPos.func_177977_b(), LootTables.field_204773_u);
            } else if ("supply_chest".equals(string)) {
                LockableLootTileEntity.func_195479_a(iServerWorld, random, blockPos.func_177977_b(), LootTables.field_204772_t);
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            int n = 256;
            \u2603 = 0;
            BlockPos \u26032 = this.field_186176_a.func_186259_a();
            Heightmap.Type \u26033 = this.field_204757_f ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.OCEAN_FLOOR_WG;
            n2 = \u26032.func_177958_n() * \u26032.func_177952_p();
            if (n2 == 0) {
                \u2603 = iSeedReader.func_201676_a(\u26033, this.field_186178_c.func_177958_n(), this.field_186178_c.func_177952_p());
            } else {
                int n2;
                BlockPos blockPos2 = this.field_186178_c.func_177982_a(\u26032.func_177958_n() - 1, 0, \u26032.func_177952_p() - 1);
                for (BlockPos blockPos3 : BlockPos.func_218278_a(this.field_186178_c, blockPos2)) {
                    int n3 = iSeedReader.func_201676_a(\u26033, blockPos3.func_177958_n(), blockPos3.func_177952_p());
                    \u2603 += n3;
                    n = Math.min(n, n3);
                }
                \u2603 /= n2;
            }
            \u2603 = this.field_204757_f ? n - \u26032.func_177956_o() / 2 - random.nextInt(3) : \u2603;
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), \u2603, this.field_186178_c.func_177952_p());
            return super.func_230383_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos, blockPos);
        }
    }
}

