/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.gen.feature.WeepingVineFeature;

public class HugeFungusFeature
extends Feature<HugeFungusConfig> {
    public HugeFungusFeature(Codec<HugeFungusConfig> codec) {
        super(codec);
    }

    @Override
    public boolean func_241855_a(ISeedReader iSeedReader, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, HugeFungusConfig hugeFungusConfig2) {
        Block block = hugeFungusConfig2.field_236303_f_.func_177230_c();
        BlockPos \u26032 = null;
        Block block2 = iSeedReader.func_180495_p(blockPos.func_177977_b()).func_177230_c();
        if (block2 == block) {
            \u26032 = blockPos;
        }
        if (\u26032 == null) {
            return false;
        }
        int \u26033 = MathHelper.func_76136_a(random, 4, 13);
        if (random.nextInt(12) == 0) {
            \u26033 *= 2;
        }
        if (!hugeFungusConfig2.field_236307_j_) {
            int n = chunkGenerator.func_230355_e_();
            if (\u26032.func_177956_o() + \u26033 + 1 >= n) {
                return false;
            }
        }
        boolean bl = !hugeFungusConfig2.field_236307_j_ && random.nextFloat() < 0.06f;
        iSeedReader.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 4);
        this.func_236317_a_(iSeedReader, random, hugeFungusConfig2, \u26032, \u26033, bl);
        this.func_236321_b_(iSeedReader, random, hugeFungusConfig2, \u26032, \u26033, bl);
        return true;
    }

    private static boolean func_236315_a_(IWorld iWorld, BlockPos blockPos, boolean bl) {
        return iWorld.func_217375_a(blockPos, blockState -> {
            Material material = blockState.func_185904_a();
            return blockState.func_185904_a().func_76222_j() || bl && material == Material.field_151585_k;
        });
    }

    private void func_236317_a_(IWorld iWorld, Random random, HugeFungusConfig hugeFungusConfig, BlockPos blockPos, int n, boolean bl) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        BlockState \u26032 = hugeFungusConfig.field_236304_g_;
        int \u26033 = bl ? 1 : 0;
        for (int i = -\u26033; i <= \u26033; ++i) {
            for (\u2603 = -\u26033; \u2603 <= \u26033; ++\u2603) {
                boolean bl2 = bl && MathHelper.func_76130_a(i) == \u26033 && MathHelper.func_76130_a(\u2603) == \u26033;
                for (int j = 0; j < n; ++j) {
                    mutable.func_239621_a_(blockPos, i, j, \u2603);
                    if (!HugeFungusFeature.func_236315_a_(iWorld, mutable, true)) continue;
                    if (hugeFungusConfig.field_236307_j_) {
                        if (!iWorld.func_180495_p((BlockPos)mutable.func_177977_b()).func_196958_f()) {
                            iWorld.func_175655_b(mutable, true);
                        }
                        iWorld.func_180501_a(mutable, \u26032, 3);
                        continue;
                    }
                    if (bl2) {
                        if (!(random.nextFloat() < 0.1f)) continue;
                        this.func_230367_a_(iWorld, mutable, \u26032);
                        continue;
                    }
                    this.func_230367_a_(iWorld, mutable, \u26032);
                }
            }
        }
    }

    private void func_236321_b_(IWorld iWorld, Random random, HugeFungusConfig hugeFungusConfig, BlockPos blockPos, int n, boolean bl) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        boolean \u26032 = hugeFungusConfig.field_236305_h_.func_203425_a(Blocks.field_189878_dg);
        int \u26033 = Math.min(random.nextInt(1 + n / 3) + 5, n);
        for (int i = \u2603 = n - \u26033; i <= n; ++i) {
            int n2 = \u2603 = i < n - random.nextInt(3) ? 2 : 1;
            if (\u26033 > 8 && i < \u2603 + 4) {
                \u2603 = 3;
            }
            if (bl) {
                ++\u2603;
            }
            for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                    boolean bl2 = \u2603 == -\u2603 || \u2603 == \u2603;
                    \u2603 = \u2603 == -\u2603 || \u2603 == \u2603;
                    \u2603 = !bl2 && !\u2603 && i != n;
                    \u2603 = bl2 && \u2603;
                    \u2603 = i < \u2603 + 3;
                    mutable.func_239621_a_(blockPos, \u2603, i, \u2603);
                    if (!HugeFungusFeature.func_236315_a_(iWorld, mutable, false)) continue;
                    if (hugeFungusConfig.field_236307_j_ && !iWorld.func_180495_p((BlockPos)mutable.func_177977_b()).func_196958_f()) {
                        iWorld.func_175655_b(mutable, true);
                    }
                    if (\u2603) {
                        if (\u2603) continue;
                        this.func_236318_a_(iWorld, random, mutable, hugeFungusConfig.field_236305_h_, \u26032);
                        continue;
                    }
                    if (\u2603) {
                        this.func_236316_a_(iWorld, random, hugeFungusConfig, mutable, 0.1f, 0.2f, \u26032 ? 0.1f : 0.0f);
                        continue;
                    }
                    if (\u2603) {
                        this.func_236316_a_(iWorld, random, hugeFungusConfig, mutable, 0.01f, 0.7f, \u26032 ? 0.083f : 0.0f);
                        continue;
                    }
                    this.func_236316_a_(iWorld, random, hugeFungusConfig, mutable, 5.0E-4f, 0.98f, \u26032 ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void func_236316_a_(IWorld iWorld, Random random, HugeFungusConfig hugeFungusConfig, BlockPos.Mutable mutable, float f, float f2, float f3) {
        if (random.nextFloat() < f) {
            this.func_230367_a_(iWorld, mutable, hugeFungusConfig.field_236306_i_);
        } else if (random.nextFloat() < f2) {
            this.func_230367_a_(iWorld, mutable, hugeFungusConfig.field_236305_h_);
            if (random.nextFloat() < f3) {
                HugeFungusFeature.func_236319_a_(mutable, iWorld, random);
            }
        }
    }

    private void func_236318_a_(IWorld iWorld, Random random, BlockPos blockPos, BlockState blockState, boolean bl) {
        if (iWorld.func_180495_p(blockPos.func_177977_b()).func_203425_a(blockState.func_177230_c())) {
            this.func_230367_a_(iWorld, blockPos, blockState);
        } else if ((double)random.nextFloat() < 0.15) {
            this.func_230367_a_(iWorld, blockPos, blockState);
            if (bl && random.nextInt(11) == 0) {
                HugeFungusFeature.func_236319_a_(blockPos, iWorld, random);
            }
        }
    }

    private static void func_236319_a_(BlockPos blockPos, IWorld iWorld, Random random) {
        BlockPos.Mutable mutable = blockPos.func_239590_i_().func_189536_c(Direction.DOWN);
        if (!iWorld.func_175623_d(mutable)) {
            return;
        }
        int \u26032 = MathHelper.func_76136_a(random, 1, 5);
        if (random.nextInt(7) == 0) {
            \u26032 *= 2;
        }
        int \u26033 = 23;
        int \u26034 = 25;
        WeepingVineFeature.func_236427_a_(iWorld, random, mutable, \u26032, 23, 25);
    }
}

