/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.BanEntry;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import net.minecraft.util.StringUtils;
import net.minecraft.world.storage.FolderName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreYggdrasilConverter {
    private static final Logger field_152732_e = LogManager.getLogger();
    public static final File field_152728_a = new File("banned-ips.txt");
    public static final File field_152729_b = new File("banned-players.txt");
    public static final File field_152730_c = new File("ops.txt");
    public static final File field_152731_d = new File("white-list.txt");

    static List<String> func_152721_a(File file, Map<String, String[]> map) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String string : list) {
            if ((string = string.trim()).startsWith("#") || string.length() < 1) continue;
            String[] stringArray = string.split("\\|");
            map.put(stringArray[0].toLowerCase(Locale.ROOT), stringArray);
        }
        return list;
    }

    private static void func_152717_a(MinecraftServer minecraftServer, Collection<String> collection, ProfileLookupCallback profileLookupCallback) {
        String[] stringArray = (String[])collection.stream().filter(string -> !StringUtils.func_151246_b(string)).toArray(String[]::new);
        if (minecraftServer.func_71266_T()) {
            minecraftServer.func_152359_aw().findProfilesByNames(stringArray, Agent.MINECRAFT, profileLookupCallback);
        } else {
            for (String string2 : stringArray) {
                UUID uUID = PlayerEntity.func_146094_a(new GameProfile(null, string2));
                GameProfile \u26032 = new GameProfile(uUID, string2);
                profileLookupCallback.onProfileLookupSucceeded(\u26032);
            }
        }
    }

    public static boolean func_152724_a(final MinecraftServer minecraftServer) {
        final BanList banList = new BanList(PlayerList.field_152613_a);
        if (field_152729_b.exists() && field_152729_b.isFile()) {
            if (banList.func_152691_c().exists()) {
                try {
                    banList.func_152679_g();
                }
                catch (IOException iOException) {
                    field_152732_e.warn("Could not load existing file {}", (Object)banList.func_152691_c().getName(), (Object)iOException);
                }
            }
            try {
                final HashMap hashMap = Maps.newHashMap();
                PreYggdrasilConverter.func_152721_a(field_152729_b, hashMap);
                ProfileLookupCallback \u26032 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        minecraftServer.func_152358_ax().func_152649_a(gameProfile);
                        String[] stringArray = (String[])hashMap.get(gameProfile.getName().toLowerCase(Locale.ROOT));
                        if (stringArray == null) {
                            field_152732_e.warn("Could not convert user banlist entry for {}", (Object)gameProfile.getName());
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date \u26032 = stringArray.length > 1 ? PreYggdrasilConverter.func_152713_b(stringArray[1], null) : null;
                        String \u26033 = stringArray.length > 2 ? stringArray[2] : null;
                        Date \u26034 = stringArray.length > 3 ? PreYggdrasilConverter.func_152713_b(stringArray[3], null) : null;
                        String \u26035 = stringArray.length > 4 ? stringArray[4] : null;
                        banList.func_152687_a(new ProfileBanEntry(gameProfile, \u26032, \u26033, \u26034, \u26035));
                    }

                    public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                        field_152732_e.warn("Could not lookup user banlist entry for {}", (Object)gameProfile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                        }
                    }
                };
                PreYggdrasilConverter.func_152717_a(minecraftServer, hashMap.keySet(), \u26032);
                banList.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152729_b);
            }
            catch (IOException iOException) {
                field_152732_e.warn("Could not read old user banlist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (ConversionError conversionError) {
                field_152732_e.error("Conversion failed, please try again later", (Throwable)conversionError);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean func_152722_b(MinecraftServer minecraftServer) {
        IPBanList iPBanList = new IPBanList(PlayerList.field_152614_b);
        if (field_152728_a.exists() && field_152728_a.isFile()) {
            if (iPBanList.func_152691_c().exists()) {
                try {
                    iPBanList.func_152679_g();
                }
                catch (IOException iOException) {
                    field_152732_e.warn("Could not load existing file {}", (Object)iPBanList.func_152691_c().getName(), (Object)iOException);
                }
            }
            try {
                HashMap hashMap = Maps.newHashMap();
                PreYggdrasilConverter.func_152721_a(field_152728_a, hashMap);
                for (String string : hashMap.keySet()) {
                    String[] stringArray = (String[])hashMap.get(string);
                    Date \u26032 = stringArray.length > 1 ? PreYggdrasilConverter.func_152713_b(stringArray[1], null) : null;
                    String \u26033 = stringArray.length > 2 ? stringArray[2] : null;
                    Date \u26034 = stringArray.length > 3 ? PreYggdrasilConverter.func_152713_b(stringArray[3], null) : null;
                    String \u26035 = stringArray.length > 4 ? stringArray[4] : null;
                    iPBanList.func_152687_a(new IPBanEntry(string, \u26032, \u26033, \u26034, \u26035));
                }
                iPBanList.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152728_a);
            }
            catch (IOException iOException) {
                field_152732_e.warn("Could not parse old ip banlist to convert it!", (Throwable)iOException);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean func_152718_c(final MinecraftServer minecraftServer) {
        final OpList opList = new OpList(PlayerList.field_152615_c);
        if (field_152730_c.exists() && field_152730_c.isFile()) {
            if (opList.func_152691_c().exists()) {
                try {
                    opList.func_152679_g();
                }
                catch (IOException iOException) {
                    field_152732_e.warn("Could not load existing file {}", (Object)opList.func_152691_c().getName(), (Object)iOException);
                }
            }
            try {
                List list = Files.readLines((File)field_152730_c, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback \u26032 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        minecraftServer.func_152358_ax().func_152649_a(gameProfile);
                        opList.func_152687_a(new OpEntry(gameProfile, minecraftServer.func_110455_j(), false));
                    }

                    public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                        field_152732_e.warn("Could not lookup oplist entry for {}", (Object)gameProfile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                        }
                    }
                };
                PreYggdrasilConverter.func_152717_a(minecraftServer, list, \u26032);
                opList.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152730_c);
            }
            catch (IOException iOException) {
                field_152732_e.warn("Could not read old oplist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (ConversionError conversionError) {
                field_152732_e.error("Conversion failed, please try again later", (Throwable)conversionError);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean func_152710_d(final MinecraftServer minecraftServer) {
        final WhiteList whiteList = new WhiteList(PlayerList.field_152616_d);
        if (field_152731_d.exists() && field_152731_d.isFile()) {
            if (whiteList.func_152691_c().exists()) {
                try {
                    whiteList.func_152679_g();
                }
                catch (IOException iOException) {
                    field_152732_e.warn("Could not load existing file {}", (Object)whiteList.func_152691_c().getName(), (Object)iOException);
                }
            }
            try {
                List list = Files.readLines((File)field_152731_d, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback \u26032 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        minecraftServer.func_152358_ax().func_152649_a(gameProfile);
                        whiteList.func_152687_a(new WhitelistEntry(gameProfile));
                    }

                    public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                        field_152732_e.warn("Could not lookup user whitelist entry for {}", (Object)gameProfile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                        }
                    }
                };
                PreYggdrasilConverter.func_152717_a(minecraftServer, list, \u26032);
                whiteList.func_152678_f();
                PreYggdrasilConverter.func_152727_c(field_152731_d);
            }
            catch (IOException iOException) {
                field_152732_e.warn("Could not read old whitelist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (ConversionError conversionError) {
                field_152732_e.error("Conversion failed, please try again later", (Throwable)conversionError);
                return false;
            }
            return true;
        }
        return true;
    }

    @Nullable
    public static UUID func_187473_a(final MinecraftServer minecraftServer2, String string) {
        MinecraftServer minecraftServer2;
        if (StringUtils.func_151246_b(string) || string.length() > 16) {
            try {
                return UUID.fromString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        GameProfile \u26032 = minecraftServer2.func_152358_ax().func_152655_a(string);
        if (\u26032 != null && \u26032.getId() != null) {
            return \u26032.getId();
        }
        if (minecraftServer2.func_71264_H() || !minecraftServer2.func_71266_T()) {
            return PlayerEntity.func_146094_a(new GameProfile(null, string));
        }
        final ArrayList \u26033 = Lists.newArrayList();
        ProfileLookupCallback \u26034 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                minecraftServer2.func_152358_ax().func_152649_a(gameProfile);
                \u26033.add(gameProfile);
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                field_152732_e.warn("Could not lookup user whitelist entry for {}", (Object)gameProfile.getName(), (Object)exception);
            }
        };
        PreYggdrasilConverter.func_152717_a(minecraftServer2, Lists.newArrayList((Object[])new String[]{string}), \u26034);
        if (!\u26033.isEmpty() && ((GameProfile)\u26033.get(0)).getId() != null) {
            return ((GameProfile)\u26033.get(0)).getId();
        }
        return null;
    }

    public static boolean func_152723_a(final DedicatedServer dedicatedServer) {
        final File file = PreYggdrasilConverter.func_219585_g(dedicatedServer);
        \u2603 = new File(file.getParentFile(), "playerdata");
        \u2603 = new File(file.getParentFile(), "unknownplayers");
        if (!file.exists() || !file.isDirectory()) {
            return true;
        }
        File[] \u26032 = file.listFiles();
        ArrayList \u26033 = Lists.newArrayList();
        for (File file2 : \u26032) {
            String string = file2.getName();
            if (!string.toLowerCase(Locale.ROOT).endsWith(".dat") || (\u2603 = string.substring(0, string.length() - ".dat".length())).isEmpty()) continue;
            \u26033.add(\u2603);
        }
        try {
            Object[] objectArray = \u26033.toArray(new String[\u26033.size()]);
            ProfileLookupCallback \u26034 = new ProfileLookupCallback((String[])objectArray){
                final /* synthetic */ String[] field_201148_e;
                {
                    this.field_201148_e = stringArray;
                }

                public void onProfileLookupSucceeded(GameProfile gameProfile) {
                    dedicatedServer.func_152358_ax().func_152649_a(gameProfile);
                    UUID uUID = gameProfile.getId();
                    if (uUID == null) {
                        throw new ConversionError("Missing UUID for user profile " + gameProfile.getName());
                    }
                    this.func_152743_a(\u2603, this.func_152744_a(gameProfile), uUID.toString());
                }

                public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                    field_152732_e.warn("Could not lookup user uuid for {}", (Object)gameProfile.getName(), (Object)exception);
                    if (!(exception instanceof ProfileNotFoundException)) {
                        throw new ConversionError("Could not request user " + gameProfile.getName() + " from backend systems", exception);
                    }
                    String string = this.func_152744_a(gameProfile);
                    this.func_152743_a(\u2603, string, string);
                }

                private void func_152743_a(File file3, String string, String string2) {
                    File file2 = new File(file, string + ".dat");
                    \u2603 = new File(file3, string2 + ".dat");
                    PreYggdrasilConverter.func_152711_b(file3);
                    if (!file2.renameTo(\u2603)) {
                        throw new ConversionError("Could not convert file for " + string);
                    }
                }

                private String func_152744_a(GameProfile gameProfile) {
                    String string = null;
                    for (String string2 : this.field_201148_e) {
                        if (string2 == null || !string2.equalsIgnoreCase(gameProfile.getName())) continue;
                        string = string2;
                        break;
                    }
                    if (string == null) {
                        throw new ConversionError("Could not find the filename for " + gameProfile.getName() + " anymore");
                    }
                    return string;
                }
            };
            PreYggdrasilConverter.func_152717_a(dedicatedServer, Lists.newArrayList((Object[])objectArray), \u26034);
        }
        catch (ConversionError conversionError) {
            field_152732_e.error("Conversion failed, please try again later", (Throwable)conversionError);
            return false;
        }
        return true;
    }

    private static void func_152711_b(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            throw new ConversionError("Can't create directory " + file.getName() + " in world save directory.");
        }
        if (!file.mkdirs()) {
            throw new ConversionError("Can't create directory " + file.getName() + " in world save directory.");
        }
    }

    public static boolean func_219587_e(MinecraftServer minecraftServer) {
        boolean bl = PreYggdrasilConverter.func_152712_b();
        bl = bl && PreYggdrasilConverter.func_219589_f(minecraftServer);
        return bl;
    }

    private static boolean func_152712_b() {
        boolean bl = false;
        if (field_152729_b.exists() && field_152729_b.isFile()) {
            bl = true;
        }
        \u2603 = false;
        if (field_152728_a.exists() && field_152728_a.isFile()) {
            \u2603 = true;
        }
        \u2603 = false;
        if (field_152730_c.exists() && field_152730_c.isFile()) {
            \u2603 = true;
        }
        \u2603 = false;
        if (field_152731_d.exists() && field_152731_d.isFile()) {
            \u2603 = true;
        }
        if (bl || \u2603 || \u2603 || \u2603) {
            field_152732_e.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
            field_152732_e.warn("** please remove the following files and restart the server:");
            if (bl) {
                field_152732_e.warn("* {}", (Object)field_152729_b.getName());
            }
            if (\u2603) {
                field_152732_e.warn("* {}", (Object)field_152728_a.getName());
            }
            if (\u2603) {
                field_152732_e.warn("* {}", (Object)field_152730_c.getName());
            }
            if (\u2603) {
                field_152732_e.warn("* {}", (Object)field_152731_d.getName());
            }
            return false;
        }
        return true;
    }

    private static boolean func_219589_f(MinecraftServer minecraftServer) {
        File file = PreYggdrasilConverter.func_219585_g(minecraftServer);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            field_152732_e.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            field_152732_e.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            field_152732_e.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File func_219585_g(MinecraftServer minecraftServer) {
        return minecraftServer.func_240776_a_(FolderName.field_237248_d_).toFile();
    }

    private static void func_152727_c(File file) {
        \u2603 = new File(file.getName() + ".converted");
        file.renameTo(\u2603);
    }

    private static Date func_152713_b(String string, Date date) {
        Date date2;
        try {
            date2 = BanEntry.field_73698_a.parse(string);
        }
        catch (ParseException parseException) {
            date2 = date;
        }
        return date2;
    }

    static class ConversionError
    extends RuntimeException {
        private ConversionError(String string, Throwable throwable) {
            super(string, throwable);
        }

        private ConversionError(String string) {
            super(string);
        }
    }
}

