/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ChorusFlowerBlock
extends Block {
    public static final IntegerProperty field_185607_a = BlockStateProperties.field_208169_V;
    private final ChorusPlantBlock field_196405_b;

    protected ChorusFlowerBlock(ChorusPlantBlock chorusPlantBlock, AbstractBlock.Properties properties) {
        super(properties);
        this.field_196405_b = chorusPlantBlock;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185607_a, 0));
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        if (!blockState.func_196955_c(serverWorld, blockPos)) {
            serverWorld.func_175655_b(blockPos, true);
        }
    }

    @Override
    public boolean func_149653_t(BlockState blockState) {
        return blockState.func_177229_b(field_185607_a) < 5;
    }

    @Override
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld2, BlockPos blockPos, Random random) {
        ServerWorld serverWorld2;
        int n;
        BlockPos blockPos2 = blockPos.func_177984_a();
        if (!serverWorld2.func_175623_d(blockPos2) || blockPos2.func_177956_o() >= 256) {
            return;
        }
        int \u26032 = blockState.func_177229_b(field_185607_a);
        if (\u26032 >= 5) {
            return;
        }
        boolean \u26033 = false;
        boolean \u26034 = false;
        BlockState \u26035 = serverWorld2.func_180495_p(blockPos.func_177977_b());
        Block \u26036 = \u26035.func_177230_c();
        if (\u26036 == Blocks.field_150377_bs) {
            \u26033 = true;
        } else if (\u26036 == this.field_196405_b) {
            n = 1;
            for (\u26038 = 0; \u26038 < 4; ++\u26038) {
                Block block = serverWorld2.func_180495_p(blockPos.func_177979_c(n + 1)).func_177230_c();
                if (block == this.field_196405_b) {
                    ++n;
                    continue;
                }
                if (block != Blocks.field_150377_bs) break;
                \u26034 = true;
                break;
            }
            if (n < 2 || n <= random.nextInt(\u26034 ? 5 : 4)) {
                \u26033 = true;
            }
        } else if (\u26035.func_196958_f()) {
            \u26033 = true;
        }
        if (\u26033 && ChorusFlowerBlock.func_185604_a(serverWorld2, blockPos2, null) && serverWorld2.func_175623_d(blockPos.func_177981_b(2))) {
            serverWorld2.func_180501_a(blockPos, this.field_196405_b.func_196497_a(serverWorld2, blockPos), 2);
            this.func_185602_a(serverWorld2, blockPos2, \u26032);
        } else if (\u26032 < 4) {
            int \u26038;
            n = random.nextInt(4);
            if (\u26034) {
                ++n;
            }
            \u26038 = 0;
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos \u26037 = blockPos.func_177972_a(direction);
                if (!serverWorld2.func_175623_d(\u26037) || !serverWorld2.func_175623_d(\u26037.func_177977_b()) || !ChorusFlowerBlock.func_185604_a(serverWorld2, \u26037, direction.func_176734_d())) continue;
                this.func_185602_a(serverWorld2, \u26037, \u26032 + 1);
                \u26038 = 1;
            }
            if (\u26038 != 0) {
                serverWorld2.func_180501_a(blockPos, this.field_196405_b.func_196497_a(serverWorld2, blockPos), 2);
            } else {
                this.func_185605_c(serverWorld2, blockPos);
            }
        } else {
            this.func_185605_c(serverWorld2, blockPos);
        }
    }

    private void func_185602_a(World world, BlockPos blockPos, int n) {
        world.func_180501_a(blockPos, (BlockState)this.func_176223_P().func_206870_a(field_185607_a, n), 2);
        world.func_217379_c(1033, blockPos, 0);
    }

    private void func_185605_c(World world, BlockPos blockPos) {
        world.func_180501_a(blockPos, (BlockState)this.func_176223_P().func_206870_a(field_185607_a, 5), 2);
        world.func_217379_c(1034, blockPos, 0);
    }

    private static boolean func_185604_a(IWorldReader iWorldReader, BlockPos blockPos, @Nullable Direction direction) {
        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
            if (direction2 == direction || iWorldReader.func_175623_d(blockPos.func_177972_a(direction2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (direction != Direction.UP && !blockState.func_196955_c(iWorld, blockPos)) {
            iWorld.func_205220_G_().func_205360_a(blockPos, this, 1);
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        BlockState blockState2 = iWorldReader.func_180495_p(blockPos.func_177977_b());
        if (blockState2.func_177230_c() == this.field_196405_b || blockState2.func_203425_a(Blocks.field_150377_bs)) {
            return true;
        }
        if (!blockState2.func_196958_f()) {
            return false;
        }
        boolean \u26032 = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockState3 = iWorldReader.func_180495_p(blockPos.func_177972_a(direction));
            if (blockState3.func_203425_a(this.field_196405_b)) {
                if (\u26032) {
                    return false;
                }
                \u26032 = true;
                continue;
            }
            if (blockState3.func_196958_f()) continue;
            return false;
        }
        return \u26032;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185607_a);
    }

    public static void func_185603_a(IWorld iWorld, BlockPos blockPos, Random random, int n) {
        iWorld.func_180501_a(blockPos, ((ChorusPlantBlock)Blocks.field_185765_cR).func_196497_a(iWorld, blockPos), 2);
        ChorusFlowerBlock.func_185601_a(iWorld, blockPos, random, blockPos, n, 0);
    }

    private static void func_185601_a(IWorld iWorld2, BlockPos blockPos, Random random, BlockPos blockPos2, int n, int n2) {
        IWorld iWorld2;
        int \u26034;
        ChorusPlantBlock chorusPlantBlock = (ChorusPlantBlock)Blocks.field_185765_cR;
        int \u26032 = random.nextInt(4) + 1;
        if (n2 == 0) {
            ++\u26032;
        }
        for (\u26034 = 0; \u26034 < \u26032; ++\u26034) {
            BlockPos blockPos3 = blockPos.func_177981_b(\u26034 + 1);
            if (!ChorusFlowerBlock.func_185604_a(iWorld2, blockPos3, null)) {
                return;
            }
            iWorld2.func_180501_a(blockPos3, chorusPlantBlock.func_196497_a(iWorld2, blockPos3), 2);
            iWorld2.func_180501_a(blockPos3.func_177977_b(), chorusPlantBlock.func_196497_a(iWorld2, blockPos3.func_177977_b()), 2);
        }
        \u26034 = 0;
        if (n2 < 4) {
            \u2603 = random.nextInt(4);
            if (n2 == 0) {
                ++\u2603;
            }
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos \u26033 = blockPos.func_177981_b(\u26032).func_177972_a(direction);
                if (Math.abs(\u26033.func_177958_n() - blockPos2.func_177958_n()) >= n || Math.abs(\u26033.func_177952_p() - blockPos2.func_177952_p()) >= n || !iWorld2.func_175623_d(\u26033) || !iWorld2.func_175623_d(\u26033.func_177977_b()) || !ChorusFlowerBlock.func_185604_a(iWorld2, \u26033, direction.func_176734_d())) continue;
                \u26034 = 1;
                iWorld2.func_180501_a(\u26033, chorusPlantBlock.func_196497_a(iWorld2, \u26033), 2);
                iWorld2.func_180501_a(\u26033.func_177972_a(direction.func_176734_d()), chorusPlantBlock.func_196497_a(iWorld2, \u26033.func_177972_a(direction.func_176734_d())), 2);
                ChorusFlowerBlock.func_185601_a(iWorld2, \u26033, random, blockPos2, n, n2 + 1);
            }
        }
        if (\u26034 == 0) {
            iWorld2.func_180501_a(blockPos.func_177981_b(\u26032), (BlockState)Blocks.field_185766_cS.func_176223_P().func_206870_a(field_185607_a, 5), 2);
        }
    }

    @Override
    public void func_220066_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, ProjectileEntity projectileEntity) {
        if (projectileEntity.func_200600_R().func_220341_a(EntityTypeTags.field_232893_e_)) {
            BlockPos blockPos = blockRayTraceResult.func_216350_a();
            world.func_225521_a_(blockPos, true, projectileEntity);
        }
    }
}

