/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.asm;

import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ObjectHolderDefinalize
implements ILaunchPluginService {
    private final String OBJECT_HOLDER = "Lnet/minecraftforge/registries/ObjectHolder;";
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);

    public String name() {
        return "object_holder_definalize";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return isEmpty ? NAY : YAY;
    }

    private boolean hasHolder(List<AnnotationNode> lst) {
        return lst != null && lst.stream().anyMatch(n -> n.desc.equals("Lnet/minecraftforge/registries/ObjectHolder;"));
    }

    private String getValue(List<AnnotationNode> lst) {
        AnnotationNode ann = lst.stream().filter(n -> n.desc.equals("Lnet/minecraftforge/registries/ObjectHolder;")).findFirst().get();
        if (ann.values != null) {
            for (int x = 0; x < ann.values.size() - 1; x += 2) {
                if (!ann.values.get(x).equals("value")) continue;
                return (String)ann.values.get(x + 1);
            }
        }
        return null;
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        AtomicBoolean changes = new AtomicBoolean();
        int flags = 25;
        classNode.fields.stream().filter(f -> (f.access & 0x19) == 25 && f.desc.startsWith("L") && this.hasHolder(f.visibleAnnotations)).forEach(f -> {
            int prev = f.access;
            f.access &= 0xFFFFFFEF;
            f.access |= 0x1000;
            changes.compareAndSet(false, prev != f.access);
        });
        if (this.hasHolder(classNode.visibleAnnotations)) {
            String value = this.getValue(classNode.visibleAnnotations);
            classNode.fields.stream().filter(f -> (f.access & 0x19) == 25 && f.desc.startsWith("L")).forEach(f -> {
                int prev = f.access;
                f.access &= 0xFFFFFFEF;
                f.access |= 0x1000;
                changes.compareAndSet(false, prev != f.access);
            });
        }
        return changes.get() ? 256 : 0;
    }
}

