/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class PlayerInteractEvent
extends PlayerEvent {
    private final Hand hand;
    private final BlockPos pos;
    @Nullable
    private final Direction face;
    private ActionResultType cancellationResult = ActionResultType.PASS;

    private PlayerInteractEvent(PlayerEntity player, Hand hand, BlockPos pos, @Nullable Direction face) {
        super((PlayerEntity)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (Hand)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (BlockPos)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @Nonnull
    public Hand getHand() {
        return this.hand;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getPlayer().func_184586_b(this.hand);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public Direction getFace() {
        return this.face;
    }

    public World getWorld() {
        return this.getPlayer().func_130014_f_();
    }

    public LogicalSide getSide() {
        return this.getWorld().field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public ActionResultType getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(ActionResultType result) {
        this.cancellationResult = result;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(PlayerEntity player) {
            super(player, Hand.MAIN_HAND, player.func_233580_cy_(), null);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;

        public LeftClickBlock(PlayerEntity player, BlockPos pos, Direction face) {
            super(player, Hand.MAIN_HAND, pos, face);
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(PlayerEntity player, Hand hand) {
            super(player, hand, player.func_233580_cy_(), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(PlayerEntity player, Hand hand) {
            super(player, hand, player.func_233580_cy_(), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private BlockRayTraceResult hitVec;

        @Deprecated
        public RightClickBlock(PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
            super(player, hand, pos, face);
        }

        public RightClickBlock(PlayerEntity player, Hand hand, BlockPos pos, BlockRayTraceResult hitVec) {
            super(player, hand, pos, hitVec.func_216354_b());
            this.hitVec = hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public BlockRayTraceResult getHitVec() {
            return this.hitVec;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final Entity target;

        public EntityInteract(PlayerEntity player, Hand hand, Entity target) {
            super(player, hand, target.func_233580_cy_(), null);
            this.target = target;
        }

        public Entity getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final Vector3d localPos;
        private final Entity target;

        public EntityInteractSpecific(PlayerEntity player, Hand hand, Entity target, Vector3d localPos) {
            super(player, hand, target.func_233580_cy_(), null);
            this.localPos = localPos;
            this.target = target;
        }

        public Vector3d getLocalPos() {
            return this.localPos;
        }

        public Entity getTarget() {
            return this.target;
        }
    }
}

