/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.stream.LongStream;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.MathHelper;

public class BitStorageAlignFix
extends DataFix {
    public BitStorageAlignFix(Schema schema) {
        super(schema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.field_211287_c);
        \u2603 = type.findFieldType("Level");
        OpticFinder \u26032 = DSL.fieldFinder((String)"Level", (Type)\u2603);
        OpticFinder \u26033 = \u26032.type().findField("Sections");
        \u2603 = ((List.ListType)\u26033.type()).getElement();
        OpticFinder \u26034 = DSL.typeFinder((Type)\u2603);
        \u2603 = DSL.named((String)TypeReferences.field_211296_l.typeName(), (Type)DSL.remainderType());
        OpticFinder \u26035 = DSL.fieldFinder((String)"Palette", (Type)DSL.list((Type)\u2603));
        return this.fixTypeEverywhereTyped("BitStorageAlignFix", type, this.getOutputSchema().getType(TypeReferences.field_211287_c), typed2 -> typed2.updateTyped(\u26032, typed -> this.func_233092_a_(BitStorageAlignFix.func_233089_a_(\u26033, \u26034, \u26035, typed))));
    }

    private Typed<?> func_233092_a_(Typed<?> typed) {
        return typed.update(DSL.remainderFinder(), dynamic -> dynamic.update("Heightmaps", dynamic2 -> dynamic2.updateMapValues(pair -> pair.mapSecond(dynamic2 -> BitStorageAlignFix.func_233097_a_(dynamic, dynamic2, 256, 9)))));
    }

    private static Typed<?> func_233089_a_(OpticFinder<?> opticFinder, OpticFinder<?> opticFinder2, OpticFinder<List<Pair<String, Dynamic<?>>>> opticFinder3, Typed<?> typed) {
        return typed.updateTyped(opticFinder, typed2 -> typed2.updateTyped(opticFinder2, typed -> {
            int n = typed.getOptional(opticFinder3).map(list -> Math.max(4, DataFixUtils.ceillog2((int)list.size()))).orElse(0);
            if (n == 0 || MathHelper.func_151235_d(n)) {
                return typed;
            }
            return typed.update(DSL.remainderFinder(), dynamic -> dynamic.update("BlockStates", dynamic2 -> BitStorageAlignFix.func_233097_a_(dynamic, dynamic2, 4096, n)));
        }));
    }

    private static Dynamic<?> func_233097_a_(Dynamic<?> dynamic, Dynamic<?> dynamic2, int n, int n2) {
        long[] lArray = dynamic2.asLongStream().toArray();
        \u2603 = BitStorageAlignFix.func_233086_a_(n, n2, lArray);
        return dynamic.createLongList(LongStream.of(\u2603));
    }

    public static long[] func_233086_a_(int n, int n2, long[] lArray) {
        int n3 = lArray.length;
        if (n3 == 0) {
            return lArray;
        }
        long \u26032 = (1L << n2) - 1L;
        \u2603 = 64 / n2;
        \u2603 = (n + \u2603 - 1) / \u2603;
        long[] \u26033 = new long[\u2603];
        \u2603 = 0;
        \u2603 = 0;
        long \u26034 = 0L;
        \u2603 = 0;
        long \u26035 = lArray[0];
        long \u26036 = n3 > 1 ? lArray[1] : 0L;
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            long \u26037;
            \u2603 = \u2603 * n2;
            \u2603 = \u2603 >> 6;
            \u2603 = (\u2603 + 1) * n2 - 1 >> 6;
            n4 = \u2603 ^ \u2603 << 6;
            if (\u2603 != \u2603) {
                \u26035 = \u26036;
                \u26036 = \u2603 + 1 < n3 ? lArray[\u2603 + 1] : 0L;
                \u2603 = \u2603;
            }
            if (\u2603 == \u2603) {
                \u26037 = \u26035 >>> n4 & \u26032;
            } else {
                int n4;
                \u2603 = 64 - n4;
                \u26037 = (\u26035 >>> n4 | \u26036 << \u2603) & \u26032;
            }
            \u2603 = \u2603 + n2;
            if (\u2603 >= 64) {
                \u26033[\u2603++] = \u26034;
                \u26034 = \u26037;
                \u2603 = n2;
                continue;
            }
            \u26034 |= \u26037 << \u2603;
            \u2603 = \u2603;
        }
        if (\u26034 != 0L) {
            \u26033[\u2603] = \u26034;
        }
        return \u26033;
    }
}

