/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.server.ServerWorld;

public class GatherPOITask
extends Task<CreatureEntity> {
    private final PointOfInterestType field_220604_a;
    private final MemoryModuleType<GlobalPos> field_220605_b;
    private final boolean field_220606_c;
    private final Optional<Byte> field_242290_e;
    private long field_220607_d;
    private final Long2ObjectMap<RetryMarker> field_223013_e = new Long2ObjectOpenHashMap();

    public GatherPOITask(PointOfInterestType pointOfInterestType, MemoryModuleType<GlobalPos> memoryModuleType, MemoryModuleType<GlobalPos> memoryModuleType2, boolean bl, Optional<Byte> optional) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)GatherPOITask.func_233841_a_(memoryModuleType, memoryModuleType2));
        this.field_220604_a = pointOfInterestType;
        this.field_220605_b = memoryModuleType2;
        this.field_220606_c = bl;
        this.field_242290_e = optional;
    }

    public GatherPOITask(PointOfInterestType pointOfInterestType, MemoryModuleType<GlobalPos> memoryModuleType, boolean bl, Optional<Byte> optional) {
        this(pointOfInterestType, memoryModuleType, memoryModuleType, bl, optional);
    }

    private static ImmutableMap<MemoryModuleType<?>, MemoryModuleStatus> func_233841_a_(MemoryModuleType<GlobalPos> memoryModuleType, MemoryModuleType<GlobalPos> memoryModuleType2) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(memoryModuleType, (Object)MemoryModuleStatus.VALUE_ABSENT);
        if (memoryModuleType2 != memoryModuleType) {
            builder.put(memoryModuleType2, (Object)MemoryModuleStatus.VALUE_ABSENT);
        }
        return builder.build();
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, CreatureEntity creatureEntity) {
        if (this.field_220606_c && creatureEntity.func_70631_g_()) {
            return false;
        }
        if (this.field_220607_d == 0L) {
            this.field_220607_d = creatureEntity.field_70170_p.func_82737_E() + (long)serverWorld.field_73012_v.nextInt(20);
            return false;
        }
        return serverWorld.func_82737_E() >= this.field_220607_d;
    }

    @Override
    protected void func_212831_a_(ServerWorld serverWorld, CreatureEntity creatureEntity, long l) {
        this.field_220607_d = l + 20L + (long)serverWorld.func_201674_k().nextInt(20);
        PointOfInterestManager pointOfInterestManager = serverWorld.func_217443_B();
        this.field_223013_e.long2ObjectEntrySet().removeIf(entry -> !((RetryMarker)entry.getValue()).func_241371_b_(l));
        Predicate<BlockPos> \u26032 = blockPos -> {
            RetryMarker retryMarker = (RetryMarker)this.field_223013_e.get(blockPos.func_218275_a());
            if (retryMarker == null) {
                return true;
            }
            if (!retryMarker.func_241372_c_(l)) {
                return false;
            }
            retryMarker.func_241370_a_(l);
            return true;
        };
        Set<BlockPos> \u26033 = pointOfInterestManager.func_242324_b(this.field_220604_a.func_221045_c(), \u26032, creatureEntity.func_233580_cy_(), 48, PointOfInterestManager.Status.HAS_SPACE).limit(5L).collect(Collectors.toSet());
        Path \u26034 = creatureEntity.func_70661_as().func_241390_a_(\u26033, this.field_220604_a.func_225478_d());
        if (\u26034 != null && \u26034.func_224771_h()) {
            BlockPos blockPos2 = \u26034.func_224770_k();
            pointOfInterestManager.func_219148_c(blockPos2).ifPresent(pointOfInterestType -> {
                pointOfInterestManager.func_219157_a(this.field_220604_a.func_221045_c(), blockPos2 -> blockPos2.equals(blockPos2), blockPos2, 1);
                creatureEntity.func_213375_cj().func_218205_a(this.field_220605_b, GlobalPos.func_239648_a_(serverWorld.func_234923_W_(), blockPos2));
                this.field_242290_e.ifPresent(by -> serverWorld.func_72960_a(creatureEntity, (byte)by));
                this.field_223013_e.clear();
                DebugPacketSender.func_218801_c(serverWorld, blockPos2);
            });
        } else {
            for (BlockPos blockPos3 : \u26033) {
                this.field_223013_e.computeIfAbsent(blockPos3.func_218275_a(), l2 -> new RetryMarker(creatureEntity.field_70170_p.field_73012_v, l));
            }
        }
    }

    static class RetryMarker {
        private final Random field_241366_a_;
        private long field_241367_b_;
        private long field_241368_c_;
        private int field_241369_d_;

        RetryMarker(Random random, long l) {
            this.field_241366_a_ = random;
            this.func_241370_a_(l);
        }

        public void func_241370_a_(long l) {
            this.field_241367_b_ = l;
            int n = this.field_241369_d_ + this.field_241366_a_.nextInt(40) + 40;
            this.field_241369_d_ = Math.min(n, 400);
            this.field_241368_c_ = l + (long)this.field_241369_d_;
        }

        public boolean func_241371_b_(long l) {
            return l - this.field_241367_b_ < 400L;
        }

        public boolean func_241372_c_(long l) {
            return l >= this.field_241368_c_;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.field_241367_b_ + ", nextScheduledAttemptAt=" + this.field_241368_c_ + ", currentDelay=" + this.field_241369_d_ + '}';
        }
    }
}

