/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FlowingFluidBlock
extends Block
implements IBucketPickupHandler {
    public static final IntegerProperty field_176367_b = BlockStateProperties.field_208132_ag;
    protected final FlowingFluid field_204517_c;
    private final List<FluidState> field_212565_c;
    public static final VoxelShape field_235510_c_ = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);

    protected FlowingFluidBlock(FlowingFluid flowingFluid2, AbstractBlock.Properties properties) {
        super(properties);
        FlowingFluid flowingFluid2;
        this.field_204517_c = flowingFluid2;
        this.field_212565_c = Lists.newArrayList();
        this.field_212565_c.add(flowingFluid2.func_207204_a(false));
        for (int i = 1; i < 8; ++i) {
            this.field_212565_c.add(flowingFluid2.func_207207_a(8 - i, false));
        }
        this.field_212565_c.add(flowingFluid2.func_207207_a(8, true));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176367_b, 0));
    }

    @Override
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        if (iSelectionContext.func_216378_a(field_235510_c_, blockPos, true) && blockState.func_177229_b(field_176367_b) == 0 && iSelectionContext.func_230426_a_(iBlockReader.func_204610_c(blockPos.func_177984_a()), this.field_204517_c)) {
            return field_235510_c_;
        }
        return VoxelShapes.func_197880_a();
    }

    @Override
    public boolean func_149653_t(BlockState blockState) {
        return blockState.func_204520_s().func_206890_h();
    }

    @Override
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        blockState.func_204520_s().func_206891_b(serverWorld, blockPos, random);
    }

    @Override
    public boolean func_200123_i(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return false;
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return !this.field_204517_c.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    public FluidState func_204507_t(BlockState blockState) {
        int n = blockState.func_177229_b(field_176367_b);
        return this.field_212565_c.get(Math.min(n, 8));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.INVISIBLE;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (this.func_204515_c(world, blockPos, blockState)) {
            world.func_205219_F_().func_205360_a(blockPos, blockState.func_204520_s().func_206886_c(), this.field_204517_c.func_205569_a(world));
        }
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (blockState.func_204520_s().func_206889_d() || blockState2.func_204520_s().func_206889_d()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, blockState.func_204520_s().func_206886_c(), this.field_204517_c.func_205569_a(iWorld));
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (this.func_204515_c(world, blockPos, blockState)) {
            world.func_205219_F_().func_205360_a(blockPos, blockState.func_204520_s().func_206886_c(), this.field_204517_c.func_205569_a(world));
        }
    }

    private boolean func_204515_c(World world, BlockPos blockPos, BlockState blockState) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            boolean bl = world.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_235336_cN_);
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN) continue;
                BlockPos blockPos2 = blockPos.func_177972_a(direction);
                if (world.func_204610_c(blockPos2).func_206884_a(FluidTags.field_206959_a)) {
                    Block block = world.func_204610_c(blockPos).func_206889_d() ? Blocks.field_150343_Z : Blocks.field_150347_e;
                    world.func_175656_a(blockPos, block.func_176223_P());
                    this.func_180688_d(world, blockPos);
                    return false;
                }
                if (!bl || !world.func_180495_p(blockPos2).func_203425_a(Blocks.field_205164_gk)) continue;
                world.func_175656_a(blockPos, Blocks.field_235337_cO_.func_176223_P());
                this.func_180688_d(world, blockPos);
                return false;
            }
        }
        return true;
    }

    private void func_180688_d(IWorld iWorld, BlockPos blockPos) {
        iWorld.func_217379_c(1501, blockPos, 0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176367_b);
    }

    @Override
    public Fluid func_204508_a(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
        if (blockState.func_177229_b(field_176367_b) == 0) {
            iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.field_204517_c;
        }
        return Fluids.field_204541_a;
    }
}

