/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractButtonBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty field_176584_b = BlockStateProperties.field_208194_u;
    protected static final VoxelShape field_196370_b = Block.func_208617_a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape field_196371_c = Block.func_208617_a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape field_196376_y = Block.func_208617_a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape field_196377_z = Block.func_208617_a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape field_185622_d = Block.func_208617_a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape field_185624_e = Block.func_208617_a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape field_185626_f = Block.func_208617_a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape field_185628_g = Block.func_208617_a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape field_196372_E = Block.func_208617_a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape field_196373_F = Block.func_208617_a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape field_196374_G = Block.func_208617_a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape field_196375_H = Block.func_208617_a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape field_185623_D = Block.func_208617_a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape field_185625_E = Block.func_208617_a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape field_185627_F = Block.func_208617_a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape field_185629_G = Block.func_208617_a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final boolean field_150047_a;

    protected AbstractButtonBlock(boolean bl, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, Direction.NORTH)).func_206870_a(field_176584_b, false)).func_206870_a(field_196366_M, AttachFace.WALL));
        this.field_150047_a = bl;
    }

    private int func_235471_c_() {
        return this.field_150047_a ? 30 : 20;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        Direction direction = blockState.func_177229_b(field_185512_D);
        boolean \u26032 = blockState.func_177229_b(field_176584_b);
        switch ((AttachFace)blockState.func_177229_b(field_196366_M)) {
            case FLOOR: {
                if (direction.func_176740_k() == Direction.Axis.X) {
                    return \u26032 ? field_196374_G : field_196376_y;
                }
                return \u26032 ? field_196375_H : field_196377_z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return \u26032 ? field_185629_G : field_185628_g;
                    }
                    case WEST: {
                        return \u26032 ? field_185627_F : field_185626_f;
                    }
                    case SOUTH: {
                        return \u26032 ? field_185625_E : field_185624_e;
                    }
                }
                return \u26032 ? field_185623_D : field_185622_d;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            return \u26032 ? field_196372_E : field_196370_b;
        }
        return \u26032 ? field_196373_F : field_196371_c;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (blockState.func_177229_b(field_176584_b).booleanValue()) {
            return ActionResultType.CONSUME;
        }
        this.func_226910_d_(blockState, world, blockPos);
        this.func_196367_a(playerEntity, world, blockPos, true);
        return ActionResultType.func_233537_a_(world.field_72995_K);
    }

    public void func_226910_d_(BlockState blockState, World world, BlockPos blockPos) {
        world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176584_b, true), 3);
        this.func_196368_e(blockState, world, blockPos);
        world.func_205220_G_().func_205360_a(blockPos, this, this.func_235471_c_());
    }

    protected void func_196367_a(@Nullable PlayerEntity playerEntity, IWorld iWorld, BlockPos blockPos, boolean bl) {
        iWorld.func_184133_a(bl ? playerEntity : null, blockPos, this.func_196369_b(bl), SoundCategory.BLOCKS, 0.3f, bl ? 0.6f : 0.5f);
    }

    protected abstract SoundEvent func_196369_b(boolean var1);

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (bl || blockState.func_203425_a(blockState2.func_177230_c())) {
            return;
        }
        if (blockState.func_177229_b(field_176584_b).booleanValue()) {
            this.func_196368_e(blockState, world, blockPos);
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return blockState.func_177229_b(field_176584_b) != false ? 15 : 0;
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (blockState.func_177229_b(field_176584_b).booleanValue() && AbstractButtonBlock.func_196365_i(blockState) == direction) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean func_149744_f(BlockState blockState) {
        return true;
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        if (!blockState.func_177229_b(field_176584_b).booleanValue()) {
            return;
        }
        if (this.field_150047_a) {
            this.func_185616_e(blockState, serverWorld, blockPos);
        } else {
            serverWorld.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176584_b, false), 3);
            this.func_196368_e(blockState, serverWorld, blockPos);
            this.func_196367_a(null, serverWorld, blockPos, false);
        }
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (world.field_72995_K || !this.field_150047_a || blockState.func_177229_b(field_176584_b).booleanValue()) {
            return;
        }
        this.func_185616_e(blockState, world, blockPos);
    }

    private void func_185616_e(BlockState blockState, World world, BlockPos blockPos) {
        List<AbstractArrowEntity> list = world.func_217357_a(AbstractArrowEntity.class, blockState.func_196954_c(world, blockPos).func_197752_a().func_186670_a(blockPos));
        boolean \u26032 = !list.isEmpty();
        if (\u26032 != (\u2603 = blockState.func_177229_b(field_176584_b).booleanValue())) {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176584_b, \u26032), 3);
            this.func_196368_e(blockState, world, blockPos);
            this.func_196367_a(null, world, blockPos, \u26032);
        }
        if (\u26032) {
            world.func_205220_G_().func_205360_a(new BlockPos(blockPos), this, this.func_235471_c_());
        }
    }

    private void func_196368_e(BlockState blockState, World world, BlockPos blockPos) {
        world.func_195593_d(blockPos, this);
        world.func_195593_d(blockPos.func_177972_a(AbstractButtonBlock.func_196365_i(blockState).func_176734_d()), this);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176584_b, field_196366_M);
    }
}

