/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;

public interface IForgeBlockState {
    default public BlockState getBlockState() {
        return (BlockState)this;
    }

    default public float getSlipperiness(IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getBlockState().func_177230_c().getSlipperiness(this.getBlockState(), world, pos, entity);
    }

    default public int getLightValue(IBlockReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().getLightValue(this.getBlockState(), world, pos);
    }

    default public boolean isLadder(IWorldReader world, BlockPos pos, LivingEntity entity) {
        return this.getBlockState().func_177230_c().isLadder(this.getBlockState(), world, pos, entity);
    }

    default public boolean hasTileEntity() {
        return this.getBlockState().func_177230_c().hasTileEntity(this.getBlockState());
    }

    @Nullable
    default public TileEntity createTileEntity(IBlockReader world) {
        return this.getBlockState().func_177230_c().createTileEntity(this.getBlockState(), world);
    }

    default public boolean canHarvestBlock(IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getBlockState().func_177230_c().canHarvestBlock(this.getBlockState(), world, pos, player);
    }

    default public boolean removedByPlayer(World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return this.getBlockState().func_177230_c().removedByPlayer(this.getBlockState(), world, pos, player, willHarvest, fluid);
    }

    default public boolean isBed(IBlockReader world, BlockPos pos, @Nullable LivingEntity sleeper) {
        return this.getBlockState().func_177230_c().isBed(this.getBlockState(), world, pos, (Entity)sleeper);
    }

    default public boolean canCreatureSpawn(IWorldReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return this.getBlockState().func_177230_c().canCreatureSpawn(this.getBlockState(), (IBlockReader)world, pos, type, entityType);
    }

    default public Optional<Vector3d> getBedSpawnPosition(EntityType<?> type, IWorldReader world, BlockPos pos, float orientation, @Nullable LivingEntity sleeper) {
        return this.getBlockState().func_177230_c().getBedSpawnPosition(type, this.getBlockState(), world, pos, orientation, sleeper);
    }

    default public void setBedOccupied(World world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        this.getBlockState().func_177230_c().setBedOccupied(this.getBlockState(), world, pos, sleeper, occupied);
    }

    default public Direction getBedDirection(IWorldReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().getBedDirection(this.getBlockState(), world, pos);
    }

    @Deprecated
    default public boolean isAir(IBlockReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().isAir(this.getBlockState(), world, pos);
    }

    default public boolean canBeReplacedByLeaves(IWorldReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().canBeReplacedByLeaves(this.getBlockState(), world, pos);
    }

    default public boolean canBeReplacedByLogs(IWorldReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().canBeReplacedByLogs(this.getBlockState(), world, pos);
    }

    default public float getExplosionResistance(IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getBlockState().func_177230_c().getExplosionResistance(this.getBlockState(), world, pos, explosion);
    }

    default public boolean canConnectRedstone(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return this.getBlockState().func_177230_c().canConnectRedstone(this.getBlockState(), world, pos, side);
    }

    default public ItemStack getPickBlock(RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getBlockState().func_177230_c().getPickBlock(this.getBlockState(), target, world, pos, player);
    }

    default public boolean addLandingEffects(ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return this.getBlockState().func_177230_c().addLandingEffects(this.getBlockState(), worldserver, pos, state2, entity, numberOfParticles);
    }

    default public boolean addRunningEffects(World world, BlockPos pos, Entity entity) {
        return this.getBlockState().func_177230_c().addRunningEffects(this.getBlockState(), world, pos, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean addHitEffects(World world, RayTraceResult target, ParticleManager manager) {
        return this.getBlockState().func_177230_c().addHitEffects(this.getBlockState(), world, target, manager);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return this.getBlockState().func_177230_c().addDestroyEffects(this.getBlockState(), world, pos, manager);
    }

    default public boolean canSustainPlant(IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.getBlockState().func_177230_c().canSustainPlant(this.getBlockState(), world, pos, facing, plantable);
    }

    default public boolean isFertile(IBlockReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().isFertile(this.getBlockState(), world, pos);
    }

    default public boolean isConduitFrame(IWorldReader world, BlockPos pos, BlockPos conduit) {
        return this.getBlockState().func_177230_c().isConduitFrame(this.getBlockState(), world, pos, conduit);
    }

    default public boolean isPortalFrame(IBlockReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().isPortalFrame(this.getBlockState(), world, pos);
    }

    default public int getExpDrop(IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return this.getBlockState().func_177230_c().getExpDrop(this.getBlockState(), world, pos, fortune, silktouch);
    }

    default public BlockState rotate(IWorld world, BlockPos pos, Rotation direction) {
        return this.getBlockState().func_177230_c().rotate(this.getBlockState(), world, pos, direction);
    }

    default public float getEnchantPowerBonus(IWorldReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().getEnchantPowerBonus(this.getBlockState(), world, pos);
    }

    default public void onNeighborChange(IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.getBlockState().func_177230_c().onNeighborChange(this.getBlockState(), world, pos, neighbor);
    }

    @Deprecated
    default public void observedNeighborChange(World world, BlockPos pos, Block changed, BlockPos changedPos) {
        this.getBlockState().func_177230_c().observedNeighborChange(this.getBlockState(), world, pos, changed, changedPos);
    }

    default public boolean shouldCheckWeakPower(IWorldReader world, BlockPos pos, Direction side) {
        return this.getBlockState().func_177230_c().shouldCheckWeakPower(this.getBlockState(), world, pos, side);
    }

    default public boolean getWeakChanges(IWorldReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().getWeakChanges(this.getBlockState(), world, pos);
    }

    default public ToolType getHarvestTool() {
        return this.getBlockState().func_177230_c().getHarvestTool(this.getBlockState());
    }

    default public int getHarvestLevel() {
        return this.getBlockState().func_177230_c().getHarvestLevel(this.getBlockState());
    }

    default public boolean isToolEffective(ToolType tool) {
        return this.getBlockState().func_177230_c().isToolEffective(this.getBlockState(), tool);
    }

    default public SoundType getSoundType(IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getBlockState().func_177230_c().getSoundType(this.getBlockState(), world, pos, entity);
    }

    @Nullable
    default public float[] getBeaconColorMultiplier(IWorldReader world, BlockPos pos, BlockPos beacon) {
        return this.getBlockState().func_177230_c().getBeaconColorMultiplier(this.getBlockState(), world, pos, beacon);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Vector3d getFogColor(IWorldReader world, BlockPos pos, Entity entity, Vector3d originalColor, float partialTicks) {
        return this.getBlockState().func_177230_c().getFogColor(this.getBlockState(), world, pos, entity, originalColor, partialTicks);
    }

    default public BlockState getStateAtViewpoint(IBlockReader world, BlockPos pos, Vector3d viewpoint) {
        return this.getBlockState().func_177230_c().getStateAtViewpoint(this.getBlockState(), world, pos, viewpoint);
    }

    default public boolean isSlimeBlock() {
        return this.getBlockState().func_177230_c().isSlimeBlock(this.getBlockState());
    }

    default public boolean isStickyBlock() {
        return this.getBlockState().func_177230_c().isStickyBlock(this.getBlockState());
    }

    default public boolean canStickTo(BlockState other) {
        return this.getBlockState().func_177230_c().canStickTo(this.getBlockState(), other);
    }

    default public int getFlammability(IBlockReader world, BlockPos pos, Direction face) {
        return this.getBlockState().func_177230_c().getFlammability(this.getBlockState(), world, pos, face);
    }

    default public boolean isFlammable(IBlockReader world, BlockPos pos, Direction face) {
        return this.getBlockState().func_177230_c().isFlammable(this.getBlockState(), world, pos, face);
    }

    default public void catchFire(World world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.getBlockState().func_177230_c().catchFire(this.getBlockState(), world, pos, face, igniter);
    }

    default public int getFireSpreadSpeed(IBlockReader world, BlockPos pos, Direction face) {
        return this.getBlockState().func_177230_c().getFireSpreadSpeed(this.getBlockState(), world, pos, face);
    }

    default public boolean isFireSource(IWorldReader world, BlockPos pos, Direction side) {
        return this.getBlockState().func_177230_c().isFireSource(this.getBlockState(), world, pos, side);
    }

    default public boolean canEntityDestroy(IBlockReader world, BlockPos pos, Entity entity) {
        return this.getBlockState().func_177230_c().canEntityDestroy(this.getBlockState(), world, pos, entity);
    }

    default public boolean isBurning(IBlockReader world, BlockPos pos) {
        return this.getBlockState().func_177230_c().isBurning(this.getBlockState(), world, pos);
    }

    @Nullable
    default public PathNodeType getAiPathNodeType(IBlockReader world, BlockPos pos) {
        return this.getAiPathNodeType(world, pos, null);
    }

    @Nullable
    default public PathNodeType getAiPathNodeType(IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return this.getBlockState().func_177230_c().getAiPathNodeType(this.getBlockState(), world, pos, entity);
    }

    default public boolean canDropFromExplosion(IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getBlockState().func_177230_c().canDropFromExplosion(this.getBlockState(), world, pos, explosion);
    }

    default public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.getBlockState().func_177230_c().onBlockExploded(this.getBlockState(), world, pos, explosion);
    }

    default public boolean collisionExtendsVertically(IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return this.getBlockState().func_177230_c().collisionExtendsVertically(this.getBlockState(), world, pos, collidingEntity);
    }

    default public boolean shouldDisplayFluidOverlay(IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return this.getBlockState().func_177230_c().shouldDisplayFluidOverlay(this.getBlockState(), world, pos, fluidState);
    }

    @Nullable
    default public BlockState getToolModifiedState(World world, BlockPos pos, PlayerEntity player, ItemStack stack, ToolType toolType) {
        BlockState eventState = ForgeEventFactory.onToolUse(this.getBlockState(), world, pos, player, stack, toolType);
        return eventState != this.getBlockState() ? eventState : this.getBlockState().func_177230_c().getToolModifiedState(this.getBlockState(), world, pos, player, stack, toolType);
    }

    default public boolean isScaffolding(LivingEntity entity) {
        return this.getBlockState().func_177230_c().isScaffolding(this.getBlockState(), (IWorldReader)entity.field_70170_p, entity.func_233580_cy_(), entity);
    }
}

