/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkDistanceGraph;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.ChunkTaskPriorityQueueSorter;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TicketManager {
    private static final Logger field_219373_a = LogManager.getLogger();
    private static final int field_219374_b = 33 + ChunkStatus.func_222599_a(ChunkStatus.field_222617_m) - 2;
    private final Long2ObjectMap<ObjectSet<ServerPlayerEntity>> field_219375_c = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> field_219377_e = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker field_219378_f = new ChunkTicketTracker();
    private final PlayerChunkTracker field_219381_i = new PlayerChunkTracker(8);
    private final PlayerTicketTracker field_219382_j = new PlayerTicketTracker(33);
    private final Set<ChunkHolder> field_219383_k = Sets.newHashSet();
    private final ChunkTaskPriorityQueueSorter field_219384_l;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.FunctionEntry<Runnable>> field_219385_m;
    private final ITaskExecutor<ChunkTaskPriorityQueueSorter.RunnableEntry> field_219386_n;
    private final LongSet field_219387_o = new LongOpenHashSet();
    private final Executor field_219388_p;
    private long field_219389_q;
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> forcedTickets = new Long2ObjectOpenHashMap();

    protected TicketManager(Executor p_i50707_1_, Executor p_i50707_2_) {
        ChunkTaskPriorityQueueSorter chunktaskpriorityqueuesorter;
        ITaskExecutor itaskexecutor = ITaskExecutor.func_213140_a((String)"player ticket throttler", p_i50707_2_::execute);
        this.field_219384_l = chunktaskpriorityqueuesorter = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)itaskexecutor), p_i50707_1_, 4);
        this.field_219385_m = chunktaskpriorityqueuesorter.func_219087_a(itaskexecutor, true);
        this.field_219386_n = chunktaskpriorityqueuesorter.func_219091_a(itaskexecutor);
        this.field_219388_p = p_i50707_2_;
    }

    protected void func_219340_a() {
        ++this.field_219389_q;
        ObjectIterator objectiterator = this.field_219377_e.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            if (((SortedArraySet)entry.getValue()).removeIf(p_219370_1_ -> p_219370_1_.func_223182_a(this.field_219389_q))) {
                this.field_219378_f.func_215491_b(entry.getLongKey(), TicketManager.func_229844_a_((SortedArraySet)entry.getValue()), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int func_229844_a_(SortedArraySet<Ticket<?>> p_229844_0_) {
        return !p_229844_0_.isEmpty() ? ((Ticket)p_229844_0_.func_226178_b_()).func_219477_b() : ChunkManager.field_219249_a + 1;
    }

    protected abstract boolean func_219371_a(long var1);

    @Nullable
    protected abstract ChunkHolder func_219335_b(long var1);

    @Nullable
    protected abstract ChunkHolder func_219372_a(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean func_219353_a(ChunkManager chunkManager) {
        boolean flag;
        this.field_219381_i.func_215497_a();
        this.field_219382_j.func_215497_a();
        int i = Integer.MAX_VALUE - this.field_219378_f.func_215493_a(Integer.MAX_VALUE);
        boolean bl = flag = i != 0;
        if (flag) {
            // empty if block
        }
        if (!this.field_219383_k.isEmpty()) {
            this.field_219383_k.forEach(p_219343_1_ -> p_219343_1_.func_219291_a(chunkManager));
            this.field_219383_k.clear();
            return true;
        }
        if (!this.field_219387_o.isEmpty()) {
            LongIterator longiterator = this.field_219387_o.iterator();
            while (longiterator.hasNext()) {
                long j = longiterator.nextLong();
                if (!this.func_229848_e_(j).stream().anyMatch(p_219369_0_ -> p_219369_0_.func_219479_a() == TicketType.field_219490_c)) continue;
                ChunkHolder chunkholder = chunkManager.func_219220_a(j);
                if (chunkholder == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<Either<Chunk, ChunkHolder.IChunkLoadingError>> completablefuture = chunkholder.func_219297_b();
                completablefuture.thenAccept(p_219363_3_ -> this.field_219388_p.execute(() -> this.field_219386_n.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219073_a(() -> {}, (long)j, (boolean)false))));
            }
            this.field_219387_o.clear();
        }
        return flag;
    }

    private void func_219347_a(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet<Ticket<?>> sortedarrayset = this.func_229848_e_(chunkPosIn);
        int i = TicketManager.func_229844_a_(sortedarrayset);
        Ticket ticket = (Ticket)sortedarrayset.func_226175_a_(ticketIn);
        ticket.func_229861_a_(this.field_219389_q);
        if (ticketIn.func_219477_b() < i) {
            this.field_219378_f.func_215491_b(chunkPosIn, ticketIn.func_219477_b(), true);
        }
        if (ticketIn.isForceTicks()) {
            SortedArraySet tickets = (SortedArraySet)this.forcedTickets.computeIfAbsent(chunkPosIn, e -> SortedArraySet.func_226172_a_((int)4));
            tickets.func_226175_a_((Object)ticket);
        }
    }

    private void func_219349_b(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet tickets;
        SortedArraySet<Ticket<?>> sortedarrayset = this.func_229848_e_(chunkPosIn);
        if (sortedarrayset.remove(ticketIn)) {
            // empty if block
        }
        if (sortedarrayset.isEmpty()) {
            this.field_219377_e.remove(chunkPosIn);
        }
        this.field_219378_f.func_215491_b(chunkPosIn, TicketManager.func_229844_a_(sortedarrayset), false);
        if (ticketIn.isForceTicks() && (tickets = (SortedArraySet)this.forcedTickets.get(chunkPosIn)) != null) {
            tickets.remove(ticketIn);
        }
    }

    public <T> void func_219356_a(TicketType<T> type, ChunkPos pos, int level, T value) {
        this.func_219347_a(pos.func_201841_a(), new Ticket<T>(type, level, value));
    }

    public <T> void func_219345_b(TicketType<T> type, ChunkPos pos, int level, T value) {
        Ticket<T> ticket = new Ticket<T>(type, level, value);
        this.func_219349_b(pos.func_201841_a(), ticket);
    }

    public <T> void func_219331_c(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.func_219347_a(pos.func_201841_a(), new Ticket<T>(type, 33 - distance, value));
    }

    public <T> void func_219362_d(TicketType<T> type, ChunkPos pos, int distance, T value) {
        Ticket<T> ticket = new Ticket<T>(type, 33 - distance, value);
        this.func_219349_b(pos.func_201841_a(), ticket);
    }

    public <T> void registerTicking(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.func_219347_a(pos.func_201841_a(), new Ticket<T>(type, 33 - distance, value, true));
    }

    public <T> void releaseTicking(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.func_219349_b(pos.func_201841_a(), new Ticket<T>(type, 33 - distance, value, true));
    }

    private SortedArraySet<Ticket<?>> func_229848_e_(long p_229848_1_) {
        return (SortedArraySet)this.field_219377_e.computeIfAbsent(p_229848_1_, p_229851_0_ -> SortedArraySet.func_226172_a_((int)4));
    }

    protected void func_219364_a(ChunkPos pos, boolean add) {
        Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.field_219491_d, 31, pos);
        if (add) {
            this.func_219347_a(pos.func_201841_a(), ticket);
        } else {
            this.func_219349_b(pos.func_201841_a(), ticket);
        }
    }

    public void func_219341_a(SectionPos sectionPosIn, ServerPlayerEntity player) {
        long i = sectionPosIn.func_218155_u().func_201841_a();
        ((ObjectSet)this.field_219375_c.computeIfAbsent(i, p_219361_0_ -> new ObjectOpenHashSet())).add((Object)player);
        this.field_219381_i.func_215491_b(i, 0, true);
        this.field_219382_j.func_215491_b(i, 0, true);
    }

    public void func_219367_b(SectionPos sectionPosIn, ServerPlayerEntity player) {
        long i = sectionPosIn.func_218155_u().func_201841_a();
        ObjectSet objectset = (ObjectSet)this.field_219375_c.get(i);
        objectset.remove((Object)player);
        if (objectset.isEmpty()) {
            this.field_219375_c.remove(i);
            this.field_219381_i.func_215491_b(i, Integer.MAX_VALUE, false);
            this.field_219382_j.func_215491_b(i, Integer.MAX_VALUE, false);
        }
    }

    protected String func_225413_c(long p_225413_1_) {
        SortedArraySet sortedarrayset = (SortedArraySet)this.field_219377_e.get(p_225413_1_);
        String s = sortedarrayset != null && !sortedarrayset.isEmpty() ? ((Ticket)sortedarrayset.func_226178_b_()).toString() : "no_ticket";
        return s;
    }

    protected void func_219354_b(int viewDistance) {
        this.field_219382_j.func_215508_a(viewDistance);
    }

    public int func_219358_b() {
        this.field_219381_i.func_215497_a();
        return this.field_219381_i.field_215498_a.size();
    }

    public boolean func_223494_d(long chunkPosIn) {
        this.field_219381_i.func_215497_a();
        return this.field_219381_i.field_215498_a.containsKey(chunkPosIn);
    }

    public String func_225412_c() {
        return this.field_219384_l.func_225396_a();
    }

    public boolean shouldForceTicks(long chunkPos) {
        SortedArraySet tickets = (SortedArraySet)this.forcedTickets.get(chunkPos);
        return tickets != null && !tickets.isEmpty();
    }

    class PlayerTicketTracker
    extends PlayerChunkTracker {
        private int field_215512_e;
        private final Long2IntMap field_215513_f;
        private final LongSet field_215514_g;

        protected PlayerTicketTracker(int p_i50682_2_) {
            super(p_i50682_2_);
            this.field_215513_f = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.field_215514_g = new LongOpenHashSet();
            this.field_215512_e = 0;
            this.field_215513_f.defaultReturnValue(p_i50682_2_ + 2);
        }

        @Override
        protected void func_215495_a(long chunkPosIn, int oldLevel, int newLevel) {
            this.field_215514_g.add(chunkPosIn);
        }

        public void func_215508_a(int viewDistanceIn) {
            for (Long2ByteMap.Entry entry : this.field_215498_a.long2ByteEntrySet()) {
                byte b0 = entry.getByteValue();
                long i = entry.getLongKey();
                this.func_215504_a(i, b0, this.func_215505_c(b0), b0 <= viewDistanceIn - 2);
            }
            this.field_215512_e = viewDistanceIn;
        }

        private void func_215504_a(long chunkPosIn, int p_215504_3_, boolean p_215504_4_, boolean p_215504_5_) {
            if (p_215504_4_ != p_215504_5_) {
                Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.field_219490_c, field_219374_b, new ChunkPos(chunkPosIn));
                if (p_215504_5_) {
                    TicketManager.this.field_219385_m.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219069_a(() -> TicketManager.this.field_219388_p.execute(() -> {
                        if (this.func_215505_c(this.func_215471_c(chunkPosIn))) {
                            TicketManager.this.func_219347_a(chunkPosIn, ticket);
                            TicketManager.this.field_219387_o.add(chunkPosIn);
                        } else {
                            TicketManager.this.field_219386_n.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219073_a(() -> {}, (long)chunkPosIn, (boolean)false));
                        }
                    }), (long)chunkPosIn, () -> p_215504_3_));
                } else {
                    TicketManager.this.field_219386_n.func_212871_a_((Object)ChunkTaskPriorityQueueSorter.func_219073_a(() -> TicketManager.this.field_219388_p.execute(() -> TicketManager.this.func_219349_b(chunkPosIn, ticket)), (long)chunkPosIn, (boolean)true));
                }
            }
        }

        @Override
        public void func_215497_a() {
            super.func_215497_a();
            if (!this.field_215514_g.isEmpty()) {
                LongIterator longiterator = this.field_215514_g.iterator();
                while (longiterator.hasNext()) {
                    int k;
                    long i = longiterator.nextLong();
                    int j = this.field_215513_f.get(i);
                    if (j == (k = this.func_215471_c(i))) continue;
                    TicketManager.this.field_219384_l.func_219066_a(new ChunkPos(i), () -> this.field_215513_f.get(i), k, p_215506_3_ -> {
                        if (p_215506_3_ >= this.field_215513_f.defaultReturnValue()) {
                            this.field_215513_f.remove(i);
                        } else {
                            this.field_215513_f.put(i, p_215506_3_);
                        }
                    });
                    this.func_215504_a(i, k, this.func_215505_c(j), this.func_215505_c(k));
                }
                this.field_215514_g.clear();
            }
        }

        private boolean func_215505_c(int p_215505_1_) {
            return p_215505_1_ <= this.field_215512_e - 2;
        }
    }

    class PlayerChunkTracker
    extends ChunkDistanceGraph {
        protected final Long2ByteMap field_215498_a;
        protected final int field_215499_b;

        protected PlayerChunkTracker(int levelCount) {
            super(levelCount + 2, 16, 256);
            this.field_215498_a = new Long2ByteOpenHashMap();
            this.field_215499_b = levelCount;
            this.field_215498_a.defaultReturnValue((byte)(levelCount + 2));
        }

        protected int func_215471_c(long sectionPosIn) {
            return this.field_215498_a.get(sectionPosIn);
        }

        protected void func_215476_a(long sectionPosIn, int level) {
            byte b0 = level > this.field_215499_b ? this.field_215498_a.remove(sectionPosIn) : this.field_215498_a.put(sectionPosIn, (byte)level);
            this.func_215495_a(sectionPosIn, b0, level);
        }

        protected void func_215495_a(long chunkPosIn, int oldLevel, int newLevel) {
        }

        protected int func_215492_b(long pos) {
            return this.func_215496_d(pos) ? 0 : Integer.MAX_VALUE;
        }

        private boolean func_215496_d(long chunkPosIn) {
            ObjectSet objectset = (ObjectSet)TicketManager.this.field_219375_c.get(chunkPosIn);
            return objectset != null && !objectset.isEmpty();
        }

        public void func_215497_a() {
            this.func_215483_b(Integer.MAX_VALUE);
        }
    }

    class ChunkTicketTracker
    extends ChunkDistanceGraph {
        public ChunkTicketTracker() {
            super(ChunkManager.field_219249_a + 2, 16, 256);
        }

        protected int func_215492_b(long pos) {
            SortedArraySet sortedarrayset = (SortedArraySet)TicketManager.this.field_219377_e.get(pos);
            if (sortedarrayset == null) {
                return Integer.MAX_VALUE;
            }
            return sortedarrayset.isEmpty() ? Integer.MAX_VALUE : ((Ticket)sortedarrayset.func_226178_b_()).func_219477_b();
        }

        protected int func_215471_c(long sectionPosIn) {
            ChunkHolder chunkholder;
            if (!TicketManager.this.func_219371_a(sectionPosIn) && (chunkholder = TicketManager.this.func_219335_b(sectionPosIn)) != null) {
                return chunkholder.func_219299_i();
            }
            return ChunkManager.field_219249_a + 1;
        }

        protected void func_215476_a(long sectionPosIn, int level) {
            int i;
            ChunkHolder chunkholder = TicketManager.this.func_219335_b(sectionPosIn);
            int n = i = chunkholder == null ? ChunkManager.field_219249_a + 1 : chunkholder.func_219299_i();
            if (i != level && (chunkholder = TicketManager.this.func_219372_a(sectionPosIn, level, chunkholder, i)) != null) {
                TicketManager.this.field_219383_k.add(chunkholder);
            }
        }

        public int func_215493_a(int toUpdateCount) {
            return this.func_215483_b(toUpdateCount);
        }
    }
}

