/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> field_240908_a_ = Codec.STRING.comapFlatMap(ResourceLocation::func_240911_c_, ResourceLocation::toString).stable();
    private static final SimpleCommandExceptionType field_200118_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.id.invalid"));
    protected final String field_110626_a;
    protected final String field_110625_b;

    protected ResourceLocation(String[] resourceParts) {
        this.field_110626_a = StringUtils.isEmpty((CharSequence)resourceParts[0]) ? "minecraft" : resourceParts[0];
        this.field_110625_b = resourceParts[1];
        if (!ResourceLocation.func_217858_d(this.field_110626_a)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + this.field_110626_a + ':' + this.field_110625_b);
        }
        if (!ResourceLocation.func_217856_c(this.field_110625_b)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + this.field_110626_a + ':' + this.field_110625_b);
        }
    }

    public ResourceLocation(String resourceName) {
        this(ResourceLocation.func_195823_b(resourceName, ':'));
    }

    public ResourceLocation(String namespaceIn, String pathIn) {
        this(new String[]{namespaceIn, pathIn});
    }

    public static ResourceLocation func_195828_a(String resourceName, char splitOn) {
        return new ResourceLocation(ResourceLocation.func_195823_b(resourceName, splitOn));
    }

    @Nullable
    public static ResourceLocation func_208304_a(String string) {
        try {
            return new ResourceLocation(string);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    protected static String[] func_195823_b(String resourceName, char splitOn) {
        String[] astring = new String[]{"minecraft", resourceName};
        int i = resourceName.indexOf(splitOn);
        if (i >= 0) {
            astring[1] = resourceName.substring(i + 1, resourceName.length());
            if (i >= 1) {
                astring[0] = resourceName.substring(0, i);
            }
        }
        return astring;
    }

    private static DataResult<ResourceLocation> func_240911_c_(String encoded) {
        try {
            return DataResult.success((Object)new ResourceLocation(encoded));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error((String)("Not a valid resource location: " + encoded + " " + resourcelocationexception.getMessage()));
        }
    }

    public String func_110623_a() {
        return this.field_110625_b;
    }

    public String func_110624_b() {
        return this.field_110626_a;
    }

    public String toString() {
        return this.field_110626_a + ':' + this.field_110625_b;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation resourcelocation = (ResourceLocation)p_equals_1_;
        return this.field_110626_a.equals(resourcelocation.field_110626_a) && this.field_110625_b.equals(resourcelocation.field_110625_b);
    }

    public int hashCode() {
        return 31 * this.field_110626_a.hashCode() + this.field_110625_b.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation p_compareTo_1_) {
        int i = this.field_110625_b.compareTo(p_compareTo_1_.field_110625_b);
        if (i == 0) {
            i = this.field_110626_a.compareTo(p_compareTo_1_.field_110626_a);
        }
        return i;
    }

    public int compareNamespaced(ResourceLocation o) {
        int ret = this.field_110626_a.compareTo(o.field_110626_a);
        return ret != 0 ? ret : this.field_110625_b.compareTo(o.field_110625_b);
    }

    public static ResourceLocation func_195826_a(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && ResourceLocation.func_195824_a(reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            reader.setCursor(i);
            throw field_200118_c.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean func_195824_a(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == ':' || charIn == '/' || charIn == '.' || charIn == '-';
    }

    private static boolean func_217856_c(String pathIn) {
        for (int i = 0; i < pathIn.length(); ++i) {
            if (ResourceLocation.func_240909_b_(pathIn.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean func_217858_d(String namespaceIn) {
        for (int i = 0; i < namespaceIn.length(); ++i) {
            if (ResourceLocation.func_240910_c_(namespaceIn.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean func_240909_b_(char charValue) {
        return charValue == '_' || charValue == '-' || charValue >= 'a' && charValue <= 'z' || charValue >= '0' && charValue <= '9' || charValue == '/' || charValue == '.';
    }

    private static boolean func_240910_c_(char charValue) {
        return charValue == '_' || charValue == '-' || charValue >= 'a' && charValue <= 'z' || charValue >= '0' && charValue <= '9' || charValue == '.';
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_217855_b(String resourceName) {
        String[] astring = ResourceLocation.func_195823_b(resourceName, ':');
        return ResourceLocation.func_217858_d(StringUtils.isEmpty((CharSequence)astring[0]) ? "minecraft" : astring[0]) && ResourceLocation.func_217856_c(astring[1]);
    }

    public static class Serializer
    implements JsonDeserializer<ResourceLocation>,
    JsonSerializer<ResourceLocation> {
        public ResourceLocation deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return new ResourceLocation(JSONUtils.func_151206_a((JsonElement)p_deserialize_1_, (String)"location"));
        }

        public JsonElement serialize(ResourceLocation p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return new JsonPrimitive(p_serialize_1_.toString());
        }
    }
}

