/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), field_176348_a, (Object)((Object)Direction.EAST), field_176347_b, (Object)((Object)Direction.SOUTH), field_176349_M, (Object)((Object)Direction.WEST), field_176350_N));
    private static final VoxelShape field_235538_g_ = Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> field_235539_h_ = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), (Object)Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)((Object)Direction.SOUTH), (Object)Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)((Object)Direction.EAST), (Object)Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)((Object)Direction.WEST), (Object)Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> field_235540_i_ = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), (Object)VoxelShapes.func_197872_a((VoxelShape)field_235539_h_.get((Object)Direction.NORTH), (VoxelShape)Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)((Object)Direction.SOUTH), (Object)VoxelShapes.func_197872_a((VoxelShape)field_235539_h_.get((Object)Direction.SOUTH), (VoxelShape)Block.func_208617_a(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)((Object)Direction.EAST), (Object)VoxelShapes.func_197872_a((VoxelShape)field_235539_h_.get((Object)Direction.EAST), (VoxelShape)Block.func_208617_a(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)((Object)Direction.WEST), (Object)VoxelShapes.func_197872_a((VoxelShape)field_235539_h_.get((Object)Direction.WEST), (VoxelShape)Block.func_208617_a(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private final Map<BlockState, VoxelShape> field_235541_j_ = Maps.newHashMap();
    private static final Vector3f[] field_235542_k_ = new Vector3f[16];
    private final BlockState field_235543_o_;
    private boolean field_150181_a = true;

    public RedstoneWireBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176348_a, (Comparable)RedstoneSide.NONE))).func_206870_a((Property)field_176347_b, (Comparable)RedstoneSide.NONE))).func_206870_a((Property)field_176349_M, (Comparable)RedstoneSide.NONE))).func_206870_a((Property)field_176350_N, (Comparable)RedstoneSide.NONE))).func_206870_a((Property)field_176351_O, Integer.valueOf(0))));
        this.field_235543_o_ = (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_176348_a, (Comparable)RedstoneSide.SIDE))).func_206870_a((Property)field_176347_b, (Comparable)RedstoneSide.SIDE))).func_206870_a((Property)field_176349_M, (Comparable)RedstoneSide.SIDE))).func_206870_a((Property)field_176350_N, (Comparable)RedstoneSide.SIDE));
        for (BlockState blockstate : this.func_176194_O().func_177619_a()) {
            if ((Integer)blockstate.func_177229_b((Property)field_176351_O) != 0) continue;
            this.field_235541_j_.put(blockstate, this.func_235554_l_(blockstate));
        }
    }

    private VoxelShape func_235554_l_(BlockState state) {
        VoxelShape voxelshape = field_235538_g_;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)field_196498_A.get((Object)direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_235539_h_.get((Object)direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_235540_i_.get((Object)direction));
        }
        return voxelshape;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.field_235541_j_.get(state.func_206870_a((Property)field_176351_O, Integer.valueOf(0)));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.func_235544_a_((IBlockReader)((Object)context.func_195991_k()), this.field_235543_o_, context.func_195995_a());
    }

    private BlockState func_235544_a_(IBlockReader reader, BlockState state, BlockPos pos) {
        boolean flag6;
        boolean flag = RedstoneWireBlock.func_235556_n_(state);
        state = this.func_235551_b_(reader, (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_176351_O, state.func_177229_b((Property)field_176351_O))), pos);
        if (flag && RedstoneWireBlock.func_235556_n_(state)) {
            return state;
        }
        boolean flag1 = ((RedstoneSide)state.func_177229_b((Property)field_176348_a)).func_235921_b_();
        boolean flag2 = ((RedstoneSide)state.func_177229_b((Property)field_176349_M)).func_235921_b_();
        boolean flag3 = ((RedstoneSide)state.func_177229_b((Property)field_176347_b)).func_235921_b_();
        boolean flag4 = ((RedstoneSide)state.func_177229_b((Property)field_176350_N)).func_235921_b_();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            state = (BlockState)((Object)state.func_206870_a((Property)field_176350_N, (Comparable)RedstoneSide.SIDE));
        }
        if (!flag3 && flag5) {
            state = (BlockState)((Object)state.func_206870_a((Property)field_176347_b, (Comparable)RedstoneSide.SIDE));
        }
        if (!flag1 && flag6) {
            state = (BlockState)((Object)state.func_206870_a((Property)field_176348_a, (Comparable)RedstoneSide.SIDE));
        }
        if (!flag2 && flag6) {
            state = (BlockState)((Object)state.func_206870_a((Property)field_176349_M, (Comparable)RedstoneSide.SIDE));
        }
        return state;
    }

    private BlockState func_235551_b_(IBlockReader reader, BlockState state, BlockPos pos) {
        boolean flag = !reader.func_180495_p(pos.func_177984_a()).func_215686_e(reader, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.func_177229_b((Property)field_196498_A.get((Object)direction))).func_235921_b_()) continue;
            RedstoneSide redstoneside = this.func_235545_a_(reader, pos, direction, flag);
            state = (BlockState)((Object)state.func_206870_a((Property)field_196498_A.get((Object)direction), (Comparable)redstoneside));
        }
        return state;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return this.func_235544_a_((IBlockReader)worldIn, stateIn, currentPos);
        }
        RedstoneSide redstoneside = this.func_208074_a((IBlockReader)worldIn, currentPos, facing);
        return redstoneside.func_235921_b_() == ((RedstoneSide)stateIn.func_177229_b((Property)field_196498_A.get((Object)facing))).func_235921_b_() && !RedstoneWireBlock.func_235555_m_(stateIn) ? (BlockState)((Object)stateIn.func_206870_a((Property)field_196498_A.get((Object)facing), (Comparable)redstoneside)) : this.func_235544_a_((IBlockReader)worldIn, (BlockState)((Object)((BlockState)((Object)this.field_235543_o_.func_206870_a((Property)field_176351_O, stateIn.func_177229_b((Property)field_176351_O)))).func_206870_a((Property)field_196498_A.get((Object)facing), (Comparable)redstoneside)), currentPos);
    }

    private static boolean func_235555_m_(BlockState state) {
        return ((RedstoneSide)state.func_177229_b((Property)field_176348_a)).func_235921_b_() && ((RedstoneSide)state.func_177229_b((Property)field_176349_M)).func_235921_b_() && ((RedstoneSide)state.func_177229_b((Property)field_176347_b)).func_235921_b_() && ((RedstoneSide)state.func_177229_b((Property)field_176350_N)).func_235921_b_();
    }

    private static boolean func_235556_n_(BlockState state) {
        return !((RedstoneSide)state.func_177229_b((Property)field_176348_a)).func_235921_b_() && !((RedstoneSide)state.func_177229_b((Property)field_176349_M)).func_235921_b_() && !((RedstoneSide)state.func_177229_b((Property)field_176347_b)).func_235921_b_() && !((RedstoneSide)state.func_177229_b((Property)field_176350_N)).func_235921_b_();
    }

    @Override
    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)field_196498_A.get((Object)direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$mutable.func_239622_a_((Vector3i)pos, direction)).func_203425_a(this)) continue;
            blockpos$mutable.func_189536_c(Direction.DOWN);
            BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutable);
            if (!blockstate.func_203425_a(Blocks.field_190976_dk)) {
                BlockPos blockpos = blockpos$mutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$mutable, blockpos);
                RedstoneWireBlock.func_241468_a_(blockstate, blockstate1, worldIn, (BlockPos)blockpos$mutable, flags, recursionLeft);
            }
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = worldIn.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate3.func_203425_a(Blocks.field_190976_dk)) continue;
            BlockPos blockpos1 = blockpos$mutable.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$mutable, blockpos1);
            RedstoneWireBlock.func_241468_a_(blockstate3, blockstate2, worldIn, (BlockPos)blockpos$mutable, flags, recursionLeft);
        }
    }

    private RedstoneSide func_208074_a(IBlockReader worldIn, BlockPos pos, Direction face) {
        return this.func_235545_a_(worldIn, pos, face, !worldIn.func_180495_p(pos.func_177984_a()).func_215686_e(worldIn, pos));
    }

    private RedstoneSide func_235545_a_(IBlockReader reader, BlockPos pos, Direction direction, boolean nonNormalCubeAbove) {
        boolean flag;
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState blockstate = reader.func_180495_p(blockpos);
        if (nonNormalCubeAbove && (flag = this.func_235552_b_(reader, blockpos, blockstate)) && RedstoneWireBlock.canConnectTo(reader.func_180495_p(blockpos.func_177984_a()), reader, blockpos.func_177984_a(), null)) {
            if (blockstate.func_224755_d(reader, blockpos, direction.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !RedstoneWireBlock.canConnectTo(blockstate, reader, blockpos, direction) && (blockstate.func_215686_e(reader, blockpos) || !RedstoneWireBlock.canConnectTo(reader.func_180495_p(blockpos.func_177977_b()), reader, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return this.func_235552_b_((IBlockReader)((Object)worldIn), blockpos, blockstate);
    }

    private boolean func_235552_b_(IBlockReader reader, BlockPos pos, BlockState state) {
        return state.func_224755_d(reader, pos, Direction.UP) || state.func_203425_a(Blocks.field_150438_bZ);
    }

    private void func_235547_a_(World world, BlockPos pos, BlockState state) {
        int i = this.func_235546_a_(world, pos);
        if ((Integer)state.func_177229_b((Property)field_176351_O) != i) {
            if (world.func_180495_p(pos) == state) {
                world.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_176351_O, Integer.valueOf(i))), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction : Direction.values()) {
                set.add(pos.func_177972_a(direction));
            }
            for (BlockPos blockpos : set) {
                world.func_195593_d(blockpos, this);
            }
        }
    }

    private int func_235546_a_(World world, BlockPos pos) {
        this.field_150181_a = false;
        int i = world.func_175687_A(pos);
        this.field_150181_a = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState blockstate = world.func_180495_p(blockpos);
                j = Math.max(j, this.func_235557_o_(blockstate));
                BlockPos blockpos1 = pos.func_177984_a();
                if (blockstate.func_215686_e((IBlockReader)((Object)world), blockpos) && !world.func_180495_p(blockpos1).func_215686_e((IBlockReader)((Object)world), blockpos1)) {
                    j = Math.max(j, this.func_235557_o_(world.func_180495_p(blockpos.func_177984_a())));
                    continue;
                }
                if (blockstate.func_215686_e((IBlockReader)((Object)world), blockpos)) continue;
                j = Math.max(j, this.func_235557_o_(world.func_180495_p(blockpos.func_177977_b())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int func_235557_o_(BlockState state) {
        return state.func_203425_a(this) ? (Integer)state.func_177229_b((Property)field_176351_O) : 0;
    }

    private void func_176344_d(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_203425_a(this)) {
            worldIn.func_195593_d(pos, this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), this);
            }
        }
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c()) && !worldIn.field_72995_K) {
            this.func_235547_a_(worldIn, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), this);
            }
            this.func_235553_d_(worldIn, pos);
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), this);
                }
                this.func_235547_a_(worldIn, pos, state);
                this.func_235553_d_(worldIn, pos);
            }
        }
    }

    private void func_235553_d_(World world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.func_176344_d(world, pos.func_177972_a(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction1);
            if (world.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)world), blockpos)) {
                this.func_176344_d(world, blockpos.func_177984_a());
                continue;
            }
            this.func_176344_d(world, blockpos.func_177977_b());
        }
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            if (state.func_196955_c((IWorldReader)((Object)worldIn), pos)) {
                this.func_235547_a_(worldIn, pos, state);
            } else {
                RedstoneWireBlock.func_220075_c(state, worldIn, pos);
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !this.field_150181_a ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (this.field_150181_a && side != Direction.DOWN) {
            int i = (Integer)blockState.func_177229_b((Property)field_176351_O);
            if (i == 0) {
                return 0;
            }
            return side != Direction.UP && !((RedstoneSide)this.func_235544_a_(blockAccess, blockState, pos).func_177229_b((Property)field_196498_A.get((Object)side.func_176734_d()))).func_235921_b_() ? 0 : i;
        }
        return 0;
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (blockState.func_203425_a(Blocks.field_150488_af)) {
            return true;
        }
        if (blockState.func_203425_a(Blocks.field_196633_cV)) {
            Direction direction = (Direction)((Object)blockState.func_177229_b((Property)RepeaterBlock.field_185512_D));
            return direction == side || direction.func_176734_d() == side;
        }
        if (blockState.func_203425_a(Blocks.field_190976_dk)) {
            return side == blockState.func_177229_b((Property)ObserverBlock.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    @Override
    public boolean func_149744_f(BlockState state) {
        return this.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_235550_b_(int power) {
        Vector3f vector3f = field_235542_k_[power];
        return MathHelper.func_180183_b((float)vector3f.func_195899_a(), (float)vector3f.func_195900_b(), (float)vector3f.func_195902_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_235549_a_(World world, Random rand, BlockPos pos, Vector3f rgbVector, Direction directionFrom, Direction directionTo, float minChance, float maxChance) {
        float f = maxChance - minChance;
        if (!(rand.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = minChance + f * rand.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)directionFrom.func_82601_c()) + (double)(f2 * (float)directionTo.func_82601_c());
            double d1 = 0.5 + (double)(0.4375f * (float)directionFrom.func_96559_d()) + (double)(f2 * (float)directionTo.func_96559_d());
            double d2 = 0.5 + (double)(0.4375f * (float)directionFrom.func_82599_e()) + (double)(f2 * (float)directionTo.func_82599_e());
            world.func_195594_a((IParticleData)new RedstoneParticleData(rgbVector.func_195899_a(), rgbVector.func_195900_b(), rgbVector.func_195902_c(), 1.0f), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((Property)field_176351_O);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)stateIn.func_177229_b((Property)field_196498_A.get((Object)direction));
                switch (redstoneside) {
                    case UP: {
                        this.func_235549_a_(worldIn, rand, pos, field_235542_k_[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.func_235549_a_(worldIn, rand, pos, field_235542_k_[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.func_235549_a_(worldIn, rand, pos, field_235542_k_[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((Property)field_176348_a, state.func_177229_b((Property)field_176349_M)))).func_206870_a((Property)field_176347_b, state.func_177229_b((Property)field_176350_N)))).func_206870_a((Property)field_176349_M, state.func_177229_b((Property)field_176348_a)))).func_206870_a((Property)field_176350_N, state.func_177229_b((Property)field_176347_b)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((Property)field_176348_a, state.func_177229_b((Property)field_176347_b)))).func_206870_a((Property)field_176347_b, state.func_177229_b((Property)field_176349_M)))).func_206870_a((Property)field_176349_M, state.func_177229_b((Property)field_176350_N)))).func_206870_a((Property)field_176350_N, state.func_177229_b((Property)field_176348_a)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((Property)field_176348_a, state.func_177229_b((Property)field_176350_N)))).func_206870_a((Property)field_176347_b, state.func_177229_b((Property)field_176348_a)))).func_206870_a((Property)field_176349_M, state.func_177229_b((Property)field_176347_b)))).func_206870_a((Property)field_176350_N, state.func_177229_b((Property)field_176349_M)));
            }
        }
        return state;
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((Object)((BlockState)((Object)state.func_206870_a((Property)field_176348_a, state.func_177229_b((Property)field_176349_M)))).func_206870_a((Property)field_176349_M, state.func_177229_b((Property)field_176348_a)));
            }
            case FRONT_BACK: {
                return (BlockState)((Object)((BlockState)((Object)state.func_206870_a((Property)field_176347_b, state.func_177229_b((Property)field_176350_N)))).func_206870_a((Property)field_176350_N, state.func_177229_b((Property)field_176347_b)));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        if (RedstoneWireBlock.func_235555_m_(state) || RedstoneWireBlock.func_235556_n_(state)) {
            BlockState blockstate = RedstoneWireBlock.func_235555_m_(state) ? this.func_176223_P() : this.field_235543_o_;
            blockstate = (BlockState)((Object)blockstate.func_206870_a((Property)field_176351_O, state.func_177229_b((Property)field_176351_O)));
            if ((blockstate = this.func_235544_a_((IBlockReader)((Object)worldIn), blockstate, pos)) != state) {
                worldIn.func_180501_a(pos, blockstate, 3);
                this.func_235548_a_(worldIn, pos, state, blockstate);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void func_235548_a_(World world, BlockPos pos, BlockState prevState, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction);
            if (((RedstoneSide)prevState.func_177229_b((Property)field_196498_A.get((Object)direction))).func_235921_b_() == ((RedstoneSide)newState.func_177229_b((Property)field_196498_A.get((Object)direction))).func_235921_b_() || !world.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)world), blockpos)) continue;
            world.func_175695_a(blockpos, newState.func_177230_c(), direction.func_176734_d());
        }
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = MathHelper.func_76131_a((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = MathHelper.func_76131_a((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            RedstoneWireBlock.field_235542_k_[i] = new Vector3f(f1, f2, f3);
        }
    }
}

