/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeWorldTypeScreens {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ForgeWorldType, BiomeGeneratorTypeScreens> GENERATORS = Maps.newHashMap();
    private static final Map<ForgeWorldType, BiomeGeneratorTypeScreens.IFactory> GENERATOR_SCREEN_FACTORIES = Maps.newHashMap();

    public static synchronized void registerFactory(ForgeWorldType type, BiomeGeneratorTypeScreens.IFactory factory) {
        if (GENERATOR_SCREEN_FACTORIES.containsKey(type)) {
            throw new IllegalStateException("Factory has already been registered for: " + type);
        }
        GENERATOR_SCREEN_FACTORIES.put(type, factory);
    }

    static BiomeGeneratorTypeScreens getDefaultGenerator() {
        ForgeWorldType def = ForgeWorldType.getDefaultWorldType();
        if (def == null) {
            return BiomeGeneratorTypeScreens.field_239066_a_;
        }
        BiomeGeneratorTypeScreens gen = GENERATORS.get(def);
        if (gen == null) {
            LOGGER.error("The default world type '{}' has not been added to the GUI. Was it registered too late?", (Object)def.getRegistryName());
            return BiomeGeneratorTypeScreens.field_239066_a_;
        }
        return gen;
    }

    static BiomeGeneratorTypeScreens.IFactory getGeneratorScreenFactory(Optional<BiomeGeneratorTypeScreens> generator, @Nullable BiomeGeneratorTypeScreens.IFactory biomegeneratortypescreens$ifactory) {
        return generator.filter(gen -> gen instanceof GeneratorType).map(type -> GENERATOR_SCREEN_FACTORIES.get(((GeneratorType)((Object)type)).getWorldType())).orElse(biomegeneratortypescreens$ifactory);
    }

    static void registerTypes() {
        ForgeRegistries.WORLD_TYPES.forEach(wt -> {
            GeneratorType gen = new GeneratorType((ForgeWorldType)wt);
            GENERATORS.put((ForgeWorldType)wt, gen);
            BiomeGeneratorTypeScreens.registerGenerator((BiomeGeneratorTypeScreens)gen);
        });
    }

    private static class GeneratorType
    extends BiomeGeneratorTypeScreens {
        private final ForgeWorldType worldType;

        public GeneratorType(ForgeWorldType wt) {
            super(wt.getDisplayName());
            this.worldType = wt;
        }

        public ForgeWorldType getWorldType() {
            return this.worldType;
        }

        @Nonnull
        public DimensionGeneratorSettings func_241220_a_(@Nonnull DynamicRegistries.Impl dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest) {
            return this.worldType.createSettings((DynamicRegistries)dynamicRegistries, seed, generateStructures, bonusChest, "");
        }

        @Nonnull
        protected ChunkGenerator func_241869_a(@Nonnull Registry<Biome> p_241869_1_, @Nonnull Registry<DimensionSettings> p_241869_2_, long p_241869_3_) {
            return this.worldType.createChunkGenerator(p_241869_1_, p_241869_2_, p_241869_3_, "");
        }
    }
}

