/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.AngleArgument;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.ColorArgument;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.command.arguments.ComponentArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EnchantmentArgument;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.command.arguments.FunctionArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.IRangeArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ItemPredicateArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.arguments.NBTTagArgument;
import net.minecraft.command.arguments.ObjectiveArgument;
import net.minecraft.command.arguments.ObjectiveCriteriaArgument;
import net.minecraft.command.arguments.OperationArgument;
import net.minecraft.command.arguments.ParticleArgument;
import net.minecraft.command.arguments.PotionArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.ScoreHolderArgument;
import net.minecraft.command.arguments.ScoreboardSlotArgument;
import net.minecraft.command.arguments.SlotArgument;
import net.minecraft.command.arguments.SwizzleArgument;
import net.minecraft.command.arguments.TeamArgument;
import net.minecraft.command.arguments.TimeArgument;
import net.minecraft.command.arguments.UUIDArgument;
import net.minecraft.command.arguments.Vec2Argument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.command.arguments.serializers.BrigadierSerializers;
import net.minecraft.network.PacketBuffer;
import net.minecraft.test.TestArgArgument;
import net.minecraft.test.TestTypeArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArgumentTypes {
    private static final Logger field_197488_a = LogManager.getLogger();
    private static final Map<Class<?>, Entry<?>> field_197489_b = Maps.newHashMap();
    private static final Map<ResourceLocation, Entry<?>> field_197490_c = Maps.newHashMap();

    public static <T extends ArgumentType<?>> void func_218136_a(String p_218136_0_, Class<T> p_218136_1_, IArgumentSerializer<T> p_218136_2_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_218136_0_);
        if (field_197489_b.containsKey(p_218136_1_)) {
            throw new IllegalArgumentException("Class " + p_218136_1_.getName() + " already has a serializer!");
        }
        if (field_197490_c.containsKey(resourcelocation)) {
            throw new IllegalArgumentException("'" + resourcelocation + "' is already a registered serializer!");
        }
        Entry entry = new Entry(p_218136_1_, p_218136_2_, resourcelocation);
        field_197489_b.put(p_218136_1_, entry);
        field_197490_c.put(resourcelocation, entry);
    }

    public static void func_197483_a() {
        BrigadierSerializers.func_197511_a();
        ArgumentTypes.func_218136_a("entity", EntityArgument.class, new EntityArgument.Serializer());
        ArgumentTypes.func_218136_a("game_profile", GameProfileArgument.class, new ArgumentSerializer(GameProfileArgument::func_197108_a));
        ArgumentTypes.func_218136_a("block_pos", BlockPosArgument.class, new ArgumentSerializer(BlockPosArgument::func_197276_a));
        ArgumentTypes.func_218136_a("column_pos", ColumnPosArgument.class, new ArgumentSerializer(ColumnPosArgument::func_212603_a));
        ArgumentTypes.func_218136_a("vec3", Vec3Argument.class, new ArgumentSerializer(Vec3Argument::func_197301_a));
        ArgumentTypes.func_218136_a("vec2", Vec2Argument.class, new ArgumentSerializer(Vec2Argument::func_197296_a));
        ArgumentTypes.func_218136_a("block_state", BlockStateArgument.class, new ArgumentSerializer(BlockStateArgument::func_197239_a));
        ArgumentTypes.func_218136_a("block_predicate", BlockPredicateArgument.class, new ArgumentSerializer(BlockPredicateArgument::func_199824_a));
        ArgumentTypes.func_218136_a("item_stack", ItemArgument.class, new ArgumentSerializer(ItemArgument::func_197317_a));
        ArgumentTypes.func_218136_a("item_predicate", ItemPredicateArgument.class, new ArgumentSerializer(ItemPredicateArgument::func_199846_a));
        ArgumentTypes.func_218136_a("color", ColorArgument.class, new ArgumentSerializer(ColorArgument::func_197063_a));
        ArgumentTypes.func_218136_a("component", ComponentArgument.class, new ArgumentSerializer(ComponentArgument::func_197067_a));
        ArgumentTypes.func_218136_a("message", MessageArgument.class, new ArgumentSerializer(MessageArgument::func_197123_a));
        ArgumentTypes.func_218136_a("nbt_compound_tag", NBTCompoundTagArgument.class, new ArgumentSerializer(NBTCompoundTagArgument::func_218043_a));
        ArgumentTypes.func_218136_a("nbt_tag", NBTTagArgument.class, new ArgumentSerializer(NBTTagArgument::func_218085_a));
        ArgumentTypes.func_218136_a("nbt_path", NBTPathArgument.class, new ArgumentSerializer(NBTPathArgument::func_197149_a));
        ArgumentTypes.func_218136_a("objective", ObjectiveArgument.class, new ArgumentSerializer(ObjectiveArgument::func_197157_a));
        ArgumentTypes.func_218136_a("objective_criteria", ObjectiveCriteriaArgument.class, new ArgumentSerializer(ObjectiveCriteriaArgument::func_197162_a));
        ArgumentTypes.func_218136_a("operation", OperationArgument.class, new ArgumentSerializer(OperationArgument::func_197184_a));
        ArgumentTypes.func_218136_a("particle", ParticleArgument.class, new ArgumentSerializer(ParticleArgument::func_197190_a));
        ArgumentTypes.func_218136_a("angle", AngleArgument.class, new ArgumentSerializer(AngleArgument::func_242991_a));
        ArgumentTypes.func_218136_a("rotation", RotationArgument.class, new ArgumentSerializer(RotationArgument::func_197288_a));
        ArgumentTypes.func_218136_a("scoreboard_slot", ScoreboardSlotArgument.class, new ArgumentSerializer(ScoreboardSlotArgument::func_197219_a));
        ArgumentTypes.func_218136_a("score_holder", ScoreHolderArgument.class, new ScoreHolderArgument.Serializer());
        ArgumentTypes.func_218136_a("swizzle", SwizzleArgument.class, new ArgumentSerializer(SwizzleArgument::func_197293_a));
        ArgumentTypes.func_218136_a("team", TeamArgument.class, new ArgumentSerializer(TeamArgument::func_197227_a));
        ArgumentTypes.func_218136_a("item_slot", SlotArgument.class, new ArgumentSerializer(SlotArgument::func_197223_a));
        ArgumentTypes.func_218136_a("resource_location", ResourceLocationArgument.class, new ArgumentSerializer(ResourceLocationArgument::func_197197_a));
        ArgumentTypes.func_218136_a("mob_effect", PotionArgument.class, new ArgumentSerializer(PotionArgument::func_197126_a));
        ArgumentTypes.func_218136_a("function", FunctionArgument.class, new ArgumentSerializer(FunctionArgument::func_200021_a));
        ArgumentTypes.func_218136_a("entity_anchor", EntityAnchorArgument.class, new ArgumentSerializer(EntityAnchorArgument::func_201024_a));
        ArgumentTypes.func_218136_a("int_range", IRangeArgument.IntRange.class, new ArgumentSerializer(IRangeArgument::func_211371_a));
        ArgumentTypes.func_218136_a("float_range", IRangeArgument.FloatRange.class, new ArgumentSerializer(IRangeArgument::func_243493_b));
        ArgumentTypes.func_218136_a("item_enchantment", EnchantmentArgument.class, new ArgumentSerializer(EnchantmentArgument::func_201945_a));
        ArgumentTypes.func_218136_a("entity_summon", EntitySummonArgument.class, new ArgumentSerializer(EntitySummonArgument::func_211366_a));
        ArgumentTypes.func_218136_a("dimension", DimensionArgument.class, new ArgumentSerializer(DimensionArgument::func_212595_a));
        ArgumentTypes.func_218136_a("time", TimeArgument.class, new ArgumentSerializer(TimeArgument::func_218091_a));
        ArgumentTypes.func_218136_a("uuid", UUIDArgument.class, new ArgumentSerializer(UUIDArgument::func_239194_a_));
        if (SharedConstants.field_206244_b) {
            ArgumentTypes.func_218136_a("test_argument", TestArgArgument.class, new ArgumentSerializer(TestArgArgument::func_229665_a_));
            ArgumentTypes.func_218136_a("test_class", TestTypeArgument.class, new ArgumentSerializer(TestTypeArgument::func_229611_a_));
        }
    }

    @Nullable
    private static Entry<?> func_197482_a(ResourceLocation p_197482_0_) {
        return field_197490_c.get(p_197482_0_);
    }

    @Nullable
    private static Entry<?> func_201040_a(ArgumentType<?> p_201040_0_) {
        return field_197489_b.get(p_201040_0_.getClass());
    }

    public static <T extends ArgumentType<?>> void func_197484_a(PacketBuffer p_197484_0_, T p_197484_1_) {
        Entry<?> entry = ArgumentTypes.func_201040_a(p_197484_1_);
        if (entry == null) {
            field_197488_a.error("Could not serialize {} ({}) - will not be sent to client!", p_197484_1_, p_197484_1_.getClass());
            p_197484_0_.func_192572_a(new ResourceLocation(""));
        } else {
            p_197484_0_.func_192572_a(entry.field_197481_c);
            entry.field_197480_b.func_197072_a(p_197484_1_, p_197484_0_);
        }
    }

    @Nullable
    public static ArgumentType<?> func_197486_a(PacketBuffer p_197486_0_) {
        ResourceLocation resourcelocation = p_197486_0_.func_192575_l();
        Entry<?> entry = ArgumentTypes.func_197482_a(resourcelocation);
        if (entry == null) {
            field_197488_a.error("Could not deserialize {}", (Object)resourcelocation);
            return null;
        }
        return entry.field_197480_b.func_197071_b(p_197486_0_);
    }

    private static <T extends ArgumentType<?>> void func_201042_a(JsonObject p_201042_0_, T p_201042_1_) {
        Entry<?> entry = ArgumentTypes.func_201040_a(p_201042_1_);
        if (entry == null) {
            field_197488_a.error("Could not serialize argument {} ({})!", p_201042_1_, p_201042_1_.getClass());
            p_201042_0_.addProperty("type", "unknown");
        } else {
            p_201042_0_.addProperty("type", "argument");
            p_201042_0_.addProperty("parser", entry.field_197481_c.toString());
            JsonObject jsonobject = new JsonObject();
            entry.field_197480_b.func_212244_a(p_201042_1_, jsonobject);
            if (jsonobject.size() > 0) {
                p_201042_0_.add("properties", (JsonElement)jsonobject);
            }
        }
    }

    public static <S> JsonObject func_200388_a(CommandDispatcher<S> p_200388_0_, CommandNode<S> p_200388_1_) {
        Collection collection;
        JsonObject jsonobject = new JsonObject();
        if (p_200388_1_ instanceof RootCommandNode) {
            jsonobject.addProperty("type", "root");
        } else if (p_200388_1_ instanceof LiteralCommandNode) {
            jsonobject.addProperty("type", "literal");
        } else if (p_200388_1_ instanceof ArgumentCommandNode) {
            ArgumentTypes.func_201042_a(jsonobject, ((ArgumentCommandNode)p_200388_1_).getType());
        } else {
            field_197488_a.error("Could not serialize node {} ({})!", p_200388_1_, p_200388_1_.getClass());
            jsonobject.addProperty("type", "unknown");
        }
        JsonObject jsonobject1 = new JsonObject();
        for (CommandNode commandnode : p_200388_1_.getChildren()) {
            jsonobject1.add(commandnode.getName(), (JsonElement)ArgumentTypes.func_200388_a(p_200388_0_, commandnode));
        }
        if (jsonobject1.size() > 0) {
            jsonobject.add("children", (JsonElement)jsonobject1);
        }
        if (p_200388_1_.getCommand() != null) {
            jsonobject.addProperty("executable", Boolean.valueOf(true));
        }
        if (p_200388_1_.getRedirect() != null && !(collection = p_200388_0_.getPath(p_200388_1_.getRedirect())).isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            for (String s : collection) {
                jsonarray.add(s);
            }
            jsonobject.add("redirect", (JsonElement)jsonarray);
        }
        return jsonobject;
    }

    public static boolean func_243510_a(ArgumentType<?> p_243510_0_) {
        return ArgumentTypes.func_201040_a(p_243510_0_) != null;
    }

    public static <T> Set<ArgumentType<?>> func_243511_a(CommandNode<T> p_243511_0_) {
        Set set = Sets.newIdentityHashSet();
        HashSet set1 = Sets.newHashSet();
        ArgumentTypes.func_243512_a(p_243511_0_, set1, set);
        return set1;
    }

    private static <T> void func_243512_a(CommandNode<T> p_243512_0_, Set<ArgumentType<?>> p_243512_1_, Set<CommandNode<T>> p_243512_2_) {
        if (p_243512_2_.add(p_243512_0_)) {
            if (p_243512_0_ instanceof ArgumentCommandNode) {
                p_243512_1_.add(((ArgumentCommandNode)p_243512_0_).getType());
            }
            p_243512_0_.getChildren().forEach(p_243513_2_ -> ArgumentTypes.func_243512_a(p_243513_2_, p_243512_1_, p_243512_2_));
            CommandNode commandnode = p_243512_0_.getRedirect();
            if (commandnode != null) {
                ArgumentTypes.func_243512_a(commandnode, p_243512_1_, p_243512_2_);
            }
        }
    }

    @Nullable
    public static ResourceLocation getId(ArgumentType<?> type) {
        Entry<?> entry = ArgumentTypes.func_201040_a(type);
        return entry == null ? null : entry.field_197481_c;
    }

    static class Entry<T extends ArgumentType<?>> {
        public final Class<T> field_197479_a;
        public final IArgumentSerializer<T> field_197480_b;
        public final ResourceLocation field_197481_c;

        private Entry(Class<T> p_i48088_1_, IArgumentSerializer<T> p_i48088_2_, ResourceLocation p_i48088_3_) {
            this.field_197479_a = p_i48088_1_;
            this.field_197480_b = p_i48088_2_;
            this.field_197481_c = p_i48088_3_;
        }
    }
}

