/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class SpiderEntity
extends MonsterEntity {
    private static final DataParameter<Byte> field_184729_a = EntityDataManager.func_187226_a(SpiderEntity.class, DataSerializers.field_187191_a);

    public SpiderEntity(EntityType<? extends SpiderEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(3, new LeapAtTargetGoal(this, 0.4f));
        this.field_70714_bg.func_75776_a(4, new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, new WaterAvoidingRandomWalkingGoal(this, 0.8));
        this.field_70714_bg.func_75776_a(6, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new TargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, new TargetGoal<IronGolemEntity>(this, IronGolemEntity.class));
    }

    @Override
    public double func_70042_X() {
        return this.func_213302_cg() * 0.5f;
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new ClimberPathNavigator(this, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184729_a, (byte)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70839_e(this.field_70123_F);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234305_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.3f);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187821_fM;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    @Override
    public boolean func_70617_f_() {
        return this.func_70841_p();
    }

    @Override
    public void func_213295_a(BlockState blockState, Vector3d vector3d) {
        if (!blockState.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(blockState, vector3d);
        }
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    @Override
    public boolean func_70687_e(EffectInstance effectInstance) {
        if (effectInstance.func_188419_a() == Effects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    public boolean func_70841_p() {
        return (this.field_70180_af.func_187225_a(field_184729_a) & 1) != 0;
    }

    public void func_70839_e(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184729_a);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(field_184729_a, by);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
        if (iServerWorld.func_201674_k().nextInt(100) == 0) {
            Object object = EntityType.field_200741_ag.func_200721_a(this.field_70170_p);
            ((Entity)object).func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            ((AbstractSkeletonEntity)object).func_213386_a(iServerWorld, difficultyInstance, spawnReason, null, null);
            ((Entity)object).func_184220_m(this);
        }
        if (iLivingEntityData2 == null) {
            iLivingEntityData2 = new GroupData();
            if (iServerWorld.func_175659_aa() == Difficulty.HARD && iServerWorld.func_201674_k().nextFloat() < 0.1f * difficultyInstance.func_180170_c()) {
                ((GroupData)iLivingEntityData2).func_111104_a(iServerWorld.func_201674_k());
            }
        }
        if (iLivingEntityData2 instanceof GroupData && (object = ((GroupData)iLivingEntityData2).field_188478_a) != null) {
            this.func_195064_c(new EffectInstance((Effect)object, Integer.MAX_VALUE));
        }
        return iLivingEntityData2;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 0.65f;
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(SpiderEntity spiderEntity, Class<T> clazz) {
            super((MobEntity)spiderEntity, clazz, true);
        }

        @Override
        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            if (f >= 0.5f) {
                return false;
            }
            return super.func_75250_a();
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(SpiderEntity spiderEntity) {
            super(spiderEntity, 1.0, true);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75441_b.func_184207_aI();
        }

        @Override
        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        @Override
        protected double func_179512_a(LivingEntity livingEntity) {
            return 4.0f + livingEntity.func_213311_cf();
        }
    }

    public static class GroupData
    implements ILivingEntityData {
        public Effect field_188478_a;

        public void func_111104_a(Random random) {
            int n = random.nextInt(5);
            if (n <= 1) {
                this.field_188478_a = Effects.field_76424_c;
            } else if (n <= 2) {
                this.field_188478_a = Effects.field_76420_g;
            } else if (n <= 3) {
                this.field_188478_a = Effects.field_76428_l;
            } else if (n <= 4) {
                this.field_188478_a = Effects.field_76441_p;
            }
        }
    }
}

