/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, field_176348_a, (Object)Direction.EAST, field_176347_b, (Object)Direction.SOUTH, field_176349_M, (Object)Direction.WEST, field_176350_N));
    private static final VoxelShape field_235538_g_ = Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> field_235539_h_ = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)Direction.EAST, (Object)Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)Direction.WEST, (Object)Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> field_235540_i_ = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_197872_a(field_235539_h_.get(Direction.NORTH), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197872_a(field_235539_h_.get(Direction.SOUTH), Block.func_208617_a(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)Direction.EAST, (Object)VoxelShapes.func_197872_a(field_235539_h_.get(Direction.EAST), Block.func_208617_a(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)Direction.WEST, (Object)VoxelShapes.func_197872_a(field_235539_h_.get(Direction.WEST), Block.func_208617_a(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private final Map<BlockState, VoxelShape> field_235541_j_ = Maps.newHashMap();
    private static final Vector3f[] field_235542_k_ = new Vector3f[16];
    private final BlockState field_235543_o_;
    private boolean field_150181_a = true;

    public RedstoneWireBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176348_a, RedstoneSide.NONE)).func_206870_a(field_176347_b, RedstoneSide.NONE)).func_206870_a(field_176349_M, RedstoneSide.NONE)).func_206870_a(field_176350_N, RedstoneSide.NONE)).func_206870_a(field_176351_O, 0));
        this.field_235543_o_ = (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176348_a, RedstoneSide.SIDE)).func_206870_a(field_176347_b, RedstoneSide.SIDE)).func_206870_a(field_176349_M, RedstoneSide.SIDE)).func_206870_a(field_176350_N, RedstoneSide.SIDE);
        for (BlockState blockState : this.func_176194_O().func_177619_a()) {
            if (blockState.func_177229_b(field_176351_O) != 0) continue;
            this.field_235541_j_.put(blockState, this.func_235554_l_(blockState));
        }
    }

    private VoxelShape func_235554_l_(BlockState blockState) {
        VoxelShape \u26032 = field_235538_g_;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneSide = (RedstoneSide)blockState.func_177229_b(field_196498_A.get(direction));
            if (redstoneSide == RedstoneSide.SIDE) {
                \u26032 = VoxelShapes.func_197872_a(\u26032, field_235539_h_.get(direction));
                continue;
            }
            if (redstoneSide != RedstoneSide.UP) continue;
            \u26032 = VoxelShapes.func_197872_a(\u26032, field_235540_i_.get(direction));
        }
        return \u26032;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.field_235541_j_.get(blockState.func_206870_a(field_176351_O, 0));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return this.func_235544_a_(blockItemUseContext.func_195991_k(), this.field_235543_o_, blockItemUseContext.func_195995_a());
    }

    private BlockState func_235544_a_(IBlockReader iBlockReader, BlockState \u260322, BlockPos blockPos) {
        boolean bl = RedstoneWireBlock.func_235556_n_(\u260322);
        BlockState \u260322 = this.func_235551_b_(iBlockReader, (BlockState)this.func_176223_P().func_206870_a(field_176351_O, \u260322.func_177229_b(field_176351_O)), blockPos);
        if (bl && RedstoneWireBlock.func_235556_n_(\u260322)) {
            return \u260322;
        }
        \u2603 = \u260322.func_177229_b(field_176348_a).func_235921_b_();
        \u2603 = \u260322.func_177229_b(field_176349_M).func_235921_b_();
        \u2603 = \u260322.func_177229_b(field_176347_b).func_235921_b_();
        \u2603 = \u260322.func_177229_b(field_176350_N).func_235921_b_();
        \u2603 = !\u2603 && !\u2603;
        boolean bl2 = \u2603 = !\u2603 && !\u2603;
        if (!\u2603 && \u2603) {
            \u260322 = (BlockState)\u260322.func_206870_a(field_176350_N, RedstoneSide.SIDE);
        }
        if (!\u2603 && \u2603) {
            \u260322 = (BlockState)\u260322.func_206870_a(field_176347_b, RedstoneSide.SIDE);
        }
        if (!\u2603 && \u2603) {
            \u260322 = (BlockState)\u260322.func_206870_a(field_176348_a, RedstoneSide.SIDE);
        }
        if (!\u2603 && \u2603) {
            \u260322 = (BlockState)\u260322.func_206870_a(field_176349_M, RedstoneSide.SIDE);
        }
        return \u260322;
    }

    private BlockState func_235551_b_(IBlockReader iBlockReader, BlockState \u260322, BlockPos blockPos) {
        BlockState \u260322;
        boolean bl = !iBlockReader.func_180495_p(blockPos.func_177984_a()).func_215686_e(iBlockReader, blockPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)\u260322.func_177229_b(field_196498_A.get(direction))).func_235921_b_()) continue;
            RedstoneSide redstoneSide = this.func_235545_a_(iBlockReader, blockPos, direction, bl);
            \u260322 = (BlockState)\u260322.func_206870_a(field_196498_A.get(direction), redstoneSide);
        }
        return \u260322;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN) {
            return blockState;
        }
        if (direction == Direction.UP) {
            return this.func_235544_a_(iWorld, blockState, blockPos);
        }
        RedstoneSide redstoneSide = this.func_208074_a(iWorld, blockPos, direction);
        if (redstoneSide.func_235921_b_() == ((RedstoneSide)blockState.func_177229_b(field_196498_A.get(direction))).func_235921_b_() && !RedstoneWireBlock.func_235555_m_(blockState)) {
            return (BlockState)blockState.func_206870_a(field_196498_A.get(direction), redstoneSide);
        }
        return this.func_235544_a_(iWorld, (BlockState)((BlockState)this.field_235543_o_.func_206870_a(field_176351_O, blockState.func_177229_b(field_176351_O))).func_206870_a(field_196498_A.get(direction), redstoneSide), blockPos);
    }

    private static boolean func_235555_m_(BlockState blockState) {
        return blockState.func_177229_b(field_176348_a).func_235921_b_() && blockState.func_177229_b(field_176349_M).func_235921_b_() && blockState.func_177229_b(field_176347_b).func_235921_b_() && blockState.func_177229_b(field_176350_N).func_235921_b_();
    }

    private static boolean func_235556_n_(BlockState blockState) {
        return !blockState.func_177229_b(field_176348_a).func_235921_b_() && !blockState.func_177229_b(field_176349_M).func_235921_b_() && !blockState.func_177229_b(field_176347_b).func_235921_b_() && !blockState.func_177229_b(field_176350_N).func_235921_b_();
    }

    @Override
    public void func_196248_b(BlockState blockState, IWorld iWorld, BlockPos blockPos, int n, int n2) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Object \u26033;
            RedstoneSide redstoneSide = (RedstoneSide)blockState.func_177229_b(field_196498_A.get(direction));
            if (redstoneSide == RedstoneSide.NONE || iWorld.func_180495_p(mutable.func_239622_a_(blockPos, direction)).func_203425_a(this)) continue;
            mutable.func_189536_c(Direction.DOWN);
            BlockState \u26032 = iWorld.func_180495_p(mutable);
            if (!\u26032.func_203425_a(Blocks.field_190976_dk)) {
                \u26033 = mutable.func_177972_a(direction.func_176734_d());
                \u26034 = \u26032.func_196956_a(direction.func_176734_d(), iWorld.func_180495_p((BlockPos)\u26033), iWorld, mutable, (BlockPos)\u26033);
                RedstoneWireBlock.func_241468_a_(\u26032, (BlockState)\u26034, iWorld, mutable, n, n2);
            }
            mutable.func_239622_a_(blockPos, direction).func_189536_c(Direction.UP);
            \u26033 = iWorld.func_180495_p(mutable);
            if (((AbstractBlock.AbstractBlockState)\u26033).func_203425_a(Blocks.field_190976_dk)) continue;
            Object \u26034 = mutable.func_177972_a(direction.func_176734_d());
            BlockState \u26035 = ((AbstractBlock.AbstractBlockState)\u26033).func_196956_a(direction.func_176734_d(), iWorld.func_180495_p((BlockPos)\u26034), iWorld, mutable, (BlockPos)\u26034);
            RedstoneWireBlock.func_241468_a_((BlockState)\u26033, \u26035, iWorld, mutable, n, n2);
        }
    }

    private RedstoneSide func_208074_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return this.func_235545_a_(iBlockReader, blockPos, direction, !iBlockReader.func_180495_p(blockPos.func_177984_a()).func_215686_e(iBlockReader, blockPos));
    }

    private RedstoneSide func_235545_a_(IBlockReader iBlockReader, BlockPos blockPos, Direction direction, boolean bl) {
        BlockPos blockPos2 = blockPos.func_177972_a(direction);
        BlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
        if (bl && (\u2603 = this.func_235552_b_(iBlockReader, blockPos2, \u26032)) && RedstoneWireBlock.func_176346_d(iBlockReader.func_180495_p(blockPos2.func_177984_a()))) {
            if (\u26032.func_224755_d(iBlockReader, blockPos2, direction.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        if (RedstoneWireBlock.func_176343_a(\u26032, direction) || !\u26032.func_215686_e(iBlockReader, blockPos2) && RedstoneWireBlock.func_176346_d(iBlockReader.func_180495_p(blockPos2.func_177977_b()))) {
            return RedstoneSide.SIDE;
        }
        return RedstoneSide.NONE;
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        BlockState blockState2 = iWorldReader.func_180495_p(\u2603);
        return this.func_235552_b_(iWorldReader, \u2603, blockState2);
    }

    private boolean func_235552_b_(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState) {
        return blockState.func_224755_d(iBlockReader, blockPos, Direction.UP) || blockState.func_203425_a(Blocks.field_150438_bZ);
    }

    private void func_235547_a_(World world, BlockPos blockPos, BlockState blockState) {
        int n = this.func_235546_a_(world, blockPos);
        if (blockState.func_177229_b(field_176351_O) != n) {
            if (world.func_180495_p(blockPos) == blockState) {
                world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176351_O, n), 2);
            }
            HashSet hashSet = Sets.newHashSet();
            hashSet.add(blockPos);
            for (Direction direction : Direction.values()) {
                hashSet.add(blockPos.func_177972_a(direction));
            }
            for (BlockPos \u26032 : hashSet) {
                world.func_195593_d(\u26032, this);
            }
        }
    }

    private int func_235546_a_(World world, BlockPos blockPos) {
        int \u26033;
        this.field_150181_a = false;
        int n = world.func_175687_A(blockPos);
        this.field_150181_a = true;
        \u26033 = 0;
        if (n < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPos2 = blockPos.func_177972_a(direction);
                BlockState \u26032 = world.func_180495_p(blockPos2);
                \u26033 = Math.max(\u26033, this.func_235557_o_(\u26032));
                \u2603 = blockPos.func_177984_a();
                if (\u26032.func_215686_e(world, blockPos2) && !world.func_180495_p(\u2603).func_215686_e(world, \u2603)) {
                    \u26033 = Math.max(\u26033, this.func_235557_o_(world.func_180495_p(blockPos2.func_177984_a())));
                    continue;
                }
                if (\u26032.func_215686_e(world, blockPos2)) continue;
                \u26033 = Math.max(\u26033, this.func_235557_o_(world.func_180495_p(blockPos2.func_177977_b())));
            }
        }
        return Math.max(n, \u26033 - 1);
    }

    private int func_235557_o_(BlockState blockState) {
        return blockState.func_203425_a(this) ? blockState.func_177229_b(field_176351_O) : 0;
    }

    private void func_176344_d(World world, BlockPos blockPos) {
        if (!world.func_180495_p(blockPos).func_203425_a(this)) {
            return;
        }
        world.func_195593_d(blockPos, this);
        for (Direction direction : Direction.values()) {
            world.func_195593_d(blockPos.func_177972_a(direction), this);
        }
    }

    @Override
    public void func_220082_b(BlockState blockState, World world2, BlockPos blockPos, BlockState blockState2, boolean bl) {
        World world2;
        if (blockState2.func_203425_a(blockState.func_177230_c()) || world2.field_72995_K) {
            return;
        }
        this.func_235547_a_(world2, blockPos, blockState);
        for (Direction direction : Direction.Plane.VERTICAL) {
            world2.func_195593_d(blockPos.func_177972_a(direction), this);
        }
        this.func_235553_d_(world2, blockPos);
    }

    @Override
    public void func_196243_a(BlockState blockState, World world2, BlockPos blockPos, BlockState blockState2, boolean bl) {
        World world2;
        if (bl || blockState.func_203425_a(blockState2.func_177230_c())) {
            return;
        }
        super.func_196243_a(blockState, world2, blockPos, blockState2, bl);
        if (world2.field_72995_K) {
            return;
        }
        for (Direction direction : Direction.values()) {
            world2.func_195593_d(blockPos.func_177972_a(direction), this);
        }
        this.func_235547_a_(world2, blockPos, blockState);
        this.func_235553_d_(world2, blockPos);
    }

    private void func_235553_d_(World world, BlockPos blockPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.func_176344_d(world, blockPos.func_177972_a(direction));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            if (world.func_180495_p(blockPos2).func_215686_e(world, blockPos2)) {
                this.func_176344_d(world, blockPos2.func_177984_a());
                continue;
            }
            this.func_176344_d(world, blockPos2.func_177977_b());
        }
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (world.field_72995_K) {
            return;
        }
        if (blockState.func_196955_c(world, blockPos)) {
            this.func_235547_a_(world, blockPos, blockState);
        } else {
            RedstoneWireBlock.func_220075_c(blockState, world, blockPos);
            world.func_217377_a(blockPos, false);
        }
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (!this.field_150181_a) {
            return 0;
        }
        return blockState.func_185911_a(iBlockReader, blockPos, direction);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (!this.field_150181_a || direction == Direction.DOWN) {
            return 0;
        }
        int n = blockState.func_177229_b(field_176351_O);
        if (n == 0) {
            return 0;
        }
        if (direction == Direction.UP || ((RedstoneSide)this.func_235544_a_(iBlockReader, blockState, blockPos).func_177229_b(field_196498_A.get(direction.func_176734_d()))).func_235921_b_()) {
            return n;
        }
        return 0;
    }

    protected static boolean func_176346_d(BlockState blockState) {
        return RedstoneWireBlock.func_176343_a(blockState, null);
    }

    protected static boolean func_176343_a(BlockState blockState, @Nullable Direction direction) {
        if (blockState.func_203425_a(Blocks.field_150488_af)) {
            return true;
        }
        if (blockState.func_203425_a(Blocks.field_196633_cV)) {
            \u2603 = blockState.func_177229_b(RepeaterBlock.field_185512_D);
            return \u2603 == direction || \u2603.func_176734_d() == direction;
        }
        if (blockState.func_203425_a(Blocks.field_190976_dk)) {
            return direction == blockState.func_177229_b(ObserverBlock.field_176387_N);
        }
        return blockState.func_185897_m() && direction != null;
    }

    @Override
    public boolean func_149744_f(BlockState blockState) {
        return this.field_150181_a;
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176349_M))).func_206870_a(field_176347_b, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176348_a))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176347_b));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176347_b))).func_206870_a(field_176347_b, blockState.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176348_a));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176347_b, blockState.func_177229_b(field_176348_a))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176347_b))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176349_M));
            }
        }
        return blockState;
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState.func_206870_a(field_176348_a, blockState.func_177229_b(field_176349_M))).func_206870_a(field_176349_M, blockState.func_177229_b(field_176348_a));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState.func_206870_a(field_176347_b, blockState.func_177229_b(field_176350_N))).func_206870_a(field_176350_N, blockState.func_177229_b(field_176347_b));
            }
        }
        return super.func_185471_a(blockState, mirror);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (!playerEntity.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        if (RedstoneWireBlock.func_235555_m_(blockState) || RedstoneWireBlock.func_235556_n_(blockState)) {
            BlockState blockState2 = RedstoneWireBlock.func_235555_m_(blockState) ? this.func_176223_P() : this.field_235543_o_;
            blockState2 = (BlockState)blockState2.func_206870_a(field_176351_O, blockState.func_177229_b(field_176351_O));
            if ((blockState2 = this.func_235544_a_(world, blockState2, blockPos)) != blockState) {
                world.func_180501_a(blockPos, blockState2, 3);
                this.func_235548_a_(world, blockPos, blockState, blockState2);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void func_235548_a_(World world, BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            if (((RedstoneSide)blockState.func_177229_b(field_196498_A.get(direction))).func_235921_b_() == ((RedstoneSide)blockState2.func_177229_b(field_196498_A.get(direction))).func_235921_b_() || !world.func_180495_p(blockPos2).func_215686_e(world, blockPos2)) continue;
            world.func_175695_a(blockPos2, blockState2.func_177230_c(), direction.func_176734_d());
        }
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f = \u2603 * 0.6f + ((\u2603 = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            \u2603 = MathHelper.func_76131_a(\u2603 * \u2603 * 0.7f - 0.5f, 0.0f, 1.0f);
            \u2603 = MathHelper.func_76131_a(\u2603 * \u2603 * 0.6f - 0.7f, 0.0f, 1.0f);
            RedstoneWireBlock.field_235542_k_[i] = new Vector3f(f, \u2603, \u2603);
        }
    }
}

