/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryKeyCodec;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.GravityStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.IExtensibleEnum;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JigsawPattern {
    private static final Logger field_236853_d_ = LogManager.getLogger();
    public static final Codec<JigsawPattern> field_236852_a_ = RecordCodecBuilder.create(p_236854_0_ -> p_236854_0_.group((App)ResourceLocation.field_240908_a_.fieldOf("name").forGetter(JigsawPattern::func_214947_b), (App)ResourceLocation.field_240908_a_.fieldOf("fallback").forGetter(JigsawPattern::func_214948_a), (App)Codec.mapPair((MapCodec)JigsawPiece.field_236847_e_.fieldOf("element"), (MapCodec)Codec.INT.fieldOf("weight")).codec().listOf().promotePartial(Util.func_240982_a_("Pool element: ", arg_0 -> ((Logger)field_236853_d_).error(arg_0))).fieldOf("elements").forGetter(p_236857_0_ -> p_236857_0_.field_214952_d)).apply((Applicative)p_236854_0_, JigsawPattern::new));
    public static final Codec<Supplier<JigsawPattern>> field_244392_b_ = RegistryKeyCodec.func_241794_a_(Registry.field_243555_ax, field_236852_a_);
    private final ResourceLocation field_214951_c;
    private final List<Pair<JigsawPiece, Integer>> field_214952_d;
    private final List<JigsawPiece> field_214953_e;
    private final ResourceLocation field_214954_f;
    private int field_214956_h = Integer.MIN_VALUE;

    public JigsawPattern(ResourceLocation p_i242010_1_, ResourceLocation p_i242010_2_, List<Pair<JigsawPiece, Integer>> p_i242010_3_) {
        this.field_214951_c = p_i242010_1_;
        this.field_214952_d = p_i242010_3_;
        this.field_214953_e = Lists.newArrayList();
        for (Pair<JigsawPiece, Integer> pair : p_i242010_3_) {
            JigsawPiece jigsawpiece = (JigsawPiece)pair.getFirst();
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                this.field_214953_e.add(jigsawpiece);
            }
        }
        this.field_214954_f = p_i242010_2_;
    }

    public JigsawPattern(ResourceLocation nameIn, ResourceLocation p_i51397_2_, List<Pair<Function<PlacementBehaviour, ? extends JigsawPiece>, Integer>> p_i51397_3_, PlacementBehaviour placementBehaviourIn) {
        this.field_214951_c = nameIn;
        this.field_214952_d = Lists.newArrayList();
        this.field_214953_e = Lists.newArrayList();
        for (Pair<Function<PlacementBehaviour, ? extends JigsawPiece>, Integer> pair : p_i51397_3_) {
            JigsawPiece jigsawpiece = (JigsawPiece)((Function)pair.getFirst()).apply(placementBehaviourIn);
            this.field_214952_d.add((Pair<JigsawPiece, Integer>)Pair.of((Object)jigsawpiece, (Object)pair.getSecond()));
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                this.field_214953_e.add(jigsawpiece);
            }
        }
        this.field_214954_f = p_i51397_2_;
    }

    public int func_214945_a(TemplateManager templateManagerIn) {
        if (this.field_214956_h == Integer.MIN_VALUE) {
            this.field_214956_h = this.field_214953_e.stream().mapToInt(p_236856_1_ -> p_236856_1_.func_214852_a(templateManagerIn, BlockPos.field_177992_a, Rotation.NONE).func_78882_c()).max().orElse(0);
        }
        return this.field_214956_h;
    }

    public ResourceLocation func_214948_a() {
        return this.field_214954_f;
    }

    public JigsawPiece func_214944_a(Random rand) {
        return this.field_214953_e.get(rand.nextInt(this.field_214953_e.size()));
    }

    public List<JigsawPiece> func_214943_b(Random rand) {
        return ImmutableList.copyOf((Object[])ObjectArrays.shuffle((Object[])this.field_214953_e.toArray(new JigsawPiece[0]), (Random)rand));
    }

    public ResourceLocation func_214947_b() {
        return this.field_214951_c;
    }

    public int func_214946_c() {
        return this.field_214953_e.size();
    }

    public static enum PlacementBehaviour implements IStringSerializable,
    IExtensibleEnum
    {
        TERRAIN_MATCHING("terrain_matching", (ImmutableList<StructureProcessor>)ImmutableList.of((Object)new GravityStructureProcessor(Heightmap.Type.WORLD_SURFACE_WG, -1))),
        RIGID("rigid", (ImmutableList<StructureProcessor>)ImmutableList.of());

        public static final Codec<PlacementBehaviour> field_236858_c_;
        private static final Map<String, PlacementBehaviour> field_214939_c;
        private final String field_214940_d;
        private final ImmutableList<StructureProcessor> field_214941_e;

        private PlacementBehaviour(String nameIn, ImmutableList<StructureProcessor> structureProcessorsIn) {
            this.field_214940_d = nameIn;
            this.field_214941_e = structureProcessorsIn;
        }

        public String func_214936_a() {
            return this.field_214940_d;
        }

        public static PlacementBehaviour func_214938_a(String nameIn) {
            return field_214939_c.get(nameIn);
        }

        public ImmutableList<StructureProcessor> func_214937_b() {
            return this.field_214941_e;
        }

        public String func_176610_l() {
            return this.field_214940_d;
        }

        public static PlacementBehaviour create(String enumName, String nameIn, ImmutableList<StructureProcessor> structureProcessorsIn) {
            throw new IllegalStateException("Enum not extended");
        }

        @Deprecated
        public void init() {
            field_214939_c.put(this.func_214936_a(), this);
        }

        static {
            field_236858_c_ = IExtensibleEnum.createCodecForExtensibleEnum(PlacementBehaviour::values, PlacementBehaviour::func_214938_a);
            field_214939_c = Arrays.stream(PlacementBehaviour.values()).collect(Collectors.toMap(PlacementBehaviour::func_214936_a, p_214935_0_ -> p_214935_0_));
        }
    }
}

