/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillageSiege
implements ISpecialSpawner {
    private static final Logger field_242320_a = LogManager.getLogger();
    private boolean field_75535_b;
    private State field_75536_c = State.SIEGE_DONE;
    private int field_75533_d;
    private int field_75534_e;
    private int field_75532_g;
    private int field_75538_h;
    private int field_75539_i;

    public int func_230253_a_(ServerWorld p_230253_1_, boolean p_230253_2_, boolean p_230253_3_) {
        if (!p_230253_1_.func_72935_r() && p_230253_2_) {
            float f = p_230253_1_.func_242415_f(0.0f);
            if ((double)f == 0.5) {
                State state = this.field_75536_c = p_230253_1_.field_73012_v.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
            }
            if (this.field_75536_c == State.SIEGE_DONE) {
                return 0;
            }
            if (!this.field_75535_b) {
                if (!this.func_75529_b(p_230253_1_)) {
                    return 0;
                }
                this.field_75535_b = true;
            }
            if (this.field_75534_e > 0) {
                --this.field_75534_e;
                return 0;
            }
            this.field_75534_e = 2;
            if (this.field_75533_d > 0) {
                this.func_75530_c(p_230253_1_);
                --this.field_75533_d;
            } else {
                this.field_75536_c = State.SIEGE_DONE;
            }
            return 1;
        }
        this.field_75536_c = State.SIEGE_DONE;
        this.field_75535_b = false;
        return 0;
    }

    private boolean func_75529_b(ServerWorld world) {
        for (PlayerEntity playerEntity : world.func_217369_A()) {
            BlockPos blockpos;
            if (playerEntity.func_175149_v() || !world.func_217483_b_(blockpos = playerEntity.func_233580_cy_()) || world.func_226691_t_(blockpos).func_201856_r() == Biome.Category.MUSHROOM) continue;
            for (int i = 0; i < 10; ++i) {
                float f = world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
                this.field_75532_g = blockpos.func_177958_n() + MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)f) * 32.0f));
                this.field_75538_h = blockpos.func_177956_o();
                this.field_75539_i = blockpos.func_177952_p() + MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)f) * 32.0f));
                Vector3d siegeLocation = this.func_225476_a(world, new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
                if (siegeLocation == null) continue;
                if (MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent(this, (World)world, playerEntity, siegeLocation))) {
                    return false;
                }
                this.field_75534_e = 0;
                this.field_75533_d = 20;
                break;
            }
            return true;
        }
        return false;
    }

    private void func_75530_c(ServerWorld world) {
        Vector3d vector3d = this.func_225476_a(world, new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
        if (vector3d != null) {
            ZombieEntity zombieentity;
            try {
                zombieentity = EntityType.field_200725_aD.func_200721_a(world);
                zombieentity.func_213386_a((IServerWorld)world, world.func_175649_E(zombieentity.func_233580_cy_()), SpawnReason.EVENT, null, null);
            }
            catch (Exception exception) {
                field_242320_a.warn("Failed to create zombie for village siege at {}", (Object)vector3d, (Object)exception);
                return;
            }
            zombieentity.func_70012_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_242417_l((Entity)((Object)zombieentity));
        }
    }

    @Nullable
    private Vector3d func_225476_a(ServerWorld world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.func_177958_n() + world.field_73012_v.nextInt(16) - 8;
            BlockPos blockpos = new BlockPos(j, l = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, j, k = pos.func_177952_p() + world.field_73012_v.nextInt(16) - 8), k);
            if (!world.func_217483_b_(blockpos) || !MonsterEntity.func_223325_c(EntityType.field_200725_aD, (IServerWorld)world, (SpawnReason)SpawnReason.EVENT, (BlockPos)blockpos, (Random)world.field_73012_v)) continue;
            return Vector3d.func_237492_c_((Vector3i)blockpos);
        }
        return null;
    }

    static enum State {
        SIEGE_CAN_ACTIVATE,
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

