/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ConfiguredCarvers;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegistries {
    protected static final Logger field_243649_a = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> field_243659_k = Maps.newLinkedHashMap();
    private static final MutableRegistry<MutableRegistry<?>> field_243660_l = new SimpleRegistry(RegistryKey.func_240904_a_(new ResourceLocation("root")), Lifecycle.experimental());
    public static final Registry<? extends Registry<?>> field_243650_b = field_243660_l;
    public static final Registry<ConfiguredSurfaceBuilder<?>> field_243651_c = WorldGenRegistries.func_243667_a(Registry.field_243550_as, () -> ConfiguredSurfaceBuilders.field_244184_p);
    public static final Registry<ConfiguredCarver<?>> field_243652_d = WorldGenRegistries.func_243667_a(Registry.field_243551_at, () -> ConfiguredCarvers.field_243767_a);
    public static final Registry<ConfiguredFeature<?, ?>> field_243653_e = WorldGenRegistries.func_243667_a(Registry.field_243552_au, () -> Features.field_243862_bH);
    public static final Registry<StructureFeature<?, ?>> field_243654_f = WorldGenRegistries.func_243667_a(Registry.field_243553_av, () -> StructureFeatures.field_244136_b);
    public static final Registry<StructureProcessorList> field_243655_g = WorldGenRegistries.func_243667_a(Registry.field_243554_aw, () -> ProcessorLists.field_244102_b);
    public static final Registry<JigsawPattern> field_243656_h = WorldGenRegistries.func_243667_a(Registry.field_243555_ax, JigsawPatternRegistry::func_244093_a);
    @Deprecated
    public static final Registry<Biome> field_243657_i = WorldGenRegistries.forge(Registry.field_239720_u_, () -> BiomeRegistry.field_244200_a);
    public static final Registry<DimensionSettings> field_243658_j = WorldGenRegistries.func_243667_a(Registry.field_243549_ar, DimensionSettings::func_242746_i);

    private static <T> Registry<T> func_243667_a(RegistryKey<? extends Registry<T>> registryKey, Supplier<T> defaultSupplier) {
        return WorldGenRegistries.func_243665_a(registryKey, Lifecycle.stable(), defaultSupplier);
    }

    private static <T extends IForgeRegistryEntry<T>> Registry<T> forge(RegistryKey<? extends Registry<T>> key, Supplier<T> def) {
        return WorldGenRegistries.func_243666_a(key, GameData.getWrapper(key, (Lifecycle)Lifecycle.stable()), def, Lifecycle.stable());
    }

    private static <T> Registry<T> func_243665_a(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Supplier<T> defaultSupplier) {
        return WorldGenRegistries.func_243666_a(registryKey, new SimpleRegistry(registryKey, lifecycle), defaultSupplier, lifecycle);
    }

    private static <T, R extends MutableRegistry<T>> R func_243666_a(RegistryKey<? extends Registry<T>> registryKey, R registry, Supplier<T> defaultSupplier, Lifecycle lifecycle) {
        ResourceLocation resourcelocation = registryKey.func_240901_a_();
        field_243659_k.put(resourcelocation, defaultSupplier);
        MutableRegistry<MutableRegistry<?>> mutableregistry = field_243660_l;
        return (R)((MutableRegistry)mutableregistry.func_218381_a(registryKey, registry, lifecycle));
    }

    public static <T> T func_243663_a(Registry<? super T> registry, String id, T value) {
        return WorldGenRegistries.func_243664_a(registry, new ResourceLocation(id), value);
    }

    public static <V, T extends V> T func_243664_a(Registry<V> registry, ResourceLocation id, T value) {
        return (T)((MutableRegistry)registry).func_218381_a(RegistryKey.func_240903_a_(registry.func_243578_f(), id), value, Lifecycle.stable());
    }

    public static <V, T extends V> T func_243662_a(Registry<V> registry, int index, RegistryKey<V> registryKey, T value) {
        return (T)((MutableRegistry)registry).func_218382_a(index, registryKey, value, Lifecycle.stable());
    }

    public static void func_243661_a() {
    }

    static {
        field_243659_k.forEach((p_243668_0_, p_243668_1_) -> {
            if (p_243668_1_.get() == null) {
                field_243649_a.error("Unable to bootstrap registry '{}'", p_243668_0_);
            }
        });
        Registry.func_239738_a_(field_243660_l);
    }
}

