/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class RayTraceContext {
    private final Vector3d field_222254_a;
    private final Vector3d field_222255_b;
    private final BlockMode field_222256_c;
    private final FluidMode field_222257_d;
    private final ISelectionContext field_222258_e;

    public RayTraceContext(Vector3d startVecIn, Vector3d endVecIn, BlockMode blockModeIn, FluidMode fluidModeIn, @Nullable Entity entityIn) {
        this.field_222254_a = startVecIn;
        this.field_222255_b = endVecIn;
        this.field_222256_c = blockModeIn;
        this.field_222257_d = fluidModeIn;
        this.field_222258_e = entityIn == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(entityIn);
    }

    public Vector3d func_222250_a() {
        return this.field_222255_b;
    }

    public Vector3d func_222253_b() {
        return this.field_222254_a;
    }

    public VoxelShape func_222251_a(BlockState blockState, IBlockReader world, BlockPos pos) {
        return this.field_222256_c.get(blockState, world, pos, this.field_222258_e);
    }

    public VoxelShape func_222252_a(FluidState state, IBlockReader world, BlockPos pos) {
        return this.field_222257_d.func_222248_a(state) ? state.func_215676_d(world, pos) : VoxelShapes.func_197880_a();
    }

    public static interface IVoxelProvider {
        public VoxelShape get(BlockState var1, IBlockReader var2, BlockPos var3, ISelectionContext var4);
    }

    public static enum FluidMode {
        NONE(p_222247_0_ -> false),
        SOURCE_ONLY(FluidState::func_206889_d),
        ANY(p_222246_0_ -> !p_222246_0_.func_206888_e());

        private final Predicate<FluidState> field_222249_d;

        private FluidMode(Predicate<FluidState> fluidTestIn) {
            this.field_222249_d = fluidTestIn;
        }

        public boolean func_222248_a(FluidState state) {
            return this.field_222249_d.test(state);
        }
    }

    public static enum BlockMode implements IVoxelProvider
    {
        COLLIDER(AbstractBlock.AbstractBlockState::func_215685_b),
        OUTLINE(AbstractBlock.AbstractBlockState::func_215700_a),
        VISUAL(AbstractBlock.AbstractBlockState::func_199611_f);

        private final IVoxelProvider field_222245_c;

        private BlockMode(IVoxelProvider providerIn) {
            this.field_222245_c = providerIn;
        }

        @Override
        public VoxelShape get(BlockState p_get_1_, IBlockReader p_get_2_, BlockPos p_get_3_, ISelectionContext p_get_4_) {
            return this.field_222245_c.get(p_get_1_, p_get_2_, p_get_3_, p_get_4_);
        }
    }
}

