/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoatEntity
extends Entity {
    private static final DataParameter<Integer> field_184460_a = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184462_b = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184464_c = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184466_d = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_199704_e = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_199705_f = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_203064_g = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private final float[] field_184470_f = new float[2];
    private float field_184472_g;
    private float field_184474_h;
    private float field_184475_as;
    private int field_184476_at;
    private double field_70281_h;
    private double field_184477_av;
    private double field_184478_aw;
    private double field_70273_g;
    private double field_184479_ay;
    private boolean field_184480_az;
    private boolean field_184459_aA;
    private boolean field_184461_aB;
    private boolean field_184463_aC;
    private double field_184465_aD;
    private float field_184467_aE;
    private Status field_184469_aF;
    private Status field_184471_aG;
    private double field_184473_aH;
    private boolean field_203059_aM;
    private boolean field_203060_aN;
    private float field_203061_aO;
    private float field_203062_aP;
    private float field_203063_aQ;

    public BoatEntity(EntityType<? extends BoatEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public BoatEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends BoatEntity>)EntityType.field_200793_g, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    @Override
    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b;
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184460_a, 0);
        this.field_70180_af.func_187214_a(field_184462_b, 1);
        this.field_70180_af.func_187214_a(field_184464_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184466_d, Type.OAK.ordinal());
        this.field_70180_af.func_187214_a(field_199704_e, false);
        this.field_70180_af.func_187214_a(field_199705_f, false);
        this.field_70180_af.func_187214_a(field_203064_g, 0);
    }

    @Override
    public boolean func_241849_j(Entity entity) {
        return BoatEntity.func_242378_a(this, entity);
    }

    public static boolean func_242378_a(Entity p_242378_0_, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !p_242378_0_.func_184223_x(entity);
    }

    @Override
    public boolean func_241845_aY() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result result) {
        return LivingEntity.func_242288_h(super.func_241839_a(axis, result));
    }

    @Override
    public double func_70042_X() {
        return -0.1;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a(this.func_184455_j());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @Override
    public void func_203002_i(boolean downwards) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_203059_aM = true;
            this.field_203060_aN = downwards;
            if (this.func_203058_B() == 0) {
                this.func_203055_e(60);
            }
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof BoatEntity) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public Item func_184455_j() {
        switch (this.func_184453_r()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: 
        }
        return Items.field_185154_aL;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() * 11.0f);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_70281_h = x;
        this.field_184477_av = y;
        this.field_184478_aw = z;
        this.field_70273_g = yaw;
        this.field_184479_ay = pitch;
        this.field_184476_at = 10;
    }

    @Override
    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        this.field_184471_aG = this.field_184469_aF;
        this.field_184469_aF = this.func_184449_t();
        this.field_184474_h = this.field_184469_aF != Status.UNDER_WATER && this.field_184469_aF != Status.UNDER_FLOWING_WATER ? 0.0f : (this.field_184474_h += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        super.func_70071_h_();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a((IPacket<?>)new CSteerBoatPacket(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_203057_r();
        for (int i = 0; i <= 1; ++i) {
            if (this.func_184457_a(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.field_184470_f[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.field_184470_f[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.func_193047_k()) != null) {
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vector3d.field_72449_c : vector3d.field_72449_c;
                    double d1 = i == 1 ? vector3d.field_72450_a : -vector3d.field_72450_a;
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.field_184470_f[i] = (float)((double)this.field_184470_f[i] + (double)0.3926991f);
                continue;
            }
            this.field_184470_f[i] = 0.0f;
        }
        this.func_145775_I();
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = list.get(j);
                if (entity.func_184196_w(this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m(this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    private void func_203057_r() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.func_203058_B();
            this.field_203061_aO = i > 0 ? (this.field_203061_aO += 0.05f) : (this.field_203061_aO -= 0.1f);
            this.field_203061_aO = MathHelper.func_76131_a((float)this.field_203061_aO, (float)0.0f, (float)1.0f);
            this.field_203063_aQ = this.field_203062_aP;
            this.field_203062_aP = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.field_203061_aO;
        } else {
            int k;
            if (!this.field_203059_aM) {
                this.func_203055_e(0);
            }
            if ((k = this.func_203058_B()) > 0) {
                this.func_203055_e(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.func_203055_e(0);
                    Vector3d vector3d = this.func_213322_ci();
                    if (this.field_203060_aN) {
                        this.func_213317_d(vector3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.func_213293_j(vector3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vector3d.field_72449_c);
                    }
                }
                this.field_203059_aM = false;
            }
        }
    }

    @Nullable
    protected SoundEvent func_193047_k() {
        switch (this.func_184449_t()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    private void func_184447_s() {
        if (this.func_184186_bw()) {
            this.field_184476_at = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_184476_at > 0) {
            double d0 = this.func_226277_ct_() + (this.field_70281_h - this.func_226277_ct_()) / (double)this.field_184476_at;
            double d1 = this.func_226278_cu_() + (this.field_184477_av - this.func_226278_cu_()) / (double)this.field_184476_at;
            double d2 = this.func_226281_cx_() + (this.field_184478_aw - this.func_226281_cx_()) / (double)this.field_184476_at;
            double d3 = MathHelper.func_76138_g((double)(this.field_70273_g - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_184476_at);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_184479_ay - (double)this.field_70125_A) / (double)this.field_184476_at);
            --this.field_184476_at;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_184445_a(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(field_199704_e, left);
        this.field_70180_af.func_187227_b(field_199705_f, right);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184448_a(int side, float limbSwing) {
        return this.func_184457_a(side) ? (float)MathHelper.func_151238_b((double)((double)this.field_184470_f[side] - (double)0.3926991f), (double)this.field_184470_f[side], (double)limbSwing) : 0.0f;
    }

    private Status func_184449_t() {
        Status boatentity$status = this.func_184444_v();
        if (boatentity$status != null) {
            this.field_184465_aD = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.func_184446_u()) {
            return Status.IN_WATER;
        }
        float f = this.func_184441_l();
        if (f > 0.0f) {
            this.field_184467_aE = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float func_184451_k() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.field_184473_aH));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a(FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    public float func_184441_l() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable, this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean func_184446_u() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.field_184465_aD = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a(FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable);
                    this.field_184465_aD = Math.max((double)f, this.field_184465_aD);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status func_184444_v() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a(FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void func_184450_w() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.field_184472_g = 0.05f;
        if (this.field_184471_aG == Status.IN_AIR && this.field_184469_aF != Status.IN_AIR && this.field_184469_aF != Status.ON_LAND) {
            this.field_184465_aD = this.func_226283_e_(1.0);
            this.func_70107_b(this.func_226277_ct_(), (double)(this.func_184451_k() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.field_184473_aH = 0.0;
            this.field_184469_aF = Status.IN_WATER;
        } else {
            if (this.field_184469_aF == Status.IN_WATER) {
                d2 = (this.field_184465_aD - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.field_184472_g = 0.45f;
            } else if (this.field_184469_aF == Status.IN_AIR) {
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.ON_LAND) {
                this.field_184472_g = this.field_184467_aE;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.field_184467_aE /= 2.0f;
                }
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)this.field_184472_g, vector3d.field_72448_b + d1, vector3d.field_72449_c * (double)this.field_184472_g);
            this.field_184475_as *= this.field_184472_g;
            if (d2 > 0.0) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213293_j(vector3d1.field_72450_a, (vector3d1.field_72448_b + d2 * 0.06153846016296973) * 0.75, vector3d1.field_72449_c);
            }
        }
    }

    private void func_184443_x() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.field_184480_az) {
                this.field_184475_as -= 1.0f;
            }
            if (this.field_184459_aA) {
                this.field_184475_as += 1.0f;
            }
            if (this.field_184459_aA != this.field_184480_az && !this.field_184461_aB && !this.field_184463_aC) {
                f += 0.005f;
            }
            this.field_70177_z += this.field_184475_as;
            if (this.field_184461_aB) {
                f += 0.04f;
            }
            if (this.field_184463_aC) {
                f -= 0.005f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f, 0.0, MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f));
            this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.field_184461_aB, this.field_184480_az && !this.field_184459_aA || this.field_184461_aB);
        }
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf((Object)passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vector3d = new Vector3d(f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.field_184475_as;
            passenger.func_70034_d(passenger.func_70079_am() + this.field_184475_as);
            this.func_184454_a(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)((Object)passenger)).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        double d1;
        Vector3d vector3d = BoatEntity.func_233559_a_(this.func_213311_cf() * MathHelper.field_180189_a, livingEntity.func_213311_cf(), this.field_70177_z);
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        BlockPos blockpos = new BlockPos(d0, this.func_174813_aQ().field_72337_e, d1 = this.func_226281_cx_() + vector3d.field_72449_c);
        BlockPos blockpos1 = blockpos.func_177977_b();
        if (!this.field_70170_p.func_201671_F(blockpos1)) {
            double d2 = (double)blockpos.func_177956_o() + this.field_70170_p.func_242403_h(blockpos);
            double d3 = (double)blockpos.func_177956_o() + this.field_70170_p.func_242403_h(blockpos1);
            for (Pose pose : livingEntity.func_230297_ef_()) {
                Vector3d vector3d1 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d0, (double)d2, (double)d1, (LivingEntity)livingEntity, (Pose)pose);
                if (vector3d1 != null) {
                    livingEntity.func_213301_b(pose);
                    return vector3d1;
                }
                Vector3d vector3d2 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d0, (double)d3, (double)d1, (LivingEntity)livingEntity, (Pose)pose);
                if (vector3d2 == null) continue;
                livingEntity.func_213301_b(pose);
                return vector3d2;
            }
        }
        return super.func_230268_c_(livingEntity);
    }

    protected void func_184454_a(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.func_184454_a(entityToUpdate);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.func_184453_r().func_184980_a());
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.func_184458_a(Type.func_184981_a(compound.func_74779_i("Type")));
        }
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.field_184474_h < 60.0f) {
            if (!this.field_70170_p.field_72995_K) {
                return player.func_184220_m(this) ? ActionResultType.CONSUME : ActionResultType.PASS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a(this.func_184453_r().func_195933_b());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a(Items.field_151055_y);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a(FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean func_184457_a(int side) {
        return this.field_70180_af.func_187225_a(side == 0 ? field_199704_e : field_199705_f) != false && this.func_184179_bs() != null;
    }

    public void func_70266_a(float damageTaken) {
        this.field_70180_af.func_187227_b(field_184464_c, Float.valueOf(damageTaken));
    }

    public float func_70271_g() {
        return this.field_70180_af.func_187225_a(field_184464_c).floatValue();
    }

    public void func_70265_b(int timeSinceHit) {
        this.field_70180_af.func_187227_b(field_184460_a, timeSinceHit);
    }

    public int func_70268_h() {
        return this.field_70180_af.func_187225_a(field_184460_a);
    }

    private void func_203055_e(int ticks) {
        this.field_70180_af.func_187227_b(field_203064_g, ticks);
    }

    private int func_203058_B() {
        return this.field_70180_af.func_187225_a(field_203064_g);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_203056_b(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.field_203063_aQ, (float)this.field_203062_aP);
    }

    public void func_70269_c(int forwardDirection) {
        this.field_70180_af.func_187227_b(field_184462_b, forwardDirection);
    }

    public int func_70267_i() {
        return this.field_70180_af.func_187225_a(field_184462_b);
    }

    public void func_184458_a(Type boatType) {
        this.field_70180_af.func_187227_b(field_184466_d, boatType.ordinal());
    }

    public Type func_184453_r() {
        return Type.func_184979_a(this.field_70180_af.func_187225_a(field_184466_d));
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2 && !this.func_208600_a(FluidTags.field_206959_a);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        List<Entity> list = this.func_184188_bt();
        return list.isEmpty() ? null : list.get(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184442_a(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown) {
        this.field_184480_az = leftInputDown;
        this.field_184459_aA = rightInputDown;
        this.field_184461_aB = forwardInputDown;
        this.field_184463_aC = backInputDown;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    @Override
    public boolean func_204231_K() {
        return this.field_184469_aF == Status.UNDER_WATER || this.field_184469_aF == Status.UNDER_FLOWING_WATER;
    }

    @Override
    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.field_184476_at > 0) {
            this.field_184476_at = 0;
            this.func_70080_a(this.field_70281_h, this.field_184477_av, this.field_184478_aw, (float)this.field_70273_g, (float)this.field_184479_ay);
        }
    }

    public static enum Type {
        OAK(Blocks.field_196662_n, "oak"),
        SPRUCE(Blocks.field_196664_o, "spruce"),
        BIRCH(Blocks.field_196666_p, "birch"),
        JUNGLE(Blocks.field_196668_q, "jungle"),
        ACACIA(Blocks.field_196670_r, "acacia"),
        DARK_OAK(Blocks.field_196672_s, "dark_oak");

        private final String field_184990_g;
        private final Block field_195934_h;

        private Type(Block block, String name) {
            this.field_184990_g = name;
            this.field_195934_h = block;
        }

        public String func_184980_a() {
            return this.field_184990_g;
        }

        public Block func_195933_b() {
            return this.field_195934_h;
        }

        public String toString() {
            return this.field_184990_g;
        }

        public static Type func_184979_a(int id) {
            Type[] aboatentity$type = Type.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static Type func_184981_a(String nameIn) {
            Type[] aboatentity$type = Type.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].func_184980_a().equals(nameIn)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

