/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PoweredRailBlock
extends AbstractRailBlock {
    public static final EnumProperty<RailShape> field_176568_b = BlockStateProperties.field_208166_S;
    public static final BooleanProperty field_176569_M = BlockStateProperties.field_208194_u;
    private final boolean isActivator;

    public PoweredRailBlock(AbstractBlock.Properties builder) {
        this(builder, false);
    }

    protected PoweredRailBlock(AbstractBlock.Properties builder, boolean isPoweredRail) {
        super(true, builder);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_SOUTH))).func_206870_a((Property)field_176569_M, Boolean.valueOf(false))));
        this.isActivator = !isPoweredRail;
    }

    protected boolean func_176566_a(World worldIn, BlockPos pos, BlockState state, boolean searchForward, int recursionCount) {
        if (recursionCount >= 8) {
            return false;
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        RailShape railshape = (RailShape)state.func_177229_b((Property)field_176568_b);
        switch (railshape) {
            case NORTH_SOUTH: {
                if (searchForward) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case EAST_WEST: {
                if (searchForward) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case ASCENDING_EAST: {
                if (searchForward) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag = false;
                }
                railshape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (searchForward) {
                    --i;
                    ++j;
                    flag = false;
                } else {
                    ++i;
                }
                railshape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (searchForward) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag = false;
                }
                railshape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (searchForward) {
                    ++k;
                    ++j;
                    flag = false;
                } else {
                    --k;
                }
                railshape = RailShape.NORTH_SOUTH;
            }
        }
        if (this.func_208071_a(worldIn, new BlockPos(i, j, k), searchForward, recursionCount, railshape)) {
            return true;
        }
        return flag && this.func_208071_a(worldIn, new BlockPos(i, j - 1, k), searchForward, recursionCount, railshape);
    }

    protected boolean func_208071_a(World world, BlockPos state, boolean searchForward, int recursionCount, RailShape shape) {
        BlockState blockstate = world.func_180495_p(state);
        if (!(blockstate.func_177230_c() instanceof PoweredRailBlock)) {
            return false;
        }
        RailShape railshape = this.getRailDirection(blockstate, (IBlockReader)((Object)world), state, null);
        if (shape != RailShape.EAST_WEST || railshape != RailShape.NORTH_SOUTH && railshape != RailShape.ASCENDING_NORTH && railshape != RailShape.ASCENDING_SOUTH) {
            if (shape != RailShape.NORTH_SOUTH || railshape != RailShape.EAST_WEST && railshape != RailShape.ASCENDING_EAST && railshape != RailShape.ASCENDING_WEST) {
                if (this.isActivator == ((PoweredRailBlock)blockstate.func_177230_c()).isActivator) {
                    return world.func_175640_z(state) ? true : this.func_176566_a(world, state, blockstate, searchForward, recursionCount + 1);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void func_189541_b(BlockState state, World worldIn, BlockPos pos, Block blockIn) {
        boolean flag1;
        boolean flag = (Boolean)state.func_177229_b((Property)field_176569_M);
        boolean bl = flag1 = worldIn.func_175640_z(pos) || this.func_176566_a(worldIn, pos, state, true, 0) || this.func_176566_a(worldIn, pos, state, false, 0);
        if (flag1 != flag) {
            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_176569_M, Boolean.valueOf(flag1))), 3);
            worldIn.func_195593_d(pos.func_177977_b(), this);
            if (((RailShape)state.func_177229_b((Property)field_176568_b)).func_208092_c()) {
                worldIn.func_195593_d(pos.func_177984_a(), this);
            }
        }
    }

    @Override
    public Property<RailShape> func_176560_l() {
        return field_176568_b;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.func_177229_b((Property)field_176568_b)) {
                    case ASCENDING_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_WEST));
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_EAST));
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_SOUTH));
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_NORTH));
                    }
                    case SOUTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_WEST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_EAST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_EAST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_WEST));
                    }
                    case NORTH_SOUTH: 
                    case EAST_WEST: {
                        return state;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b((Property)field_176568_b)) {
                    case NORTH_SOUTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.EAST_WEST));
                    }
                    case EAST_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_SOUTH));
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_NORTH));
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_SOUTH));
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_WEST));
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_EAST));
                    }
                    case SOUTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_WEST));
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b((Property)field_176568_b)) {
                    case NORTH_SOUTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.EAST_WEST));
                    }
                    case EAST_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_SOUTH));
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_SOUTH));
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_NORTH));
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_EAST));
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_WEST));
                    }
                    case SOUTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_EAST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_EAST));
                    }
                }
            }
        }
        return state;
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.func_177229_b((Property)field_176568_b);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_SOUTH));
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_NORTH));
                    }
                    case SOUTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_EAST));
                    }
                }
                return super.func_185471_a(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_WEST));
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.ASCENDING_EAST));
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_EAST));
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)((Object)state.func_206870_a((Property)field_176568_b, (Comparable)RailShape.NORTH_WEST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176568_b, field_176569_M});
    }

    public boolean isActivatorRail() {
        return this.isActivator;
    }
}

