/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractBlock
extends ForgeRegistryEntry<Block> {
    protected static final Direction[] field_212556_a = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
    protected final Material field_149764_J;
    protected final boolean field_235688_at_;
    protected final float field_235689_au_;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final float field_149765_K;
    protected final float field_226886_f_;
    protected final float field_226887_g_;
    protected final boolean field_208621_p;
    protected final Properties field_235684_aB_;
    @Nullable
    protected ResourceLocation field_220085_g;
    private final Supplier<ResourceLocation> lootTableSupplier;

    public AbstractBlock(Properties properties) {
        this.field_149764_J = properties.field_200953_a;
        this.field_235688_at_ = properties.field_200955_c;
        this.field_220085_g = properties.field_222381_j;
        this.field_235689_au_ = properties.field_200958_f;
        this.field_149789_z = properties.field_200960_h;
        this.field_149762_H = properties.field_200956_d;
        this.field_149765_K = properties.field_200961_i;
        this.field_226886_f_ = properties.field_226893_j_;
        this.field_226887_g_ = properties.field_226894_k_;
        this.field_208621_p = properties.field_208772_j;
        this.field_235684_aB_ = properties;
        ResourceLocation lootTableCache = properties.field_222381_j;
        this.lootTableSupplier = lootTableCache != null ? () -> lootTableCache : (properties.lootTableSupplier != null ? properties.lootTableSupplier : () -> new ResourceLocation(this.getRegistryName().func_110624_b(), "blocks/" + this.getRegistryName().func_110623_a()));
    }

    @Deprecated
    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags, int recursionLeft) {
    }

    @Deprecated
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return !state.func_235785_r_(worldIn, pos);
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !state.func_235785_r_(worldIn, pos);
            }
        }
        return false;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        DebugPacketSender.func_218806_a((World)worldIn, (BlockPos)pos);
    }

    @Deprecated
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    @Deprecated
    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        return false;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_220074_n(BlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return false;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.field_149764_J.func_186274_m();
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return Fluids.field_204541_a.func_207188_f();
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return false;
    }

    public OffsetType func_176218_Q() {
        return OffsetType.NONE;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return state;
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }

    @Deprecated
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return state.func_185904_a().func_76222_j() && (useContext.func_195996_i().func_190926_b() || useContext.func_195996_i().func_77973_b() != this.func_199767_j());
    }

    @Deprecated
    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return this.field_149764_J.func_76222_j() || !this.field_149764_J.func_76220_a();
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ResourceLocation resourcelocation = this.func_220068_i();
        if (resourcelocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootcontext = builder.func_216015_a(LootParameters.field_216287_g, state).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld serverworld = lootcontext.func_202879_g();
        LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        return loottable.func_216113_a(lootcontext);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180186_a((Vector3i)pos);
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.func_220071_b(state, reader, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    @Deprecated
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (state.func_200015_d(worldIn, pos)) {
            return worldIn.func_201572_C();
        }
        return state.func_200131_a(worldIn, pos) ? 0 : 1;
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return null;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_235785_r_(worldIn, pos) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.field_235688_at_ ? state.func_196954_c(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.func_220071_b(state, reader, pos, context);
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.func_225534_a_(state, worldIn, pos, random);
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
    }

    @Deprecated
    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        float f = state.func_185887_b(worldIn, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)worldIn, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    @Deprecated
    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
    }

    @Deprecated
    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @Deprecated
    public final boolean func_235695_q_() {
        return this instanceof ITileEntityProvider;
    }

    public final ResourceLocation func_220068_i() {
        if (this.field_220085_g == null) {
            this.field_220085_g = this.lootTableSupplier.get();
        }
        return this.field_220085_g;
    }

    @Deprecated
    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
    }

    public abstract Item func_199767_j();

    protected abstract Block func_230328_p_();

    public MaterialColor func_235697_s_() {
        return (MaterialColor)this.field_235684_aB_.field_235800_b_.apply(this.func_230328_p_().func_176223_P());
    }

    protected boolean isAir(BlockState state) {
        return ((AbstractBlockState)state).field_235702_f_;
    }

    public static class Properties {
        private Material field_200953_a;
        private Function<BlockState, MaterialColor> field_235800_b_;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private ToIntFunction<BlockState> field_235803_e_ = p_235830_0_ -> 0;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_235806_h_;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private float field_226893_j_ = 1.0f;
        private float field_226894_k_ = 1.0f;
        private ResourceLocation field_222381_j;
        private boolean field_226895_m_ = true;
        private boolean field_235813_o_;
        private int harvestLevel = -1;
        private ToolType harvestTool;
        private Supplier<ResourceLocation> lootTableSupplier;
        private IExtendedPositionPredicate<EntityType<?>> field_235814_p_ = (p_235832_0_, p_235832_1_, p_235832_2_, p_235832_3_) -> p_235832_0_.func_224755_d(p_235832_1_, p_235832_2_, Direction.UP) && p_235832_0_.getLightValue(p_235832_1_, p_235832_2_) < 14;
        private IPositionPredicate field_235815_q_ = (p_235853_0_, p_235853_1_, p_235853_2_) -> p_235853_0_.func_185904_a().func_76218_k() && p_235853_0_.func_235785_r_(p_235853_1_, p_235853_2_);
        private IPositionPredicate field_235816_r_;
        private IPositionPredicate field_235817_s_ = this.field_235816_r_ = (p_235848_1_, p_235848_2_, p_235848_3_) -> this.field_200953_a.func_76230_c() && p_235848_1_.func_235785_r_(p_235848_2_, p_235848_3_);
        private IPositionPredicate field_235818_t_ = (p_235843_0_, p_235843_1_, p_235843_2_) -> false;
        private IPositionPredicate field_235819_u_ = (p_235831_0_, p_235831_1_, p_235831_2_) -> false;
        private boolean field_208772_j;

        private Properties(Material materialIn, MaterialColor mapColorIn) {
            this(materialIn, (BlockState p_235837_1_) -> mapColorIn);
        }

        private Properties(Material material, Function<BlockState, MaterialColor> stateColorFunction) {
            this.field_200953_a = material;
            this.field_235800_b_ = stateColorFunction;
        }

        public static Properties func_200945_a(Material materialIn) {
            return Properties.func_200949_a(materialIn, materialIn.func_151565_r());
        }

        public static Properties func_200952_a(Material materialIn, DyeColor color) {
            return Properties.func_200949_a(materialIn, color.func_196055_e());
        }

        public static Properties func_200949_a(Material materialIn, MaterialColor mapColorIn) {
            return new Properties(materialIn, mapColorIn);
        }

        public static Properties func_235836_a_(Material material, Function<BlockState, MaterialColor> stateColorFunction) {
            return new Properties(material, stateColorFunction);
        }

        public static Properties func_200950_a(AbstractBlock blockIn) {
            Properties abstractblock$properties = new Properties(blockIn.field_149764_J, blockIn.field_235684_aB_.field_235800_b_);
            abstractblock$properties.field_200953_a = blockIn.field_235684_aB_.field_200953_a;
            abstractblock$properties.field_200959_g = blockIn.field_235684_aB_.field_200959_g;
            abstractblock$properties.field_200958_f = blockIn.field_235684_aB_.field_200958_f;
            abstractblock$properties.field_200955_c = blockIn.field_235684_aB_.field_200955_c;
            abstractblock$properties.field_200960_h = blockIn.field_235684_aB_.field_200960_h;
            abstractblock$properties.field_235803_e_ = blockIn.field_235684_aB_.field_235803_e_;
            abstractblock$properties.field_235800_b_ = blockIn.field_235684_aB_.field_235800_b_;
            abstractblock$properties.field_200956_d = blockIn.field_235684_aB_.field_200956_d;
            abstractblock$properties.field_200961_i = blockIn.field_235684_aB_.field_200961_i;
            abstractblock$properties.field_226893_j_ = blockIn.field_235684_aB_.field_226893_j_;
            abstractblock$properties.field_208772_j = blockIn.field_235684_aB_.field_208772_j;
            abstractblock$properties.field_226895_m_ = blockIn.field_235684_aB_.field_226895_m_;
            abstractblock$properties.field_235813_o_ = blockIn.field_235684_aB_.field_235813_o_;
            abstractblock$properties.field_235806_h_ = blockIn.field_235684_aB_.field_235806_h_;
            abstractblock$properties.harvestLevel = blockIn.field_235684_aB_.harvestLevel;
            abstractblock$properties.harvestTool = blockIn.field_235684_aB_.harvestTool;
            return abstractblock$properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_226896_b_() {
            this.field_226895_m_ = false;
            return this;
        }

        public Properties harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Properties harvestTool(ToolType harvestTool) {
            this.harvestTool = harvestTool;
            return this;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public ToolType getHarvestTool() {
            return this.harvestTool;
        }

        public Properties func_200941_a(float slipperinessIn) {
            this.field_200961_i = slipperinessIn;
            return this;
        }

        public Properties func_226897_b_(float factor) {
            this.field_226893_j_ = factor;
            return this;
        }

        public Properties func_226898_c_(float factor) {
            this.field_226894_k_ = factor;
            return this;
        }

        public Properties func_200947_a(SoundType soundTypeIn) {
            this.field_200956_d = soundTypeIn;
            return this;
        }

        public Properties func_235838_a_(ToIntFunction<BlockState> stateLightFunction) {
            this.field_235803_e_ = stateLightFunction;
            return this;
        }

        public Properties func_200948_a(float hardnessIn, float resistanceIn) {
            this.field_200959_g = hardnessIn;
            this.field_200958_f = Math.max(0.0f, resistanceIn);
            return this;
        }

        public Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        public Properties func_200943_b(float hardnessAndResistance) {
            this.func_200948_a(hardnessAndResistance, hardnessAndResistance);
            return this;
        }

        public Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        public Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }

        public Properties func_222380_e() {
            this.field_222381_j = LootTables.field_186419_a;
            return this;
        }

        @Deprecated
        public Properties func_222379_b(Block blockIn) {
            this.lootTableSupplier = () -> ((Block)((Object)((Object)blockIn.delegate.get()))).func_220068_i();
            return this;
        }

        public Properties lootFrom(Supplier<? extends Block> blockIn) {
            this.lootTableSupplier = () -> ((Block)((Object)((Object)blockIn.get()))).func_220068_i();
            return this;
        }

        public Properties func_235859_g_() {
            this.field_235813_o_ = true;
            return this;
        }

        public Properties func_235827_a_(IExtendedPositionPredicate<EntityType<?>> spawnPredicate) {
            this.field_235814_p_ = spawnPredicate;
            return this;
        }

        public Properties func_235828_a_(IPositionPredicate opaquePredicate) {
            this.field_235815_q_ = opaquePredicate;
            return this;
        }

        public Properties func_235842_b_(IPositionPredicate suffocatesPredicate) {
            this.field_235816_r_ = suffocatesPredicate;
            return this;
        }

        public Properties func_235847_c_(IPositionPredicate blocksVisionPredicate) {
            this.field_235817_s_ = blocksVisionPredicate;
            return this;
        }

        public Properties func_235852_d_(IPositionPredicate postProcessingPredicate) {
            this.field_235818_t_ = postProcessingPredicate;
            return this;
        }

        public Properties func_235856_e_(IPositionPredicate emmisiveRenderPredicate) {
            this.field_235819_u_ = emmisiveRenderPredicate;
            return this;
        }

        public Properties func_235861_h_() {
            this.field_235806_h_ = true;
            return this;
        }
    }

    public static enum OffsetType {
        NONE,
        XZ,
        XYZ;

    }

    public static interface IPositionPredicate {
        public boolean test(BlockState var1, IBlockReader var2, BlockPos var3);
    }

    public static interface IExtendedPositionPredicate<A> {
        public boolean test(BlockState var1, IBlockReader var2, BlockPos var3, A var4);
    }

    public static abstract class AbstractBlockState
    extends StateHolder<Block, BlockState> {
        private final int field_215708_d;
        private final boolean field_215709_e;
        private final boolean field_235702_f_;
        private final Material field_235703_g_;
        private final MaterialColor field_235704_h_;
        private final float field_235705_i_;
        private final boolean field_235706_j_;
        private final boolean field_235707_k_;
        private final IPositionPredicate field_235708_l_;
        private final IPositionPredicate field_235709_m_;
        private final IPositionPredicate field_235710_n_;
        private final IPositionPredicate field_235711_o_;
        private final IPositionPredicate field_235712_p_;
        @Nullable
        protected Cache field_215707_c;

        protected AbstractBlockState(Block block, ImmutableMap<Property<?>, Comparable<?>> propertyValueMap, MapCodec<BlockState> stateCodec) {
            super((Object)block, propertyValueMap, stateCodec);
            Properties abstractblock$properties = block.field_235684_aB_;
            this.field_215708_d = abstractblock$properties.field_235803_e_.applyAsInt(this.func_230340_p_());
            this.field_215709_e = block.func_220074_n(this.func_230340_p_());
            this.field_235702_f_ = abstractblock$properties.field_235813_o_;
            this.field_235703_g_ = abstractblock$properties.field_200953_a;
            this.field_235704_h_ = (MaterialColor)abstractblock$properties.field_235800_b_.apply(this.func_230340_p_());
            this.field_235705_i_ = abstractblock$properties.field_200959_g;
            this.field_235706_j_ = abstractblock$properties.field_235806_h_;
            this.field_235707_k_ = abstractblock$properties.field_226895_m_;
            this.field_235708_l_ = abstractblock$properties.field_235815_q_;
            this.field_235709_m_ = abstractblock$properties.field_235816_r_;
            this.field_235710_n_ = abstractblock$properties.field_235817_s_;
            this.field_235711_o_ = abstractblock$properties.field_235818_t_;
            this.field_235712_p_ = abstractblock$properties.field_235819_u_;
        }

        public void func_215692_c() {
            if (!this.func_177230_c().func_208619_r()) {
                this.field_215707_c = new Cache(this.func_230340_p_());
            }
        }

        public Block func_177230_c() {
            return (Block)((Object)this.field_235892_c_);
        }

        public Material func_185904_a() {
            return this.field_235703_g_;
        }

        public boolean func_215688_a(IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
            return this.func_177230_c().field_235684_aB_.field_235814_p_.test(this.func_230340_p_(), worldIn, pos, type);
        }

        public boolean func_200131_a(IBlockReader worldIn, BlockPos pos) {
            return this.field_215707_c != null ? this.field_215707_c.field_222500_d : this.func_177230_c().func_200123_i(this.func_230340_p_(), worldIn, pos);
        }

        public int func_200016_a(IBlockReader worldIn, BlockPos pos) {
            return this.field_215707_c != null ? this.field_215707_c.field_222501_e : this.func_177230_c().func_200011_d(this.func_230340_p_(), worldIn, pos);
        }

        public VoxelShape func_215702_a(IBlockReader worldIn, BlockPos pos, Direction directionIn) {
            return this.field_215707_c != null && this.field_215707_c.field_222502_f != null ? this.field_215707_c.field_222502_f[directionIn.ordinal()] : VoxelShapes.func_216387_a((VoxelShape)this.func_235754_c_(worldIn, pos), (Direction)directionIn);
        }

        public VoxelShape func_235754_c_(IBlockReader reader, BlockPos pos) {
            return this.func_177230_c().func_196247_c(this.func_230340_p_(), reader, pos);
        }

        public boolean func_215704_f() {
            return this.field_215707_c == null || this.field_215707_c.field_222503_g;
        }

        public boolean func_215691_g() {
            return this.field_215709_e;
        }

        @Deprecated
        public int func_185906_d() {
            return this.field_215708_d;
        }

        @Deprecated
        public boolean func_196958_f() {
            return this.func_177230_c().isAir((BlockState)this);
        }

        public MaterialColor func_185909_g(IBlockReader worldIn, BlockPos pos) {
            return this.field_235704_h_;
        }

        @Deprecated
        public BlockState func_185907_a(Rotation rot) {
            return this.func_177230_c().func_185499_a(this.func_230340_p_(), rot);
        }

        public BlockState func_185902_a(Mirror mirrorIn) {
            return this.func_177230_c().func_185471_a(this.func_230340_p_(), mirrorIn);
        }

        public BlockRenderType func_185901_i() {
            return this.func_177230_c().func_149645_b(this.func_230340_p_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_227035_k_(IBlockReader reader, BlockPos pos) {
            return this.field_235712_p_.test(this.func_230340_p_(), reader, pos);
        }

        @OnlyIn(value=Dist.CLIENT)
        public float func_215703_d(IBlockReader reader, BlockPos pos) {
            return this.func_177230_c().func_220080_a(this.func_230340_p_(), reader, pos);
        }

        public boolean func_215686_e(IBlockReader reader, BlockPos pos) {
            return this.field_235708_l_.test(this.func_230340_p_(), reader, pos);
        }

        public boolean func_185897_m() {
            return this.func_177230_c().func_149744_f(this.func_230340_p_());
        }

        public int func_185911_a(IBlockReader blockAccess, BlockPos pos, Direction side) {
            return this.func_177230_c().func_180656_a(this.func_230340_p_(), blockAccess, pos, side);
        }

        public boolean func_185912_n() {
            return this.func_177230_c().func_149740_M(this.func_230340_p_());
        }

        public int func_185888_a(World worldIn, BlockPos pos) {
            return this.func_177230_c().func_180641_l(this.func_230340_p_(), worldIn, pos);
        }

        public float func_185887_b(IBlockReader worldIn, BlockPos pos) {
            return this.field_235705_i_;
        }

        public float func_185903_a(PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
            return this.func_177230_c().func_180647_a(this.func_230340_p_(), player, worldIn, pos);
        }

        public int func_185893_b(IBlockReader blockAccess, BlockPos pos, Direction side) {
            return this.func_177230_c().func_176211_b(this.func_230340_p_(), blockAccess, pos, side);
        }

        public PushReaction func_185905_o() {
            return this.func_177230_c().func_149656_h(this.func_230340_p_());
        }

        public boolean func_200015_d(IBlockReader worldIn, BlockPos pos) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_222499_c;
            }
            BlockState blockstate = this.func_230340_p_();
            return blockstate.func_200132_m() ? Block.func_208062_a(blockstate.func_235754_c_(worldIn, pos)) : false;
        }

        public boolean func_200132_m() {
            return this.field_235707_k_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_200017_a(BlockState state, Direction face) {
            return this.func_177230_c().func_200122_a(this.func_230340_p_(), state, face);
        }

        public VoxelShape func_196954_c(IBlockReader worldIn, BlockPos pos) {
            return this.func_215700_a(worldIn, pos, ISelectionContext.func_216377_a());
        }

        public VoxelShape func_215700_a(IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return this.func_177230_c().func_220053_a(this.func_230340_p_(), worldIn, pos, context);
        }

        public VoxelShape func_196952_d(IBlockReader worldIn, BlockPos pos) {
            return this.field_215707_c != null ? this.field_215707_c.field_230026_g : this.func_215685_b(worldIn, pos, ISelectionContext.func_216377_a());
        }

        public VoxelShape func_215685_b(IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return this.func_177230_c().func_220071_b(this.func_230340_p_(), worldIn, pos, context);
        }

        public VoxelShape func_196951_e(IBlockReader worldIn, BlockPos pos) {
            return this.func_177230_c().func_230335_e_(this.func_230340_p_(), worldIn, pos);
        }

        public VoxelShape func_199611_f(IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return this.func_177230_c().func_230322_a_(this.func_230340_p_(), worldIn, pos, context);
        }

        public VoxelShape func_235777_m_(IBlockReader reader, BlockPos pos) {
            return this.func_177230_c().func_199600_g(this.func_230340_p_(), reader, pos);
        }

        public final boolean func_235719_a_(IBlockReader reader, BlockPos pos, Entity entity) {
            return this.func_215682_a(reader, pos, entity, Direction.UP);
        }

        public final boolean func_215682_a(IBlockReader reader, BlockPos pos, Entity entityIn, Direction direction) {
            return Block.func_208061_a(this.func_215685_b(reader, pos, ISelectionContext.func_216374_a(entityIn)), direction);
        }

        public Vector3d func_191059_e(IBlockReader access, BlockPos pos) {
            OffsetType abstractblock$offsettype = this.func_177230_c().func_176218_Q();
            if (abstractblock$offsettype == OffsetType.NONE) {
                return Vector3d.field_186680_a;
            }
            long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
            return new Vector3d(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, abstractblock$offsettype == OffsetType.XYZ ? ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
        }

        public boolean func_235728_a_(World world, BlockPos pos, int id, int param) {
            return this.func_177230_c().func_189539_a(this.func_230340_p_(), world, pos, id, param);
        }

        public void func_215697_a(World worldIn, BlockPos posIn, Block blockIn, BlockPos fromPosIn, boolean isMoving) {
            this.func_177230_c().func_220069_a(this.func_230340_p_(), worldIn, posIn, blockIn, fromPosIn, isMoving);
        }

        public final void func_235734_a_(IWorld world, BlockPos pos, int flag) {
            this.func_241482_a_(world, pos, flag, 512);
        }

        public final void func_241482_a_(IWorld world, BlockPos pos, int flag, int recursionLeft) {
            this.func_177230_c();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (Direction direction : field_212556_a) {
                blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
                BlockState blockstate = world.func_180495_p((BlockPos)blockpos$mutable);
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), this.func_230340_p_(), world, (BlockPos)blockpos$mutable, pos);
                Block.func_241468_a_(blockstate, blockstate1, world, (BlockPos)blockpos$mutable, flag, recursionLeft);
            }
        }

        public final void func_196948_b(IWorld worldIn, BlockPos pos, int flags) {
            this.func_241483_b_(worldIn, pos, flags, 512);
        }

        public void func_241483_b_(IWorld world, BlockPos pos, int flags, int recursionLeft) {
            this.func_177230_c().func_196248_b(this.func_230340_p_(), world, pos, flags, recursionLeft);
        }

        public void func_215705_a(World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
            this.func_177230_c().func_220082_b(this.func_230340_p_(), worldIn, pos, oldState, isMoving);
        }

        public void func_196947_b(World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
            this.func_177230_c().func_196243_a(this.func_230340_p_(), worldIn, pos, newState, isMoving);
        }

        public void func_227033_a_(ServerWorld worldIn, BlockPos posIn, Random randomIn) {
            this.func_177230_c().func_225534_a_(this.func_230340_p_(), worldIn, posIn, randomIn);
        }

        public void func_227034_b_(ServerWorld worldIn, BlockPos posIn, Random randomIn) {
            this.func_177230_c().func_225542_b_(this.func_230340_p_(), worldIn, posIn, randomIn);
        }

        public void func_196950_a(World worldIn, BlockPos pos, Entity entityIn) {
            this.func_177230_c().func_196262_a(this.func_230340_p_(), worldIn, pos, entityIn);
        }

        public void func_215706_a(ServerWorld worldIn, BlockPos pos, ItemStack stack) {
            this.func_177230_c().func_220062_a(this.func_230340_p_(), worldIn, pos, stack);
        }

        public List<ItemStack> func_215693_a(LootContext.Builder builder) {
            return this.func_177230_c().func_220076_a(this.func_230340_p_(), builder);
        }

        public ActionResultType func_227031_a_(World worldIn, PlayerEntity player, Hand handIn, BlockRayTraceResult resultIn) {
            return this.func_177230_c().func_225533_a_(this.func_230340_p_(), worldIn, resultIn.func_216350_a(), player, handIn, resultIn);
        }

        public void func_196942_a(World worldIn, BlockPos pos, PlayerEntity player) {
            this.func_177230_c().func_196270_a(this.func_230340_p_(), worldIn, pos, player);
        }

        public boolean func_229980_m_(IBlockReader blockReaderIn, BlockPos blockPosIn) {
            return this.field_235709_m_.test(this.func_230340_p_(), blockReaderIn, blockPosIn);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_215696_m(IBlockReader worldIn, BlockPos pos) {
            return this.field_235710_n_.test(this.func_230340_p_(), worldIn, pos);
        }

        public BlockState func_196956_a(Direction face, BlockState queried, IWorld worldIn, BlockPos currentPos, BlockPos offsetPos) {
            return this.func_177230_c().func_196271_a(this.func_230340_p_(), face, queried, worldIn, currentPos, offsetPos);
        }

        public boolean func_196957_g(IBlockReader worldIn, BlockPos pos, PathType type) {
            return this.func_177230_c().func_196266_a(this.func_230340_p_(), worldIn, pos, type);
        }

        public boolean func_196953_a(BlockItemUseContext useContext) {
            return this.func_177230_c().func_196253_a(this.func_230340_p_(), useContext);
        }

        public boolean func_227032_a_(Fluid fluidIn) {
            return this.func_177230_c().func_225541_a_(this.func_230340_p_(), fluidIn);
        }

        public boolean func_196955_c(IWorldReader worldIn, BlockPos pos) {
            return this.func_177230_c().func_196260_a(this.func_230340_p_(), worldIn, pos);
        }

        public boolean func_202065_c(IBlockReader worldIn, BlockPos pos) {
            return this.field_235711_o_.test(this.func_230340_p_(), worldIn, pos);
        }

        @Nullable
        public INamedContainerProvider func_215699_b(World worldIn, BlockPos pos) {
            return this.func_177230_c().func_220052_b(this.func_230340_p_(), worldIn, pos);
        }

        public boolean func_235714_a_(ITag<Block> tag) {
            return this.func_177230_c().func_203417_a(tag);
        }

        public boolean func_235715_a_(ITag<Block> tag, Predicate<AbstractBlockState> predicate) {
            return this.func_177230_c().func_203417_a(tag) && predicate.test(this);
        }

        public boolean func_203425_a(Block tagIn) {
            return this.func_177230_c().func_235332_a_(tagIn);
        }

        public FluidState func_204520_s() {
            return this.func_177230_c().func_204507_t(this.func_230340_p_());
        }

        public boolean func_204519_t() {
            return this.func_177230_c().func_149653_t(this.func_230340_p_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public long func_209533_a(BlockPos pos) {
            return this.func_177230_c().func_209900_a(this.func_230340_p_(), pos);
        }

        public SoundType func_215695_r() {
            return this.func_177230_c().func_220072_p(this.func_230340_p_());
        }

        public void func_215690_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
            this.func_177230_c().func_220066_a(worldIn, state, hit, projectile);
        }

        public boolean func_224755_d(IBlockReader blockReaderIn, BlockPos blockPosIn, Direction directionIn) {
            return this.func_242698_a(blockReaderIn, blockPosIn, directionIn, BlockVoxelShape.FULL);
        }

        public boolean func_242698_a(IBlockReader blockReader, BlockPos pos, Direction direction, BlockVoxelShape blockVoxelShape) {
            return this.field_215707_c != null ? this.field_215707_c.func_242700_a(direction, blockVoxelShape) : blockVoxelShape.func_241854_a(this.func_230340_p_(), blockReader, pos, direction);
        }

        public boolean func_235785_r_(IBlockReader reader, BlockPos pos) {
            return this.field_215707_c != null ? this.field_215707_c.field_225494_j : Block.func_208062_a(this.func_196952_d(reader, pos));
        }

        protected abstract BlockState func_230340_p_();

        public boolean func_235783_q_() {
            return this.field_235706_j_;
        }

        static final class Cache {
            private static final Direction[] field_222497_a = Direction.values();
            private static final int field_242699_f = BlockVoxelShape.values().length;
            protected final boolean field_222499_c;
            private final boolean field_222500_d;
            private final int field_222501_e;
            @Nullable
            private final VoxelShape[] field_222502_f;
            protected final VoxelShape field_230026_g;
            protected final boolean field_222503_g;
            private final boolean[] field_225493_i;
            protected final boolean field_225494_j;

            private Cache(BlockState stateIn) {
                Block block = stateIn.func_177230_c();
                this.field_222499_c = stateIn.func_200015_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                this.field_222500_d = block.func_200123_i(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                this.field_222501_e = block.func_200011_d(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                if (!stateIn.func_200132_m()) {
                    this.field_222502_f = null;
                } else {
                    this.field_222502_f = new VoxelShape[field_222497_a.length];
                    VoxelShape voxelshape = block.func_196247_c(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                    Direction[] directionArray = field_222497_a;
                    int n = directionArray.length;
                    for (int i = 0; i < n; ++i) {
                        Direction direction = directionArray[i];
                        this.field_222502_f[direction.ordinal()] = VoxelShapes.func_216387_a((VoxelShape)voxelshape, (Direction)direction);
                    }
                }
                this.field_230026_g = block.func_220071_b(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, ISelectionContext.func_216377_a());
                this.field_222503_g = Arrays.stream(Direction.Axis.values()).anyMatch(p_235796_1_ -> this.field_230026_g.func_197762_b(p_235796_1_) < 0.0 || this.field_230026_g.func_197758_c(p_235796_1_) > 1.0);
                this.field_225493_i = new boolean[field_222497_a.length * field_242699_f];
                for (Direction direction1 : field_222497_a) {
                    for (BlockVoxelShape blockvoxelshape : BlockVoxelShape.values()) {
                        this.field_225493_i[Cache.func_242701_b((Direction)direction1, (BlockVoxelShape)blockvoxelshape)] = blockvoxelshape.func_241854_a(stateIn, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, direction1);
                    }
                }
                this.field_225494_j = Block.func_208062_a(stateIn.func_196952_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a));
            }

            public boolean func_242700_a(Direction direction, BlockVoxelShape blockVoxelShape) {
                return this.field_225493_i[Cache.func_242701_b(direction, blockVoxelShape)];
            }

            private static int func_242701_b(Direction direction, BlockVoxelShape blockVoxelShape) {
                return direction.ordinal() * field_242699_f + blockVoxelShape.ordinal();
            }
        }
    }
}

