/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemModelGenerator {
    public static final List<String> field_178398_a = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});

    public BlockModel func_209579_a(Function<RenderMaterial, TextureAtlasSprite> p_209579_1_, BlockModel p_209579_2_) {
        String s;
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < field_178398_a.size() && p_209579_2_.func_178300_b(s = field_178398_a.get(i)); ++i) {
            RenderMaterial rendermaterial = p_209579_2_.func_228816_c_(s);
            map.put(s, Either.left((Object)rendermaterial));
            TextureAtlasSprite textureatlassprite = p_209579_1_.apply(rendermaterial);
            list.addAll(this.func_178394_a(i, s, textureatlassprite));
        }
        map.put("particle", p_209579_2_.func_178300_b("particle") ? Either.left((Object)p_209579_2_.func_228816_c_("particle")) : (Either)map.get("layer0"));
        BlockModel blockmodel = new BlockModel(null, list, map, false, p_209579_2_.func_230176_c_(), p_209579_2_.func_181682_g(), p_209579_2_.func_187966_f());
        blockmodel.field_178317_b = p_209579_2_.field_178317_b;
        blockmodel.customData.copyFrom(p_209579_2_.customData);
        return blockmodel;
    }

    private List<BlockPart> func_178394_a(int p_178394_1_, String p_178394_2_, TextureAtlasSprite p_178394_3_) {
        HashMap map = Maps.newHashMap();
        map.put(Direction.SOUTH, new BlockPartFace((Direction)null, p_178394_1_, p_178394_2_, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        map.put(Direction.NORTH, new BlockPartFace((Direction)null, p_178394_1_, p_178394_2_, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList list = Lists.newArrayList();
        list.add(new BlockPart(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), (Map)map, (BlockPartRotation)null, true));
        list.addAll(this.func_178397_a(p_178394_3_, p_178394_2_, p_178394_1_));
        return list;
    }

    private List<BlockPart> func_178397_a(TextureAtlasSprite p_178397_1_, String p_178397_2_, int p_178397_3_) {
        float f = p_178397_1_.func_94211_a();
        float f1 = p_178397_1_.func_94216_b();
        ArrayList list = Lists.newArrayList();
        for (Span itemmodelgenerator$span : this.func_178393_a(p_178397_1_)) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 16.0f / f;
            float f11 = 16.0f / f1;
            float f12 = itemmodelgenerator$span.func_178385_b();
            float f13 = itemmodelgenerator$span.func_178384_c();
            float f14 = itemmodelgenerator$span.func_178381_d();
            SpanFacing itemmodelgenerator$spanfacing = itemmodelgenerator$span.func_178383_a();
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f8 = f14;
                    f3 = f14;
                    f5 = f14;
                    f9 = f14 + 1.0f;
                    break;
                }
                case DOWN: {
                    f8 = f14;
                    f9 = f14 + 1.0f;
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f3 = f14 + 1.0f;
                    f5 = f14 + 1.0f;
                    break;
                }
                case LEFT: {
                    f6 = f14;
                    f2 = f14;
                    f4 = f14;
                    f7 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                    break;
                }
                case RIGHT: {
                    f6 = f14;
                    f7 = f14 + 1.0f;
                    f2 = f14 + 1.0f;
                    f4 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                }
            }
            f2 *= f10;
            f4 *= f10;
            f3 *= f11;
            f5 *= f11;
            f3 = 16.0f - f3;
            f5 = 16.0f - f5;
            HashMap map = Maps.newHashMap();
            map.put(itemmodelgenerator$spanfacing.func_178367_a(), new BlockPartFace((Direction)null, p_178397_3_, p_178397_2_, new BlockFaceUV(new float[]{f6 *= f10, f8 *= f11, f7 *= f10, f9 *= f11}, 0)));
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    list.add(new BlockPart(new Vector3f(f2, f3, 7.5f), new Vector3f(f4, f3, 8.5f), (Map)map, (BlockPartRotation)null, true));
                    break;
                }
                case DOWN: {
                    list.add(new BlockPart(new Vector3f(f2, f5, 7.5f), new Vector3f(f4, f5, 8.5f), (Map)map, (BlockPartRotation)null, true));
                    break;
                }
                case LEFT: {
                    list.add(new BlockPart(new Vector3f(f2, f3, 7.5f), new Vector3f(f2, f5, 8.5f), (Map)map, (BlockPartRotation)null, true));
                    break;
                }
                case RIGHT: {
                    list.add(new BlockPart(new Vector3f(f4, f3, 7.5f), new Vector3f(f4, f5, 8.5f), (Map)map, (BlockPartRotation)null, true));
                }
            }
        }
        return list;
    }

    private List<Span> func_178393_a(TextureAtlasSprite p_178393_1_) {
        int i = p_178393_1_.func_94211_a();
        int j = p_178393_1_.func_94216_b();
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < p_178393_1_.func_110970_k(); ++k) {
            for (int l = 0; l < j; ++l) {
                for (int i1 = 0; i1 < i; ++i1) {
                    boolean flag = !this.func_199339_a(p_178393_1_, k, i1, l, i, j);
                    this.func_199338_a(SpanFacing.UP, list, p_178393_1_, k, i1, l, i, j, flag);
                    this.func_199338_a(SpanFacing.DOWN, list, p_178393_1_, k, i1, l, i, j, flag);
                    this.func_199338_a(SpanFacing.LEFT, list, p_178393_1_, k, i1, l, i, j, flag);
                    this.func_199338_a(SpanFacing.RIGHT, list, p_178393_1_, k, i1, l, i, j, flag);
                }
            }
        }
        return list;
    }

    private void func_199338_a(SpanFacing p_199338_1_, List<Span> p_199338_2_, TextureAtlasSprite p_199338_3_, int p_199338_4_, int p_199338_5_, int p_199338_6_, int p_199338_7_, int p_199338_8_, boolean p_199338_9_) {
        boolean flag;
        boolean bl = flag = this.func_199339_a(p_199338_3_, p_199338_4_, p_199338_5_ + p_199338_1_.func_178372_b(), p_199338_6_ + p_199338_1_.func_178371_c(), p_199338_7_, p_199338_8_) && p_199338_9_;
        if (flag) {
            this.func_178395_a(p_199338_2_, p_199338_1_, p_199338_5_, p_199338_6_);
        }
    }

    private void func_178395_a(List<Span> p_178395_1_, SpanFacing p_178395_2_, int p_178395_3_, int p_178395_4_) {
        int k;
        Span itemmodelgenerator$span = null;
        for (Span itemmodelgenerator$span1 : p_178395_1_) {
            int i;
            if (itemmodelgenerator$span1.func_178383_a() != p_178395_2_) continue;
            int n = i = p_178395_2_.func_178369_d() ? p_178395_4_ : p_178395_3_;
            if (itemmodelgenerator$span1.func_178381_d() != i) continue;
            itemmodelgenerator$span = itemmodelgenerator$span1;
            break;
        }
        int j = p_178395_2_.func_178369_d() ? p_178395_4_ : p_178395_3_;
        int n = k = p_178395_2_.func_178369_d() ? p_178395_3_ : p_178395_4_;
        if (itemmodelgenerator$span == null) {
            p_178395_1_.add(new Span(p_178395_2_, k, j));
        } else {
            itemmodelgenerator$span.func_178382_a(k);
        }
    }

    private boolean func_199339_a(TextureAtlasSprite p_199339_1_, int p_199339_2_, int p_199339_3_, int p_199339_4_, int p_199339_5_, int p_199339_6_) {
        return p_199339_3_ >= 0 && p_199339_4_ >= 0 && p_199339_3_ < p_199339_5_ && p_199339_4_ < p_199339_6_ ? p_199339_1_.func_195662_a(p_199339_2_, p_199339_3_, p_199339_4_) : true;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction field_178376_e;
        private final int field_178373_f;
        private final int field_178374_g;

        private SpanFacing(Direction p_i46215_3_, int p_i46215_4_, int p_i46215_5_) {
            this.field_178376_e = p_i46215_3_;
            this.field_178373_f = p_i46215_4_;
            this.field_178374_g = p_i46215_5_;
        }

        public Direction func_178367_a() {
            return this.field_178376_e;
        }

        public int func_178372_b() {
            return this.field_178373_f;
        }

        public int func_178371_c() {
            return this.field_178374_g;
        }

        private boolean func_178369_d() {
            return this == DOWN || this == UP;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Span {
        private final SpanFacing field_178389_a;
        private int field_178387_b;
        private int field_178388_c;
        private final int field_178386_d;

        public Span(SpanFacing p_i46216_1_, int p_i46216_2_, int p_i46216_3_) {
            this.field_178389_a = p_i46216_1_;
            this.field_178387_b = p_i46216_2_;
            this.field_178388_c = p_i46216_2_;
            this.field_178386_d = p_i46216_3_;
        }

        public void func_178382_a(int p_178382_1_) {
            if (p_178382_1_ < this.field_178387_b) {
                this.field_178387_b = p_178382_1_;
            } else if (p_178382_1_ > this.field_178388_c) {
                this.field_178388_c = p_178382_1_;
            }
        }

        public SpanFacing func_178383_a() {
            return this.field_178389_a;
        }

        public int func_178385_b() {
            return this.field_178387_b;
        }

        public int func_178384_c() {
            return this.field_178388_c;
        }

        public int func_178381_d() {
            return this.field_178386_d;
        }
    }
}

