/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorStandEntity
extends LivingEntity {
    private static final Rotations field_175435_a = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175433_b = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175434_c = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations field_175431_d = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations field_175432_e = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations field_175429_f = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntitySize field_242328_bp = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize field_242329_bq = EntityType.field_200789_c.func_220334_j().func_220313_a(0.5f);
    public static final DataParameter<Byte> field_184801_a = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187191_a);
    public static final DataParameter<Rotations> field_184802_b = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184803_c = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184804_d = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184805_e = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184806_f = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184807_g = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    private static final Predicate<Entity> field_184798_bv = p_200617_0_ -> p_200617_0_ instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)((Object)p_200617_0_)).canBeRidden();
    private final NonNullList<ItemStack> field_184799_bw = NonNullList.func_191197_a((int)2, (Object)((Object)ItemStack.field_190927_a));
    private final NonNullList<ItemStack> field_184800_bx = NonNullList.func_191197_a((int)4, (Object)((Object)ItemStack.field_190927_a));
    private boolean field_175436_h;
    public long field_175437_i;
    private int field_175442_bg;
    private Rotations field_175443_bh = field_175435_a;
    private Rotations field_175444_bi = field_175433_b;
    private Rotations field_175438_bj = field_175434_c;
    private Rotations field_175439_bk = field_175431_d;
    private Rotations field_175440_bl = field_175432_e;
    private Rotations field_175441_bm = field_175429_f;

    public ArmorStandEntity(EntityType<? extends ArmorStandEntity> p_i50225_1_, World p_i50225_2_) {
        super((EntityType<? extends LivingEntity>)p_i50225_1_, p_i50225_2_);
        this.field_70138_W = 0.0f;
    }

    public ArmorStandEntity(World p_i45855_1_, double p_i45855_2_, double p_i45855_4_, double p_i45855_6_) {
        this((EntityType<? extends ArmorStandEntity>)EntityType.field_200789_c, p_i45855_1_);
        this.func_70107_b(p_i45855_2_, p_i45855_4_, p_i45855_6_);
    }

    @Override
    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    private boolean func_213814_A() {
        return !this.func_181026_s() && !this.func_189652_ae();
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && this.func_213814_A();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184801_a, (byte)0);
        this.field_70180_af.func_187214_a(field_184802_b, field_175435_a);
        this.field_70180_af.func_187214_a(field_184803_c, field_175433_b);
        this.field_70180_af.func_187214_a(field_184804_d, field_175434_c);
        this.field_70180_af.func_187214_a(field_184805_e, field_175431_d);
        this.field_70180_af.func_187214_a(field_184806_f, field_175432_e);
        this.field_70180_af.func_187214_a(field_184807_g, field_175429_f);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184799_bw;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184800_bx;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        switch (p_184582_1_.func_188453_a()) {
            case HAND: {
                return (ItemStack)((Object)this.field_184799_bw.get(p_184582_1_.func_188454_b()));
            }
            case ARMOR: {
                return (ItemStack)((Object)this.field_184800_bx.get(p_184582_1_.func_188454_b()));
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
        switch (p_184201_1_.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(p_184201_2_);
                this.field_184799_bw.set(p_184201_1_.func_188454_b(), (Object)p_184201_2_);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(p_184201_2_);
                this.field_184800_bx.set(p_184201_1_.func_188454_b(), (Object)p_184201_2_);
            }
        }
    }

    @Override
    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        EquipmentSlotType equipmentslottype;
        if (p_174820_1_ == 98) {
            equipmentslottype = EquipmentSlotType.MAINHAND;
        } else if (p_174820_1_ == 99) {
            equipmentslottype = EquipmentSlotType.OFFHAND;
        } else if (p_174820_1_ == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.HEAD;
        } else if (p_174820_1_ == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.CHEST;
        } else if (p_174820_1_ == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.LEGS;
        } else {
            if (p_174820_1_ != 100 + EquipmentSlotType.FEET.func_188454_b()) {
                return false;
            }
            equipmentslottype = EquipmentSlotType.FEET;
        }
        if (!p_174820_2_.func_190926_b() && !MobEntity.func_184648_b(equipmentslottype, p_174820_2_) && equipmentslottype != EquipmentSlotType.HEAD) {
            return false;
        }
        this.func_184201_a(equipmentslottype, p_174820_2_);
        return true;
    }

    @Override
    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_213365_1_);
        return this.func_184582_a(equipmentslottype).func_190926_b() && !this.func_184796_b(equipmentslottype);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : this.field_184800_bx) {
            CompoundNBT compoundnbt = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        p_213281_1_.func_218657_a("ArmorItems", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (ItemStack itemstack1 : this.field_184799_bw) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_77955_b(compoundnbt1);
            }
            listnbt1.add((Object)compoundnbt1);
        }
        p_213281_1_.func_218657_a("HandItems", (INBT)listnbt1);
        p_213281_1_.func_74757_a("Invisible", this.func_82150_aj());
        p_213281_1_.func_74757_a("Small", this.func_175410_n());
        p_213281_1_.func_74757_a("ShowArms", this.func_175402_q());
        p_213281_1_.func_74768_a("DisabledSlots", this.field_175442_bg);
        p_213281_1_.func_74757_a("NoBasePlate", this.func_175414_r());
        if (this.func_181026_s()) {
            p_213281_1_.func_74757_a("Marker", this.func_181026_s());
        }
        p_213281_1_.func_218657_a("Pose", this.func_175419_y());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("ArmorItems", 9)) {
            ListNBT listnbt = p_70037_1_.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.field_184800_bx.size(); ++i) {
                this.field_184800_bx.set(i, (Object)ItemStack.func_199557_a(listnbt.func_150305_b(i)));
            }
        }
        if (p_70037_1_.func_150297_b("HandItems", 9)) {
            ListNBT listnbt1 = p_70037_1_.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.field_184799_bw.size(); ++j) {
                this.field_184799_bw.set(j, (Object)ItemStack.func_199557_a(listnbt1.func_150305_b(j)));
            }
        }
        this.func_82142_c(p_70037_1_.func_74767_n("Invisible"));
        this.func_175420_a(p_70037_1_.func_74767_n("Small"));
        this.func_175413_k(p_70037_1_.func_74767_n("ShowArms"));
        this.field_175442_bg = p_70037_1_.func_74762_e("DisabledSlots");
        this.func_175426_l(p_70037_1_.func_74767_n("NoBasePlate"));
        this.func_181027_m(p_70037_1_.func_74767_n("Marker"));
        this.field_70145_X = !this.func_213814_A();
        CompoundNBT compoundnbt = p_70037_1_.func_74775_l("Pose");
        this.func_175416_h(compoundnbt);
    }

    private void func_175416_h(CompoundNBT p_175416_1_) {
        ListNBT listnbt = p_175416_1_.func_150295_c("Head", 5);
        this.func_175415_a(listnbt.isEmpty() ? field_175435_a : new Rotations(listnbt));
        ListNBT listnbt1 = p_175416_1_.func_150295_c("Body", 5);
        this.func_175424_b(listnbt1.isEmpty() ? field_175433_b : new Rotations(listnbt1));
        ListNBT listnbt2 = p_175416_1_.func_150295_c("LeftArm", 5);
        this.func_175405_c(listnbt2.isEmpty() ? field_175434_c : new Rotations(listnbt2));
        ListNBT listnbt3 = p_175416_1_.func_150295_c("RightArm", 5);
        this.func_175428_d(listnbt3.isEmpty() ? field_175431_d : new Rotations(listnbt3));
        ListNBT listnbt4 = p_175416_1_.func_150295_c("LeftLeg", 5);
        this.func_175417_e(listnbt4.isEmpty() ? field_175432_e : new Rotations(listnbt4));
        ListNBT listnbt5 = p_175416_1_.func_150295_c("RightLeg", 5);
        this.func_175427_f(listnbt5.isEmpty() ? field_175429_f : new Rotations(listnbt5));
    }

    private CompoundNBT func_175419_y() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (!field_175435_a.equals((Object)this.field_175443_bh)) {
            compoundnbt.func_218657_a("Head", (INBT)this.field_175443_bh.func_179414_a());
        }
        if (!field_175433_b.equals((Object)this.field_175444_bi)) {
            compoundnbt.func_218657_a("Body", (INBT)this.field_175444_bi.func_179414_a());
        }
        if (!field_175434_c.equals((Object)this.field_175438_bj)) {
            compoundnbt.func_218657_a("LeftArm", (INBT)this.field_175438_bj.func_179414_a());
        }
        if (!field_175431_d.equals((Object)this.field_175439_bk)) {
            compoundnbt.func_218657_a("RightArm", (INBT)this.field_175439_bk.func_179414_a());
        }
        if (!field_175432_e.equals((Object)this.field_175440_bl)) {
            compoundnbt.func_218657_a("LeftLeg", (INBT)this.field_175440_bl.func_179414_a());
        }
        if (!field_175429_f.equals((Object)this.field_175441_bm)) {
            compoundnbt.func_218657_a("RightLeg", (INBT)this.field_175441_bm.func_179414_a());
        }
        return compoundnbt;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected void func_82167_n(Entity p_82167_1_) {
    }

    @Override
    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184798_bv);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f(this);
        }
    }

    @Override
    public ActionResultType func_184199_a(PlayerEntity p_184199_1_, Vector3d p_184199_2_, Hand p_184199_3_) {
        ItemStack itemstack = p_184199_1_.func_184586_b(p_184199_3_);
        if (!this.func_181026_s() && itemstack.func_77973_b() != Items.field_151057_cb) {
            if (p_184199_1_.func_175149_v()) {
                return ActionResultType.SUCCESS;
            }
            if (p_184199_1_.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
            EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(itemstack);
            if (itemstack.func_190926_b()) {
                EquipmentSlotType equipmentslottype2;
                EquipmentSlotType equipmentslottype1 = this.func_190772_a(p_184199_2_);
                EquipmentSlotType equipmentSlotType = equipmentslottype2 = this.func_184796_b(equipmentslottype1) ? equipmentslottype : equipmentslottype1;
                if (this.func_190630_a(equipmentslottype2) && this.func_226529_a_(p_184199_1_, equipmentslottype2, itemstack, p_184199_3_)) {
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (this.func_184796_b(equipmentslottype)) {
                    return ActionResultType.FAIL;
                }
                if (equipmentslottype.func_188453_a() == EquipmentSlotType.Group.HAND && !this.func_175402_q()) {
                    return ActionResultType.FAIL;
                }
                if (this.func_226529_a_(p_184199_1_, equipmentslottype, itemstack, p_184199_3_)) {
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlotType func_190772_a(Vector3d p_190772_1_) {
        EquipmentSlotType equipmentslottype = EquipmentSlotType.MAINHAND;
        boolean flag = this.func_175410_n();
        double d0 = flag ? p_190772_1_.field_72448_b * 2.0 : p_190772_1_.field_72448_b;
        EquipmentSlotType equipmentslottype1 = EquipmentSlotType.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.func_190630_a(equipmentslottype1)) {
                return EquipmentSlotType.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.func_190630_a(EquipmentSlotType.CHEST)) {
                return EquipmentSlotType.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.func_190630_a(EquipmentSlotType.LEGS)) {
                return EquipmentSlotType.LEGS;
            }
        }
        if (d0 >= 1.6 && this.func_190630_a(EquipmentSlotType.HEAD)) {
            return EquipmentSlotType.HEAD;
        }
        if (this.func_190630_a(EquipmentSlotType.MAINHAND)) return equipmentslottype;
        if (!this.func_190630_a(EquipmentSlotType.OFFHAND)) return equipmentslottype;
        return EquipmentSlotType.OFFHAND;
    }

    private boolean func_184796_b(EquipmentSlotType p_184796_1_) {
        return (this.field_175442_bg & 1 << p_184796_1_.func_188452_c()) != 0 || p_184796_1_.func_188453_a() == EquipmentSlotType.Group.HAND && !this.func_175402_q();
    }

    private boolean func_226529_a_(PlayerEntity p_226529_1_, EquipmentSlotType p_226529_2_, ItemStack p_226529_3_, Hand p_226529_4_) {
        ItemStack itemstack = this.func_184582_a(p_226529_2_);
        if (!itemstack.func_190926_b() && (this.field_175442_bg & 1 << p_226529_2_.func_188452_c() + 8) != 0) {
            return false;
        }
        if (itemstack.func_190926_b() && (this.field_175442_bg & 1 << p_226529_2_.func_188452_c() + 16) != 0) {
            return false;
        }
        if (p_226529_1_.field_71075_bZ.field_75098_d && itemstack.func_190926_b() && !p_226529_3_.func_190926_b()) {
            ItemStack itemstack2 = p_226529_3_.func_77946_l();
            itemstack2.func_190920_e(1);
            this.func_184201_a(p_226529_2_, itemstack2);
            return true;
        }
        if (!p_226529_3_.func_190926_b() && p_226529_3_.func_190916_E() > 1) {
            if (!itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = p_226529_3_.func_77946_l();
            itemstack1.func_190920_e(1);
            this.func_184201_a(p_226529_2_, itemstack1);
            p_226529_3_.func_190918_g(1);
            return true;
        }
        this.func_184201_a(p_226529_2_, p_226529_3_);
        p_226529_1_.func_184611_a(p_226529_4_, itemstack);
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (DamageSource.field_76380_i.equals(p_70097_1_)) {
                this.func_70106_y();
                return false;
            }
            if (!(this.func_180431_b(p_70097_1_) || this.field_175436_h || this.func_181026_s())) {
                if (p_70097_1_.func_94541_c()) {
                    this.func_213816_g(p_70097_1_);
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(p_70097_1_)) {
                    if (this.func_70027_ad()) {
                        this.func_213817_e(p_70097_1_, 0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(p_70097_1_) && this.func_110143_aJ() > 0.5f) {
                    this.func_213817_e(p_70097_1_, 4.0f);
                    return false;
                }
                boolean flag = p_70097_1_.func_76364_f() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)((Object)p_70097_1_.func_76364_f())).func_213874_s() > 0;
                boolean flag2 = "player".equals(p_70097_1_.func_76355_l());
                if (!flag2 && !flag) {
                    return false;
                }
                if (p_70097_1_.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)p_70097_1_.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (p_70097_1_.func_180136_u()) {
                    this.func_190773_I();
                    this.func_175412_z();
                    this.func_70106_y();
                    return flag1;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.field_175437_i > 5L && !flag) {
                    this.field_70170_p.func_72960_a(this, (byte)32);
                    this.field_175437_i = i;
                } else {
                    this.func_213815_f(p_70097_1_);
                    this.func_175412_z();
                    this.func_70106_y();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.field_175437_i = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    private void func_175412_z() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a(new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, this.func_213311_cf() / 4.0f, this.func_213302_cg() / 4.0f, this.func_213311_cf() / 4.0f, 0.05);
        }
    }

    private void func_213817_e(DamageSource p_213817_1_, float p_213817_2_) {
        float f = this.func_110143_aJ();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.func_213816_g(p_213817_1_);
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void func_213815_f(DamageSource p_213815_1_) {
        Block.func_180635_a(this.field_70170_p, this.func_233580_cy_(), new ItemStack(Items.field_179565_cj));
        this.func_213816_g(p_213815_1_);
    }

    private void func_213816_g(DamageSource p_213816_1_) {
        this.func_190773_I();
        this.func_213345_d(p_213816_1_);
        for (int i = 0; i < this.field_184799_bw.size(); ++i) {
            ItemStack itemstack = (ItemStack)((Object)this.field_184799_bw.get(i));
            if (itemstack.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, this.func_233580_cy_().func_177984_a(), itemstack);
            this.field_184799_bw.set(i, (Object)ItemStack.field_190927_a);
        }
        for (int j = 0; j < this.field_184800_bx.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)((Object)this.field_184800_bx.get(j));
            if (itemstack1.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, this.func_233580_cy_().func_177984_a(), itemstack1);
            this.field_184800_bx.set(j, (Object)ItemStack.field_190927_a);
        }
    }

    private void func_190773_I() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    @Override
    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * (this.func_70631_g_() ? 0.5f : 0.9f);
    }

    @Override
    public double func_70033_W() {
        return this.func_181026_s() ? 0.0 : (double)0.1f;
    }

    @Override
    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_213814_A()) {
            super.func_213352_e(p_213352_1_);
        }
    }

    @Override
    public void func_181013_g(float p_181013_1_) {
        this.field_70760_ar = this.field_70126_B = p_181013_1_;
        this.field_70758_at = this.field_70759_as = p_181013_1_;
    }

    @Override
    public void func_70034_d(float p_70034_1_) {
        this.field_70760_ar = this.field_70126_B = p_70034_1_;
        this.field_70758_at = this.field_70759_as = p_70034_1_;
    }

    @Override
    public void func_70071_h_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.func_70071_h_();
        Rotations rotations = this.field_70180_af.func_187225_a(field_184802_b);
        if (!this.field_175443_bh.equals((Object)rotations)) {
            this.func_175415_a(rotations);
        }
        if (!this.field_175444_bi.equals((Object)(rotations1 = this.field_70180_af.func_187225_a(field_184803_c)))) {
            this.func_175424_b(rotations1);
        }
        if (!this.field_175438_bj.equals((Object)(rotations2 = this.field_70180_af.func_187225_a(field_184804_d)))) {
            this.func_175405_c(rotations2);
        }
        if (!this.field_175439_bk.equals((Object)(rotations3 = this.field_70180_af.func_187225_a(field_184805_e)))) {
            this.func_175428_d(rotations3);
        }
        if (!this.field_175440_bl.equals((Object)(rotations4 = this.field_70180_af.func_187225_a(field_184806_f)))) {
            this.func_175417_e(rotations4);
        }
        if (!this.field_175441_bm.equals((Object)(rotations5 = this.field_70180_af.func_187225_a(field_184807_g)))) {
            this.func_175427_f(rotations5);
        }
    }

    @Override
    protected void func_175135_B() {
        this.func_82142_c(this.field_175436_h);
    }

    @Override
    public void func_82142_c(boolean p_82142_1_) {
        this.field_175436_h = p_82142_1_;
        super.func_82142_c(p_82142_1_);
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_175410_n();
    }

    @Override
    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    public boolean func_180427_aV() {
        return this.func_82150_aj();
    }

    @Override
    public PushReaction func_184192_z() {
        return this.func_181026_s() ? PushReaction.IGNORE : super.func_184192_z();
    }

    private void func_175420_a(boolean p_175420_1_) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 1, p_175420_1_));
    }

    public boolean func_175410_n() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 1) != 0;
    }

    private void func_175413_k(boolean p_175413_1_) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 4, p_175413_1_));
    }

    public boolean func_175402_q() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 4) != 0;
    }

    private void func_175426_l(boolean p_175426_1_) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 8, p_175426_1_));
    }

    public boolean func_175414_r() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 8) != 0;
    }

    private void func_181027_m(boolean p_181027_1_) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 16, p_181027_1_));
    }

    public boolean func_181026_s() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 0x10) != 0;
    }

    private byte func_184797_a(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void func_175415_a(Rotations p_175415_1_) {
        this.field_175443_bh = p_175415_1_;
        this.field_70180_af.func_187227_b(field_184802_b, p_175415_1_);
    }

    public void func_175424_b(Rotations p_175424_1_) {
        this.field_175444_bi = p_175424_1_;
        this.field_70180_af.func_187227_b(field_184803_c, p_175424_1_);
    }

    public void func_175405_c(Rotations p_175405_1_) {
        this.field_175438_bj = p_175405_1_;
        this.field_70180_af.func_187227_b(field_184804_d, p_175405_1_);
    }

    public void func_175428_d(Rotations p_175428_1_) {
        this.field_175439_bk = p_175428_1_;
        this.field_70180_af.func_187227_b(field_184805_e, p_175428_1_);
    }

    public void func_175417_e(Rotations p_175417_1_) {
        this.field_175440_bl = p_175417_1_;
        this.field_70180_af.func_187227_b(field_184806_f, p_175417_1_);
    }

    public void func_175427_f(Rotations p_175427_1_) {
        this.field_175441_bm = p_175427_1_;
        this.field_70180_af.func_187227_b(field_184807_g, p_175427_1_);
    }

    public Rotations func_175418_s() {
        return this.field_175443_bh;
    }

    public Rotations func_175408_t() {
        return this.field_175444_bi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175404_u() {
        return this.field_175438_bj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175411_v() {
        return this.field_175439_bk;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175403_w() {
        return this.field_175440_bl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175407_x() {
        return this.field_175441_bm;
    }

    @Override
    public boolean func_70067_L() {
        return super.func_70067_L() && !this.func_181026_s();
    }

    @Override
    public boolean func_85031_j(Entity p_85031_1_) {
        return p_85031_1_ instanceof PlayerEntity && !this.field_70170_p.func_175660_a((PlayerEntity)p_85031_1_, this.func_233580_cy_());
    }

    @Override
    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    @Override
    protected SoundEvent func_184588_d(int p_184588_1_) {
        return SoundEvents.field_187704_k;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187707_l;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    @Override
    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
    }

    @Override
    public boolean func_184603_cC() {
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_184801_a.equals(p_184206_1_)) {
            this.func_213323_x_();
            this.field_70156_m = !this.func_181026_s();
        }
        super.func_184206_a(p_184206_1_);
    }

    @Override
    public boolean func_190631_cK() {
        return false;
    }

    @Override
    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.func_242330_s(this.func_181026_s());
    }

    private EntitySize func_242330_s(boolean p_242330_1_) {
        if (p_242330_1_) {
            return field_242328_bp;
        }
        return this.func_70631_g_() ? field_242329_bq : this.func_200600_R().func_220334_j();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241842_k(float p_241842_1_) {
        if (this.func_181026_s()) {
            AxisAlignedBB axisalignedbb = this.func_242330_s(false).func_242286_a(this.func_213303_ch());
            BlockPos blockpos = this.func_233580_cy_();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)new BlockPos(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c), (BlockPos)new BlockPos(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f))) {
                int j = Math.max(this.field_70170_p.func_226658_a_(LightType.BLOCK, blockpos1), this.field_70170_p.func_226658_a_(LightType.SKY, blockpos1));
                if (j == 15) {
                    return Vector3d.func_237489_a_((Vector3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.func_185334_h();
            }
            return Vector3d.func_237489_a_((Vector3i)blockpos);
        }
        return super.func_241842_k(p_241842_1_);
    }
}

