/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SpongeBlock
extends Block {
    public SpongeBlock(AbstractBlock.Properties p_i48325_1_) {
        super(p_i48325_1_);
    }

    @Override
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!p_220082_4_.func_203425_a(p_220082_1_.func_177230_c())) {
            this.func_196510_a(p_220082_2_, p_220082_3_);
        }
    }

    @Override
    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        this.func_196510_a(p_220069_2_, p_220069_3_);
        super.func_220069_a(p_220069_1_, p_220069_2_, p_220069_3_, p_220069_4_, p_220069_5_, p_220069_6_);
    }

    protected void func_196510_a(World p_196510_1_, BlockPos p_196510_2_) {
        if (this.func_176312_d(p_196510_1_, p_196510_2_)) {
            p_196510_1_.func_180501_a(p_196510_2_, Blocks.field_196577_ad.func_176223_P(), 2);
            p_196510_1_.func_217379_c(2001, p_196510_2_, Block.func_196246_j(Blocks.field_150355_j.func_176223_P()));
        }
    }

    private boolean func_176312_d(World p_176312_1_, BlockPos p_176312_2_) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)p_176312_2_, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(direction);
                BlockState blockstate = p_176312_1_.func_180495_p(blockpos1);
                FluidState fluidstate = p_176312_1_.func_204610_c(blockpos1);
                Material material = blockstate.func_185904_a();
                if (!fluidstate.func_206884_a(FluidTags.field_206959_a)) continue;
                if (blockstate.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)p_176312_1_, blockpos1, blockstate) != Fluids.field_204541_a) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                    p_176312_1_.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.field_203243_f && material != Material.field_204868_h) continue;
                TileEntity tileentity = blockstate.hasTileEntity() ? p_176312_1_.func_175625_s(blockpos1) : null;
                SpongeBlock.func_220059_a(blockstate, p_176312_1_, blockpos1, tileentity);
                p_176312_1_.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

