/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public final class CsvRow {
    private static final String[] EMPTY = new String[]{""};
    private final long originalLineNumber;
    private final String[] fields;
    private final boolean comment;

    CsvRow(long originalLineNumber, boolean comment) {
        this(originalLineNumber, EMPTY, comment);
    }

    CsvRow(long originalLineNumber, String[] fields, boolean comment) {
        this.originalLineNumber = originalLineNumber;
        this.fields = fields;
        this.comment = comment;
    }

    public long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public String getField(int index) {
        return this.fields[index];
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(Arrays.asList(this.fields));
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public boolean isComment() {
        return this.comment;
    }

    public boolean isEmpty() {
        return this.fields == EMPTY;
    }

    public String toString() {
        return new StringJoiner(", ", CsvRow.class.getSimpleName() + "[", "]").add("originalLineNumber=" + this.originalLineNumber).add("fields=" + Arrays.toString(this.fields)).add("comment=" + this.comment).toString();
    }
}

