/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.EntityTickableSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.FireworkParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.ColorCache;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class ClientWorld
extends World {
    private final Int2ObjectMap<Entity> field_217429_b = new Int2ObjectOpenHashMap();
    private final ClientPlayNetHandler field_73035_a;
    private final WorldRenderer field_217430_d;
    private final ClientWorldInfo field_239130_d_;
    private final DimensionRenderInfo field_239131_x_;
    private final Minecraft field_73037_M = Minecraft.func_71410_x();
    private final List<AbstractClientPlayerEntity> field_217431_w = Lists.newArrayList();
    private Scoreboard field_200261_M = new Scoreboard();
    private final Map<String, MapData> field_217432_z = Maps.newHashMap();
    private int field_228314_A_;
    private final Object2ObjectArrayMap<ColorResolver, ColorCache> field_228315_B_ = Util.func_200696_a(new Object2ObjectArrayMap(3), p_228319_0_ -> {
        p_228319_0_.put((Object)BiomeColors.field_180291_a, (Object)new ColorCache());
        p_228319_0_.put((Object)BiomeColors.field_180289_b, (Object)new ColorCache());
        p_228319_0_.put((Object)BiomeColors.field_180290_c, (Object)new ColorCache());
    });
    private final ClientChunkProvider field_239129_E_;

    public ClientWorld(ClientPlayNetHandler p_i242067_1_, ClientWorldInfo p_i242067_2_, RegistryKey<World> p_i242067_3_, DimensionType p_i242067_4_, int p_i242067_5_, Supplier<IProfiler> p_i242067_6_, WorldRenderer p_i242067_7_, boolean p_i242067_8_, long p_i242067_9_) {
        super(p_i242067_2_, p_i242067_3_, p_i242067_4_, p_i242067_6_, true, p_i242067_8_, p_i242067_9_);
        this.field_73035_a = p_i242067_1_;
        this.field_239129_E_ = new ClientChunkProvider(this, p_i242067_5_);
        this.field_239130_d_ = p_i242067_2_;
        this.field_217430_d = p_i242067_7_;
        this.field_239131_x_ = DimensionRenderInfo.func_243495_a(p_i242067_4_);
        this.func_239136_a_(new BlockPos(8, 64, 8), 0.0f);
        this.func_72966_v();
        this.func_72947_a();
        this.gatherCapabilities();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)this));
    }

    public DimensionRenderInfo func_239132_a_() {
        return this.field_239131_x_;
    }

    public void func_72835_b(BooleanSupplier p_72835_1_) {
        this.func_175723_af().func_212673_r();
        this.func_239141_x_();
        this.func_217381_Z().func_76320_a("blocks");
        this.field_239129_E_.func_217207_a(p_72835_1_);
        this.func_217381_Z().func_76319_b();
    }

    private void func_239141_x_() {
        this.func_239134_a_(this.field_72986_A.func_82573_f() + 1L);
        if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
            this.func_72877_b(this.field_72986_A.func_76073_f() + 1L);
        }
    }

    public void func_239134_a_(long p_239134_1_) {
        this.field_239130_d_.func_239155_a_(p_239134_1_);
    }

    public void func_72877_b(long p_72877_1_) {
        if (p_72877_1_ < 0L) {
            p_72877_1_ = -p_72877_1_;
            ((GameRules.BooleanValue)this.func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223570_a(false, (MinecraftServer)null);
        } else {
            ((GameRules.BooleanValue)this.func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223570_a(true, (MinecraftServer)null);
        }
        this.field_239130_d_.func_239158_b_(p_72877_1_);
    }

    public Iterable<Entity> func_217416_b() {
        return this.field_217429_b.values();
    }

    public void func_217419_d() {
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("entities");
        ObjectIterator objectiterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectiterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
            Entity entity = (Entity)((Object)entry.getValue());
            if (entity.func_184218_aH()) continue;
            iprofiler.func_76320_a("tick");
            if (!entity.field_70128_L) {
                this.func_217390_a(this::func_217418_a, entity);
            }
            iprofiler.func_76319_b();
            iprofiler.func_76320_a("remove");
            if (entity.field_70128_L) {
                objectiterator.remove();
                this.func_217414_d(entity);
            }
            iprofiler.func_76319_b();
        }
        this.func_217391_K();
        iprofiler.func_76319_b();
    }

    public void func_217418_a(Entity p_217418_1_) {
        if (!(p_217418_1_ instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(p_217418_1_)) {
            this.func_217423_b(p_217418_1_);
        } else {
            p_217418_1_.func_226286_f_(p_217418_1_.func_226277_ct_(), p_217418_1_.func_226278_cu_(), p_217418_1_.func_226281_cx_());
            p_217418_1_.field_70126_B = p_217418_1_.field_70177_z;
            p_217418_1_.field_70127_C = p_217418_1_.field_70125_A;
            if (p_217418_1_.field_70175_ag || p_217418_1_.func_175149_v()) {
                ++p_217418_1_.field_70173_aa;
                this.func_217381_Z().func_194340_a(() -> Registry.field_212629_r.func_177774_c(p_217418_1_.func_200600_R()).toString());
                if (p_217418_1_.canUpdate()) {
                    p_217418_1_.func_70071_h_();
                }
                this.func_217381_Z().func_76319_b();
            }
            this.func_217423_b(p_217418_1_);
            if (p_217418_1_.field_70175_ag) {
                for (Entity entity : p_217418_1_.func_184188_bt()) {
                    this.func_217420_a(p_217418_1_, entity);
                }
            }
        }
    }

    public void func_217420_a(Entity p_217420_1_, Entity p_217420_2_) {
        if (!p_217420_2_.field_70128_L && p_217420_2_.func_184187_bx() == p_217420_1_) {
            if (p_217420_2_ instanceof PlayerEntity || this.func_72863_F().func_217204_a(p_217420_2_)) {
                p_217420_2_.func_226286_f_(p_217420_2_.func_226277_ct_(), p_217420_2_.func_226278_cu_(), p_217420_2_.func_226281_cx_());
                p_217420_2_.field_70126_B = p_217420_2_.field_70177_z;
                p_217420_2_.field_70127_C = p_217420_2_.field_70125_A;
                if (p_217420_2_.field_70175_ag) {
                    ++p_217420_2_.field_70173_aa;
                    p_217420_2_.func_70098_U();
                }
                this.func_217423_b(p_217420_2_);
                if (p_217420_2_.field_70175_ag) {
                    for (Entity entity : p_217420_2_.func_184188_bt()) {
                        this.func_217420_a(p_217420_2_, entity);
                    }
                }
            }
        } else {
            p_217420_2_.func_184210_p();
        }
    }

    private void func_217423_b(Entity p_217423_1_) {
        if (p_217423_1_.func_233578_ci_()) {
            this.func_217381_Z().func_76320_a("chunkCheck");
            int i = MathHelper.func_76128_c((double)(p_217423_1_.func_226277_ct_() / 16.0));
            int j = MathHelper.func_76128_c((double)(p_217423_1_.func_226278_cu_() / 16.0));
            int k = MathHelper.func_76128_c((double)(p_217423_1_.func_226281_cx_() / 16.0));
            if (!p_217423_1_.field_70175_ag || p_217423_1_.field_70176_ah != i || p_217423_1_.field_70162_ai != j || p_217423_1_.field_70164_aj != k) {
                if (p_217423_1_.field_70175_ag && this.func_217354_b(p_217423_1_.field_70176_ah, p_217423_1_.field_70164_aj)) {
                    this.func_212866_a_(p_217423_1_.field_70176_ah, p_217423_1_.field_70164_aj).func_76608_a(p_217423_1_, p_217423_1_.field_70162_ai);
                }
                if (!p_217423_1_.func_233577_ch_() && !this.func_217354_b(i, k)) {
                    if (p_217423_1_.field_70175_ag) {
                        field_195596_d.warn("Entity {} left loaded chunk area", (Object)p_217423_1_);
                    }
                    p_217423_1_.field_70175_ag = false;
                } else {
                    this.func_212866_a_(i, k).func_76612_a(p_217423_1_);
                }
            }
            this.func_217381_Z().func_76319_b();
        }
    }

    public void func_217409_a(Chunk p_217409_1_) {
        this.field_147483_b.addAll(p_217409_1_.func_177434_r().values());
        this.field_239129_E_.func_212863_j_().func_215571_a(p_217409_1_.func_76632_l(), false);
    }

    public void func_228323_e_(int p_228323_1_, int p_228323_2_) {
        this.field_228315_B_.forEach((p_228316_2_, p_228316_3_) -> p_228316_3_.func_228070_a_(p_228323_1_, p_228323_2_));
    }

    public void func_228327_h_() {
        this.field_228315_B_.forEach((p_228320_0_, p_228320_1_) -> p_228320_1_.func_228069_a_());
    }

    public boolean func_217354_b(int p_217354_1_, int p_217354_2_) {
        return true;
    }

    public int func_217425_f() {
        return this.field_217429_b.size();
    }

    public void func_217408_a(int p_217408_1_, AbstractClientPlayerEntity p_217408_2_) {
        this.func_217424_b(p_217408_1_, p_217408_2_);
        this.field_217431_w.add(p_217408_2_);
    }

    public void func_217411_a(int p_217411_1_, Entity p_217411_2_) {
        this.func_217424_b(p_217411_1_, p_217411_2_);
    }

    private void func_217424_b(int p_217424_1_, Entity p_217424_2_) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(p_217424_2_, (World)this))) {
            return;
        }
        this.func_217413_d(p_217424_1_);
        this.field_217429_b.put(p_217424_1_, (Object)p_217424_2_);
        this.func_72863_F().func_212849_a_(MathHelper.func_76128_c((double)(p_217424_2_.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(p_217424_2_.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true).func_76612_a(p_217424_2_);
        p_217424_2_.onAddedToWorld();
    }

    public void func_217413_d(int p_217413_1_) {
        Entity entity = (Entity)((Object)this.field_217429_b.remove(p_217413_1_));
        if (entity != null) {
            entity.func_70106_y();
            this.func_217414_d(entity);
        }
    }

    private void func_217414_d(Entity p_217414_1_) {
        p_217414_1_.func_213319_R();
        if (p_217414_1_.field_70175_ag) {
            this.func_212866_a_(p_217414_1_.field_70176_ah, p_217414_1_.field_70164_aj).func_76622_b(p_217414_1_);
        }
        this.field_217431_w.remove((Object)p_217414_1_);
        p_217414_1_.onRemovedFromWorld();
        MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveWorldEvent(p_217414_1_, (World)this));
    }

    public void func_217417_b(Chunk p_217417_1_) {
        for (Int2ObjectMap.Entry entry : this.field_217429_b.int2ObjectEntrySet()) {
            Entity entity = (Entity)((Object)entry.getValue());
            int i = MathHelper.func_76128_c((double)(entity.func_226277_ct_() / 16.0));
            int j = MathHelper.func_76128_c((double)(entity.func_226281_cx_() / 16.0));
            if (i != p_217417_1_.func_76632_l().field_77276_a || j != p_217417_1_.func_76632_l().field_77275_b) continue;
            p_217417_1_.func_76612_a(entity);
        }
    }

    @Override
    @Nullable
    public Entity func_73045_a(int p_73045_1_) {
        return (Entity)((Object)this.field_217429_b.get(p_73045_1_));
    }

    public void func_195597_b(BlockPos p_195597_1_, BlockState p_195597_2_) {
        this.func_180501_a(p_195597_1_, p_195597_2_, 19);
    }

    @Override
    public void func_72882_A() {
        this.field_73035_a.func_147298_b().func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.quitting"));
    }

    public void func_73029_E(int p_73029_1_, int p_73029_2_, int p_73029_3_) {
        int i = 32;
        Random random = new Random();
        boolean flag = false;
        if (this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE) {
            for (ItemStack itemstack : this.field_73037_M.field_71439_g.func_184214_aD()) {
                if (itemstack.func_77973_b() != Blocks.field_180401_cv.func_199767_j()) continue;
                flag = true;
                break;
            }
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int j = 0; j < 667; ++j) {
            this.func_184153_a(p_73029_1_, p_73029_2_, p_73029_3_, 16, random, flag, blockpos$mutable);
            this.func_184153_a(p_73029_1_, p_73029_2_, p_73029_3_, 32, random, flag, blockpos$mutable);
        }
    }

    public void func_184153_a(int p_184153_1_, int p_184153_2_, int p_184153_3_, int p_184153_4_, Random p_184153_5_, boolean p_184153_6_, BlockPos.Mutable p_184153_7_) {
        int i = p_184153_1_ + this.field_73012_v.nextInt(p_184153_4_) - this.field_73012_v.nextInt(p_184153_4_);
        int j = p_184153_2_ + this.field_73012_v.nextInt(p_184153_4_) - this.field_73012_v.nextInt(p_184153_4_);
        int k = p_184153_3_ + this.field_73012_v.nextInt(p_184153_4_) - this.field_73012_v.nextInt(p_184153_4_);
        p_184153_7_.func_181079_c(i, j, k);
        BlockState blockstate = this.func_180495_p((BlockPos)p_184153_7_);
        blockstate.func_177230_c().func_180655_c(blockstate, this, (BlockPos)p_184153_7_, p_184153_5_);
        FluidState fluidstate = this.func_204610_c((BlockPos)p_184153_7_);
        if (!fluidstate.func_206888_e()) {
            fluidstate.func_206881_a(this, (BlockPos)p_184153_7_, p_184153_5_);
            IParticleData iparticledata = fluidstate.func_204521_c();
            if (iparticledata != null && this.field_73012_v.nextInt(10) == 0) {
                boolean flag = blockstate.func_224755_d((IBlockReader)((Object)this), (BlockPos)p_184153_7_, Direction.DOWN);
                BlockPos blockpos = p_184153_7_.func_177977_b();
                this.func_211530_a(blockpos, this.func_180495_p(blockpos), iparticledata, flag);
            }
        }
        if (p_184153_6_ && blockstate.func_203425_a(Blocks.field_180401_cv)) {
            this.func_195594_a((IParticleData)ParticleTypes.field_197610_c, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 0.0, 0.0, 0.0);
        }
        if (!blockstate.func_235785_r_((IBlockReader)((Object)this), (BlockPos)p_184153_7_)) {
            this.func_226691_t_((BlockPos)p_184153_7_).func_235090_t_().ifPresent(p_239135_2_ -> {
                if (p_239135_2_.func_235047_a_(this.field_73012_v)) {
                    this.func_195594_a(p_239135_2_.func_235044_a_(), (double)p_184153_7_.func_177958_n() + this.field_73012_v.nextDouble(), (double)p_184153_7_.func_177956_o() + this.field_73012_v.nextDouble(), (double)p_184153_7_.func_177952_p() + this.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    private void func_211530_a(BlockPos p_211530_1_, BlockState p_211530_2_, IParticleData p_211530_3_, boolean p_211530_4_) {
        if (p_211530_2_.func_204520_s().func_206888_e()) {
            VoxelShape voxelshape = p_211530_2_.func_196952_d((IBlockReader)((Object)this), p_211530_1_);
            double d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            if (d0 < 1.0) {
                if (p_211530_4_) {
                    this.func_211834_a(p_211530_1_.func_177958_n(), p_211530_1_.func_177958_n() + 1, p_211530_1_.func_177952_p(), p_211530_1_.func_177952_p() + 1, (double)(p_211530_1_.func_177956_o() + 1) - 0.05, p_211530_3_);
                }
            } else if (!p_211530_2_.func_235714_a_(BlockTags.field_211923_H)) {
                double d1 = voxelshape.func_197762_b(Direction.Axis.Y);
                if (d1 > 0.0) {
                    this.func_211835_a(p_211530_1_, p_211530_3_, voxelshape, (double)p_211530_1_.func_177956_o() + d1 - 0.05);
                } else {
                    BlockPos blockpos = p_211530_1_.func_177977_b();
                    BlockState blockstate = this.func_180495_p(blockpos);
                    VoxelShape voxelshape1 = blockstate.func_196952_d((IBlockReader)((Object)this), blockpos);
                    double d2 = voxelshape1.func_197758_c(Direction.Axis.Y);
                    if (d2 < 1.0 && blockstate.func_204520_s().func_206888_e()) {
                        this.func_211835_a(p_211530_1_, p_211530_3_, voxelshape, (double)p_211530_1_.func_177956_o() - 0.05);
                    }
                }
            }
        }
    }

    private void func_211835_a(BlockPos p_211835_1_, IParticleData p_211835_2_, VoxelShape p_211835_3_, double p_211835_4_) {
        this.func_211834_a((double)p_211835_1_.func_177958_n() + p_211835_3_.func_197762_b(Direction.Axis.X), (double)p_211835_1_.func_177958_n() + p_211835_3_.func_197758_c(Direction.Axis.X), (double)p_211835_1_.func_177952_p() + p_211835_3_.func_197762_b(Direction.Axis.Z), (double)p_211835_1_.func_177952_p() + p_211835_3_.func_197758_c(Direction.Axis.Z), p_211835_4_, p_211835_2_);
    }

    private void func_211834_a(double p_211834_1_, double p_211834_3_, double p_211834_5_, double p_211834_7_, double p_211834_9_, IParticleData p_211834_11_) {
        this.func_195594_a(p_211834_11_, MathHelper.func_219803_d((double)this.field_73012_v.nextDouble(), (double)p_211834_1_, (double)p_211834_3_), p_211834_9_, MathHelper.func_219803_d((double)this.field_73012_v.nextDouble(), (double)p_211834_5_, (double)p_211834_7_), 0.0, 0.0, 0.0);
    }

    public void func_73022_a() {
        ObjectIterator objectiterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectiterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
            Entity entity = (Entity)((Object)entry.getValue());
            if (!entity.field_70128_L) continue;
            objectiterator.remove();
            this.func_217414_d(entity);
        }
    }

    @Override
    public CrashReportCategory func_72914_a(CrashReport p_72914_1_) {
        CrashReportCategory crashreportcategory = super.func_72914_a(p_72914_1_);
        crashreportcategory.func_189529_a("Server brand", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73037_M.field_71439_g.func_142021_k()));
        crashreportcategory.func_189529_a("Server type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73037_M.func_71401_C() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server"));
        return crashreportcategory;
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_, SoundEvent p_184148_8_, SoundCategory p_184148_9_, float p_184148_10_, float p_184148_11_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)p_184148_1_, (SoundEvent)p_184148_8_, (SoundCategory)p_184148_9_, (float)p_184148_10_, (float)p_184148_11_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_184148_8_ = event.getSound();
        p_184148_9_ = event.getCategory();
        p_184148_10_ = event.getVolume();
        if (p_184148_1_ == this.field_73037_M.field_71439_g) {
            this.func_184134_a(p_184148_2_, p_184148_4_, p_184148_6_, p_184148_8_, p_184148_9_, p_184148_10_, p_184148_11_, false);
        }
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity p_217384_1_, Entity p_217384_2_, SoundEvent p_217384_3_, SoundCategory p_217384_4_, float p_217384_5_, float p_217384_6_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)p_217384_1_, (SoundEvent)p_217384_3_, (SoundCategory)p_217384_4_, (float)p_217384_5_, (float)p_217384_6_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_217384_3_ = event.getSound();
        p_217384_4_ = event.getCategory();
        p_217384_5_ = event.getVolume();
        if (p_217384_1_ == this.field_73037_M.field_71439_g) {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)new EntityTickableSound(p_217384_3_, p_217384_4_, p_217384_2_));
        }
    }

    public void func_184156_a(BlockPos p_184156_1_, SoundEvent p_184156_2_, SoundCategory p_184156_3_, float p_184156_4_, float p_184156_5_, boolean p_184156_6_) {
        this.func_184134_a((double)p_184156_1_.func_177958_n() + 0.5, (double)p_184156_1_.func_177956_o() + 0.5, (double)p_184156_1_.func_177952_p() + 0.5, p_184156_2_, p_184156_3_, p_184156_4_, p_184156_5_, p_184156_6_);
    }

    @Override
    public void func_184134_a(double p_184134_1_, double p_184134_3_, double p_184134_5_, SoundEvent p_184134_7_, SoundCategory p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        double d0 = this.field_73037_M.field_71460_t.func_215316_n().func_216785_c().func_186679_c(p_184134_1_, p_184134_3_, p_184134_5_);
        SimpleSound simplesound = new SimpleSound(p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_, p_184134_1_, p_184134_3_, p_184134_5_);
        if (p_184134_11_ && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.field_73037_M.func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)simplesound);
        }
    }

    @Override
    public void func_92088_a(double p_92088_1_, double p_92088_3_, double p_92088_5_, double p_92088_7_, double p_92088_9_, double p_92088_11_, @Nullable CompoundNBT p_92088_13_) {
        this.field_73037_M.field_71452_i.func_78873_a((Particle)new FireworkParticle.Starter(this, p_92088_1_, p_92088_3_, p_92088_5_, p_92088_7_, p_92088_9_, p_92088_11_, this.field_73037_M.field_71452_i, p_92088_13_));
    }

    @Override
    public void func_184135_a(IPacket<?> p_184135_1_) {
        this.field_73035_a.func_147297_a(p_184135_1_);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73035_a.func_199526_e();
    }

    public void func_96443_a(Scoreboard p_96443_1_) {
        this.field_200261_M = p_96443_1_;
    }

    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public ClientChunkProvider func_72863_F() {
        return this.field_239129_E_;
    }

    @Override
    @Nullable
    public MapData func_217406_a(String p_217406_1_) {
        return this.field_217432_z.get(p_217406_1_);
    }

    @Override
    public void func_217399_a(MapData p_217399_1_) {
        this.field_217432_z.put(p_217399_1_.func_195925_e(), p_217399_1_);
    }

    @Override
    public int func_217395_y() {
        return 0;
    }

    @Override
    public Scoreboard func_96441_U() {
        return this.field_200261_M;
    }

    @Override
    public ITagCollectionSupplier func_205772_D() {
        return this.field_73035_a.func_199724_l();
    }

    public DynamicRegistries func_241828_r() {
        return this.field_73035_a.func_239165_n_();
    }

    @Override
    public void func_184138_a(BlockPos p_184138_1_, BlockState p_184138_2_, BlockState p_184138_3_, int p_184138_4_) {
        this.field_217430_d.func_184376_a((IBlockReader)((Object)this), p_184138_1_, p_184138_2_, p_184138_3_, p_184138_4_);
    }

    @Override
    public void func_225319_b(BlockPos p_225319_1_, BlockState p_225319_2_, BlockState p_225319_3_) {
        this.field_217430_d.func_224746_a(p_225319_1_, p_225319_2_, p_225319_3_);
    }

    public void func_217427_b(int p_217427_1_, int p_217427_2_, int p_217427_3_) {
        this.field_217430_d.func_215321_a(p_217427_1_, p_217427_2_, p_217427_3_);
    }

    @Override
    public void func_175715_c(int p_175715_1_, BlockPos p_175715_2_, int p_175715_3_) {
        this.field_217430_d.func_180441_b(p_175715_1_, p_175715_2_, p_175715_3_);
    }

    @Override
    public void func_175669_a(int p_175669_1_, BlockPos p_175669_2_, int p_175669_3_) {
        this.field_217430_d.func_180440_a(p_175669_1_, p_175669_2_, p_175669_3_);
    }

    public void func_217378_a(@Nullable PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
        try {
            this.field_217430_d.func_180439_a(p_217378_1_, p_217378_2_, p_217378_3_, p_217378_4_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Level event being played");
            crashreportcategory.func_71507_a("Block coordinates", CrashReportCategory.func_180522_a(p_217378_3_));
            crashreportcategory.func_71507_a("Event source", (Object)p_217378_1_);
            crashreportcategory.func_71507_a("Event type", p_217378_2_);
            crashreportcategory.func_71507_a("Event data", p_217378_4_);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void func_195594_a(IParticleData p_195594_1_, double p_195594_2_, double p_195594_4_, double p_195594_6_, double p_195594_8_, double p_195594_10_, double p_195594_12_) {
        this.field_217430_d.func_195461_a(p_195594_1_, p_195594_1_.func_197554_b().func_197575_f(), p_195594_2_, p_195594_4_, p_195594_6_, p_195594_8_, p_195594_10_, p_195594_12_);
    }

    @Override
    public void func_195590_a(IParticleData p_195590_1_, boolean p_195590_2_, double p_195590_3_, double p_195590_5_, double p_195590_7_, double p_195590_9_, double p_195590_11_, double p_195590_13_) {
        this.field_217430_d.func_195461_a(p_195590_1_, p_195590_1_.func_197554_b().func_197575_f() || p_195590_2_, p_195590_3_, p_195590_5_, p_195590_7_, p_195590_9_, p_195590_11_, p_195590_13_);
    }

    @Override
    public void func_195589_b(IParticleData p_195589_1_, double p_195589_2_, double p_195589_4_, double p_195589_6_, double p_195589_8_, double p_195589_10_, double p_195589_12_) {
        this.field_217430_d.func_195462_a(p_195589_1_, false, true, p_195589_2_, p_195589_4_, p_195589_6_, p_195589_8_, p_195589_10_, p_195589_12_);
    }

    @Override
    public void func_217404_b(IParticleData p_217404_1_, boolean p_217404_2_, double p_217404_3_, double p_217404_5_, double p_217404_7_, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        this.field_217430_d.func_195462_a(p_217404_1_, p_217404_1_.func_197554_b().func_197575_f() || p_217404_2_, true, p_217404_3_, p_217404_5_, p_217404_7_, p_217404_9_, p_217404_11_, p_217404_13_);
    }

    public List<AbstractClientPlayerEntity> func_217369_A() {
        return this.field_217431_w;
    }

    public Biome func_225604_a_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return (Biome)((Object)this.func_241828_r().func_243612_b(Registry.field_239720_u_).func_243576_d(Biomes.field_76772_c));
    }

    public float func_228326_g_(float p_228326_1_) {
        float f = this.func_242415_f(p_228326_1_);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72867_j(p_228326_1_) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72819_i(p_228326_1_) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    public Vector3d func_228318_a_(BlockPos p_228318_1_, float p_228318_2_) {
        float f9;
        float f = this.func_242415_f(p_228318_2_);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        Biome biome = this.func_226691_t_(p_228318_1_);
        int i = biome.func_225529_c_();
        float f2 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(i & 0xFF) / 255.0f;
        f2 *= f1;
        f3 *= f1;
        f4 *= f1;
        float f5 = this.func_72867_j(p_228318_2_);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.75f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = this.func_72819_i(p_228318_2_)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.75f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (this.field_228314_A_ > 0) {
            float f11 = (float)this.field_228314_A_ - p_228318_2_;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + 1.0f * f11;
        }
        return new Vector3d(f2, f3, f4);
    }

    public Vector3d func_228328_h_(float p_228328_1_) {
        float f = this.func_242415_f(p_228328_1_);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = this.func_72867_j(p_228328_1_);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.95f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = this.func_72819_i(p_228328_1_);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.95f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vector3d(f2, f3, f4);
    }

    public float func_228330_j_(float p_228330_1_) {
        float f = this.func_242415_f(p_228330_1_);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public int func_228332_n_() {
        return this.field_228314_A_;
    }

    @Override
    public void func_225605_c_(int p_225605_1_) {
        this.field_228314_A_ = p_225605_1_;
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        boolean flag = this.func_239132_a_().func_239217_c_();
        if (!p_230487_2_) {
            return flag ? 0.9f : 1.0f;
        }
        switch (p_230487_1_) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public int func_225525_a_(BlockPos p_225525_1_, ColorResolver p_225525_2_) {
        ColorCache colorcache = (ColorCache)this.field_228315_B_.get((Object)p_225525_2_);
        return colorcache.func_228071_a_(p_225525_1_, () -> this.func_228321_b_(p_225525_1_, p_225525_2_));
    }

    public int func_228321_b_(BlockPos p_228321_1_, ColorResolver p_228321_2_) {
        int i = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        if (i == 0) {
            return p_228321_2_.getColor(this.func_226691_t_(p_228321_1_), (double)p_228321_1_.func_177958_n(), (double)p_228321_1_.func_177952_p());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(p_228321_1_.func_177958_n() - i, p_228321_1_.func_177956_o(), p_228321_1_.func_177952_p() - i, p_228321_1_.func_177958_n() + i, p_228321_1_.func_177956_o(), p_228321_1_.func_177952_p() + i);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        while (cubecoordinateiterator.func_218301_a()) {
            blockpos$mutable.func_181079_c(cubecoordinateiterator.func_218304_b(), cubecoordinateiterator.func_218302_c(), cubecoordinateiterator.func_218303_d());
            int j1 = p_228321_2_.getColor(this.func_226691_t_((BlockPos)blockpos$mutable), (double)blockpos$mutable.func_177958_n(), (double)blockpos$mutable.func_177952_p());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public BlockPos func_239140_u_() {
        BlockPos blockpos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockpos)) {
            blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_230316_a_(), 0.0, this.func_175723_af().func_230317_b_()));
        }
        return blockpos;
    }

    public float func_243489_v() {
        return this.field_72986_A.func_241860_d();
    }

    public void func_239136_a_(BlockPos p_239136_1_, float p_239136_2_) {
        this.field_72986_A.func_176143_a(p_239136_1_, p_239136_2_);
    }

    public String toString() {
        return "ClientLevel";
    }

    public ClientWorldInfo func_72912_H() {
        return this.field_239130_d_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientWorldInfo
    implements ISpawnWorldInfo {
        private final boolean field_239144_a_;
        private final GameRules field_239145_b_;
        private final boolean field_239146_c_;
        private int field_239147_d_;
        private int field_239148_e_;
        private int field_239149_f_;
        private float field_243490_g;
        private long field_239150_g_;
        private long field_239151_h_;
        private boolean field_239152_i_;
        private Difficulty field_239153_j_;
        private boolean field_239154_k_;

        public ClientWorldInfo(Difficulty p_i232338_1_, boolean p_i232338_2_, boolean p_i232338_3_) {
            this.field_239153_j_ = p_i232338_1_;
            this.field_239144_a_ = p_i232338_2_;
            this.field_239146_c_ = p_i232338_3_;
            this.field_239145_b_ = new GameRules();
        }

        public int func_76079_c() {
            return this.field_239147_d_;
        }

        public int func_76075_d() {
            return this.field_239148_e_;
        }

        public int func_76074_e() {
            return this.field_239149_f_;
        }

        public float func_241860_d() {
            return this.field_243490_g;
        }

        public long func_82573_f() {
            return this.field_239150_g_;
        }

        public long func_76073_f() {
            return this.field_239151_h_;
        }

        public void func_76058_a(int p_76058_1_) {
            this.field_239147_d_ = p_76058_1_;
        }

        public void func_76056_b(int p_76056_1_) {
            this.field_239148_e_ = p_76056_1_;
        }

        public void func_76087_c(int p_76087_1_) {
            this.field_239149_f_ = p_76087_1_;
        }

        public void func_241859_a(float p_241859_1_) {
            this.field_243490_g = p_241859_1_;
        }

        public void func_239155_a_(long p_239155_1_) {
            this.field_239150_g_ = p_239155_1_;
        }

        public void func_239158_b_(long p_239158_1_) {
            this.field_239151_h_ = p_239158_1_;
        }

        public void func_176143_a(BlockPos p_176143_1_, float p_176143_2_) {
            this.field_239147_d_ = p_176143_1_.func_177958_n();
            this.field_239148_e_ = p_176143_1_.func_177956_o();
            this.field_239149_f_ = p_176143_1_.func_177952_p();
            this.field_243490_g = p_176143_2_;
        }

        public boolean func_76061_m() {
            return false;
        }

        public boolean func_76059_o() {
            return this.field_239152_i_;
        }

        public void func_76084_b(boolean p_76084_1_) {
            this.field_239152_i_ = p_76084_1_;
        }

        public boolean func_76093_s() {
            return this.field_239144_a_;
        }

        public GameRules func_82574_x() {
            return this.field_239145_b_;
        }

        public Difficulty func_176130_y() {
            return this.field_239153_j_;
        }

        public boolean func_176123_z() {
            return this.field_239154_k_;
        }

        public void func_85118_a(CrashReportCategory p_85118_1_) {
            super.func_85118_a(p_85118_1_);
        }

        public void func_239156_a_(Difficulty p_239156_1_) {
            ForgeHooks.onDifficultyChange((Difficulty)p_239156_1_, (Difficulty)this.field_239153_j_);
            this.field_239153_j_ = p_239156_1_;
        }

        public void func_239157_a_(boolean p_239157_1_) {
            this.field_239154_k_ = p_239157_1_;
        }

        public double func_239159_f_() {
            return this.field_239146_c_ ? 0.0 : 63.0;
        }

        public double func_239160_g_() {
            return this.field_239146_c_ ? 1.0 : 0.03125;
        }
    }
}

