/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockItem
extends Item {
    @Deprecated
    private final Block field_150939_a;

    public BlockItem(Block p_i48527_1_, Item.Properties p_i48527_2_) {
        super(p_i48527_2_);
        this.field_150939_a = p_i48527_1_;
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        ActionResultType actionresulttype = this.func_195942_a(new BlockItemUseContext(p_195939_1_));
        return !actionresulttype.func_226246_a_() && this.func_219971_r() ? this.func_77659_a(p_195939_1_.func_195991_k(), p_195939_1_.func_195999_j(), p_195939_1_.func_221531_n()).func_188397_a() : actionresulttype;
    }

    public ActionResultType func_195942_a(BlockItemUseContext p_195942_1_) {
        if (!p_195942_1_.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.func_219984_b(p_195942_1_);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = this.func_195945_b(blockitemusecontext);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.func_195941_b(blockitemusecontext, blockstate)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity playerentity = blockitemusecontext.func_195999_j();
        ItemStack itemstack = blockitemusecontext.func_195996_i();
        BlockState blockstate1 = world.func_180495_p(blockpos);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            blockstate1 = this.func_219985_a(blockpos, world, itemstack, blockstate1);
            this.func_195943_a(blockpos, world, playerentity, itemstack, blockstate1);
            block.func_180633_a(world, blockpos, blockstate1, playerentity, itemstack);
            if (playerentity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((IWorldReader)((Object)world), blockpos, p_195942_1_.func_195999_j());
        world.func_184133_a(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, p_195942_1_.func_195999_j()), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (playerentity == null || !playerentity.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    @Deprecated
    protected SoundEvent func_219983_a(BlockState p_219983_1_) {
        return p_219983_1_.func_215695_r().func_185841_e();
    }

    protected SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)((Object)world), pos, entity).func_185841_e();
    }

    @Nullable
    public BlockItemUseContext func_219984_b(BlockItemUseContext p_219984_1_) {
        return p_219984_1_;
    }

    protected boolean func_195943_a(BlockPos p_195943_1_, World p_195943_2_, @Nullable PlayerEntity p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        return BlockItem.func_179224_a(p_195943_2_, p_195943_3_, p_195943_1_, p_195943_4_);
    }

    @Nullable
    protected BlockState func_195945_b(BlockItemUseContext p_195945_1_) {
        BlockState blockstate = this.func_179223_d().func_196258_a(p_195945_1_);
        return blockstate != null && this.func_195944_a(p_195945_1_, blockstate) ? blockstate : null;
    }

    private BlockState func_219985_a(BlockPos p_219985_1_, World p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundNBT compoundnbt = p_219985_3_.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer<Block, BlockState> statecontainer = p_219985_4_.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                blockstate = BlockItem.func_219988_a(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.func_180501_a(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState func_219988_a(BlockState p_219988_0_, Property<T> p_219988_1_, String p_219988_2_) {
        return p_219988_1_.func_185929_b(p_219988_2_).map(p_219986_2_ -> (BlockState)((Object)((Object)p_219988_0_.func_206870_a(p_219988_1_, (Comparable)p_219986_2_)))).orElse(p_219988_0_);
    }

    protected boolean func_195944_a(BlockItemUseContext p_195944_1_, BlockState p_195944_2_) {
        PlayerEntity playerentity = p_195944_1_.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(playerentity);
        return (!this.func_219987_d() || p_195944_2_.func_196955_c((IWorldReader)((Object)p_195944_1_.func_195991_k()), p_195944_1_.func_195995_a())) && p_195944_1_.func_195991_k().func_226663_a_(p_195944_2_, p_195944_1_.func_195995_a(), iselectioncontext);
    }

    protected boolean func_219987_d() {
        return true;
    }

    protected boolean func_195941_b(BlockItemUseContext p_195941_1_, BlockState p_195941_2_) {
        return p_195941_1_.func_195991_k().func_180501_a(p_195941_1_.func_195995_a(), p_195941_2_, 11);
    }

    public static boolean func_179224_a(World p_179224_0_, @Nullable PlayerEntity p_179224_1_, BlockPos p_179224_2_, ItemStack p_179224_3_) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = p_179224_0_.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        CompoundNBT compoundnbt = p_179224_3_.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && (tileentity = p_179224_0_.func_175625_s(p_179224_2_)) != null) {
            if (!(p_179224_0_.field_72995_K || !tileentity.func_183000_F() || p_179224_1_ != null && p_179224_1_.func_195070_dx())) {
                return false;
            }
            CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
            CompoundNBT compoundnbt2 = compoundnbt1.func_74737_b();
            compoundnbt1.func_197643_a(compoundnbt);
            compoundnbt1.func_74768_a("x", p_179224_2_.func_177958_n());
            compoundnbt1.func_74768_a("y", p_179224_2_.func_177956_o());
            compoundnbt1.func_74768_a("z", p_179224_2_.func_177952_p());
            if (!compoundnbt1.equals(compoundnbt2)) {
                tileentity.func_230337_a_(p_179224_0_.func_180495_p(p_179224_2_), compoundnbt1);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public String func_77658_a() {
        return this.func_179223_d().func_149739_a();
    }

    @Override
    public void func_150895_a(ItemGroup p_150895_1_, NonNullList<ItemStack> p_150895_2_) {
        if (this.func_194125_a(p_150895_1_)) {
            this.func_179223_d().func_149666_a(p_150895_1_, p_150895_2_);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> p_77624_3_, ITooltipFlag p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        this.func_179223_d().func_190948_a(p_77624_1_, (IBlockReader)((Object)p_77624_2_), p_77624_3_, p_77624_4_);
    }

    public Block func_179223_d() {
        return this.getBlockRaw() == null ? null : (Block)((Object)this.getBlockRaw().delegate.get());
    }

    private Block getBlockRaw() {
        return this.field_150939_a;
    }

    public void func_195946_a(Map<Block, Item> p_195946_1_, Item p_195946_2_) {
        p_195946_1_.put(this.func_179223_d(), p_195946_2_);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove((Object)this.func_179223_d());
    }
}

