/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractHorseEntity
extends AnimalEntity
implements IInventoryChangedListener,
IJumpingMount,
IEquipable {
    private static final Predicate<LivingEntity> field_110276_bu = p_213617_0_ -> p_213617_0_ instanceof AbstractHorseEntity && ((AbstractHorseEntity)((Object)((Object)p_213617_0_))).func_110205_ce();
    private static final EntityPredicate field_213618_bK = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221011_b().func_221014_c().func_221012_a(field_110276_bu);
    private static final Ingredient field_234235_bE_ = Ingredient.func_199804_a(Items.field_151015_O, Items.field_151102_aT, Blocks.field_150407_cf.func_199767_j(), Items.field_151034_e, Items.field_151150_bK, Items.field_151153_ao, Items.field_196100_at);
    private static final DataParameter<Byte> field_184787_bE = EntityDataManager.func_187226_a(AbstractHorseEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> field_184790_bH = EntityDataManager.func_187226_a(AbstractHorseEntity.class, DataSerializers.field_187203_m);
    private int field_190689_bJ;
    private int field_110290_bE;
    private int field_110295_bF;
    public int field_110278_bp;
    public int field_110279_bq;
    protected boolean field_110275_br;
    protected Inventory field_110296_bG;
    protected int field_110274_bs;
    protected float field_110277_bt;
    private boolean field_110294_bI;
    private float field_110283_bJ;
    private float field_110284_bK;
    private float field_110281_bL;
    private float field_110282_bM;
    private float field_110287_bN;
    private float field_110288_bO;
    protected boolean field_190688_bE = true;
    protected int field_110285_bP;
    private LazyOptional<?> itemHandler = null;

    protected AbstractHorseEntity(EntityType<? extends AbstractHorseEntity> p_i48563_1_, World p_i48563_2_) {
        super(p_i48563_1_, p_i48563_2_);
        this.field_70138_W = 1.0f;
        this.func_110226_cD();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.func_205714_dM();
    }

    protected void func_205714_dM() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184787_bE, (byte)0);
        this.field_70180_af.func_187214_a(field_184790_bH, Optional.empty());
    }

    protected boolean func_110233_w(int p_110233_1_) {
        return (this.field_70180_af.func_187225_a(field_184787_bE) & p_110233_1_) != 0;
    }

    protected void func_110208_b(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184787_bE);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(b0 | p_110208_1_));
        } else {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(b0 & ~p_110208_1_));
        }
    }

    public boolean func_110248_bS() {
        return this.func_110233_w(2);
    }

    @Nullable
    public UUID func_184780_dh() {
        return this.field_70180_af.func_187225_a(field_184790_bH).orElse(null);
    }

    public void func_184779_b(@Nullable UUID p_184779_1_) {
        this.field_70180_af.func_187227_b(field_184790_bH, Optional.ofNullable(p_184779_1_));
    }

    public boolean func_110246_bZ() {
        return this.field_110275_br;
    }

    public void func_110234_j(boolean p_110234_1_) {
        this.func_110208_b(2, p_110234_1_);
    }

    public void func_110255_k(boolean p_110255_1_) {
        this.field_110275_br = p_110255_1_;
    }

    protected void func_142017_o(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.func_110204_cc()) {
            this.func_110227_p(false);
        }
    }

    public boolean func_110204_cc() {
        return this.func_110233_w(16);
    }

    public boolean func_110209_cd() {
        return this.func_110233_w(32);
    }

    public boolean func_110205_ce() {
        return this.func_110233_w(8);
    }

    public void func_110242_l(boolean p_110242_1_) {
        this.func_110208_b(8, p_110242_1_);
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_() && this.func_110248_bS();
    }

    public void func_230266_a_(@Nullable SoundCategory p_230266_1_) {
        this.field_110296_bG.func_70299_a(0, new ItemStack(Items.field_151141_av));
        if (p_230266_1_ != null) {
            this.field_70170_p.func_217384_a(null, (Entity)((Object)this), SoundEvents.field_187726_cu, p_230266_1_, 0.5f, 1.0f);
        }
    }

    public boolean func_110257_ck() {
        return this.func_110233_w(4);
    }

    public int func_110252_cg() {
        return this.field_110274_bs;
    }

    public void func_110238_s(int p_110238_1_) {
        this.field_110274_bs = p_110238_1_;
    }

    public int func_110198_t(int p_110198_1_) {
        int i = MathHelper.func_76125_a((int)(this.func_110252_cg() + p_110198_1_), (int)0, (int)this.func_190676_dC());
        this.func_110238_s(i);
        return i;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void func_110266_cB() {
        SoundEvent soundevent;
        this.func_110249_cI();
        if (!this.func_174814_R() && (soundevent = this.func_230274_fe_()) != null) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundevent, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        int i;
        if (p_225503_1_ > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = this.func_225508_e_(p_225503_1_, p_225503_2_)) <= 0) {
            return false;
        }
        this.func_70097_a(DamageSource.field_76379_h, i);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, i);
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        return MathHelper.func_76123_f((float)((p_225508_1_ * 0.5f - 3.0f) * p_225508_2_));
    }

    protected int func_190686_di() {
        return 2;
    }

    protected void func_110226_cD() {
        Inventory inventory = this.field_110296_bG;
        this.field_110296_bG = new Inventory(this.func_190686_di());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.field_110296_bG.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.field_110296_bG.func_110134_a((IInventoryChangedListener)this);
        this.func_230275_fc_();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.field_110296_bG));
    }

    protected void func_230275_fc_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110208_b(4, !this.field_110296_bG.func_70301_a(0).func_190926_b());
        }
    }

    public void func_76316_a(IInventory p_76316_1_) {
        boolean flag = this.func_110257_ck();
        this.func_230275_fc_();
        if (this.field_70173_aa > 20 && !flag && this.func_110257_ck()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    public double func_110215_cj() {
        return this.func_233637_b_(Attributes.field_233830_m_);
    }

    @Nullable
    protected SoundEvent func_230274_fe_() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_110220_cK();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.func_110220_cK();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184785_dv() {
        this.func_110220_cK();
        return null;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        if (!p_180429_2_.func_185904_a().func_76224_d()) {
            BlockState blockstate = this.field_70170_p.func_180495_p(p_180429_1_.func_177984_a());
            SoundType soundtype = p_180429_2_.getSoundType((IWorldReader)((Object)this.field_70170_p), p_180429_1_, (Entity)((Object)this));
            if (blockstate.func_203425_a(Blocks.field_150433_aE)) {
                soundtype = blockstate.getSoundType((IWorldReader)((Object)this.field_70170_p), p_180429_1_, (Entity)((Object)this));
            }
            if (this.func_184207_aI() && this.field_190688_bE) {
                ++this.field_110285_bP;
                if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                    this.func_190680_a(soundtype);
                } else if (this.field_110285_bP <= 5) {
                    this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187714_cq, p_190680_1_.func_185843_a() * 0.15f, p_190680_1_.func_185847_b());
    }

    public static AttributeModifierMap.MutableAttribute func_234237_fg_() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233830_m_).func_233815_a_(Attributes.field_233818_a_, 53.0).func_233815_a_(Attributes.field_233821_d_, 0.225f);
    }

    public int func_70641_bl() {
        return 6;
    }

    public int func_190676_dC() {
        return 100;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    @Override
    public int func_70627_aG() {
        return 400;
    }

    public void func_110199_f(PlayerEntity p_110199_1_) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w(p_110199_1_)) && this.func_110248_bS()) {
            p_110199_1_.func_184826_a(this, (IInventory)this.field_110296_bG);
        }
    }

    public ActionResultType func_241395_b_(PlayerEntity p_241395_1_, ItemStack p_241395_2_) {
        boolean flag = this.func_190678_b(p_241395_1_, p_241395_2_);
        if (!p_241395_1_.field_71075_bZ.field_75098_d) {
            p_241395_2_.func_190918_g(1);
        }
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        return flag ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    protected boolean func_190678_b(PlayerEntity p_190678_1_, ItemStack p_190678_2_) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = p_190678_2_.func_77973_b();
        if (item == Items.field_151015_O) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (item == Items.field_151150_bK) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (!this.field_70170_p.field_72995_K && this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(p_190678_1_);
            }
        } else if (item == Items.field_151153_ao || item == Items.field_196100_at) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (!this.field_70170_p.field_72995_K && this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(p_190678_1_);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(j);
            }
        }
        if (flag) {
            this.func_110266_cB();
        }
        return flag;
    }

    protected void func_110237_h(PlayerEntity p_110237_1_) {
        this.func_110227_p(false);
        this.func_110219_q(false);
        if (!this.field_70170_p.field_72995_K) {
            p_110237_1_.field_70177_z = this.field_70177_z;
            p_110237_1_.field_70125_A = this.field_70125_A;
            p_110237_1_.func_184220_m((Entity)((Object)this));
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.func_110257_ck() || this.func_110204_cc() || this.func_110209_cd();
    }

    @Override
    public boolean func_70877_b(ItemStack p_70877_1_) {
        return field_234235_bE_.test(p_70877_1_);
    }

    private void func_110210_cH() {
        this.field_110278_bp = 1;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.field_110296_bG != null) {
            for (int i = 0; i < this.field_110296_bG.func_70302_i_(); ++i) {
                ItemStack itemstack = this.field_110296_bG.func_70301_a(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c(itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.func_190684_dE()) {
                if (!this.func_110204_cc() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_196658_i)) {
                    this.func_110227_p(true);
                }
                if (this.func_110204_cc() && ++this.field_190689_bJ > 50) {
                    this.field_190689_bJ = 0;
                    this.func_110227_p(false);
                }
            }
            this.func_190679_dD();
        }
    }

    protected void func_190679_dD() {
        LivingEntity livingentity;
        if (this.func_110205_ce() && this.func_70631_g_() && !this.func_110204_cc() && (livingentity = this.field_70170_p.func_217360_a(AbstractHorseEntity.class, field_213618_bK, (LivingEntity)((Object)this), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_174813_aQ().func_186662_g(16.0))) != null && this.func_70068_e(livingentity) > 4.0) {
            this.field_70699_by.func_75494_a(livingentity, 0);
        }
    }

    public boolean func_190684_dE() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_110290_bE > 0 && ++this.field_110290_bE > 30) {
            this.field_110290_bE = 0;
            this.func_110208_b(64, false);
        }
        if ((this.func_184186_bw() || this.func_70613_aW()) && this.field_110295_bF > 0 && ++this.field_110295_bF > 20) {
            this.field_110295_bF = 0;
            this.func_110219_q(false);
        }
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.field_110284_bK = this.field_110283_bJ;
        if (this.func_110204_cc()) {
            this.field_110283_bJ += (1.0f - this.field_110283_bJ) * 0.4f + 0.05f;
            if (this.field_110283_bJ > 1.0f) {
                this.field_110283_bJ = 1.0f;
            }
        } else {
            this.field_110283_bJ += (0.0f - this.field_110283_bJ) * 0.4f - 0.05f;
            if (this.field_110283_bJ < 0.0f) {
                this.field_110283_bJ = 0.0f;
            }
        }
        this.field_110282_bM = this.field_110281_bL;
        if (this.func_110209_cd()) {
            this.field_110284_bK = this.field_110283_bJ = 0.0f;
            this.field_110281_bL += (1.0f - this.field_110281_bL) * 0.4f + 0.05f;
            if (this.field_110281_bL > 1.0f) {
                this.field_110281_bL = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.field_110281_bL += (0.8f * this.field_110281_bL * this.field_110281_bL * this.field_110281_bL - this.field_110281_bL) * 0.6f - 0.05f;
            if (this.field_110281_bL < 0.0f) {
                this.field_110281_bL = 0.0f;
            }
        }
        this.field_110288_bO = this.field_110287_bN;
        if (this.func_110233_w(64)) {
            this.field_110287_bN += (1.0f - this.field_110287_bN) * 0.7f + 0.05f;
            if (this.field_110287_bN > 1.0f) {
                this.field_110287_bN = 1.0f;
            }
        } else {
            this.field_110287_bN += (0.0f - this.field_110287_bN) * 0.7f - 0.05f;
            if (this.field_110287_bN < 0.0f) {
                this.field_110287_bN = 0.0f;
            }
        }
    }

    private void func_110249_cI() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_110290_bE = 1;
            this.func_110208_b(64, true);
        }
    }

    public void func_110227_p(boolean p_110227_1_) {
        this.func_110208_b(16, p_110227_1_);
    }

    public void func_110219_q(boolean p_110219_1_) {
        if (p_110219_1_) {
            this.func_110227_p(false);
        }
        this.func_110208_b(32, p_110219_1_);
    }

    private void func_110220_cK() {
        if (this.func_184186_bw() || this.func_70613_aW()) {
            this.field_110295_bF = 1;
            this.func_110219_q(true);
        }
    }

    public void func_190687_dF() {
        if (!this.func_110209_cd()) {
            this.func_110220_cK();
            SoundEvent soundevent = this.func_184785_dv();
            if (soundevent != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public boolean func_110263_g(PlayerEntity p_110263_1_) {
        this.func_184779_b(p_110263_1_.func_110124_au());
        this.func_110234_j(true);
        if (p_110263_1_ instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)p_110263_1_, (AnimalEntity)this);
        }
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)7);
        return true;
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.field_110285_bP = 0;
                }
                if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.field_110294_bI) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                    double d0 = this.func_110215_cj() * (double)this.field_110277_bt * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vector3d vector3d = this.func_213322_ci();
                    this.func_213293_j(vector3d.field_72450_a, d1, vector3d.field_72449_c);
                    this.func_110255_k(true);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)((Object)this));
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c(-0.4f * f2 * this.field_110277_bt, 0.0, 0.4f * f3 * this.field_110277_bt));
                    }
                    this.field_110277_bt = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                    super.func_213352_e(new Vector3d(f, p_213352_1_.field_72448_b, f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.field_110277_bt = 0.0f;
                    this.func_110255_k(false);
                }
                this.func_233629_a_((LivingEntity)((Object)this), false);
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(p_213352_1_);
            }
        }
    }

    protected void func_205715_ee() {
        this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("EatingHaystack", this.func_110204_cc());
        p_213281_1_.func_74757_a("Bred", this.func_110205_ce());
        p_213281_1_.func_74768_a("Temper", this.func_110252_cg());
        p_213281_1_.func_74757_a("Tame", this.func_110248_bS());
        if (this.func_184780_dh() != null) {
            p_213281_1_.func_186854_a("Owner", this.func_184780_dh());
        }
        if (!this.field_110296_bG.func_70301_a(0).func_190926_b()) {
            p_213281_1_.func_218657_a("SaddleItem", this.field_110296_bG.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        ItemStack itemstack;
        UUID uuid;
        super.func_70037_a(p_70037_1_);
        this.func_110227_p(p_70037_1_.func_74767_n("EatingHaystack"));
        this.func_110242_l(p_70037_1_.func_74767_n("Bred"));
        this.func_110238_s(p_70037_1_.func_74762_e("Temper"));
        this.func_110234_j(p_70037_1_.func_74767_n("Tame"));
        if (p_70037_1_.func_186855_b("Owner")) {
            uuid = p_70037_1_.func_186857_a("Owner");
        } else {
            String s = p_70037_1_.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            this.func_184779_b(uuid);
        }
        if (p_70037_1_.func_150297_b("SaddleItem", 10) && (itemstack = ItemStack.func_199557_a(p_70037_1_.func_74775_l("SaddleItem"))).func_77973_b() == Items.field_151141_av) {
            this.field_110296_bG.func_70299_a(0, itemstack);
        }
        this.func_230275_fc_();
    }

    @Override
    public boolean func_70878_b(AnimalEntity p_70878_1_) {
        return false;
    }

    protected boolean func_110200_cJ() {
        return !this.func_184207_aI() && !this.func_184218_aH() && this.func_110248_bS() && !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    protected void func_190681_a(AgeableEntity p_190681_1_, AbstractHorseEntity p_190681_2_) {
        double d0 = this.func_233638_c_(Attributes.field_233818_a_) + p_190681_1_.func_233638_c_(Attributes.field_233818_a_) + (double)this.func_110267_cL();
        p_190681_2_.func_110148_a(Attributes.field_233818_a_).func_111128_a(d0 / 3.0);
        double d1 = this.func_233638_c_(Attributes.field_233830_m_) + p_190681_1_.func_233638_c_(Attributes.field_233830_m_) + this.func_110245_cM();
        p_190681_2_.func_110148_a(Attributes.field_233830_m_).func_111128_a(d1 / 3.0);
        double d2 = this.func_233638_c_(Attributes.field_233821_d_) + p_190681_1_.func_233638_c_(Attributes.field_233821_d_) + this.func_110203_cN();
        p_190681_2_.func_110148_a(Attributes.field_233821_d_).func_111128_a(d2 / 3.0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_110258_o(float p_110258_1_) {
        return MathHelper.func_219799_g((float)p_110258_1_, (float)this.field_110284_bK, (float)this.field_110283_bJ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_110223_p(float p_110223_1_) {
        return MathHelper.func_219799_g((float)p_110223_1_, (float)this.field_110282_bM, (float)this.field_110281_bL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_110201_q(float p_110201_1_) {
        return MathHelper.func_219799_g((float)p_110201_1_, (float)this.field_110288_bO, (float)this.field_110287_bN);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int p_110206_1_) {
        if (this.func_110257_ck()) {
            if (p_110206_1_ < 0) {
                p_110206_1_ = 0;
            } else {
                this.field_110294_bI = true;
                this.func_110220_cK();
            }
            this.field_110277_bt = p_110206_1_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_110206_1_ / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return this.func_110257_ck();
    }

    public void func_184775_b(int p_184775_1_) {
        this.field_110294_bI = true;
        this.func_110220_cK();
        this.func_205715_ee();
    }

    public void func_184777_r_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_110216_r(boolean p_110216_1_) {
        BasicParticleType iparticledata = p_110216_1_ ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 7) {
            this.func_110216_r(true);
        } else if (p_70103_1_ == 6) {
            this.func_110216_r(false);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void func_184232_k(Entity p_184232_1_) {
        super.func_184232_k(p_184232_1_);
        if (p_184232_1_ instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)p_184232_1_;
            this.field_70761_aq = mobentity.field_70761_aq;
        }
        if (this.field_110282_bM > 0.0f) {
            float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.field_110282_bM;
            float f2 = 0.15f * this.field_110282_bM;
            p_184232_1_.func_70107_b(this.func_226277_ct_() + (double)(f1 * f3), this.func_226278_cu_() + this.func_70042_X() + p_184232_1_.func_70033_W() + (double)f2, this.func_226281_cx_() - (double)(f1 * f));
            if (p_184232_1_ instanceof LivingEntity) {
                ((LivingEntity)p_184232_1_).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    protected float func_110267_cL() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    protected double func_110245_cM() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    protected double func_110203_cN() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * 0.95f;
    }

    public boolean func_230276_fq_() {
        return false;
    }

    public boolean func_230277_fr_() {
        return !this.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
    }

    public boolean func_190682_f(ItemStack p_190682_1_) {
        return false;
    }

    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        int i = p_174820_1_ - 400;
        if (i >= 0 && i < 2 && i < this.field_110296_bG.func_70302_i_()) {
            if (i == 0 && p_174820_2_.func_77973_b() != Items.field_151141_av) {
                return false;
            }
            if (i != 1 || this.func_230276_fq_() && this.func_190682_f(p_174820_2_)) {
                this.field_110296_bG.func_70299_a(i, p_174820_2_);
                this.func_230275_fc_();
                return true;
            }
            return false;
        }
        int j = p_174820_1_ - 500 + 2;
        if (j >= 2 && j < this.field_110296_bG.func_70302_i_()) {
            this.field_110296_bG.func_70299_a(j, p_174820_2_);
            return true;
        }
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)((Object)this.func_184188_bt().get(0));
    }

    @Nullable
    private Vector3d func_234236_a_(Vector3d p_234236_1_, LivingEntity p_234236_2_) {
        double d0 = this.func_226277_ct_() + p_234236_1_.field_72450_a;
        double d1 = this.func_174813_aQ().field_72338_b;
        double d2 = this.func_226281_cx_() + p_234236_1_.field_72449_c;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (Pose pose : p_234236_2_.func_230297_ef_()) {
            blockpos$mutable.func_189532_c(d0, d1, d2);
            double d3 = this.func_174813_aQ().field_72337_e + 0.75;
            do {
                Vector3d vector3d;
                AxisAlignedBB axisalignedbb;
                double d4 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                if ((double)blockpos$mutable.func_177956_o() + d4 > d3) continue block0;
                if (TransportationHelper.func_234630_a_((double)d4) && TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)p_234236_2_, (AxisAlignedBB)(axisalignedbb = p_234236_2_.func_233648_f_(pose)).func_191194_a(vector3d = new Vector3d(d0, (double)blockpos$mutable.func_177956_o() + d4, d2)))) {
                    p_234236_2_.func_213301_b(pose);
                    return vector3d;
                }
                blockpos$mutable.func_189536_c(Direction.UP);
            } while ((double)blockpos$mutable.func_177956_o() < d3);
        }
        return null;
    }

    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        Vector3d vector3d = AbstractHorseEntity.func_233559_a_((double)this.func_213311_cf(), (double)p_230268_1_.func_213311_cf(), (float)(this.field_70177_z + (p_230268_1_.func_184591_cq() == HandSide.RIGHT ? 90.0f : -90.0f)));
        Vector3d vector3d1 = this.func_234236_a_(vector3d, p_230268_1_);
        if (vector3d1 != null) {
            return vector3d1;
        }
        Vector3d vector3d2 = AbstractHorseEntity.func_233559_a_((double)this.func_213311_cf(), (double)p_230268_1_.func_213311_cf(), (float)(this.field_70177_z + (p_230268_1_.func_184591_cq() == HandSide.LEFT ? 90.0f : -90.0f)));
        Vector3d vector3d3 = this.func_234236_a_(vector3d2, p_230268_1_);
        return vector3d3 != null ? vector3d3 : this.func_213303_ch();
    }

    protected void func_230273_eI_() {
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        if (p_213386_4_ == null) {
            p_213386_4_ = new AgeableEntity.AgeableData(0.2f);
        }
        this.func_230273_eI_();
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }
}

