/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeTextureAtlasSprite;

@OnlyIn(value=Dist.CLIENT)
public class TextureAtlasSprite
implements AutoCloseable,
IForgeTextureAtlasSprite {
    private final AtlasTexture field_229225_b_;
    private final Info field_229226_c_;
    private final AnimationMetadataSection field_110982_k;
    protected final NativeImage[] field_195670_c;
    private final int[] field_195671_d;
    private final int[] field_195672_e;
    @Nullable
    private final InterpolationData field_229227_g_;
    private final int field_110975_c;
    private final int field_110974_d;
    private final float field_110979_l;
    private final float field_110980_m;
    private final float field_110977_n;
    private final float field_110978_o;
    private int field_110973_g;
    private int field_110983_h;

    protected TextureAtlasSprite(AtlasTexture p_i226049_1_, Info p_i226049_2_, int p_i226049_3_, int p_i226049_4_, int p_i226049_5_, int p_i226049_6_, int p_i226049_7_, NativeImage p_i226049_8_) {
        this.field_229225_b_ = p_i226049_1_;
        AnimationMetadataSection animationmetadatasection = p_i226049_2_.field_229247_d_;
        int i = p_i226049_2_.field_229245_b_;
        int j = p_i226049_2_.field_229246_c_;
        this.field_110975_c = p_i226049_6_;
        this.field_110974_d = p_i226049_7_;
        this.field_110979_l = (float)p_i226049_6_ / (float)p_i226049_4_;
        this.field_110980_m = (float)(p_i226049_6_ + i) / (float)p_i226049_4_;
        this.field_110977_n = (float)p_i226049_7_ / (float)p_i226049_5_;
        this.field_110978_o = (float)(p_i226049_7_ + j) / (float)p_i226049_5_;
        int k = p_i226049_8_.func_195702_a() / animationmetadatasection.func_229302_b_(i);
        int l = p_i226049_8_.func_195714_b() / animationmetadatasection.func_229301_a_(j);
        if (animationmetadatasection.func_110473_c() > 0) {
            int i1 = (Integer)animationmetadatasection.func_130073_e().stream().max(Integer::compareTo).get() + 1;
            this.field_195671_d = new int[i1];
            this.field_195672_e = new int[i1];
            Arrays.fill(this.field_195671_d, -1);
            Arrays.fill(this.field_195672_e, -1);
            Iterator iterator = animationmetadatasection.func_130073_e().iterator();
            while (iterator.hasNext()) {
                int l1;
                int j1 = (Integer)iterator.next();
                if (j1 >= k * l) {
                    throw new RuntimeException("invalid frameindex " + j1);
                }
                int k1 = j1 / k;
                this.field_195671_d[j1] = l1 = j1 % k;
                this.field_195672_e[j1] = k1;
            }
        } else {
            ArrayList list = Lists.newArrayList();
            int i2 = k * l;
            this.field_195671_d = new int[i2];
            this.field_195672_e = new int[i2];
            for (int j2 = 0; j2 < l; ++j2) {
                int k2 = 0;
                while (k2 < k) {
                    int l2 = j2 * k + k2;
                    this.field_195671_d[l2] = k2++;
                    this.field_195672_e[l2] = j2;
                    list.add(new AnimationFrame(l2, -1));
                }
            }
            animationmetadatasection = new AnimationMetadataSection((List)list, i, j, animationmetadatasection.func_110469_d(), animationmetadatasection.func_177219_e());
        }
        this.field_229226_c_ = new Info(p_i226049_2_.field_229244_a_, i, j, animationmetadatasection);
        this.field_110982_k = animationmetadatasection;
        try {
            try {
                this.field_195670_c = MipmapGenerator.func_229173_a_((NativeImage)p_i226049_8_, (int)p_i226049_3_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport1 = CrashReport.func_85055_a(throwable, "Generating mipmaps for frame");
                CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Frame being iterated");
                crashreportcategory1.func_189529_a("First frame", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                    StringBuilder stringbuilder = new StringBuilder();
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(p_i226049_8_.func_195702_a()).append("x").append(p_i226049_8_.func_195714_b());
                    return stringbuilder.toString();
                }));
                throw new ReportedException(crashreport1);
            }
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
            crashreportcategory.func_189529_a("Sprite name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_195668_m().toString()));
            crashreportcategory.func_189529_a("Sprite size", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_94211_a() + " x " + this.func_94216_b()));
            crashreportcategory.func_189529_a("Sprite frames", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.func_110970_k() + " frames"));
            crashreportcategory.func_71507_a("Mipmap levels", p_i226049_3_);
            throw new ReportedException(crashreport);
        }
        this.field_229227_g_ = animationmetadatasection.func_177219_e() ? new InterpolationData(p_i226049_2_, p_i226049_3_) : null;
    }

    private void func_195659_d(int p_195659_1_) {
        int i = this.field_195671_d[p_195659_1_] * this.field_229226_c_.field_229245_b_;
        int j = this.field_195672_e[p_195659_1_] * this.field_229226_c_.field_229246_c_;
        this.func_195667_a(i, j, this.field_195670_c);
    }

    private void func_195667_a(int p_195667_1_, int p_195667_2_, NativeImage[] p_195667_3_) {
        for (int i = 0; i < this.field_195670_c.length && this.field_229226_c_.field_229245_b_ >> i > 0 && this.field_229226_c_.field_229246_c_ >> i > 0; ++i) {
            p_195667_3_[i].func_227788_a_(i, this.field_110975_c >> i, this.field_110974_d >> i, p_195667_1_ >> i, p_195667_2_ >> i, this.field_229226_c_.field_229245_b_ >> i, this.field_229226_c_.field_229246_c_ >> i, this.field_195670_c.length > 1, false);
        }
    }

    public int func_94211_a() {
        return this.field_229226_c_.field_229245_b_;
    }

    public int func_94216_b() {
        return this.field_229226_c_.field_229246_c_;
    }

    public float func_94209_e() {
        return this.field_110979_l;
    }

    public float func_94212_f() {
        return this.field_110980_m;
    }

    public float func_94214_a(double p_94214_1_) {
        float f = this.field_110980_m - this.field_110979_l;
        return this.field_110979_l + f * (float)p_94214_1_ / 16.0f;
    }

    public float func_94206_g() {
        return this.field_110977_n;
    }

    public float func_94210_h() {
        return this.field_110978_o;
    }

    public float func_94207_b(double p_94207_1_) {
        float f = this.field_110978_o - this.field_110977_n;
        return this.field_110977_n + f * (float)p_94207_1_ / 16.0f;
    }

    public ResourceLocation func_195668_m() {
        return this.field_229226_c_.field_229244_a_;
    }

    public AtlasTexture func_229241_m_() {
        return this.field_229225_b_;
    }

    public int func_110970_k() {
        return this.field_195671_d.length;
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.field_195670_c) {
            if (nativeimage == null) continue;
            nativeimage.close();
        }
        if (this.field_229227_g_ != null) {
            this.field_229227_g_.close();
        }
    }

    public String toString() {
        int i = this.field_195671_d.length;
        return "TextureAtlasSprite{name='" + this.field_229226_c_.field_229244_a_ + '\'' + ", frameCount=" + i + ", x=" + this.field_110975_c + ", y=" + this.field_110974_d + ", height=" + this.field_229226_c_.field_229246_c_ + ", width=" + this.field_229226_c_.field_229245_b_ + ", u0=" + this.field_110979_l + ", u1=" + this.field_110980_m + ", v0=" + this.field_110977_n + ", v1=" + this.field_110978_o + '}';
    }

    public boolean func_195662_a(int p_195662_1_, int p_195662_2_, int p_195662_3_) {
        return (this.field_195670_c[0].func_195709_a(p_195662_2_ + this.field_195671_d[p_195662_1_] * this.field_229226_c_.field_229245_b_, p_195662_3_ + this.field_195672_e[p_195662_1_] * this.field_229226_c_.field_229246_c_) >> 24 & 0xFF) == 0;
    }

    public void func_195663_q() {
        this.func_195659_d(0);
    }

    private float func_229228_a_() {
        float f = (float)this.field_229226_c_.field_229245_b_ / (this.field_110980_m - this.field_110979_l);
        float f1 = (float)this.field_229226_c_.field_229246_c_ / (this.field_110978_o - this.field_110977_n);
        return Math.max(f1, f);
    }

    public float func_229242_p_() {
        return 4.0f / this.func_229228_a_();
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int i = this.field_110982_k.func_110468_c(this.field_110973_g);
            int j = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j;
            this.field_110983_h = 0;
            int k = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (i != k && k >= 0 && k < this.func_110970_k()) {
                this.func_195659_d(k);
            }
        } else if (this.field_229227_g_ != null) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.field_229227_g_.func_229257_a_());
            } else {
                this.field_229227_g_.func_229257_a_();
            }
        }
    }

    public boolean func_130098_m() {
        return this.field_110982_k.func_110473_c() > 1;
    }

    public IVertexBuilder func_229230_a_(IVertexBuilder p_229230_1_) {
        return new SpriteAwareVertexBuilder(p_229230_1_, this);
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        return this.field_195670_c[0].func_195709_a(x + this.field_195671_d[frameIndex] * this.func_94211_a(), y + this.field_195672_e[frameIndex] * this.func_94216_b());
    }

    @OnlyIn(value=Dist.CLIENT)
    final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] field_229256_b_;

        private InterpolationData(Info p_i226051_2_, int p_i226051_3_) {
            this.field_229256_b_ = new NativeImage[p_i226051_3_ + 1];
            for (int i = 0; i < this.field_229256_b_.length; ++i) {
                int j = p_i226051_2_.field_229245_b_ >> i;
                int k = p_i226051_2_.field_229246_c_ >> i;
                if (this.field_229256_b_[i] != null) continue;
                this.field_229256_b_[i] = new NativeImage(j, k, false);
            }
        }

        private void func_229257_a_() {
            double d0 = 1.0 - (double)TextureAtlasSprite.this.field_110983_h / (double)TextureAtlasSprite.this.field_110982_k.func_110472_a(TextureAtlasSprite.this.field_110973_g);
            int i = TextureAtlasSprite.this.field_110982_k.func_110468_c(TextureAtlasSprite.this.field_110973_g);
            int j = TextureAtlasSprite.this.field_110982_k.func_110473_c() == 0 ? TextureAtlasSprite.this.func_110970_k() : TextureAtlasSprite.this.field_110982_k.func_110473_c();
            int k = TextureAtlasSprite.this.field_110982_k.func_110468_c((TextureAtlasSprite.this.field_110973_g + 1) % j);
            if (i != k && k >= 0 && k < TextureAtlasSprite.this.func_110970_k()) {
                for (int l = 0; l < this.field_229256_b_.length; ++l) {
                    int i1 = TextureAtlasSprite.this.field_229226_c_.field_229245_b_ >> l;
                    int j1 = TextureAtlasSprite.this.field_229226_c_.field_229246_c_ >> l;
                    for (int k1 = 0; k1 < j1; ++k1) {
                        for (int l1 = 0; l1 < i1; ++l1) {
                            int i2 = this.func_229259_a_(i, l, l1, k1);
                            int j2 = this.func_229259_a_(k, l, l1, k1);
                            int k2 = this.func_229258_a_(d0, i2 >> 16 & 0xFF, j2 >> 16 & 0xFF);
                            int l2 = this.func_229258_a_(d0, i2 >> 8 & 0xFF, j2 >> 8 & 0xFF);
                            int i3 = this.func_229258_a_(d0, i2 & 0xFF, j2 & 0xFF);
                            this.field_229256_b_[l].func_195700_a(l1, k1, i2 & 0xFF000000 | k2 << 16 | l2 << 8 | i3);
                        }
                    }
                }
                TextureAtlasSprite.this.func_195667_a(0, 0, this.field_229256_b_);
            }
        }

        private int func_229259_a_(int p_229259_1_, int p_229259_2_, int p_229259_3_, int p_229259_4_) {
            return TextureAtlasSprite.this.field_195670_c[p_229259_2_].func_195709_a(p_229259_3_ + (TextureAtlasSprite.this.field_195671_d[p_229259_1_] * TextureAtlasSprite.this.field_229226_c_.field_229245_b_ >> p_229259_2_), p_229259_4_ + (TextureAtlasSprite.this.field_195672_e[p_229259_1_] * TextureAtlasSprite.this.field_229226_c_.field_229246_c_ >> p_229259_2_));
        }

        private int func_229258_a_(double p_229258_1_, int p_229258_3_, int p_229258_4_) {
            return (int)(p_229258_1_ * (double)p_229258_3_ + (1.0 - p_229258_1_) * (double)p_229258_4_);
        }

        @Override
        public void close() {
            for (NativeImage nativeimage : this.field_229256_b_) {
                if (nativeimage == null) continue;
                nativeimage.close();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Info {
        private final ResourceLocation field_229244_a_;
        private final int field_229245_b_;
        private final int field_229246_c_;
        private final AnimationMetadataSection field_229247_d_;

        public Info(ResourceLocation p_i226050_1_, int p_i226050_2_, int p_i226050_3_, AnimationMetadataSection p_i226050_4_) {
            this.field_229244_a_ = p_i226050_1_;
            this.field_229245_b_ = p_i226050_2_;
            this.field_229246_c_ = p_i226050_3_;
            this.field_229247_d_ = p_i226050_4_;
        }

        public ResourceLocation func_229248_a_() {
            return this.field_229244_a_;
        }

        public int func_229250_b_() {
            return this.field_229245_b_;
        }

        public int func_229252_c_() {
            return this.field_229246_c_;
        }
    }
}

