/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.eventbus.api.Event;

public class StructureSpawnListGatherEvent
extends Event {
    private final Structure<?> structure;
    private final Map<EntityClassification, List<MobSpawnInfo.Spawners>> entitySpawns = new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>();
    private final Map<EntityClassification, List<MobSpawnInfo.Spawners>> entitySpawnsUnmodifiableLists = new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>();
    private final Map<EntityClassification, List<MobSpawnInfo.Spawners>> entitySpawnsUnmodifiable = Collections.unmodifiableMap(this.entitySpawnsUnmodifiableLists);
    private boolean insideOnly;

    public StructureSpawnListGatherEvent(Structure<?> structure) {
        this.structure = structure;
        this.insideOnly = this.structure.getDefaultRestrictsSpawnsToInside();
        this.addEntitySpawns(EntityClassification.MONSTER, this.structure.getDefaultSpawnList());
        this.addEntitySpawns(EntityClassification.CREATURE, this.structure.getDefaultCreatureSpawnList());
    }

    public Structure<?> getStructure() {
        return this.structure;
    }

    public void setInsideOnly(boolean insideOnly) {
        this.insideOnly = insideOnly;
    }

    public boolean isInsideOnly() {
        return this.insideOnly;
    }

    public List<MobSpawnInfo.Spawners> getEntitySpawns(EntityClassification classification) {
        return this.entitySpawnsUnmodifiableLists.getOrDefault(classification, Collections.emptyList());
    }

    private List<MobSpawnInfo.Spawners> getOrCreateEntitySpawns(EntityClassification classification) {
        return this.entitySpawns.computeIfAbsent(classification, c -> {
            ArrayList spawners = new ArrayList();
            this.entitySpawnsUnmodifiableLists.put((EntityClassification)c, Collections.unmodifiableList(spawners));
            return spawners;
        });
    }

    public void addEntitySpawn(EntityClassification classification, MobSpawnInfo.Spawners spawner) {
        this.getOrCreateEntitySpawns(classification).add(spawner);
    }

    public void addEntitySpawns(EntityClassification classification, List<MobSpawnInfo.Spawners> spawners) {
        this.getOrCreateEntitySpawns(classification).addAll(spawners);
    }

    public void removeEntitySpawn(EntityClassification classification, MobSpawnInfo.Spawners spawner) {
        if (this.entitySpawns.containsKey(classification)) {
            this.entitySpawns.get(classification).remove(spawner);
        }
    }

    public Map<EntityClassification, List<MobSpawnInfo.Spawners>> getEntitySpawns() {
        return this.entitySpawnsUnmodifiable;
    }
}

