/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface IForgeItem {
    default public Item getItem() {
        return (Item)this;
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return this.getItem().func_111205_h(slot);
    }

    default public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        return true;
    }

    default public ITextComponent getHighlightTip(ItemStack item, ITextComponent displayName) {
        return displayName;
    }

    default public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    default public boolean isPiglinCurrency(ItemStack stack) {
        return stack.func_77973_b() == PiglinTasks.field_234444_a_;
    }

    default public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_200880_d() == ArmorMaterial.GOLD;
    }

    public boolean isRepairable(ItemStack var1);

    default public float getXpRepairRatio(ItemStack stack) {
        return 2.0f;
    }

    @Nullable
    default public CompoundNBT getShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }

    default public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        stack.func_77982_d(nbt);
    }

    default public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    default public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
    }

    default public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return false;
    }

    default public ItemStack getContainerItem(ItemStack itemStack) {
        if (!this.hasContainerItem(itemStack)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)this.getItem().func_77668_q());
    }

    default public boolean hasContainerItem(ItemStack stack) {
        return this.getItem().func_77634_r();
    }

    default public int getEntityLifespan(ItemStack itemStack, World world) {
        return 6000;
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @Nullable
    default public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return null;
    }

    default public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return false;
    }

    default public Collection<ItemGroup> getCreativeTabs() {
        return Collections.singletonList(this.getItem().func_77640_w());
    }

    default public float getSmeltingExperience(ItemStack item) {
        return -1.0f;
    }

    default public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    default public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
    }

    default public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return MobEntity.func_184640_d((ItemStack)stack) == armorType;
    }

    @Nullable
    default public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return null;
    }

    default public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Nullable
    default public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public FontRenderer getFontRenderer(ItemStack stack) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return null;
    }

    default public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHelmetOverlay(ItemStack stack, PlayerEntity player, int width, int height, float partialTicks) {
    }

    default public int getDamage(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Damage");
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    default public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public int getMaxDamage(ItemStack stack) {
        return this.getItem().func_77612_l();
    }

    default public boolean isDamaged(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    default public void setDamage(ItemStack stack, int damage) {
        stack.func_196082_o().func_74768_a("Damage", Math.max(0, damage));
    }

    default public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.getItem().func_150897_b(state);
    }

    default public int getItemStackLimit(ItemStack stack) {
        return this.getItem().func_77639_j();
    }

    public Set<ToolType> getToolTypes(ItemStack var1);

    public int getHarvestLevel(ItemStack var1, ToolType var2, @Nullable PlayerEntity var3, @Nullable BlockState var4);

    default public int getItemEnchantability(ItemStack stack) {
        return this.getItem().func_77619_b();
    }

    default public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)newStack, (ItemStack)oldStack) || !newStack.func_77984_f() && newStack.func_77952_i() != oldStack.func_77952_i();
    }

    default public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Nullable
    default public String getCreatorModId(ItemStack itemStack) {
        return ForgeHooks.getDefaultCreatorModId(itemStack);
    }

    @Nullable
    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return null;
    }

    default public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this instanceof AxeItem;
    }

    default public boolean isShield(ItemStack stack, @Nullable LivingEntity entity) {
        return stack.func_77973_b() == Items.field_185159_cQ;
    }

    default public int getBurnTime(ItemStack itemStack) {
        return -1;
    }

    default public void onHorseArmorTick(ItemStack stack, World world, MobEntity horse) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStackTileEntityRenderer getItemStackTileEntityRenderer();

    public Set<ResourceLocation> getTags();

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return amount;
    }

    default public boolean isEnderMask(ItemStack stack, PlayerEntity player, EndermanEntity endermanEntity) {
        return stack.func_77973_b() == Blocks.field_196625_cS.func_199767_j();
    }

    default public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return false;
    }

    default public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return false;
    }

    default public boolean isDamageable(ItemStack stack) {
        return this.getItem().func_77645_m();
    }
}

