/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.client.ForgeWorldTypeScreens;
import net.minecraftforge.client.event.ClientPlayerChangeGameModeEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.ReloadRequirements;
import net.minecraftforge.resource.SelectiveReloadStateHandler;
import net.minecraftforge.resource.VanillaResourceType;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    private static final Logger LOGGER = LogManager.getLogger();
    static final ThreadLocal<RenderType> renderLayer = new ThreadLocal();
    public static String forgeStatusLine;
    static int worldRenderPass;
    private static final Matrix4f flipX;
    private static final Matrix3f flipXNormal;
    private static int slotMainHand;

    public static String getArmorTexture(Entity entity, ItemStack armor, String _default, EquipmentSlotType slot, String type) {
        String result = armor.func_77973_b().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static boolean onDrawBlockHighlight(WorldRenderer context, ActiveRenderInfo info, RayTraceResult target, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffers) {
        switch (target.func_216346_c()) {
            case BLOCK: {
                if (!(target instanceof BlockRayTraceResult)) {
                    return false;
                }
                return MinecraftForge.EVENT_BUS.post((Event)new DrawHighlightEvent.HighlightBlock(context, info, target, partialTicks, matrix, buffers));
            }
            case ENTITY: {
                if (!(target instanceof EntityRayTraceResult)) {
                    return false;
                }
                return MinecraftForge.EVENT_BUS.post((Event)new DrawHighlightEvent.HighlightEntity(context, info, target, partialTicks, matrix, buffers));
            }
        }
        return MinecraftForge.EVENT_BUS.post((Event)new DrawHighlightEvent(context, info, target, partialTicks, matrix, buffers));
    }

    public static void dispatchRenderLast(WorldRenderer context, MatrixStack mat, float partialTicks, Matrix4f projectionMatrix, long finishTimeNano) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderWorldLastEvent(context, mat, partialTicks, projectionMatrix, finishTimeNano));
    }

    public static boolean renderSpecificFirstPersonHand(Hand hand, MatrixStack mat, IRenderTypeBuffer buffers, int light, float partialTicks, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderHandEvent(hand, mat, buffers, light, partialTicks, interpPitch, swingProgress, equipProgress, stack));
    }

    public static void onTextureStitchedPre(AtlasTexture map, Set<ResourceLocation> resourceLocations) {
        StartupMessageManager.mcLoaderConsumer().ifPresent(c -> c.accept("Atlas Stitching : " + map.func_229223_g_().toString()));
        ModLoader.get().postEvent(new TextureStitchEvent.Pre(map, resourceLocations));
        Atlases.field_228750_i_.values().stream().filter(rm -> rm.func_229310_a_().equals((Object)map.func_229223_g_())).forEach(rm -> resourceLocations.add(rm.func_229313_b_()));
    }

    public static void onTextureStitchedPost(AtlasTexture map) {
        ModLoader.get().postEvent(new TextureStitchEvent.Post(map));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        ModLoader.get().postEvent(new ColorHandlerEvent.Block(blockColors));
    }

    public static void onItemColorsInit(ItemColors itemColors, BlockColors blockColors) {
        ModLoader.get().postEvent(new ColorHandlerEvent.Item(itemColors, blockColors));
    }

    public static void setRenderLayer(RenderType layer) {
        renderLayer.set(layer);
    }

    public static <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType slot, A _default) {
        BipedModel model = itemStack.func_77973_b().getArmorModel(entityLiving, itemStack, slot, _default);
        return (A)(model == null ? _default : model);
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    public static float getOffsetFOV(PlayerEntity entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post((Event)fovUpdateEvent);
        return fovUpdateEvent.getNewfov();
    }

    public static double getFOVModifier(GameRenderer renderer, ActiveRenderInfo info, double renderPartialTicks, double fov) {
        EntityViewRenderEvent.FOVModifier event = new EntityViewRenderEvent.FOVModifier(renderer, info, renderPartialTicks, fov);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getFOV();
    }

    @Deprecated
    public static void renderMainMenu(MainMenuScreen gui, MatrixStack mStack, FontRenderer font, int width, int height) {
        ForgeHooksClient.renderMainMenu(gui, mStack, font, width, height, -1);
    }

    public static void renderMainMenu(MainMenuScreen gui, MatrixStack mStack, FontRenderer font, int width, int height, int alpha) {
        Object line;
        VersionChecker.Status status = ForgeVersion.getStatus();
        if (status == VersionChecker.Status.BETA || status == VersionChecker.Status.BETA_OUTDATED) {
            line = new TranslationTextComponent("forge.update.beta.1", new Object[]{TextFormatting.RED, TextFormatting.RESET}).func_240699_a_(TextFormatting.RED);
            int n = width / 2;
            font.getClass();
            AbstractGui.func_238472_a_((MatrixStack)mStack, (FontRenderer)font, (ITextComponent)line, (int)n, (int)(4 + 0 * (9 + 1)), (int)(0xFFFFFF | alpha));
            line = new TranslationTextComponent("forge.update.beta.2");
            int n2 = width / 2;
            font.getClass();
            AbstractGui.func_238472_a_((MatrixStack)mStack, (FontRenderer)font, (ITextComponent)line, (int)n2, (int)(4 + 1 * (9 + 1)), (int)(0xFFFFFF | alpha));
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = I18n.func_135052_a((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        forgeStatusLine = line;
    }

    public static ISound playSound(SoundEngine manager, ISound sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getResultSound();
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(Screen screen, MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.DrawScreenEvent.Pre(screen, mStack, mouseX, mouseY, partialTicks))) {
            screen.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.DrawScreenEvent.Post(screen, mStack, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(FogRenderer.FogType type, ActiveRenderInfo info, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(type, info, partial, density);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return event.getDensity();
        }
        return -1.0f;
    }

    public static void onFogRender(FogRenderer.FogType type, ActiveRenderInfo info, float partial, float distance) {
        MinecraftForge.EVENT_BUS.post((Event)new EntityViewRenderEvent.RenderFogEvent(type, info, partial, distance));
    }

    public static EntityViewRenderEvent.CameraSetup onCameraSetup(GameRenderer renderer, ActiveRenderInfo info, float partial) {
        EntityViewRenderEvent.CameraSetup event = new EntityViewRenderEvent.CameraSetup(renderer, info, partial, info.func_216778_f(), info.func_216777_e(), 0.0f);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void onModelBake(ModelManager modelManager, Map<ResourceLocation, IBakedModel> modelRegistry, ModelLoader modelLoader) {
        ModLoader.get().postEvent(new ModelBakeEvent(modelManager, modelRegistry, modelLoader));
        modelLoader.onPostBakeEvent(modelRegistry);
    }

    public static IBakedModel handleCameraTransforms(MatrixStack matrixStack, IBakedModel model, ItemCameraTransforms.TransformType cameraTransformType, boolean leftHandHackery) {
        MatrixStack stack = new MatrixStack();
        model = model.handlePerspective(cameraTransformType, stack);
        if (!stack.func_227867_d_()) {
            Matrix4f tMat = stack.func_227866_c_().func_227870_a_();
            Matrix3f nMat = stack.func_227866_c_().func_227872_b_();
            if (leftHandHackery) {
                tMat.multiplyBackward(flipX);
                tMat.func_226595_a_(flipX);
                nMat.multiplyBackward(flipXNormal);
                nMat.func_226118_b_(flipXNormal);
            }
            matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(tMat);
            matrixStack.func_227866_c_().func_227872_b_().func_226118_b_(nMat);
        }
        return model;
    }

    public static void preDraw(VertexFormatElement.Usage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = (VertexFormatElement)format.func_227894_c_().get(element);
        int count = attr.getElementCount();
        int constant = attr.func_177367_b().func_177397_c();
        ((Buffer)buffer).position(format.getOffset(element));
        switch (attrType) {
            case POSITION: {
                GL20.glVertexPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32884);
                break;
            }
            case NORMAL: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + attr);
                }
                GL20.glNormalPointer((int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32885);
                break;
            }
            case COLOR: {
                GL20.glColorPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32886);
                break;
            }
            case UV: {
                GL13.glClientActiveTexture((int)(33984 + attr.func_177369_e()));
                GL20.glTexCoordPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.func_177369_e());
                GL20.glVertexAttribPointer((int)attr.func_177369_e(), (int)count, (int)constant, (boolean)false, (int)stride, (ByteBuffer)buffer);
                break;
            }
            default: {
                LOGGER.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.func_177384_a());
            }
        }
    }

    public static void postDraw(VertexFormatElement.Usage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = (VertexFormatElement)format.func_227894_c_().get(element);
        switch (attrType) {
            case POSITION: {
                GL20.glDisableClientState((int)32884);
                break;
            }
            case NORMAL: {
                GL20.glDisableClientState((int)32885);
                break;
            }
            case COLOR: {
                GL20.glDisableClientState((int)32886);
                break;
            }
            case UV: {
                GL13.glClientActiveTexture((int)(33984 + attr.func_177369_e()));
                GL20.glDisableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.func_177369_e());
                break;
            }
            default: {
                LOGGER.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.func_177384_a());
            }
        }
    }

    public static int getColorIndex(VertexFormat fmt) {
        ImmutableList elements = fmt.func_227894_c_();
        for (int i = 0; i < elements.size(); ++i) {
            if (((VertexFormatElement)elements.get(i)).func_177375_c() != VertexFormatElement.Usage.COLOR) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("There is no COLOR element in the provided VertexFormat.");
    }

    public static TextureAtlasSprite[] getFluidSprites(IBlockDisplayReader world, BlockPos pos, FluidState fluidStateIn) {
        ResourceLocation overlayTexture = fluidStateIn.func_206886_c().getAttributes().getOverlayTexture();
        return new TextureAtlasSprite[]{(TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStateIn.func_206886_c().getAttributes().getStillTexture(world, pos)), (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluidStateIn.func_206886_c().getAttributes().getFlowingTexture(world, pos)), overlayTexture == null ? null : (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(overlayTexture)};
    }

    public static void gatherFluidTextures(Set<RenderMaterial> textures) {
        ForgeRegistries.FLUIDS.getValues().stream().flatMap(ForgeHooksClient::getFluidMaterials).forEach(textures::add);
    }

    public static Stream<RenderMaterial> getFluidMaterials(Fluid fluid) {
        return fluid.getAttributes().getTextures().filter(Objects::nonNull).map(ForgeHooksClient::getBlockMaterial);
    }

    public static RenderMaterial getBlockMaterial(ResourceLocation loc) {
        return new RenderMaterial(AtlasTexture.field_110575_b, loc);
    }

    public static void fillNormal(int[] faceData, Direction facing) {
        Vector3f v1 = ForgeHooksClient.getVertexPos(faceData, 3);
        Vector3f t1 = ForgeHooksClient.getVertexPos(faceData, 1);
        Vector3f v2 = ForgeHooksClient.getVertexPos(faceData, 2);
        Vector3f t2 = ForgeHooksClient.getVertexPos(faceData, 0);
        v1.func_195897_a(t1);
        v2.func_195897_a(t2);
        v2.func_195896_c(v1);
        v2.func_229194_d_();
        int x = (byte)Math.round(v2.func_195899_a() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.func_195900_b() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.func_195902_c() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 8 + 7] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 8;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static void loadEntityShader(Entity entity, GameRenderer entityRenderer) {
        ResourceLocation shader;
        if (entity != null && (shader = ClientRegistry.getEntityShader(entity.getClass())) != null) {
            entityRenderer.func_175069_a(shader);
        }
    }

    public static boolean shouldCauseReequipAnimation(@Nonnull ItemStack from, @Nonnull ItemStack to, int slot) {
        boolean fromInvalid = from.func_190926_b();
        boolean toInvalid = to.func_190926_b();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.func_77973_b().shouldCauseReequipAnimation(from, to, changed);
    }

    public static RenderGameOverlayEvent.BossInfo bossBarRenderPre(MatrixStack mStack, MainWindow res, ClientBossInfo bossInfo, int x, int y, int increment) {
        RenderGameOverlayEvent.BossInfo evt = new RenderGameOverlayEvent.BossInfo(mStack, new RenderGameOverlayEvent(mStack, Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO, bossInfo, x, y, increment);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void bossBarRenderPost(MatrixStack mStack, MainWindow res) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(mStack, new RenderGameOverlayEvent(mStack, Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO));
    }

    public static ScreenshotEvent onScreenshot(NativeImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void onClientChangeGameMode(NetworkPlayerInfo info, GameType currentGameMode, GameType newGameMode) {
        if (currentGameMode != newGameMode) {
            ClientPlayerChangeGameModeEvent evt = new ClientPlayerChangeGameModeEvent(info, currentGameMode, newGameMode);
            MinecraftForge.EVENT_BUS.post((Event)evt);
        }
    }

    public static IBakedModel handlePerspective(IBakedModel model, ItemCameraTransforms.TransformType type, MatrixStack stack) {
        TransformationMatrix tr = TransformationHelper.toTransformation(model.func_177552_f().func_181688_b(type));
        if (!tr.isIdentity()) {
            tr.push(stack);
        }
        return model;
    }

    public static void onInputUpdate(PlayerEntity player, MovementInput movementInput) {
        MinecraftForge.EVENT_BUS.post((Event)new InputUpdateEvent(player, movementInput));
    }

    public static void refreshResources(Minecraft mc, VanillaResourceType ... types) {
        SelectiveReloadStateHandler.INSTANCE.beginReload(ReloadRequirements.include(types));
        mc.func_213237_g();
        SelectiveReloadStateHandler.INSTANCE.endReload();
    }

    public static boolean onGuiMouseClickedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseClickedEvent.Pre event = new GuiScreenEvent.MouseClickedEvent.Pre(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseClickedPost(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseClickedEvent.Post event = new GuiScreenEvent.MouseClickedEvent.Post(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseReleasedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseReleasedEvent.Pre event = new GuiScreenEvent.MouseReleasedEvent.Pre(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseReleasedPost(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseReleasedEvent.Post event = new GuiScreenEvent.MouseReleasedEvent.Post(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseDragPre(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        GuiScreenEvent.MouseDragEvent.Pre event = new GuiScreenEvent.MouseDragEvent.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseDragPost(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        GuiScreenEvent.MouseDragEvent.Post event = new GuiScreenEvent.MouseDragEvent.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseScrollPre(MouseHelper mouseHelper, Screen guiScreen, double scrollDelta) {
        MainWindow mainWindow = guiScreen.getMinecraft().func_228018_at_();
        double mouseX = mouseHelper.func_198024_e() * (double)mainWindow.func_198107_o() / (double)mainWindow.func_198105_m();
        double mouseY = mouseHelper.func_198026_f() * (double)mainWindow.func_198087_p() / (double)mainWindow.func_198083_n();
        GuiScreenEvent.MouseScrollEvent.Pre event = new GuiScreenEvent.MouseScrollEvent.Pre(guiScreen, mouseX, mouseY, scrollDelta);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseScrollPost(MouseHelper mouseHelper, Screen guiScreen, double scrollDelta) {
        MainWindow mainWindow = guiScreen.getMinecraft().func_228018_at_();
        double mouseX = mouseHelper.func_198024_e() * (double)mainWindow.func_198107_o() / (double)mainWindow.func_198105_m();
        double mouseY = mouseHelper.func_198026_f() * (double)mainWindow.func_198087_p() / (double)mainWindow.func_198083_n();
        GuiScreenEvent.MouseScrollEvent.Post event = new GuiScreenEvent.MouseScrollEvent.Post(guiScreen, mouseX, mouseY, scrollDelta);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyPressedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyPressedEvent.Pre event = new GuiScreenEvent.KeyboardKeyPressedEvent.Pre(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyPressedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyPressedEvent.Post event = new GuiScreenEvent.KeyboardKeyPressedEvent.Post(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyReleasedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event = new GuiScreenEvent.KeyboardKeyReleasedEvent.Pre(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyReleasedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyReleasedEvent.Post event = new GuiScreenEvent.KeyboardKeyReleasedEvent.Post(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiCharTypedPre(Screen guiScreen, char codePoint, int modifiers) {
        GuiScreenEvent.KeyboardCharTypedEvent.Pre event = new GuiScreenEvent.KeyboardCharTypedEvent.Pre(guiScreen, codePoint, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiCharTypedPost(Screen guiScreen, char codePoint, int modifiers) {
        GuiScreenEvent.KeyboardCharTypedEvent.Post event = new GuiScreenEvent.KeyboardCharTypedEvent.Post(guiScreen, codePoint, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void onRecipesUpdated(RecipeManager mgr) {
        RecipesUpdatedEvent event = new RecipesUpdatedEvent(mgr);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void invalidateLog4jThreadCache() {
        if (System.getProperty("java.version").compareTo("1.8.0_102") >= 0) {
            return;
        }
        try {
            Field nameField = ThreadNameCachingStrategy.class.getDeclaredField("THREADLOCAL_NAME");
            Field logEventField = ReusableLogEventFactory.class.getDeclaredField("mutableLogEventThreadLocal");
            nameField.setAccessible(true);
            logEventField.setAccessible(true);
            ((ThreadLocal)nameField.get(null)).set(null);
            ((ThreadLocal)logEventField.get(null)).set(null);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            LOGGER.error("Unable to invalidate log4j thread cache, thread fields in logs may be inaccurate", e);
        }
    }

    public static void fireMouseInput(int button, int action, int mods) {
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.MouseInputEvent(button, action, mods));
    }

    public static void fireKeyInput(int key, int scanCode, int action, int modifiers) {
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent(key, scanCode, action, modifiers));
    }

    public static boolean onMouseScroll(MouseHelper mouseHelper, double scrollDelta) {
        InputEvent.MouseScrollEvent event = new InputEvent.MouseScrollEvent(scrollDelta, mouseHelper.func_198030_b(), mouseHelper.isMiddleDown(), mouseHelper.func_198031_d(), mouseHelper.func_198024_e(), mouseHelper.func_198026_f());
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onRawMouseClicked(int button, int action, int mods) {
        return MinecraftForge.EVENT_BUS.post((Event)new InputEvent.RawMouseEvent(button, action, mods));
    }

    public static InputEvent.ClickInputEvent onClickInput(int button, KeyBinding keyBinding, Hand hand) {
        InputEvent.ClickInputEvent event = new InputEvent.ClickInputEvent(button, keyBinding, hand);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void drawItemLayered(ItemRenderer renderer, IBakedModel modelIn, ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, boolean fabulous) {
        for (Pair layerModel : modelIn.getLayerModels(itemStackIn, fabulous)) {
            IBakedModel layer = (IBakedModel)layerModel.getFirst();
            RenderType rendertype = (RenderType)layerModel.getSecond();
            ForgeHooksClient.setRenderLayer(rendertype);
            IVertexBuilder ivertexbuilder = fabulous ? ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s()) : ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s());
            renderer.func_229114_a_(layer, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    public static boolean isNameplateInRenderDistance(Entity entity, double squareDistance) {
        ModifiableAttributeInstance attribute;
        if (entity instanceof LivingEntity && (attribute = ((LivingEntity)entity).func_110148_a((Attribute)ForgeMod.NAMETAG_DISTANCE.get())) != null) {
            return !(squareDistance > attribute.func_111126_e() * attribute.func_111126_e());
        }
        return !(squareDistance > 4096.0);
    }

    public static void renderPistonMovedBlocks(BlockPos pos, BlockState state, MatrixStack stack, IRenderTypeBuffer buffer, World world, boolean checkSides, int combinedOverlay, BlockRendererDispatcher blockRenderer) {
        RenderType.func_228661_n_().stream().filter(t -> RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)t)).forEach(rendertype -> {
            ForgeHooksClient.setRenderLayer(rendertype);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(rendertype == RenderType.func_228645_f_() ? RenderType.func_239269_g_() : rendertype);
            blockRenderer.func_175019_b().func_228802_a_((IBlockDisplayReader)world, blockRenderer.func_184389_a(state), state, pos, stack, ivertexbuilder, checkSides, new Random(), state.func_209533_a(pos), combinedOverlay);
        });
        ForgeHooksClient.setRenderLayer(null);
    }

    public static void registerForgeWorldTypeScreens() {
        ForgeWorldTypeScreens.registerTypes();
    }

    public static BiomeGeneratorTypeScreens.IFactory getBiomeGeneratorTypeScreenFactory(Optional<BiomeGeneratorTypeScreens> generator, @Nullable BiomeGeneratorTypeScreens.IFactory biomegeneratortypescreens$ifactory) {
        return ForgeWorldTypeScreens.getGeneratorScreenFactory(generator, biomegeneratortypescreens$ifactory);
    }

    public static boolean hasBiomeGeneratorSettingsOptionsScreen(Optional<BiomeGeneratorTypeScreens> generator) {
        return ForgeHooksClient.getBiomeGeneratorTypeScreenFactory(generator, null) != null;
    }

    public static Optional<BiomeGeneratorTypeScreens> getWorldTypeFromGenerator(DimensionGeneratorSettings dimensionGeneratorSettings) {
        return BiomeGeneratorTypeScreens.func_239079_a_((DimensionGeneratorSettings)dimensionGeneratorSettings);
    }

    public static Optional<BiomeGeneratorTypeScreens> getDefaultWorldType() {
        return Optional.of(ForgeWorldTypeScreens.getDefaultGenerator());
    }

    static {
        flipX = Matrix4f.func_226593_a_((float)-1.0f, (float)1.0f, (float)1.0f);
        flipXNormal = new Matrix3f(flipX);
        slotMainHand = 0;
    }
}

