/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.SweepingEnchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    public static int func_77506_a(Enchantment p_77506_0_, ItemStack p_77506_1_) {
        if (p_77506_1_.func_190926_b()) {
            return 0;
        }
        ResourceLocation resourcelocation = Registry.field_212628_q.func_177774_c(p_77506_0_);
        ListNBT listnbt = p_77506_1_.func_77986_q();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            ResourceLocation resourcelocation1 = ResourceLocation.func_208304_a(compoundnbt.func_74779_i("id"));
            if (resourcelocation1 == null || !resourcelocation1.equals(resourcelocation)) continue;
            return MathHelper.func_76125_a((int)compoundnbt.func_74762_e("lvl"), (int)0, (int)255);
        }
        return 0;
    }

    public static Map<Enchantment, Integer> func_82781_a(ItemStack p_82781_0_) {
        ListNBT listnbt = p_82781_0_.func_77973_b() == Items.field_151134_bR ? EnchantedBookItem.func_92110_g((ItemStack)p_82781_0_) : p_82781_0_.func_77986_q();
        return EnchantmentHelper.func_226652_a_(listnbt);
    }

    public static Map<Enchantment, Integer> func_226652_a_(ListNBT p_226652_0_) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < p_226652_0_.size(); ++i) {
            CompoundNBT compoundnbt = p_226652_0_.func_150305_b(i);
            Registry.field_212628_q.func_241873_b(ResourceLocation.func_208304_a(compoundnbt.func_74779_i("id"))).ifPresent(p_226651_2_ -> {
                Integer integer = map.put(p_226651_2_, compoundnbt.func_74762_e("lvl"));
            });
        }
        return map;
    }

    public static void func_82782_a(Map<Enchantment, Integer> p_82782_0_, ItemStack p_82782_1_) {
        ListNBT listnbt = new ListNBT();
        for (Map.Entry<Enchantment, Integer> entry : p_82782_0_.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c(enchantment)));
            compoundnbt.func_74777_a("lvl", (short)i);
            listnbt.add((Object)compoundnbt);
            if (p_82782_1_.func_77973_b() != Items.field_151134_bR) continue;
            EnchantedBookItem.func_92115_a((ItemStack)p_82782_1_, (EnchantmentData)new EnchantmentData(enchantment, i));
        }
        if (listnbt.isEmpty()) {
            p_82782_1_.func_196083_e("Enchantments");
        } else if (p_82782_1_.func_77973_b() != Items.field_151134_bR) {
            p_82782_1_.func_77983_a("Enchantments", (INBT)listnbt);
        }
    }

    private static void func_77518_a(IEnchantmentVisitor p_77518_0_, ItemStack p_77518_1_) {
        if (!p_77518_1_.func_190926_b()) {
            ListNBT listnbt = p_77518_1_.func_77986_q();
            for (int i = 0; i < listnbt.size(); ++i) {
                String s = listnbt.func_150305_b(i).func_74779_i("id");
                int j = listnbt.func_150305_b(i).func_74762_e("lvl");
                Registry.field_212628_q.func_241873_b(ResourceLocation.func_208304_a(s)).ifPresent(p_222184_2_ -> p_77518_0_.accept((Enchantment)((Object)p_222184_2_), j));
            }
        }
    }

    private static void func_77516_a(IEnchantmentVisitor p_77516_0_, Iterable<ItemStack> p_77516_1_) {
        for (ItemStack itemstack : p_77516_1_) {
            EnchantmentHelper.func_77518_a(p_77516_0_, itemstack);
        }
    }

    public static int func_77508_a(Iterable<ItemStack> p_77508_0_, DamageSource p_77508_1_) {
        MutableInt mutableint = new MutableInt();
        EnchantmentHelper.func_77516_a((p_212576_2_, p_212576_3_) -> mutableint.add(p_212576_2_.func_77318_a(p_212576_3_, p_77508_1_)), p_77508_0_);
        return mutableint.intValue();
    }

    public static float func_152377_a(ItemStack p_152377_0_, CreatureAttribute p_152377_1_) {
        MutableFloat mutablefloat = new MutableFloat();
        EnchantmentHelper.func_77518_a((p_212573_2_, p_212573_3_) -> mutablefloat.add(p_212573_2_.func_152376_a(p_212573_3_, p_152377_1_)), p_152377_0_);
        return mutablefloat.floatValue();
    }

    public static float func_191527_a(LivingEntity p_191527_0_) {
        int i = EnchantmentHelper.func_185284_a(Enchantments.field_191530_r, p_191527_0_);
        return i > 0 ? SweepingEnchantment.func_191526_e((int)i) : 0.0f;
    }

    public static void func_151384_a(LivingEntity p_151384_0_, Entity p_151384_1_) {
        IEnchantmentVisitor enchantmenthelper$ienchantmentvisitor = (p_212575_2_, p_212575_3_) -> p_212575_2_.func_151367_b(p_151384_0_, p_151384_1_, p_212575_3_);
        if (p_151384_0_ != null) {
            EnchantmentHelper.func_77516_a(enchantmenthelper$ienchantmentvisitor, p_151384_0_.func_184209_aF());
        }
        if (p_151384_1_ instanceof PlayerEntity) {
            EnchantmentHelper.func_77518_a(enchantmenthelper$ienchantmentvisitor, p_151384_0_.func_184614_ca());
        }
    }

    public static void func_151385_b(LivingEntity p_151385_0_, Entity p_151385_1_) {
        IEnchantmentVisitor enchantmenthelper$ienchantmentvisitor = (p_212574_2_, p_212574_3_) -> p_212574_2_.func_151368_a(p_151385_0_, p_151385_1_, p_212574_3_);
        if (p_151385_0_ != null) {
            EnchantmentHelper.func_77516_a(enchantmenthelper$ienchantmentvisitor, p_151385_0_.func_184209_aF());
        }
        if (p_151385_0_ instanceof PlayerEntity) {
            EnchantmentHelper.func_77518_a(enchantmenthelper$ienchantmentvisitor, p_151385_0_.func_184614_ca());
        }
    }

    public static int func_185284_a(Enchantment p_185284_0_, LivingEntity p_185284_1_) {
        Collection<ItemStack> iterable = p_185284_0_.func_222181_a(p_185284_1_).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.func_77506_a(p_185284_0_, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int func_77501_a(LivingEntity p_77501_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_180313_o, p_77501_0_);
    }

    public static int func_90036_a(LivingEntity p_90036_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_77334_n, p_90036_0_);
    }

    public static int func_185292_c(LivingEntity p_185292_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185298_f, p_185292_0_);
    }

    public static int func_185294_d(LivingEntity p_185294_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185300_i, p_185294_0_);
    }

    public static int func_185293_e(LivingEntity p_185293_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185305_q, p_185293_0_);
    }

    public static int func_191529_b(ItemStack p_191529_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_151370_z, p_191529_0_);
    }

    public static int func_191528_c(ItemStack p_191528_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_151369_A, p_191528_0_);
    }

    public static int func_185283_h(LivingEntity p_185283_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185304_p, p_185283_0_);
    }

    public static boolean func_185287_i(LivingEntity p_185287_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185299_g, p_185287_0_) > 0;
    }

    public static boolean func_189869_j(LivingEntity p_189869_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_185301_j, p_189869_0_) > 0;
    }

    public static boolean func_234846_j_(LivingEntity p_234846_0_) {
        return EnchantmentHelper.func_185284_a(Enchantments.field_234847_l_, p_234846_0_) > 0;
    }

    public static boolean func_190938_b(ItemStack p_190938_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_190941_k, p_190938_0_) > 0;
    }

    public static boolean func_190939_c(ItemStack p_190939_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_190940_C, p_190939_0_) > 0;
    }

    public static int func_203191_f(ItemStack p_203191_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203193_C, p_203191_0_);
    }

    public static int func_203190_g(ItemStack p_203190_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203195_E, p_203190_0_);
    }

    public static boolean func_203192_h(ItemStack p_203192_0_) {
        return EnchantmentHelper.func_77506_a(Enchantments.field_203196_F, p_203192_0_) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlotType, ItemStack> func_222189_b(Enchantment p_222189_0_, LivingEntity p_222189_1_) {
        return EnchantmentHelper.func_234844_a_(p_222189_0_, p_222189_1_, p_234845_0_ -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlotType, ItemStack> func_234844_a_(Enchantment p_234844_0_, LivingEntity p_234844_1_, Predicate<ItemStack> p_234844_2_) {
        Map<EquipmentSlotType, ItemStack> map = p_234844_0_.func_222181_a(p_234844_1_);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EquipmentSlotType, ItemStack> entry : map.entrySet()) {
            ItemStack itemstack = entry.getValue();
            if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a(p_234844_0_, itemstack) <= 0 || !p_234844_2_.test(itemstack)) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(p_234844_1_.func_70681_au().nextInt(list.size()));
    }

    public static int func_77514_a(Random p_77514_0_, int p_77514_1_, int p_77514_2_, ItemStack p_77514_3_) {
        Item item = p_77514_3_.func_77973_b();
        int i = p_77514_3_.getItemEnchantability();
        if (i <= 0) {
            return 0;
        }
        if (p_77514_2_ > 15) {
            p_77514_2_ = 15;
        }
        int j = p_77514_0_.nextInt(8) + 1 + (p_77514_2_ >> 1) + p_77514_0_.nextInt(p_77514_2_ + 1);
        if (p_77514_1_ == 0) {
            return Math.max(j / 3, 1);
        }
        return p_77514_1_ == 1 ? j * 2 / 3 + 1 : Math.max(j, p_77514_2_ * 2);
    }

    public static ItemStack func_77504_a(Random p_77504_0_, ItemStack p_77504_1_, int p_77504_2_, boolean p_77504_3_) {
        boolean flag;
        List<EnchantmentData> list = EnchantmentHelper.func_77513_b(p_77504_0_, p_77504_1_, p_77504_2_, p_77504_3_);
        boolean bl = flag = p_77504_1_.func_77973_b() == Items.field_151122_aG;
        if (flag) {
            p_77504_1_ = new ItemStack(Items.field_151134_bR);
        }
        for (EnchantmentData enchantmentdata : list) {
            if (flag) {
                EnchantedBookItem.func_92115_a((ItemStack)p_77504_1_, (EnchantmentData)enchantmentdata);
                continue;
            }
            p_77504_1_.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
        }
        return p_77504_1_;
    }

    public static List<EnchantmentData> func_77513_b(Random p_77513_0_, ItemStack p_77513_1_, int p_77513_2_, boolean p_77513_3_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_77513_1_.func_77973_b();
        int i = p_77513_1_.getItemEnchantability();
        if (i <= 0) {
            return list;
        }
        p_77513_2_ = p_77513_2_ + 1 + p_77513_0_.nextInt(i / 4 + 1) + p_77513_0_.nextInt(i / 4 + 1);
        float f = (p_77513_0_.nextFloat() + p_77513_0_.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentData> list1 = EnchantmentHelper.func_185291_a(p_77513_2_ = MathHelper.func_76125_a((int)Math.round((float)p_77513_2_ + (float)p_77513_2_ * f), (int)1, (int)Integer.MAX_VALUE), p_77513_1_, p_77513_3_);
        if (!list1.isEmpty()) {
            list.add(WeightedRandom.func_76271_a((Random)p_77513_0_, list1));
            while (p_77513_0_.nextInt(50) <= p_77513_2_) {
                EnchantmentHelper.func_185282_a(list1, (EnchantmentData)Util.func_223378_a(list));
                if (list1.isEmpty()) break;
                list.add(WeightedRandom.func_76271_a((Random)p_77513_0_, list1));
                p_77513_2_ /= 2;
            }
        }
        return list;
    }

    public static void func_185282_a(List<EnchantmentData> p_185282_0_, EnchantmentData p_185282_1_) {
        Iterator<EnchantmentData> iterator = p_185282_0_.iterator();
        while (iterator.hasNext()) {
            if (p_185282_1_.field_76302_b.func_191560_c(iterator.next().field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static boolean func_201840_a(Collection<Enchantment> p_201840_0_, Enchantment p_201840_1_) {
        for (Enchantment enchantment : p_201840_0_) {
            if (enchantment.func_191560_c(p_201840_1_)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentData> func_185291_a(int p_185291_0_, ItemStack p_185291_1_, boolean p_185291_2_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_185291_1_.func_77973_b();
        boolean flag = p_185291_1_.func_77973_b() == Items.field_151122_aG;
        Iterator iterator = Registry.field_212628_q.iterator();
        block0: while (iterator.hasNext()) {
            Enchantment enchantment = (Enchantment)((Object)iterator.next());
            if (enchantment.func_185261_e() && !p_185291_2_ || !enchantment.func_230310_i_() || !enchantment.canApplyAtEnchantingTable(p_185291_1_) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.func_77325_b(); i > enchantment.func_77319_d() - 1; --i) {
                if (p_185291_0_ < enchantment.func_77321_a(i) || p_185291_0_ > enchantment.func_223551_b(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    @FunctionalInterface
    static interface IEnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

