/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import java.util.Map;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.network.ForgeConnectionNetworkFilter;
import net.minecraftforge.network.VanillaConnectionNetworkFilter;
import net.minecraftforge.network.VanillaPacketFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, VanillaPacketFilter> instances = ImmutableMap.of((Object)"forge:vanilla_filter", (Object)((Object)new VanillaConnectionNetworkFilter()), (Object)"forge:forge_fixes", (Object)((Object)new ForgeConnectionNetworkFilter()));

    public static void injectIfNecessary(NetworkManager manager) {
        instances.forEach((key, filter) -> {
            if (filter.isNecessary(manager)) {
                manager.channel().pipeline().addBefore("packet_handler", key, (ChannelHandler)filter);
                LOGGER.debug("Injected {} into {}", (Object)filter, (Object)manager);
            }
        });
    }

    private NetworkFilters() {
    }
}

