/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;

public class ExistingFileHelper {
    private final SimpleReloadableResourceManager clientResources;
    private final SimpleReloadableResourceManager serverData;
    private final boolean enable;
    private final Multimap<ResourcePackType, ResourceLocation> generated = HashMultimap.create();

    @Deprecated
    public ExistingFileHelper(Collection<Path> existingPacks, boolean enable) {
        this(existingPacks, Collections.emptySet(), enable);
    }

    public ExistingFileHelper(Collection<Path> existingPacks, Set<String> existingMods, boolean enable) {
        Object pack;
        this.clientResources = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES);
        this.serverData = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
        this.clientResources.func_199021_a((IResourcePack)new VanillaPack(new String[]{"minecraft", "realms"}));
        this.serverData.func_199021_a((IResourcePack)new VanillaPack(new String[]{"minecraft"}));
        for (Path existing : existingPacks) {
            File file = existing.toFile();
            pack = file.isDirectory() ? new FolderPack(file) : new FilePack(file);
            this.clientResources.func_199021_a((IResourcePack)pack);
            this.serverData.func_199021_a((IResourcePack)pack);
        }
        for (String existingMod : existingMods) {
            ModFileInfo modFileInfo = ModList.get().getModFileById(existingMod);
            if (modFileInfo == null) continue;
            pack = new ModFileResourcePack(modFileInfo.getFile());
            this.clientResources.func_199021_a((IResourcePack)pack);
            this.serverData.func_199021_a((IResourcePack)pack);
        }
        this.enable = enable;
    }

    private IResourceManager getManager(ResourcePackType packType) {
        return packType == ResourcePackType.CLIENT_RESOURCES ? this.clientResources : this.serverData;
    }

    private ResourceLocation getLocation(ResourceLocation base, String suffix, String prefix) {
        return new ResourceLocation(base.func_110624_b(), prefix + "/" + base.func_110623_a() + suffix);
    }

    public boolean exists(ResourceLocation loc, ResourcePackType packType) {
        if (!this.enable) {
            return true;
        }
        return this.generated.get((Object)packType).contains(loc) || this.getManager(packType).func_219533_b(loc);
    }

    public boolean exists(ResourceLocation loc, IResourceType type) {
        return this.exists(this.getLocation(loc, type.getSuffix(), type.getPrefix()), type.getPackType());
    }

    public boolean exists(ResourceLocation loc, ResourcePackType packType, String pathSuffix, String pathPrefix) {
        return this.exists(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    public void trackGenerated(ResourceLocation loc, IResourceType type) {
        this.generated.put((Object)type.getPackType(), (Object)this.getLocation(loc, type.getSuffix(), type.getPrefix()));
    }

    public void trackGenerated(ResourceLocation loc, ResourcePackType packType, String pathSuffix, String pathPrefix) {
        this.generated.put((Object)packType, (Object)this.getLocation(loc, pathSuffix, pathPrefix));
    }

    @VisibleForTesting
    public IResource getResource(ResourceLocation loc, ResourcePackType packType, String pathSuffix, String pathPrefix) throws IOException {
        return this.getResource(this.getLocation(loc, pathSuffix, pathPrefix), packType);
    }

    @VisibleForTesting
    public IResource getResource(ResourceLocation loc, ResourcePackType packType) throws IOException {
        return this.getManager(packType).func_199002_a(loc);
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public static class ResourceType
    implements IResourceType {
        final ResourcePackType packType;
        final String suffix;
        final String prefix;

        public ResourceType(ResourcePackType type, String suffix, String prefix) {
            this.packType = type;
            this.suffix = suffix;
            this.prefix = prefix;
        }

        @Override
        public ResourcePackType getPackType() {
            return this.packType;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }

    public static interface IResourceType {
        public ResourcePackType getPackType();

        public String getSuffix();

        public String getPrefix();
    }
}

