/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IWorldReader
extends IBlockDisplayReader,
ICollisionReader,
BiomeManager.IBiomeReader {
    @Nullable
    public IChunk func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean func_217354_b(int var1, int var2);

    public int func_201676_a(Heightmap.Type var1, int var2, int var3);

    public int func_175657_ab();

    public BiomeManager func_225523_d_();

    default public Biome func_226691_t_(BlockPos p_226691_1_) {
        return this.func_225523_d_().func_226836_a_(p_226691_1_);
    }

    default public Stream<BlockState> func_234939_c_(AxisAlignedBB p_234939_1_) {
        int j1;
        int i = MathHelper.func_76128_c((double)p_234939_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_234939_1_.field_72336_d);
        int k = MathHelper.func_76128_c((double)p_234939_1_.field_72338_b);
        int l = MathHelper.func_76128_c((double)p_234939_1_.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)p_234939_1_.field_72339_c);
        return this.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)p_234939_1_.field_72334_f)) ? this.func_234853_a_(p_234939_1_) : Stream.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int func_225525_a_(BlockPos p_225525_1_, ColorResolver p_225525_2_) {
        return p_225525_2_.getColor(this.func_226691_t_(p_225525_1_), (double)p_225525_1_.func_177958_n(), (double)p_225525_1_.func_177952_p());
    }

    default public Biome func_225526_b_(int p_225526_1_, int p_225526_2_, int p_225526_3_) {
        IChunk ichunk = this.func_217353_a(p_225526_1_ >> 2, p_225526_3_ >> 2, ChunkStatus.field_222608_d, false);
        return ichunk != null && ichunk.func_225549_i_() != null ? ichunk.func_225549_i_().func_225526_b_(p_225526_1_, p_225526_2_, p_225526_3_) : this.func_225604_a_(p_225526_1_, p_225526_2_, p_225526_3_);
    }

    public Biome func_225604_a_(int var1, int var2, int var3);

    public boolean func_201670_d();

    @Deprecated
    public int func_181545_F();

    public DimensionType func_230315_m_();

    default public BlockPos func_205770_a(Heightmap.Type p_205770_1_, BlockPos p_205770_2_) {
        return new BlockPos(p_205770_2_.func_177958_n(), this.func_201676_a(p_205770_1_, p_205770_2_.func_177958_n(), p_205770_2_.func_177952_p()), p_205770_2_.func_177952_p());
    }

    default public boolean func_175623_d(BlockPos p_175623_1_) {
        return this.func_180495_p(p_175623_1_).isAir((IBlockReader)((Object)this), p_175623_1_);
    }

    default public boolean func_175710_j(BlockPos p_175710_1_) {
        if (p_175710_1_.func_177956_o() >= this.func_181545_F()) {
            return this.func_226660_f_(p_175710_1_);
        }
        BlockPos blockpos = new BlockPos(p_175710_1_.func_177958_n(), this.func_181545_F(), p_175710_1_.func_177952_p());
        if (!this.func_226660_f_(blockpos)) {
            return false;
        }
        BlockPos blockpos1 = blockpos.func_177977_b();
        while (blockpos1.func_177956_o() > p_175710_1_.func_177956_o()) {
            BlockState blockstate = this.func_180495_p(blockpos1);
            if (blockstate.func_200016_a((IBlockReader)((Object)this), blockpos1) > 0 && !blockstate.func_185904_a().func_76224_d()) {
                return false;
            }
            blockpos1 = blockpos1.func_177977_b();
        }
        return true;
    }

    @Deprecated
    default public float func_205052_D(BlockPos p_205052_1_) {
        return this.func_230315_m_().func_236021_a_(this.func_201696_r(p_205052_1_));
    }

    default public int func_175627_a(BlockPos p_175627_1_, Direction p_175627_2_) {
        return this.func_180495_p(p_175627_1_).func_185893_b((IBlockReader)((Object)this), p_175627_1_, p_175627_2_);
    }

    default public IChunk func_217349_x(BlockPos p_217349_1_) {
        return this.func_212866_a_(p_217349_1_.func_177958_n() >> 4, p_217349_1_.func_177952_p() >> 4);
    }

    default public IChunk func_212866_a_(int p_212866_1_, int p_212866_2_) {
        return this.func_217353_a(p_212866_1_, p_212866_2_, ChunkStatus.field_222617_m, true);
    }

    default public IChunk func_217348_a(int p_217348_1_, int p_217348_2_, ChunkStatus p_217348_3_) {
        return this.func_217353_a(p_217348_1_, p_217348_2_, p_217348_3_, true);
    }

    @Nullable
    default public IBlockReader func_225522_c_(int p_225522_1_, int p_225522_2_) {
        return this.func_217353_a(p_225522_1_, p_225522_2_, ChunkStatus.field_223226_a_, false);
    }

    default public boolean func_201671_F(BlockPos p_201671_1_) {
        return this.func_204610_c(p_201671_1_).func_206884_a(FluidTags.field_206959_a);
    }

    default public boolean func_72953_d(AxisAlignedBB p_72953_1_) {
        int i = MathHelper.func_76128_c((double)p_72953_1_.field_72340_a);
        int j = MathHelper.func_76143_f((double)p_72953_1_.field_72336_d);
        int k = MathHelper.func_76128_c((double)p_72953_1_.field_72338_b);
        int l = MathHelper.func_76143_f((double)p_72953_1_.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)p_72953_1_.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)p_72953_1_.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockState blockstate = this.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(k1, l1, i2));
                    if (blockstate.func_204520_s().func_206888_e()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int func_201696_r(BlockPos p_201696_1_) {
        return this.func_205049_d(p_201696_1_, this.func_175657_ab());
    }

    default public int func_205049_d(BlockPos p_205049_1_, int p_205049_2_) {
        return p_205049_1_.func_177958_n() >= -30000000 && p_205049_1_.func_177952_p() >= -30000000 && p_205049_1_.func_177958_n() < 30000000 && p_205049_1_.func_177952_p() < 30000000 ? this.func_226659_b_(p_205049_1_, p_205049_2_) : 15;
    }

    @Deprecated
    default public boolean func_175667_e(BlockPos p_175667_1_) {
        return this.func_217354_b(p_175667_1_.func_177958_n() >> 4, p_175667_1_.func_177952_p() >> 4);
    }

    default public boolean isAreaLoaded(BlockPos center, int range) {
        return this.func_175707_a(center.func_177982_a(-range, -range, -range), center.func_177982_a(range, range, range));
    }

    @Deprecated
    default public boolean func_175707_a(BlockPos p_175707_1_, BlockPos p_175707_2_) {
        return this.func_217344_a(p_175707_1_.func_177958_n(), p_175707_1_.func_177956_o(), p_175707_1_.func_177952_p(), p_175707_2_.func_177958_n(), p_175707_2_.func_177956_o(), p_175707_2_.func_177952_p());
    }

    @Deprecated
    default public boolean func_217344_a(int p_217344_1_, int p_217344_2_, int p_217344_3_, int p_217344_4_, int p_217344_5_, int p_217344_6_) {
        if (p_217344_5_ >= 0 && p_217344_2_ < 256) {
            p_217344_3_ >>= 4;
            p_217344_4_ >>= 4;
            p_217344_6_ >>= 4;
            for (int i = p_217344_1_ >>= 4; i <= p_217344_4_; ++i) {
                for (int j = p_217344_3_; j <= p_217344_6_; ++j) {
                    if (this.func_217354_b(i, j)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

