/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class SpiderEntity
extends MonsterEntity {
    private static final DataParameter<Byte> field_184729_a = EntityDataManager.func_187226_a(SpiderEntity.class, DataSerializers.field_187191_a);

    public SpiderEntity(EntityType<? extends SpiderEntity> p_i48550_1_, World p_i48550_2_) {
        super(p_i48550_1_, p_i48550_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)((Object)this), 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new TargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, new TargetGoal<IronGolemEntity>(this, IronGolemEntity.class));
    }

    public double func_70042_X() {
        return this.func_213302_cg() * 0.5f;
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new ClimberPathNavigator((MobEntity)((Object)this), p_175447_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184729_a, (byte)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70839_e(this.field_70123_F);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234305_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.3f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.func_70841_p();
    }

    public void func_213295_a(BlockState p_213295_1_, Vector3d p_213295_2_) {
        if (!p_213295_1_.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(p_213295_1_, p_213295_2_);
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70687_e(EffectInstance p_70687_1_) {
        if (p_70687_1_.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)((Object)this), p_70687_1_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(p_70687_1_);
    }

    public boolean func_70841_p() {
        return (this.field_70180_af.func_187225_a(field_184729_a) & 1) != 0;
    }

    public void func_70839_e(boolean p_70839_1_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184729_a);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(field_184729_a, b0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        Effect effect;
        p_213386_4_ = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        if (p_213386_1_.func_201674_k().nextInt(100) == 0) {
            SkeletonEntity skeletonentity = EntityType.field_200741_ag.func_200721_a(this.field_70170_p);
            skeletonentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            skeletonentity.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, (ILivingEntityData)null, (CompoundNBT)null);
            skeletonentity.func_184220_m((Entity)((Object)this));
        }
        if (p_213386_4_ == null) {
            p_213386_4_ = new GroupData();
            if (p_213386_1_.func_175659_aa() == Difficulty.HARD && p_213386_1_.func_201674_k().nextFloat() < 0.1f * p_213386_2_.func_180170_c()) {
                ((GroupData)p_213386_4_).func_111104_a(p_213386_1_.func_201674_k());
            }
        }
        if (p_213386_4_ instanceof GroupData && (effect = ((GroupData)p_213386_4_).field_188478_a) != null) {
            this.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE));
        }
        return p_213386_4_;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 0.65f;
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(SpiderEntity p_i45818_1_, Class<T> p_i45818_2_) {
            super((MobEntity)((Object)p_i45818_1_), p_i45818_2_, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }

    public static class GroupData
    implements ILivingEntityData {
        public Effect field_188478_a;

        public void func_111104_a(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.field_188478_a = Effects.field_76424_c;
            } else if (i <= 2) {
                this.field_188478_a = Effects.field_76420_g;
            } else if (i <= 3) {
                this.field_188478_a = Effects.field_76428_l;
            } else if (i <= 4) {
                this.field_188478_a = Effects.field_76441_p;
            }
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(SpiderEntity p_i46676_1_) {
            super((CreatureEntity)p_i46676_1_, 1.0, true);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75441_b.func_184207_aI();
        }

        @Override
        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((LivingEntity)null);
                return false;
            }
            return super.func_75253_b();
        }

        @Override
        protected double func_179512_a(LivingEntity p_179512_1_) {
            return 4.0f + p_179512_1_.func_213311_cf();
        }
    }
}

