/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class OverlayRenderer {
    private static final ResourceLocation field_228733_a_ = new ResourceLocation("textures/misc/underwater.png");

    public static void func_228734_a_(Minecraft p_228734_0_, MatrixStack p_228734_1_) {
        Pair<BlockState, BlockPos> overlay;
        RenderSystem.disableAlphaTest();
        ClientPlayerEntity playerentity = p_228734_0_.field_71439_g;
        if (!playerentity.field_70145_X && (overlay = OverlayRenderer.getOverlayBlock(playerentity)) != null && !ForgeEventFactory.renderBlockOverlay((PlayerEntity)playerentity, (MatrixStack)p_228734_1_, (RenderBlockOverlayEvent.OverlayType)RenderBlockOverlayEvent.OverlayType.BLOCK, (BlockState)((BlockState)((Object)overlay.getLeft())), (BlockPos)((BlockPos)overlay.getRight()))) {
            OverlayRenderer.func_228735_a_(p_228734_0_, p_228734_0_.func_175602_ab().func_175023_a().getTexture((BlockState)((Object)overlay.getLeft()), p_228734_0_.field_71441_e, (BlockPos)overlay.getRight()), p_228734_1_);
        }
        if (!p_228734_0_.field_71439_g.func_175149_v()) {
            if (p_228734_0_.field_71439_g.func_208600_a(FluidTags.field_206959_a) && !ForgeEventFactory.renderWaterOverlay((PlayerEntity)playerentity, (MatrixStack)p_228734_1_)) {
                OverlayRenderer.func_228736_b_(p_228734_0_, p_228734_1_);
            }
            if (p_228734_0_.field_71439_g.func_70027_ad() && !ForgeEventFactory.renderFireOverlay((PlayerEntity)playerentity, (MatrixStack)p_228734_1_)) {
                OverlayRenderer.func_228737_c_(p_228734_0_, p_228734_1_);
            }
        }
        RenderSystem.enableAlphaTest();
    }

    @Nullable
    private static BlockState func_230018_a_(PlayerEntity p_230018_0_) {
        return (BlockState)((Object)OverlayRenderer.getOverlayBlock(p_230018_0_).getLeft());
    }

    @Nullable
    private static Pair<BlockState, BlockPos> getOverlayBlock(PlayerEntity p_230018_0_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i < 8; ++i) {
            double d0 = p_230018_0_.func_226277_ct_() + (double)(((float)((i >> 0) % 2) - 0.5f) * p_230018_0_.func_213311_cf() * 0.8f);
            double d1 = p_230018_0_.func_226280_cw_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double d2 = p_230018_0_.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * p_230018_0_.func_213311_cf() * 0.8f);
            blockpos$mutable.func_189532_c(d0, d1, d2);
            BlockState blockstate = p_230018_0_.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate.func_185901_i() == BlockRenderType.INVISIBLE || !blockstate.func_215696_m((IBlockReader)((Object)p_230018_0_.field_70170_p), (BlockPos)blockpos$mutable)) continue;
            return Pair.of((Object)((Object)blockstate), (Object)blockpos$mutable.func_185334_h());
        }
        return null;
    }

    private static void func_228735_a_(Minecraft p_228735_0_, TextureAtlasSprite p_228735_1_, MatrixStack p_228735_2_) {
        p_228735_0_.func_110434_K().func_110577_a(p_228735_1_.func_229241_m_().func_229223_g_());
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        float f = 0.1f;
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = p_228735_1_.func_94209_e();
        float f7 = p_228735_1_.func_94212_f();
        float f8 = p_228735_1_.func_94206_g();
        float f9 = p_228735_1_.func_94210_h();
        Matrix4f matrix4f = p_228735_2_.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix4f, -1.0f, -1.0f, -0.5f).func_227885_a_(0.1f, 0.1f, 0.1f, 1.0f).func_225583_a_(f7, f9).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, 1.0f, -1.0f, -0.5f).func_227885_a_(0.1f, 0.1f, 0.1f, 1.0f).func_225583_a_(f6, f9).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, 1.0f, 1.0f, -0.5f).func_227885_a_(0.1f, 0.1f, 0.1f, 1.0f).func_225583_a_(f6, f8).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, -1.0f, 1.0f, -0.5f).func_227885_a_(0.1f, 0.1f, 0.1f, 1.0f).func_225583_a_(f7, f8).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    private static void func_228736_b_(Minecraft p_228736_0_, MatrixStack p_228736_1_) {
        RenderSystem.enableTexture();
        p_228736_0_.func_110434_K().func_110577_a(field_228733_a_);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        float f = p_228736_0_.field_71439_g.func_70013_c();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -p_228736_0_.field_71439_g.field_70177_z / 64.0f;
        float f8 = p_228736_0_.field_71439_g.field_70125_A / 64.0f;
        Matrix4f matrix4f = p_228736_1_.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix4f, -1.0f, -1.0f, -0.5f).func_227885_a_(f, f, f, 0.1f).func_225583_a_(4.0f + f7, 4.0f + f8).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, 1.0f, -1.0f, -0.5f).func_227885_a_(f, f, f, 0.1f).func_225583_a_(0.0f + f7, 4.0f + f8).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, 1.0f, 1.0f, -0.5f).func_227885_a_(f, f, f, 0.1f).func_225583_a_(0.0f + f7, 0.0f + f8).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, -1.0f, 1.0f, -0.5f).func_227885_a_(f, f, f, 0.1f).func_225583_a_(4.0f + f7, 0.0f + f8).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableBlend();
    }

    private static void func_228737_c_(Minecraft p_228737_0_, MatrixStack p_228737_1_) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableTexture();
        TextureAtlasSprite textureatlassprite = ModelBakery.field_207764_b.func_229314_c_();
        p_228737_0_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
        float f = textureatlassprite.func_94209_e();
        float f1 = textureatlassprite.func_94212_f();
        float f2 = (f + f1) / 2.0f;
        float f3 = textureatlassprite.func_94206_g();
        float f4 = textureatlassprite.func_94210_h();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = textureatlassprite.func_229242_p_();
        float f7 = MathHelper.func_219799_g((float)f6, (float)f, (float)f2);
        float f8 = MathHelper.func_219799_g((float)f6, (float)f1, (float)f2);
        float f9 = MathHelper.func_219799_g((float)f6, (float)f3, (float)f5);
        float f10 = MathHelper.func_219799_g((float)f6, (float)f4, (float)f5);
        float f11 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            p_228737_1_.func_227860_a_();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            p_228737_1_.func_227861_a_((double)((float)(-(i * 2 - 1)) * 0.24f), (double)-0.3f, 0.0);
            p_228737_1_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = p_228737_1_.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            bufferbuilder.func_227888_a_(matrix4f, -0.5f, -0.5f, -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.9f).func_225583_a_(f8, f10).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 0.5f, -0.5f, -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.9f).func_225583_a_(f7, f10).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, 0.5f, 0.5f, -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.9f).func_225583_a_(f7, f9).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, -0.5f, 0.5f, -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.9f).func_225583_a_(f8, f9).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            p_228737_1_.func_227865_b_();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
    }
}

