/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.IServerWorldInfo;

public class WanderingTraderSpawner
implements ISpecialSpawner {
    private final Random field_221246_a = new Random();
    private final IServerWorldInfo field_234559_b_;
    private int field_221248_c;
    private int field_221249_d;
    private int field_221250_e;

    public WanderingTraderSpawner(IServerWorldInfo iServerWorldInfo) {
        this.field_234559_b_ = iServerWorldInfo;
        this.field_221248_c = 1200;
        this.field_221249_d = iServerWorldInfo.func_230399_u_();
        this.field_221250_e = iServerWorldInfo.func_230400_v_();
        if (this.field_221249_d == 0 && this.field_221250_e == 0) {
            this.field_221249_d = 24000;
            iServerWorldInfo.func_230396_g_(this.field_221249_d);
            this.field_221250_e = 25;
            iServerWorldInfo.func_230397_h_(this.field_221250_e);
        }
    }

    @Override
    public int func_230253_a_(ServerWorld serverWorld, boolean bl, boolean bl2) {
        if (!serverWorld.func_82736_K().func_223586_b(GameRules.field_230128_E_)) {
            return 0;
        }
        if (--this.field_221248_c > 0) {
            return 0;
        }
        this.field_221248_c = 1200;
        this.field_221249_d -= 1200;
        this.field_234559_b_.func_230396_g_(this.field_221249_d);
        if (this.field_221249_d > 0) {
            return 0;
        }
        this.field_221249_d = 24000;
        if (!serverWorld.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            return 0;
        }
        int n = this.field_221250_e;
        this.field_221250_e = MathHelper.func_76125_a(this.field_221250_e + 25, 25, 75);
        this.field_234559_b_.func_230397_h_(this.field_221250_e);
        if (this.field_221246_a.nextInt(100) > n) {
            return 0;
        }
        if (this.func_234562_a_(serverWorld)) {
            this.field_221250_e = 25;
            return 1;
        }
        return 0;
    }

    private boolean func_234562_a_(ServerWorld serverWorld) {
        ServerPlayerEntity serverPlayerEntity = serverWorld.func_217472_l_();
        if (serverPlayerEntity == null) {
            return true;
        }
        if (this.field_221246_a.nextInt(10) != 0) {
            return false;
        }
        BlockPos \u26032 = serverPlayerEntity.func_233580_cy_();
        int \u26033 = 48;
        PointOfInterestManager \u26034 = serverWorld.func_217443_B();
        Optional<BlockPos> \u26035 = \u26034.func_219127_a(PointOfInterestType.field_221070_r.func_221045_c(), blockPos -> true, \u26032, 48, PointOfInterestManager.Status.ANY);
        BlockPos \u26036 = \u26035.orElse(\u26032);
        BlockPos \u26037 = this.func_234561_a_(serverWorld, \u26036, 48);
        if (\u26037 != null && this.func_234560_a_(serverWorld, \u26037)) {
            if (serverWorld.func_242406_i(\u26037).equals(Optional.of(Biomes.field_185440_P))) {
                return false;
            }
            WanderingTraderEntity wanderingTraderEntity = EntityType.field_220351_aK.func_220342_a(serverWorld, null, null, null, \u26037, SpawnReason.EVENT, false, false);
            if (wanderingTraderEntity != null) {
                for (int i = 0; i < 2; ++i) {
                    this.func_242373_a(serverWorld, wanderingTraderEntity, 4);
                }
                this.field_234559_b_.func_230394_a_(wanderingTraderEntity.func_110124_au());
                wanderingTraderEntity.func_213728_s(48000);
                wanderingTraderEntity.func_213726_g(\u26036);
                wanderingTraderEntity.func_213390_a(\u26036, 16);
                return true;
            }
        }
        return false;
    }

    private void func_242373_a(ServerWorld serverWorld, WanderingTraderEntity wanderingTraderEntity, int n) {
        BlockPos blockPos = this.func_234561_a_(serverWorld, wanderingTraderEntity.func_233580_cy_(), n);
        if (blockPos == null) {
            return;
        }
        TraderLlamaEntity \u26032 = EntityType.field_220354_ax.func_220342_a(serverWorld, null, null, null, blockPos, SpawnReason.EVENT, false, false);
        if (\u26032 == null) {
            return;
        }
        \u26032.func_110162_b(wanderingTraderEntity, true);
    }

    @Nullable
    private BlockPos func_234561_a_(IWorldReader iWorldReader, BlockPos blockPos, int n) {
        BlockPos blockPos2 = null;
        for (int i = 0; i < 10; ++i) {
            \u2603 = blockPos.func_177958_n() + this.field_221246_a.nextInt(n * 2) - n;
            BlockPos blockPos3 = new BlockPos(\u2603, \u2603 = iWorldReader.func_201676_a(Heightmap.Type.WORLD_SURFACE, \u2603, \u2603 = blockPos.func_177952_p() + this.field_221246_a.nextInt(n * 2) - n), \u2603);
            if (!WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, iWorldReader, blockPos3, EntityType.field_220351_aK)) continue;
            blockPos2 = blockPos3;
            break;
        }
        return blockPos2;
    }

    private boolean func_234560_a_(IBlockReader iBlockReader, BlockPos blockPos) {
        for (BlockPos blockPos2 : BlockPos.func_218278_a(blockPos, blockPos.func_177982_a(1, 2, 1))) {
            if (iBlockReader.func_180495_p(blockPos2).func_196952_d(iBlockReader, blockPos2).func_197766_b()) continue;
            return false;
        }
        return true;
    }
}

