/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class StrongholdPieces {
    private static final PieceWeight[] field_75205_b = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(Crossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean func_75189_a(int n) {
            return super.func_75189_a(n) && n > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean func_75189_a(int n) {
            return super.func_75189_a(n) && n > 5;
        }
    }};
    private static List<PieceWeight> field_75206_c;
    private static Class<? extends Stronghold> field_75203_d;
    private static int field_75207_a;
    private static final Stones field_75204_e;

    public static void func_75198_a() {
        field_75206_c = Lists.newArrayList();
        for (PieceWeight pieceWeight : field_75205_b) {
            pieceWeight.field_75193_c = 0;
            field_75206_c.add(pieceWeight);
        }
        field_75203_d = null;
    }

    private static boolean func_75202_c() {
        boolean bl = false;
        field_75207_a = 0;
        for (PieceWeight pieceWeight2 : field_75206_c) {
            PieceWeight pieceWeight2;
            if (pieceWeight2.field_75191_d > 0 && pieceWeight2.field_75193_c < pieceWeight2.field_75191_d) {
                bl = true;
            }
            field_75207_a += pieceWeight2.field_75192_b;
        }
        return bl;
    }

    private static Stronghold func_175954_a(Class<? extends Stronghold> clazz, List<StructurePiece> list, Random random, int n, int n2, int n3, @Nullable Direction direction, int n4) {
        Stronghold stronghold = null;
        if (clazz == Straight.class) {
            stronghold = Straight.func_175862_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == Prison.class) {
            stronghold = Prison.func_175860_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == LeftTurn.class) {
            stronghold = LeftTurn.func_175867_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == RightTurn.class) {
            stronghold = RightTurn.func_214824_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == RoomCrossing.class) {
            stronghold = RoomCrossing.func_175859_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == StairsStraight.class) {
            stronghold = StairsStraight.func_175861_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == Stairs.class) {
            stronghold = Stairs.func_175863_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == Crossing.class) {
            stronghold = Crossing.func_175866_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == ChestCorridor.class) {
            stronghold = ChestCorridor.func_175868_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == Library.class) {
            stronghold = Library.func_175864_a(list, random, n, n2, n3, direction, n4);
        } else if (clazz == PortalRoom.class) {
            stronghold = PortalRoom.func_175865_a(list, n, n2, n3, direction, n4);
        }
        return stronghold;
    }

    private static Stronghold func_175955_b(Stairs2 stairs2, List<StructurePiece> list2, Random random, int n, int n2, int n3, Direction direction, int n4) {
        List<StructurePiece> list2;
        if (!StrongholdPieces.func_75202_c()) {
            return null;
        }
        if (field_75203_d != null) {
            Stronghold stronghold = StrongholdPieces.func_175954_a(field_75203_d, list2, random, n, n2, n3, direction, n4);
            field_75203_d = null;
            if (stronghold != null) {
                return stronghold;
            }
        }
        int n5 = 0;
        block0: while (n5 < 5) {
            ++n5;
            \u2603 = random.nextInt(field_75207_a);
            for (PieceWeight pieceWeight : field_75206_c) {
                if ((\u2603 -= pieceWeight.field_75192_b) >= 0) continue;
                if (!pieceWeight.func_75189_a(n4) || pieceWeight == stairs2.field_75027_a) continue block0;
                Stronghold stronghold = StrongholdPieces.func_175954_a(pieceWeight.field_75194_a, list2, random, n, n2, n3, direction, n4);
                if (stronghold == null) continue;
                ++pieceWeight.field_75193_c;
                stairs2.field_75027_a = pieceWeight;
                if (!pieceWeight.func_75190_a()) {
                    field_75206_c.remove(pieceWeight);
                }
                return stronghold;
            }
        }
        MutableBoundingBox \u26032 = Corridor.func_175869_a(list2, random, n, n2, n3, direction);
        if (\u26032 != null && \u26032.field_78895_b > 1) {
            return new Corridor(n4, \u26032, direction);
        }
        return null;
    }

    private static StructurePiece func_175953_c(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2, int n3, @Nullable Direction direction, int n4) {
        if (n4 > 50) {
            return null;
        }
        if (Math.abs(n - stairs2.func_74874_b().field_78897_a) > 112 || Math.abs(n3 - stairs2.func_74874_b().field_78896_c) > 112) {
            return null;
        }
        Stronghold stronghold = StrongholdPieces.func_175955_b(stairs2, list, random, n, n2, n3, direction, n4 + 1);
        if (stronghold != null) {
            list.add(stronghold);
            stairs2.field_75026_c.add(stronghold);
        }
        return stronghold;
    }

    static {
        field_75204_e = new Stones();
    }

    static class Stones
    extends StructurePiece.BlockSelector {
        private Stones() {
        }

        @Override
        public void func_75062_a(Random random, int n, int n2, int n3, boolean bl) {
            this.field_151562_a = bl ? ((\u2603 = random.nextFloat()) < 0.2f ? Blocks.field_196700_dk.func_176223_P() : (\u2603 < 0.5f ? Blocks.field_196698_dj.func_176223_P() : (\u2603 < 0.55f ? Blocks.field_196688_de.func_176223_P() : Blocks.field_196696_di.func_176223_P()))) : Blocks.field_201941_jj.func_176223_P();
        }
    }

    public static class PortalRoom
    extends Stronghold {
        private boolean field_75005_a;

        public PortalRoom(int n, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214754_A, n);
            this.func_186164_a(direction);
            this.field_74887_e = mutableBoundingBox;
        }

        public PortalRoom(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214754_A, compoundNBT);
            this.field_75005_a = compoundNBT.func_74767_n("Mob");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74757_a("Mob", this.field_75005_a);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            if (structurePiece != null) {
                ((Stairs2)structurePiece).field_75025_b = this;
            }
        }

        public static PortalRoom func_175865_a(List<StructurePiece> list, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 11, 8, 16, direction);
            if (!PortalRoom.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new PortalRoom(n4, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 10, 7, 15, false, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, Stronghold.Door.GRATES, 4, 1, 0);
            int n = 6;
            this.func_74882_a(iSeedReader, mutableBoundingBox, 1, n, 1, 1, n, 14, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 9, n, 1, 9, n, 14, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 2, n, 1, 8, n, 2, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 2, n, 14, 8, n, 14, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 1, 1, 1, 2, 1, 4, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 8, 1, 1, 9, 1, 4, false, random, field_75204_e);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, 1, 1, 1, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 1, 1, 9, 1, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 3, 1, 8, 7, 1, 12, false, random, field_75204_e);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 1, 9, 6, 1, 11, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            BlockState \u26032 = (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, true)).func_206870_a(PaneBlock.field_196413_c, true);
            BlockState \u26033 = (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196414_y, true)).func_206870_a(PaneBlock.field_196411_b, true);
            for (\u2603 = 3; \u2603 < 14; \u2603 += 2) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, \u2603, 0, 4, \u2603, \u26032, \u26032, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 3, \u2603, 10, 4, \u2603, \u26032, \u26032, false);
            }
            for (\u2603 = 2; \u2603 < 9; \u2603 += 2) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, \u2603, 3, 15, \u2603, 4, 15, \u26033, \u26033, false);
            }
            BlockState \u26034 = (BlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a(StairsBlock.field_176309_a, Direction.NORTH);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 4, 1, 5, 6, 1, 7, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 4, 2, 6, 6, 2, 7, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 4, 3, 7, 6, 3, 7, false, random, field_75204_e);
            for (\u2603 = 4; \u2603 <= 6; ++\u2603) {
                this.func_175811_a(iSeedReader, \u26034, \u2603, 1, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u26034, \u2603, 2, 5, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u26034, \u2603, 3, 6, mutableBoundingBox);
            }
            BlockState \u26035 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(EndPortalFrameBlock.field_176508_a, Direction.NORTH);
            BlockState \u26036 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(EndPortalFrameBlock.field_176508_a, Direction.SOUTH);
            BlockState \u26037 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(EndPortalFrameBlock.field_176508_a, Direction.EAST);
            BlockState \u26038 = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(EndPortalFrameBlock.field_176508_a, Direction.WEST);
            boolean \u26039 = true;
            boolean[] \u260310 = new boolean[12];
            for (\u2603 = 0; \u2603 < \u260310.length; ++\u2603) {
                \u260310[\u2603] = random.nextFloat() > 0.9f;
                \u26039 &= \u260310[\u2603];
            }
            this.func_175811_a(iSeedReader, (BlockState)\u26035.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[0]), 4, 3, 8, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26035.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[1]), 5, 3, 8, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26035.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[2]), 6, 3, 8, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26036.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[3]), 4, 3, 12, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26036.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[4]), 5, 3, 12, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26036.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[5]), 6, 3, 12, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26037.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[6]), 3, 3, 9, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26037.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[7]), 3, 3, 10, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26037.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[8]), 3, 3, 11, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26038.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[9]), 7, 3, 9, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26038.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[10]), 7, 3, 10, mutableBoundingBox);
            this.func_175811_a(iSeedReader, (BlockState)\u26038.func_206870_a(EndPortalFrameBlock.field_176507_b, \u260310[11]), 7, 3, 11, mutableBoundingBox);
            if (\u26039) {
                BlockState blockState = Blocks.field_150384_bq.func_176223_P();
                this.func_175811_a(iSeedReader, blockState, 4, 3, 9, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 5, 3, 9, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 6, 3, 9, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 4, 3, 10, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 5, 3, 10, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 6, 3, 10, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 4, 3, 11, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 5, 3, 11, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 6, 3, 11, mutableBoundingBox);
            }
            if (!this.field_75005_a) {
                n = this.func_74862_a(3);
                BlockPos \u260311 = new BlockPos(this.func_74865_a(5, 6), n, this.func_74873_b(5, 6));
                if (mutableBoundingBox.func_175898_b(\u260311)) {
                    this.field_75005_a = true;
                    iSeedReader.func_180501_a(\u260311, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = iSeedReader.func_175625_s(\u260311);
                    if (tileEntity instanceof MobSpawnerTileEntity) {
                        ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(EntityType.field_200740_af);
                    }
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private final boolean field_74996_b;
        private final boolean field_74997_c;
        private final boolean field_74995_d;
        private final boolean field_74999_h;

        public Crossing(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214803_x, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_74996_b = random.nextBoolean();
            this.field_74997_c = random.nextBoolean();
            this.field_74995_d = random.nextBoolean();
            this.field_74999_h = random.nextInt(3) > 0;
        }

        public Crossing(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214803_x, compoundNBT);
            this.field_74996_b = compoundNBT.func_74767_n("leftLow");
            this.field_74997_c = compoundNBT.func_74767_n("leftHigh");
            this.field_74995_d = compoundNBT.func_74767_n("rightLow");
            this.field_74999_h = compoundNBT.func_74767_n("rightHigh");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74757_a("leftLow", this.field_74996_b);
            compoundNBT.func_74757_a("leftHigh", this.field_74997_c);
            compoundNBT.func_74757_a("rightLow", this.field_74995_d);
            compoundNBT.func_74757_a("rightHigh", this.field_74999_h);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            int n = 3;
            \u2603 = 5;
            Direction \u26032 = this.func_186165_e();
            if (\u26032 == Direction.WEST || \u26032 == Direction.NORTH) {
                n = 8 - n;
                \u2603 = 8 - \u2603;
            }
            this.func_74986_a((Stairs2)structurePiece, list, random, 5, 1);
            if (this.field_74996_b) {
                this.func_74989_b((Stairs2)structurePiece, list, random, n, 1);
            }
            if (this.field_74997_c) {
                this.func_74989_b((Stairs2)structurePiece, list, random, \u2603, 7);
            }
            if (this.field_74995_d) {
                this.func_74987_c((Stairs2)structurePiece, list, random, n, 1);
            }
            if (this.field_74999_h) {
                this.func_74987_c((Stairs2)structurePiece, list, random, \u2603, 7);
            }
        }

        public static Crossing func_175866_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -3, 0, 10, 9, 11, direction);
            if (!Crossing.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Crossing(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 9, 8, 10, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 4, 3, 0);
            if (this.field_74996_b) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 3, 1, 0, 5, 3, field_202556_l, field_202556_l, false);
            }
            if (this.field_74995_d) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 3, 1, 9, 5, 3, field_202556_l, field_202556_l, false);
            }
            if (this.field_74997_c) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 5, 7, 0, 7, 9, field_202556_l, field_202556_l, false);
            }
            if (this.field_74999_h) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 5, 7, 9, 7, 9, field_202556_l, field_202556_l, false);
            }
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 10, 7, 3, 10, field_202556_l, field_202556_l, false);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 1, 2, 1, 8, 2, 6, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 4, 1, 5, 4, 4, 9, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 8, 1, 5, 8, 4, 9, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 1, 4, 7, 3, 4, 9, false, random, field_75204_e);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 1, 3, 5, 3, 3, 6, false, random, field_75204_e);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 3, 4, 3, 3, 4, Blocks.field_222401_hJ.func_176223_P(), Blocks.field_222401_hJ.func_176223_P(), false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 4, 6, 3, 4, 6, Blocks.field_222401_hJ.func_176223_P(), Blocks.field_222401_hJ.func_176223_P(), false);
            this.func_74882_a(iSeedReader, mutableBoundingBox, 5, 1, 7, 7, 1, 8, false, random, field_75204_e);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 1, 9, 7, 1, 9, Blocks.field_222401_hJ.func_176223_P(), Blocks.field_222401_hJ.func_176223_P(), false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 2, 7, 7, 2, 7, Blocks.field_222401_hJ.func_176223_P(), Blocks.field_222401_hJ.func_176223_P(), false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 5, 7, 4, 5, 9, Blocks.field_222401_hJ.func_176223_P(), Blocks.field_222401_hJ.func_176223_P(), false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 8, 5, 7, 8, 5, 9, Blocks.field_222401_hJ.func_176223_P(), Blocks.field_222401_hJ.func_176223_P(), false);
            this.func_175804_a(iSeedReader, mutableBoundingBox, 5, 5, 7, 7, 5, 9, (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a(SlabBlock.field_196505_a, SlabType.DOUBLE), (BlockState)Blocks.field_222401_hJ.func_176223_P().func_206870_a(SlabBlock.field_196505_a, SlabType.DOUBLE), false);
            this.func_175811_a(iSeedReader, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.SOUTH), 6, 5, 6, mutableBoundingBox);
            return true;
        }
    }

    public static class Library
    extends Stronghold {
        private final boolean field_75008_c;

        public Library(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214805_z, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_75008_c = mutableBoundingBox.func_78882_c() > 6;
        }

        public Library(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214805_z, compoundNBT);
            this.field_75008_c = compoundNBT.func_74767_n("Tall");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74757_a("Tall", this.field_75008_c);
        }

        public static Library func_175864_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 14, 11, 15, direction);
            if (!(Library.func_74991_a(mutableBoundingBox) && StructurePiece.func_74883_a(list, mutableBoundingBox) == null || Library.func_74991_a(mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 14, 6, 15, direction)) && StructurePiece.func_74883_a(list, mutableBoundingBox) == null)) {
                return null;
            }
            return new Library(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            int n = 11;
            if (!this.field_75008_c) {
                n = 6;
            }
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 13, n - 1, 14, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 4, 1, 0);
            this.func_189914_a(iSeedReader, mutableBoundingBox, random, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.field_196553_aF.func_176223_P(), Blocks.field_196553_aF.func_176223_P(), false, false);
            boolean \u26032 = true;
            \u2603 = 12;
            for (\u2603 = 1; \u2603 <= 13; ++\u2603) {
                if ((\u2603 - 1) % 4 == 0) {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, \u2603, 1, 4, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 12, 1, \u2603, 12, 4, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.EAST), 2, 3, \u2603, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.WEST), 11, 3, \u2603, mutableBoundingBox);
                    if (!this.field_75008_c) continue;
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 6, \u2603, 1, 9, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    this.func_175804_a(iSeedReader, mutableBoundingBox, 12, 6, \u2603, 12, 9, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    continue;
                }
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 1, \u2603, 1, 4, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 12, 1, \u2603, 12, 4, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                if (!this.field_75008_c) continue;
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 6, \u2603, 1, 9, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 12, 6, \u2603, 12, 9, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (\u2603 = 3; \u2603 < 12; \u2603 += 2) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 1, \u2603, 4, 3, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 6, 1, \u2603, 7, 3, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 9, 1, \u2603, 10, 3, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            if (this.field_75008_c) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 1, 5, 1, 3, 5, 13, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 5, 1, 12, 5, 13, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 5, 1, 9, 5, 2, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 5, 12, 9, 5, 13, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175811_a(iSeedReader, Blocks.field_196662_n.func_176223_P(), 9, 5, 11, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196662_n.func_176223_P(), 8, 5, 11, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196662_n.func_176223_P(), 9, 5, 10, mutableBoundingBox);
                BlockState blockState = (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196414_y, true)).func_206870_a(FenceBlock.field_196411_b, true);
                \u2603 = (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196409_a, true)).func_206870_a(FenceBlock.field_196413_c, true);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 3, 6, 3, 3, 6, 11, \u2603, \u2603, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 10, 6, 3, 10, 6, 9, \u2603, \u2603, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 6, 2, 9, 6, 2, blockState, blockState, false);
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 6, 12, 7, 6, 12, blockState, blockState, false);
                this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196409_a, true)).func_206870_a(FenceBlock.field_196411_b, true), 3, 6, 2, mutableBoundingBox);
                this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196413_c, true)).func_206870_a(FenceBlock.field_196411_b, true), 3, 6, 12, mutableBoundingBox);
                this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196409_a, true)).func_206870_a(FenceBlock.field_196414_y, true), 10, 6, 2, mutableBoundingBox);
                for (int i = 0; i <= 2; ++i) {
                    this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196413_c, true)).func_206870_a(FenceBlock.field_196414_y, true), 8 + i, 6, 12 - i, mutableBoundingBox);
                    if (i == 2) continue;
                    this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196409_a, true)).func_206870_a(FenceBlock.field_196411_b, true), 8 + i, 6, 11 - i, mutableBoundingBox);
                }
                BlockState blockState2 = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a(LadderBlock.field_176382_a, Direction.SOUTH);
                this.func_175811_a(iSeedReader, blockState2, 10, 1, 13, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState2, 10, 2, 13, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState2, 10, 3, 13, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState2, 10, 4, 13, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState2, 10, 5, 13, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState2, 10, 6, 13, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState2, 10, 7, 13, mutableBoundingBox);
                int \u26033 = 7;
                int \u26034 = 7;
                \u2603 = (BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196411_b, true);
                this.func_175811_a(iSeedReader, \u2603, 6, 9, 7, mutableBoundingBox);
                \u2603 = (BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(FenceBlock.field_196414_y, true);
                this.func_175811_a(iSeedReader, \u2603, 7, 9, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 6, 8, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 7, 8, 7, mutableBoundingBox);
                \u2603 = (BlockState)((BlockState)\u2603.func_206870_a(FenceBlock.field_196414_y, true)).func_206870_a(FenceBlock.field_196411_b, true);
                this.func_175811_a(iSeedReader, \u2603, 6, 7, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 7, 7, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 5, 7, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 8, 7, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, (BlockState)\u2603.func_206870_a(FenceBlock.field_196409_a, true), 6, 7, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader, (BlockState)\u2603.func_206870_a(FenceBlock.field_196413_c, true), 6, 7, 8, mutableBoundingBox);
                this.func_175811_a(iSeedReader, (BlockState)\u2603.func_206870_a(FenceBlock.field_196409_a, true), 7, 7, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader, (BlockState)\u2603.func_206870_a(FenceBlock.field_196413_c, true), 7, 7, 8, mutableBoundingBox);
                \u2603 = Blocks.field_150478_aa.func_176223_P();
                this.func_175811_a(iSeedReader, \u2603, 5, 8, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 8, 8, 7, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 6, 8, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 6, 8, 8, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 7, 8, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader, \u2603, 7, 8, 8, mutableBoundingBox);
            }
            this.func_186167_a(iSeedReader, mutableBoundingBox, random, 3, 3, 5, LootTables.field_186426_h);
            if (this.field_75008_c) {
                this.func_175811_a(iSeedReader, field_202556_l, 12, 9, 1, mutableBoundingBox);
                this.func_186167_a(iSeedReader, mutableBoundingBox, random, 12, 8, 1, LootTables.field_186426_h);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214755_B, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        public Prison(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214755_B, compoundNBT);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static Prison func_175860_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 9, 5, 11, direction);
            if (!Prison.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Prison(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader2, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            ISeedReader iSeedReader2;
            this.func_74882_a(iSeedReader2, mutableBoundingBox, 0, 0, 0, 8, 4, 10, true, random, field_75204_e);
            this.func_242917_a(iSeedReader2, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 1, 1, 10, 3, 3, 10, field_202556_l, field_202556_l, false);
            this.func_74882_a(iSeedReader2, mutableBoundingBox, 4, 1, 1, 4, 3, 1, false, random, field_75204_e);
            this.func_74882_a(iSeedReader2, mutableBoundingBox, 4, 1, 3, 4, 3, 3, false, random, field_75204_e);
            this.func_74882_a(iSeedReader2, mutableBoundingBox, 4, 1, 7, 4, 3, 7, false, random, field_75204_e);
            this.func_74882_a(iSeedReader2, mutableBoundingBox, 4, 1, 9, 4, 3, 9, false, random, field_75204_e);
            for (int i = 1; i <= 3; ++i) {
                this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, true)).func_206870_a(PaneBlock.field_196413_c, true), 4, i, 4, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, (BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, true)).func_206870_a(PaneBlock.field_196413_c, true)).func_206870_a(PaneBlock.field_196411_b, true), 4, i, 5, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, true)).func_206870_a(PaneBlock.field_196413_c, true), 4, i, 6, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196414_y, true)).func_206870_a(PaneBlock.field_196411_b, true), 5, i, 5, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196414_y, true)).func_206870_a(PaneBlock.field_196411_b, true), 6, i, 5, mutableBoundingBox);
                this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196414_y, true)).func_206870_a(PaneBlock.field_196411_b, true), 7, i, 5, mutableBoundingBox);
            }
            this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, true)).func_206870_a(PaneBlock.field_196413_c, true), 4, 3, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, true)).func_206870_a(PaneBlock.field_196413_c, true), 4, 3, 8, mutableBoundingBox);
            BlockState \u26032 = (BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a(DoorBlock.field_176520_a, Direction.WEST);
            BlockState \u26033 = (BlockState)((BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a(DoorBlock.field_176520_a, Direction.WEST)).func_206870_a(DoorBlock.field_176523_O, DoubleBlockHalf.UPPER);
            this.func_175811_a(iSeedReader2, \u26032, 4, 1, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, \u26033, 4, 2, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, \u26032, 4, 1, 8, mutableBoundingBox);
            this.func_175811_a(iSeedReader2, \u26033, 4, 2, 8, mutableBoundingBox);
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected final int field_75013_b;

        public RoomCrossing(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214757_D, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_75013_b = random.nextInt(5);
        }

        public RoomCrossing(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214757_D, compoundNBT);
            this.field_75013_b = compoundNBT.func_74762_e("Type");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74768_a("Type", this.field_75013_b);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 4, 1);
            this.func_74989_b((Stairs2)structurePiece, list, random, 1, 4);
            this.func_74987_c((Stairs2)structurePiece, list, random, 1, 4);
        }

        public static RoomCrossing func_175859_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 11, 7, 11, direction);
            if (!RoomCrossing.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new RoomCrossing(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader2, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader2, mutableBoundingBox, 0, 0, 0, 10, 6, 10, true, random, field_75204_e);
            this.func_242917_a(iSeedReader2, random, mutableBoundingBox, this.field_143013_d, 4, 1, 0);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 4, 1, 10, 6, 3, 10, field_202556_l, field_202556_l, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 0, 1, 4, 0, 3, 6, field_202556_l, field_202556_l, false);
            this.func_175804_a(iSeedReader2, mutableBoundingBox, 10, 1, 4, 10, 3, 6, field_202556_l, field_202556_l, false);
            switch (this.field_75013_b) {
                default: {
                    break;
                }
                case 0: {
                    this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 5, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 5, 2, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 5, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.WEST), 4, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.EAST), 6, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.SOUTH), 5, 3, 4, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.NORTH), 5, 3, 6, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 4, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 4, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 4, 1, 6, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 6, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 6, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 6, 1, 6, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 5, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_222401_hJ.func_176223_P(), 5, 1, 6, mutableBoundingBox);
                    break;
                }
                case 1: {
                    ISeedReader iSeedReader2;
                    for (int i = 0; i < 5; ++i) {
                        this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 3, 1, 3 + i, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 7, 1, 3 + i, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 3 + i, 1, 3, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 3 + i, 1, 7, mutableBoundingBox);
                    }
                    this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 5, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 5, 2, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_196696_di.func_176223_P(), 5, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150355_j.func_176223_P(), 5, 4, 5, mutableBoundingBox);
                    break;
                }
                case 2: {
                    int n;
                    ISeedReader iSeedReader2;
                    for (n = 1; n <= 9; ++n) {
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 1, 3, n, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 9, 3, n, mutableBoundingBox);
                    }
                    for (n = 1; n <= 9; ++n) {
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), n, 3, 1, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), n, 3, 9, mutableBoundingBox);
                    }
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 5, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 5, 1, 6, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 5, 3, 4, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 5, 3, 6, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 4, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 6, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 4, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 6, 3, 5, mutableBoundingBox);
                    for (n = 1; n <= 3; ++n) {
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 4, n, 4, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 6, n, 4, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 4, n, 6, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_150347_e.func_176223_P(), 6, n, 6, mutableBoundingBox);
                    }
                    this.func_175811_a(iSeedReader2, Blocks.field_150478_aa.func_176223_P(), 5, 3, 5, mutableBoundingBox);
                    for (n = 2; n <= 8; ++n) {
                        this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 2, 3, n, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 3, 3, n, mutableBoundingBox);
                        if (n <= 3 || n >= 7) {
                            this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 4, 3, n, mutableBoundingBox);
                            this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 5, 3, n, mutableBoundingBox);
                            this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 6, 3, n, mutableBoundingBox);
                        }
                        this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 7, 3, n, mutableBoundingBox);
                        this.func_175811_a(iSeedReader2, Blocks.field_196662_n.func_176223_P(), 8, 3, n, mutableBoundingBox);
                    }
                    BlockState blockState = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a(LadderBlock.field_176382_a, Direction.WEST);
                    this.func_175811_a(iSeedReader2, blockState, 9, 1, 3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, blockState, 9, 2, 3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader2, blockState, 9, 3, 3, mutableBoundingBox);
                    this.func_186167_a(iSeedReader2, mutableBoundingBox, random, 3, 4, 8, LootTables.field_186427_i);
                }
            }
            return true;
        }
    }

    public static class RightTurn
    extends Turn {
        public RightTurn(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214756_C, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        public RightTurn(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214756_C, compoundNBT);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            Direction direction = this.func_186165_e();
            if (direction == Direction.NORTH || direction == Direction.EAST) {
                this.func_74987_c((Stairs2)structurePiece, list, random, 1, 1);
            } else {
                this.func_74989_b((Stairs2)structurePiece, list, random, 1, 1);
            }
        }

        public static RightTurn func_214824_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 5, direction);
            if (!RightTurn.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new RightTurn(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 4, 4, 4, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            Direction direction = this.func_186165_e();
            if (direction == Direction.NORTH || direction == Direction.EAST) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 1, 1, 4, 3, 3, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 1, 0, 3, 3, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Turn {
        public LeftTurn(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214804_y, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        public LeftTurn(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214804_y, compoundNBT);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            Direction direction = this.func_186165_e();
            if (direction == Direction.NORTH || direction == Direction.EAST) {
                this.func_74989_b((Stairs2)structurePiece, list, random, 1, 1);
            } else {
                this.func_74987_c((Stairs2)structurePiece, list, random, 1, 1);
            }
        }

        public static LeftTurn func_175867_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 5, direction);
            if (!LeftTurn.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new LeftTurn(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 4, 4, 4, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            Direction direction = this.func_186165_e();
            if (direction == Direction.NORTH || direction == Direction.EAST) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 1, 0, 3, 3, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 1, 1, 4, 3, 3, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static abstract class Turn
    extends Stronghold {
        protected Turn(IStructurePieceType iStructurePieceType, int n) {
            super(iStructurePieceType, n);
        }

        public Turn(IStructurePieceType iStructurePieceType, CompoundNBT compoundNBT) {
            super(iStructurePieceType, compoundNBT);
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214761_H, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        public StairsStraight(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214761_H, compoundNBT);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static StairsStraight func_175861_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -7, 0, 5, 11, 8, direction);
            if (!StairsStraight.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new StairsStraight(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 4, 10, 7, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 1, 7, 0);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, Stronghold.Door.OPENING, 1, 1, 7);
            BlockState blockState = (BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(StairsBlock.field_176309_a, Direction.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.func_175811_a(iSeedReader, blockState, 1, 6 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 2, 6 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, blockState, 3, 6 - i, 1 + i, mutableBoundingBox);
                if (i >= 5) continue;
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 5 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 2, 5 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 3, 5 - i, 1 + i, mutableBoundingBox);
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        private boolean field_75002_c;

        public ChestCorridor(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214801_v, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        public ChestCorridor(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214801_v, compoundNBT);
            this.field_75002_c = compoundNBT.func_74767_n("Chest");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74757_a("Chest", this.field_75002_c);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static ChestCorridor func_175868_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 7, direction);
            if (!ChestCorridor.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new ChestCorridor(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox2, ChunkPos chunkPos, BlockPos blockPos) {
            MutableBoundingBox mutableBoundingBox2;
            this.func_74882_a(iSeedReader, mutableBoundingBox2, 0, 0, 0, 4, 4, 6, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox2, this.field_143013_d, 1, 1, 0);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox2, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_175804_a(iSeedReader, mutableBoundingBox2, 3, 1, 2, 3, 1, 4, Blocks.field_196696_di.func_176223_P(), Blocks.field_196696_di.func_176223_P(), false);
            this.func_175811_a(iSeedReader, Blocks.field_196573_bB.func_176223_P(), 3, 1, 1, mutableBoundingBox2);
            this.func_175811_a(iSeedReader, Blocks.field_196573_bB.func_176223_P(), 3, 1, 5, mutableBoundingBox2);
            this.func_175811_a(iSeedReader, Blocks.field_196573_bB.func_176223_P(), 3, 2, 2, mutableBoundingBox2);
            this.func_175811_a(iSeedReader, Blocks.field_196573_bB.func_176223_P(), 3, 2, 4, mutableBoundingBox2);
            for (int i = 2; i <= 4; ++i) {
                this.func_175811_a(iSeedReader, Blocks.field_196573_bB.func_176223_P(), 2, 1, i, mutableBoundingBox2);
            }
            if (!this.field_75002_c && mutableBoundingBox2.func_175898_b(new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.field_75002_c = true;
                this.func_186167_a(iSeedReader, mutableBoundingBox2, random, 3, 2, 3, LootTables.field_186428_j);
            }
            return true;
        }
    }

    public static class Straight
    extends Stronghold {
        private final boolean field_75019_b;
        private final boolean field_75020_c;

        public Straight(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214760_G, n);
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_75019_b = random.nextInt(2) == 0;
            this.field_75020_c = random.nextInt(2) == 0;
        }

        public Straight(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214760_G, compoundNBT);
            this.field_75019_b = compoundNBT.func_74767_n("Left");
            this.field_75020_c = compoundNBT.func_74767_n("Right");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74757_a("Left", this.field_75019_b);
            compoundNBT.func_74757_a("Right", this.field_75020_c);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
            if (this.field_75019_b) {
                this.func_74989_b((Stairs2)structurePiece, list, random, 1, 2);
            }
            if (this.field_75020_c) {
                this.func_74987_c((Stairs2)structurePiece, list, random, 1, 2);
            }
        }

        public static Straight func_175862_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 7, direction);
            if (!Straight.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Straight(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 4, 4, 6, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, Stronghold.Door.OPENING, 1, 1, 6);
            BlockState blockState = (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.EAST);
            \u2603 = (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(WallTorchBlock.field_196532_a, Direction.WEST);
            this.func_175809_a(iSeedReader, mutableBoundingBox, random, 0.1f, 1, 2, 1, blockState);
            this.func_175809_a(iSeedReader, mutableBoundingBox, random, 0.1f, 3, 2, 1, \u2603);
            this.func_175809_a(iSeedReader, mutableBoundingBox, random, 0.1f, 1, 2, 5, blockState);
            this.func_175809_a(iSeedReader, mutableBoundingBox, random, 0.1f, 3, 2, 5, \u2603);
            if (this.field_75019_b) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 0, 1, 2, 0, 3, 4, field_202556_l, field_202556_l, false);
            }
            if (this.field_75020_c) {
                this.func_175804_a(iSeedReader, mutableBoundingBox, 4, 1, 2, 4, 3, 4, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight field_75027_a;
        @Nullable
        public PortalRoom field_75025_b;
        public final List<StructurePiece> field_75026_c = Lists.newArrayList();

        public Stairs2(Random random, int n, int n2) {
            super(IStructurePieceType.field_214759_F, 0, random, n, n2);
        }

        public Stairs2(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214759_F, compoundNBT);
        }
    }

    public static class Stairs
    extends Stronghold {
        private final boolean field_75024_a;

        public Stairs(IStructurePieceType iStructurePieceType, int n, Random random, int n2, int n3) {
            super(iStructurePieceType, n);
            this.field_75024_a = true;
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(random));
            this.field_143013_d = Stronghold.Door.OPENING;
            this.field_74887_e = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(n2, 64, n3, n2 + 5 - 1, 74, n3 + 5 - 1) : new MutableBoundingBox(n2, 64, n3, n2 + 5 - 1, 74, n3 + 5 - 1);
        }

        public Stairs(int n, Random random, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214758_E, n);
            this.field_75024_a = false;
            this.func_186164_a(direction);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        public Stairs(IStructurePieceType iStructurePieceType, CompoundNBT compoundNBT) {
            super(iStructurePieceType, compoundNBT);
            this.field_75024_a = compoundNBT.func_74767_n("Source");
        }

        public Stairs(TemplateManager templateManager, CompoundNBT compoundNBT) {
            this(IStructurePieceType.field_214758_E, compoundNBT);
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74757_a("Source", this.field_75024_a);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            if (this.field_75024_a) {
                field_75203_d = Crossing.class;
            }
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static Stairs func_175863_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -7, 0, 5, 11, 5, direction);
            if (!Stairs.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Stairs(n4, random, mutableBoundingBox, direction);
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.func_74882_a(iSeedReader, mutableBoundingBox, 0, 0, 0, 4, 10, 4, true, random, field_75204_e);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, this.field_143013_d, 1, 7, 0);
            this.func_242917_a(iSeedReader, random, mutableBoundingBox, Stronghold.Door.OPENING, 1, 1, 4);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 2, 6, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 5, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_222401_hJ.func_176223_P(), 1, 6, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 5, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 4, 3, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_222401_hJ.func_176223_P(), 1, 5, 3, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 2, 4, 3, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 3, 3, 3, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_222401_hJ.func_176223_P(), 3, 4, 3, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 3, 3, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 3, 2, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_222401_hJ.func_176223_P(), 3, 3, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 2, 2, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 1, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_222401_hJ.func_176223_P(), 1, 2, 1, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 1, 2, mutableBoundingBox);
            this.func_175811_a(iSeedReader, Blocks.field_222401_hJ.func_176223_P(), 1, 1, 3, mutableBoundingBox);
            return true;
        }
    }

    public static class Corridor
    extends Stronghold {
        private final int field_74993_a;

        public Corridor(int n, MutableBoundingBox mutableBoundingBox, Direction direction) {
            super(IStructurePieceType.field_214802_w, n);
            this.func_186164_a(direction);
            this.field_74887_e = mutableBoundingBox;
            this.field_74993_a = direction == Direction.NORTH || direction == Direction.SOUTH ? mutableBoundingBox.func_78880_d() : mutableBoundingBox.func_78883_b();
        }

        public Corridor(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(IStructurePieceType.field_214802_w, compoundNBT);
            this.field_74993_a = compoundNBT.func_74762_e("Steps");
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            super.func_143011_b(compoundNBT);
            compoundNBT.func_74768_a("Steps", this.field_74993_a);
        }

        public static MutableBoundingBox func_175869_a(List<StructurePiece> list, Random random, int n, int n2, int n3, Direction direction) {
            int n4 = 3;
            MutableBoundingBox \u26032 = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 4, direction);
            StructurePiece \u26033 = StructurePiece.func_74883_a(list, \u26032);
            if (\u26033 == null) {
                return null;
            }
            if (\u26033.func_74874_b().field_78895_b == \u26032.field_78895_b) {
                for (\u2603 = 3; \u2603 >= 1; --\u2603) {
                    \u26032 = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, \u2603 - 1, direction);
                    if (\u26033.func_74874_b().func_78884_a(\u26032)) continue;
                    return MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, \u2603, direction);
                }
            }
            return null;
        }

        @Override
        public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            for (int i = 0; i < this.field_74993_a; ++i) {
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 0, 0, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 0, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 2, 0, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 3, 0, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 4, 0, i, mutableBoundingBox);
                for (\u2603 = 1; \u2603 <= 3; ++\u2603) {
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 0, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_201941_jj.func_176223_P(), 1, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_201941_jj.func_176223_P(), 2, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_201941_jj.func_176223_P(), 3, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 4, \u2603, i, mutableBoundingBox);
                }
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 0, 4, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 1, 4, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 2, 4, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 3, 4, i, mutableBoundingBox);
                this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), 4, 4, i, mutableBoundingBox);
            }
            return true;
        }
    }

    static abstract class Stronghold
    extends StructurePiece {
        protected Door field_143013_d = Door.OPENING;

        protected Stronghold(IStructurePieceType iStructurePieceType, int n) {
            super(iStructurePieceType, n);
        }

        public Stronghold(IStructurePieceType iStructurePieceType, CompoundNBT compoundNBT) {
            super(iStructurePieceType, compoundNBT);
            this.field_143013_d = Door.valueOf(compoundNBT.func_74779_i("EntryDoor"));
        }

        @Override
        protected void func_143011_b(CompoundNBT compoundNBT) {
            compoundNBT.func_74778_a("EntryDoor", this.field_143013_d.name());
        }

        protected void func_242917_a(ISeedReader iSeedReader, Random random, MutableBoundingBox mutableBoundingBox, Door door, int n, int n2, int n3) {
            switch (door) {
                case OPENING: {
                    this.func_175804_a(iSeedReader, mutableBoundingBox, n, n2, n3, n + 3 - 1, n2 + 3 - 1, n3, field_202556_l, field_202556_l, false);
                    break;
                }
                case WOOD_DOOR: {
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 1, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 2, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_180413_ao.func_176223_P(), n + 1, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_180413_ao.func_176223_P().func_206870_a(DoorBlock.field_176523_O, DoubleBlockHalf.UPPER), n + 1, n2 + 1, n3, mutableBoundingBox);
                    break;
                }
                case GRATES: {
                    this.func_175811_a(iSeedReader, Blocks.field_201941_jj.func_176223_P(), n + 1, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_201941_jj.func_176223_P(), n + 1, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196414_y, true), n, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196414_y, true), n, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196411_b, true)).func_206870_a(PaneBlock.field_196414_y, true), n, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196411_b, true)).func_206870_a(PaneBlock.field_196414_y, true), n + 1, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196411_b, true)).func_206870_a(PaneBlock.field_196414_y, true), n + 2, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196411_b, true), n + 2, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196411_b, true), n + 2, n2, n3, mutableBoundingBox);
                    break;
                }
                case IRON_DOOR: {
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 1, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_196696_di.func_176223_P(), n + 2, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, Blocks.field_150454_av.func_176223_P(), n + 1, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a(DoorBlock.field_176523_O, DoubleBlockHalf.UPPER), n + 1, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a(AbstractButtonBlock.field_185512_D, Direction.NORTH), n + 2, n2 + 1, n3 + 1, mutableBoundingBox);
                    this.func_175811_a(iSeedReader, (BlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a(AbstractButtonBlock.field_185512_D, Direction.SOUTH), n + 2, n2 + 1, n3 - 1, mutableBoundingBox);
                }
            }
        }

        protected Door func_74988_a(Random random) {
            int n = random.nextInt(5);
            switch (n) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        @Nullable
        protected StructurePiece func_74986_a(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2) {
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c - 1, direction, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78892_f + 1, direction, this.func_74877_c());
                    }
                    case WEST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c + n, direction, this.func_74877_c());
                    }
                    case EAST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c + n, direction, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74989_b(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2) {
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, Direction.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, Direction.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74987_c(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2) {
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    case NORTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, Direction.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, Direction.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected static boolean func_74991_a(MutableBoundingBox mutableBoundingBox) {
            return mutableBoundingBox != null && mutableBoundingBox.field_78895_b > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    static class PieceWeight {
        public final Class<? extends Stronghold> field_75194_a;
        public final int field_75192_b;
        public int field_75193_c;
        public final int field_75191_d;

        public PieceWeight(Class<? extends Stronghold> clazz, int n, int n2) {
            this.field_75194_a = clazz;
            this.field_75192_b = n;
            this.field_75191_d = n2;
        }

        public boolean func_75189_a(int n) {
            return this.field_75191_d == 0 || this.field_75193_c < this.field_75191_d;
        }

        public boolean func_75190_a() {
            return this.field_75191_d == 0 || this.field_75193_c < this.field_75191_d;
        }
    }
}

