/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JigsawBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawOrientation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FeatureJigsawPiece
extends JigsawPiece {
    public static final Codec<FeatureJigsawPiece> field_236816_a_ = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredFeature.field_236264_b_.fieldOf("feature").forGetter(featureJigsawPiece -> featureJigsawPiece.field_214870_a), FeatureJigsawPiece.func_236848_d_()).apply((Applicative)instance, FeatureJigsawPiece::new));
    private final Supplier<ConfiguredFeature<?, ?>> field_214870_a;
    private final CompoundNBT field_214871_b;

    protected FeatureJigsawPiece(Supplier<ConfiguredFeature<?, ?>> supplier, JigsawPattern.PlacementBehaviour placementBehaviour) {
        super(placementBehaviour);
        this.field_214870_a = supplier;
        this.field_214871_b = this.func_214869_b();
    }

    private CompoundNBT func_214869_b() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("name", "minecraft:bottom");
        compoundNBT.func_74778_a("final_state", "minecraft:air");
        compoundNBT.func_74778_a("pool", "minecraft:empty");
        compoundNBT.func_74778_a("target", "minecraft:empty");
        compoundNBT.func_74778_a("joint", JigsawTileEntity.OrientationType.ROLLABLE.func_176610_l());
        return compoundNBT;
    }

    public BlockPos func_214868_a(TemplateManager templateManager, Rotation rotation) {
        return BlockPos.field_177992_a;
    }

    @Override
    public List<Template.BlockInfo> func_214849_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, Random random) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new Template.BlockInfo(blockPos, (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a(JigsawBlock.field_235506_a_, JigsawOrientation.func_239641_a_(Direction.DOWN, Direction.SOUTH)), this.field_214871_b));
        return arrayList;
    }

    @Override
    public MutableBoundingBox func_214852_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation) {
        BlockPos blockPos2 = this.func_214868_a(templateManager, rotation);
        return new MutableBoundingBox(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n() + blockPos2.func_177958_n(), blockPos.func_177956_o() + blockPos2.func_177956_o(), blockPos.func_177952_p() + blockPos2.func_177952_p());
    }

    @Override
    public boolean func_230378_a_(TemplateManager templateManager, ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos2, Rotation rotation, MutableBoundingBox mutableBoundingBox, Random random, boolean bl) {
        return this.field_214870_a.get().func_242765_a(iSeedReader, chunkGenerator, random, blockPos);
    }

    @Override
    public IJigsawDeserializer<?> func_214853_a() {
        return IJigsawDeserializer.field_214930_d;
    }

    public String toString() {
        return "Feature[" + Registry.field_218379_q.func_177774_c((Feature<?>)this.field_214870_a.get().func_242766_b()) + "]";
    }
}

