/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.util.SectionDistanceGraph;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestData;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.storage.RegionSectionCache;

public class PointOfInterestManager
extends RegionSectionCache<PointOfInterestData> {
    private final DistanceGraph field_219164_a;
    private final LongSet field_226345_b_ = new LongOpenHashSet();

    public PointOfInterestManager(File file, DataFixer dataFixer, boolean bl) {
        super(file, PointOfInterestData::func_234158_a_, PointOfInterestData::new, dataFixer, DefaultTypeReferences.POI_CHUNK, bl);
        this.field_219164_a = new DistanceGraph();
    }

    public void func_219135_a(BlockPos blockPos, PointOfInterestType pointOfInterestType) {
        ((PointOfInterestData)this.func_235995_e_(SectionPos.func_218167_a(blockPos).func_218146_v())).func_218243_a(blockPos, pointOfInterestType);
    }

    public void func_219140_a(BlockPos blockPos) {
        ((PointOfInterestData)this.func_235995_e_(SectionPos.func_218167_a(blockPos).func_218146_v())).func_218248_a(blockPos);
    }

    public long func_219145_a(Predicate<PointOfInterestType> predicate, BlockPos blockPos, int n, Status status) {
        return this.func_219146_b(predicate, blockPos, n, status).count();
    }

    public boolean func_234135_a_(PointOfInterestType pointOfInterestType, BlockPos blockPos) {
        Optional<PointOfInterestType> optional = ((PointOfInterestData)this.func_235995_e_(SectionPos.func_218167_a(blockPos).func_218146_v())).func_218244_d(blockPos);
        return optional.isPresent() && optional.get().equals(pointOfInterestType);
    }

    public Stream<PointOfInterest> func_226353_b_(Predicate<PointOfInterestType> predicate, BlockPos blockPos, int n, Status status) {
        int n2 = Math.floorDiv(n, 16) + 1;
        return ChunkPos.func_222243_a(new ChunkPos(blockPos), n2).flatMap(chunkPos -> this.func_219137_a(predicate, (ChunkPos)chunkPos, status)).filter(pointOfInterest -> {
            BlockPos blockPos2 = pointOfInterest.func_218261_f();
            return Math.abs(blockPos2.func_177958_n() - blockPos.func_177958_n()) <= n && Math.abs(blockPos2.func_177952_p() - blockPos.func_177952_p()) <= n;
        });
    }

    public Stream<PointOfInterest> func_219146_b(Predicate<PointOfInterestType> predicate, BlockPos blockPos, int n, Status status) {
        int n2 = n * n;
        return this.func_226353_b_(predicate, blockPos, n, status).filter(pointOfInterest -> pointOfInterest.func_218261_f().func_177951_i(blockPos) <= (double)n2);
    }

    public Stream<PointOfInterest> func_219137_a(Predicate<PointOfInterestType> predicate, ChunkPos chunkPos, Status status) {
        return IntStream.range(0, 16).boxed().map(n -> this.func_219113_d(SectionPos.func_218156_a(chunkPos, n).func_218146_v())).filter(Optional::isPresent).flatMap(optional -> ((PointOfInterestData)optional.get()).func_218247_a(predicate, status));
    }

    public Stream<BlockPos> func_225399_a(Predicate<PointOfInterestType> predicate, Predicate<BlockPos> predicate2, BlockPos blockPos, int n, Status status) {
        return this.func_219146_b(predicate, blockPos, n, status).map(PointOfInterest::func_218261_f).filter(predicate2);
    }

    public Stream<BlockPos> func_242324_b(Predicate<PointOfInterestType> predicate, Predicate<BlockPos> predicate2, BlockPos blockPos, int n, Status status) {
        return this.func_225399_a(predicate, predicate2, blockPos, n, status).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.func_177951_i(blockPos)));
    }

    public Optional<BlockPos> func_219127_a(Predicate<PointOfInterestType> predicate, Predicate<BlockPos> predicate2, BlockPos blockPos, int n, Status status) {
        return this.func_225399_a(predicate, predicate2, blockPos, n, status).findFirst();
    }

    public Optional<BlockPos> func_234148_d_(Predicate<PointOfInterestType> predicate, BlockPos blockPos, int n, Status status) {
        return this.func_219146_b(predicate, blockPos, n, status).map(PointOfInterest::func_218261_f).min(Comparator.comparingDouble(blockPos2 -> blockPos2.func_177951_i(blockPos)));
    }

    public Optional<BlockPos> func_219157_a(Predicate<PointOfInterestType> predicate, Predicate<BlockPos> predicate2, BlockPos blockPos, int n) {
        return this.func_219146_b(predicate, blockPos, n, Status.HAS_SPACE).filter(pointOfInterest -> predicate2.test(pointOfInterest.func_218261_f())).findFirst().map(pointOfInterest -> {
            pointOfInterest.func_218262_b();
            return pointOfInterest.func_218261_f();
        });
    }

    public Optional<BlockPos> func_219163_a(Predicate<PointOfInterestType> predicate, Predicate<BlockPos> predicate2, Status status, BlockPos blockPos, int n, Random random) {
        List list = this.func_219146_b(predicate, blockPos, n, status).collect(Collectors.toList());
        Collections.shuffle(list, random);
        return list.stream().filter(pointOfInterest -> predicate2.test(pointOfInterest.func_218261_f())).findFirst().map(PointOfInterest::func_218261_f);
    }

    public boolean func_219142_b(BlockPos blockPos) {
        return ((PointOfInterestData)this.func_235995_e_(SectionPos.func_218167_a(blockPos).func_218146_v())).func_218251_c(blockPos);
    }

    public boolean func_219138_a(BlockPos blockPos, Predicate<PointOfInterestType> predicate) {
        return this.func_219113_d(SectionPos.func_218167_a(blockPos).func_218146_v()).map(pointOfInterestData -> pointOfInterestData.func_218245_a(blockPos, predicate)).orElse(false);
    }

    public Optional<PointOfInterestType> func_219148_c(BlockPos blockPos) {
        PointOfInterestData pointOfInterestData = (PointOfInterestData)this.func_235995_e_(SectionPos.func_218167_a(blockPos).func_218146_v());
        return pointOfInterestData.func_218244_d(blockPos);
    }

    public int func_219150_a(SectionPos sectionPos) {
        this.field_219164_a.func_215563_a();
        return this.field_219164_a.func_215471_c(sectionPos.func_218146_v());
    }

    private boolean func_219154_f(long l) {
        Optional optional = this.func_219106_c(l);
        if (optional == null) {
            return false;
        }
        return optional.map(pointOfInterestData -> pointOfInterestData.func_218247_a(PointOfInterestType.field_221053_a, Status.IS_OCCUPIED).count() > 0L).orElse(false);
    }

    @Override
    public void func_219115_a(BooleanSupplier booleanSupplier) {
        super.func_219115_a(booleanSupplier);
        this.field_219164_a.func_215563_a();
    }

    @Override
    protected void func_219116_a(long l) {
        super.func_219116_a(l);
        this.field_219164_a.func_215515_b(l, this.field_219164_a.func_215516_b(l), false);
    }

    @Override
    protected void func_219111_b(long l) {
        this.field_219164_a.func_215515_b(l, this.field_219164_a.func_215516_b(l), false);
    }

    public void func_219139_a(ChunkPos chunkPos, ChunkSection chunkSection) {
        SectionPos sectionPos = SectionPos.func_218156_a(chunkPos, chunkSection.func_222632_g() >> 4);
        Util.func_215077_a(this.func_219113_d(sectionPos.func_218146_v()), pointOfInterestData -> pointOfInterestData.func_218240_a(biConsumer -> {
            if (PointOfInterestManager.func_219151_a(chunkSection)) {
                this.func_219132_a(chunkSection, sectionPos, (BiConsumer<BlockPos, PointOfInterestType>)biConsumer);
            }
        }), () -> {
            if (PointOfInterestManager.func_219151_a(chunkSection)) {
                PointOfInterestData pointOfInterestData = (PointOfInterestData)this.func_235995_e_(sectionPos.func_218146_v());
                this.func_219132_a(chunkSection, sectionPos, pointOfInterestData::func_218243_a);
            }
        });
    }

    private static boolean func_219151_a(ChunkSection chunkSection) {
        return chunkSection.func_235962_a_(PointOfInterestType.field_234167_x_::contains);
    }

    private void func_219132_a(ChunkSection chunkSection, SectionPos sectionPos, BiConsumer<BlockPos, PointOfInterestType> biConsumer) {
        sectionPos.func_218145_w().forEach(blockPos -> {
            BlockState blockState = chunkSection.func_177485_a(SectionPos.func_218171_b(blockPos.func_177958_n()), SectionPos.func_218171_b(blockPos.func_177956_o()), SectionPos.func_218171_b(blockPos.func_177952_p()));
            PointOfInterestType.func_221047_b(blockState).ifPresent(pointOfInterestType -> biConsumer.accept((BlockPos)blockPos, (PointOfInterestType)pointOfInterestType));
        });
    }

    public void func_226347_a_(IWorldReader iWorldReader, BlockPos blockPos, int n) {
        SectionPos.func_229421_b_(new ChunkPos(blockPos), Math.floorDiv(n, 16)).map(sectionPos -> Pair.of((Object)sectionPos, this.func_219113_d(sectionPos.func_218146_v()))).filter(pair -> ((Optional)pair.getSecond()).map(PointOfInterestData::func_226355_a_).orElse(false) == false).map(pair -> ((SectionPos)pair.getFirst()).func_218155_u()).filter(chunkPos -> this.field_226345_b_.add(chunkPos.func_201841_a())).forEach(chunkPos -> iWorldReader.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_223226_a_));
    }

    final class DistanceGraph
    extends SectionDistanceGraph {
        private final Long2ByteMap field_215565_b;

        protected DistanceGraph() {
            super(7, 16, 256);
            this.field_215565_b = new Long2ByteOpenHashMap();
            this.field_215565_b.defaultReturnValue((byte)7);
        }

        @Override
        protected int func_215516_b(long l) {
            return PointOfInterestManager.this.func_219154_f(l) ? 0 : 7;
        }

        @Override
        protected int func_215471_c(long l) {
            return this.field_215565_b.get(l);
        }

        @Override
        protected void func_215476_a(long l, int n) {
            if (n > 6) {
                this.field_215565_b.remove(l);
            } else {
                this.field_215565_b.put(l, (byte)n);
            }
        }

        public void func_215563_a() {
            super.func_215483_b(Integer.MAX_VALUE);
        }
    }

    public static enum Status {
        HAS_SPACE(PointOfInterest::func_218265_d),
        IS_OCCUPIED(PointOfInterest::func_218263_e),
        ANY(pointOfInterest -> true);

        private final Predicate<? super PointOfInterest> field_221037_d;

        private Status(Predicate<? super PointOfInterest> predicate) {
            this.field_221037_d = predicate;
        }

        public Predicate<? super PointOfInterest> func_221035_a() {
            return this.field_221037_d;
        }
    }
}

