/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DelegatingDynamicOps;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenSettingsExport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSettingsImport<T>
extends DelegatingDynamicOps<T> {
    private static final Logger field_240870_b_ = LogManager.getLogger();
    private final IResourceAccess field_244332_c;
    private final DynamicRegistries.Impl field_240872_d_;
    private final Map<RegistryKey<? extends Registry<?>>, ResultMap<?>> field_240873_e_;
    private final WorldSettingsImport<JsonElement> field_244333_f;

    public static <T> WorldSettingsImport<T> func_244335_a(DynamicOps<T> dynamicOps, IResourceManager iResourceManager, DynamicRegistries.Impl impl) {
        return WorldSettingsImport.func_244336_a(dynamicOps, IResourceAccess.func_244345_a(iResourceManager), impl);
    }

    public static <T> WorldSettingsImport<T> func_244336_a(DynamicOps<T> dynamicOps, IResourceAccess iResourceAccess, DynamicRegistries.Impl impl) {
        WorldSettingsImport<T> worldSettingsImport = new WorldSettingsImport<T>(dynamicOps, iResourceAccess, impl, Maps.newIdentityHashMap());
        DynamicRegistries.func_243608_a(impl, worldSettingsImport);
        return worldSettingsImport;
    }

    private WorldSettingsImport(DynamicOps<T> dynamicOps, IResourceAccess iResourceAccess, DynamicRegistries.Impl impl, IdentityHashMap<RegistryKey<? extends Registry<?>>, ResultMap<?>> identityHashMap) {
        super(dynamicOps);
        this.field_244332_c = iResourceAccess;
        this.field_240872_d_ = impl;
        this.field_240873_e_ = identityHashMap;
        this.field_244333_f = dynamicOps == JsonOps.INSTANCE ? this : new WorldSettingsImport<T>(JsonOps.INSTANCE, iResourceAccess, impl, (IdentityHashMap<RegistryKey<Registry<?>>, ResultMap<?>>)identityHashMap);
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> func_241802_a_(T t, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec, boolean bl) {
        Optional optional = this.field_240872_d_.func_230521_a_(registryKey);
        if (!optional.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + registryKey));
        }
        MutableRegistry \u26032 = optional.get();
        DataResult \u26033 = ResourceLocation.field_240908_a_.decode(this.field_240857_a_, t);
        if (!\u26033.result().isPresent()) {
            if (!bl) {
                return DataResult.error((String)"Inline definitions not allowed here");
            }
            return codec.decode((DynamicOps)this, t).map(pair -> pair.mapFirst(object -> () -> object));
        }
        Pair \u26034 = (Pair)\u26033.result().get();
        ResourceLocation \u26035 = (ResourceLocation)\u26034.getFirst();
        return this.func_241805_a_(registryKey, \u26032, codec, \u26035).map(supplier -> Pair.of((Object)supplier, (Object)\u26034.getSecond()));
    }

    public <E> DataResult<SimpleRegistry<E>> func_241797_a_(SimpleRegistry<E> simpleRegistry2, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec) {
        Collection<ResourceLocation> collection = this.field_244332_c.func_241880_a(registryKey);
        DataResult \u26032 = DataResult.success(simpleRegistry2, (Lifecycle)Lifecycle.stable());
        String \u26033 = registryKey.func_240901_a_().func_110623_a() + "/";
        for (ResourceLocation resourceLocation : collection) {
            String string = resourceLocation.func_110623_a();
            if (!string.endsWith(".json")) {
                field_240870_b_.warn("Skipping resource {} since it is not a json file", (Object)resourceLocation);
                continue;
            }
            if (!string.startsWith(\u26033)) {
                field_240870_b_.warn("Skipping resource {} since it does not have a registry name prefix", (Object)resourceLocation);
                continue;
            }
            \u2603 = string.substring(\u26033.length(), string.length() - ".json".length());
            ResourceLocation \u26034 = new ResourceLocation(resourceLocation.func_110624_b(), \u2603);
            \u26032 = \u26032.flatMap(simpleRegistry -> this.func_241805_a_(registryKey, (MutableRegistry)simpleRegistry, codec, \u26034).map(supplier -> simpleRegistry));
        }
        return \u26032.setPartial(simpleRegistry2);
    }

    private <E> DataResult<java.util.function.Supplier<E>> func_241805_a_(RegistryKey<? extends Registry<E>> registryKey, MutableRegistry<E> mutableRegistry2, Codec<E> codec, ResourceLocation resourceLocation) {
        MutableRegistry mutableRegistry2;
        Pair \u26037;
        RegistryKey registryKey2 = RegistryKey.func_240903_a_(registryKey, resourceLocation);
        ResultMap<E> \u26032 = this.func_240884_a_(registryKey);
        DataResult \u26033 = (DataResult)((ResultMap)\u26032).field_240893_a_.get(registryKey2);
        if (\u26033 != null) {
            return \u26033;
        }
        Supplier \u26034 = Suppliers.memoize(() -> {
            Object t = mutableRegistry2.func_230516_a_(registryKey2);
            if (t == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + registryKey2);
            }
            return t;
        });
        ((ResultMap)\u26032).field_240893_a_.put(registryKey2, DataResult.success((Object)\u26034));
        DataResult \u26035 = this.field_244332_c.func_241879_a((DynamicOps<JsonElement>)this.field_244333_f, registryKey, registryKey2, codec);
        Optional \u26036 = \u26035.result();
        if (\u26036.isPresent()) {
            \u26037 = (Pair)\u26036.get();
            mutableRegistry2.func_241874_a((OptionalInt)\u26037.getSecond(), registryKey2, \u26037.getFirst(), \u26035.lifecycle());
        }
        \u26037 = !\u26036.isPresent() && mutableRegistry2.func_230516_a_(registryKey2) != null ? DataResult.success(() -> mutableRegistry2.func_230516_a_(registryKey2), (Lifecycle)Lifecycle.stable()) : \u26035.map(pair -> () -> mutableRegistry2.func_230516_a_(registryKey2));
        ((ResultMap)\u26032).field_240893_a_.put(registryKey2, \u26037);
        return \u26037;
    }

    private <E> ResultMap<E> func_240884_a_(RegistryKey<? extends Registry<E>> registryKey2) {
        return this.field_240873_e_.computeIfAbsent(registryKey2, registryKey -> new ResultMap());
    }

    protected <E> DataResult<Registry<E>> func_244340_a(RegistryKey<? extends Registry<E>> registryKey) {
        return this.field_240872_d_.func_230521_a_(registryKey).map(mutableRegistry -> DataResult.success((Object)mutableRegistry, (Lifecycle)mutableRegistry.func_241875_b())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + registryKey)));
    }

    public static interface IResourceAccess {
        public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> var1);

        public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> var1, RegistryKey<? extends Registry<E>> var2, RegistryKey<E> var3, Decoder<E> var4);

        public static IResourceAccess func_244345_a(final IResourceManager iResourceManager) {
            return new IResourceAccess(){

                @Override
                public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> registryKey) {
                    return iResourceManager.func_199003_a(registryKey.func_240901_a_().func_110623_a(), string -> string.endsWith(".json"));
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> \u2603, RegistryKey<? extends Registry<E>> \u2603, RegistryKey<E> \u2603, Decoder<E> \u2603) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public String toString() {
                    return "ResourceAccess[" + iResourceManager + "]";
                }

                private static /* synthetic */ Pair func_244347_a(Object object) {
                    return Pair.of((Object)object, (Object)OptionalInt.empty());
                }
            };
        }

        public static final class RegistryAccess
        implements IResourceAccess {
            private final Map<RegistryKey<?>, JsonElement> field_244349_a = Maps.newIdentityHashMap();
            private final Object2IntMap<RegistryKey<?>> field_244350_b = new Object2IntOpenCustomHashMap(Util.func_212443_g());
            private final Map<RegistryKey<?>, Lifecycle> field_244351_c = Maps.newIdentityHashMap();

            public <E> void func_244352_a(DynamicRegistries.Impl impl, RegistryKey<E> registryKey, Encoder<E> encoder, int n, E e, Lifecycle lifecycle) {
                DataResult dataResult = encoder.encodeStart(WorldGenSettingsExport.func_240896_a_(JsonOps.INSTANCE, impl), e);
                Optional \u26032 = dataResult.error();
                if (\u26032.isPresent()) {
                    field_240870_b_.error("Error adding element: {}", (Object)((DataResult.PartialResult)\u26032.get()).message());
                    return;
                }
                this.field_244349_a.put(registryKey, (JsonElement)dataResult.result().get());
                this.field_244350_b.put(registryKey, n);
                this.field_244351_c.put(registryKey, lifecycle);
            }

            @Override
            public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> registryKey) {
                return this.field_244349_a.keySet().stream().filter(registryKey2 -> registryKey2.func_244356_a(registryKey)).map(registryKey2 -> new ResourceLocation(registryKey2.func_240901_a_().func_110624_b(), registryKey.func_240901_a_().func_110623_a() + "/" + registryKey2.func_240901_a_().func_110623_a() + ".json")).collect(Collectors.toList());
            }

            @Override
            public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> dynamicOps, RegistryKey<? extends Registry<E>> registryKey, RegistryKey<E> registryKey2, Decoder<E> decoder) {
                JsonElement jsonElement = this.field_244349_a.get(registryKey2);
                if (jsonElement == null) {
                    return DataResult.error((String)("Unknown element: " + registryKey2));
                }
                return decoder.parse(dynamicOps, (Object)jsonElement).setLifecycle(this.field_244351_c.get(registryKey2)).map(object -> Pair.of((Object)object, (Object)OptionalInt.of(this.field_244350_b.getInt((Object)registryKey2))));
            }
        }
    }

    static final class ResultMap<E> {
        private final Map<RegistryKey<E>, DataResult<java.util.function.Supplier<E>>> field_240893_a_ = Maps.newIdentityHashMap();

        private ResultMap() {
        }
    }
}

